/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) exec.c: version 25.5 created on 7/24/92 at 19:34:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)exec.c	25.5	7/24/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/map.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/buf.h"
#include "sys/inode.h"
#include "sys/fs/s5inode.h"
#include "sys/fstyp.h"
#include "sys/acct.h"
#include "sys/sysinfo.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/tuneable.h"
#include "sys/tty.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/message.h"
#include "sys/conf.h"
#include "sys/state.h"
#include "sys/mount.h"
#include "sys/own.h"
#ifdef	PERF
#include "sys/perf.h"
#include "sys/perfext.h"
#endif	/* PERF */

#define	SA(x)	(x)
#define	LIST_END	1+2
#define	REG_SPACE 0
#define	ASTK_SP	u.u_astk->s_sp

extern spath();

struct execa {
	char	*fname;
	char	**argp;
	char	**envp;
};

/*
 * exec system call, without and with environments.
 */

exec()
{
	((struct execa *)u.u_ap)->envp = NULL;
	exece();
}

exece()
{
	register inode_t *ip;
	register char	*cp;
	register char	*sp;
	register char	**ap;
	register struct proc	*pp;
	reg_t   *rp;
	preg_t  *prp;

	register int	np = 0;
	register int	num_arg_ptrs = 0;
	register int	nc = 0;
	register unsigned size;
	register int	c;
	register j;

	int      vwinadr;
	int	 num_bytes = 12;
	unsigned shlb_scnsz;
	unsigned shlb_datsz;
	int      shlb_buf;
	struct   exdata *shlb_dat;
	char     exec_file[DIRSIZ];
	int      i;
	int	a1000;

	struct execa	*uap;
	int	num_arg_bytes = 0;
	int	env = 0;

#ifdef Copyback_M68040
	cache_push_data();		/* push any dangling user writes */
#endif

	atom_inc(&sysinfo.sysexec);

	u.u_execsz = USIZE + SINCR + SSIZE + btoc(NCARGS-1);

	if (((ip = namei(upath,0)) == NULL) ||
			((a1000 = gethead(ip, &u.u_exdata)) == -1)) {
		return;
	}
	if (!auth_execok(ip)) {
		iput(ip);
		u.u_error = EPERM;
		return;
	}
	/*
	 * Look at what we got, u.u_exdata.ux_mag = 407/410/411/413
	 *
	 *  410 is RO (shared) text (3B5 supports *only* this magic number)
	 *  411 is separated ID (3B5 treats this as 0410)
	 *  413 is RO text in an "aligned" (paged) a.out file
	 *  443 is shared library
	 *  407 is "normal" merged text/data executable
	 */

	switch (u.u_exdata.ux_mag) {
	    case 0410:
	    case 0413:
		break;
	    case 0443:
		u.u_error = ELIBEXEC;
		break;
	    case 0407:
		if (a1000)
			break;			/* only A1000 407s allowed */
		/* fall through */
	    default:
		u.u_error = ENOEXEC;
		break;
	}
	if (u.u_error) {
		iput(ip);
		return;
	}

	pp = u.u_procp;

	/* Clear defer-signal mask */
	pp->p_chold = 0;

	exec_perf_chk(ip, pp);

	/*
	 *	Allocate memory to read the arguments, the shared library
	 *	section, and the amount of memory needed to store the inode
	 *	pointer and header data for each a.out.
	 */
	shlb_scnsz = (u.u_exdata.ux_lsize + NBPW) & (~(NBPW - 1));
	shlb_datsz = u.u_exdata.ux_nshlibs * sizeof(struct exdata);
	size = btoc( shlb_scnsz + shlb_datsz + 3*(NCARGS + NBPW) );

	atom_sub(&availrmem, size);
	atom_sub(&availsmem, size);
	if (availrmem < tune.t_minarmem || availsmem < tune.t_minasmem) {
		atom_add(&availrmem, size);
		atom_add(&availsmem, size);
		nomemmsg("exece", size, 0, 0);
		u.u_error = EAGAIN;
		iput(ip);
		return;
	}

	vwinadr = sptalloc(size,
		(PG_P | PG_CB | PG_R | PG_W | PG_G | PG_S | PG_REF | PG_M),
		0, 0);

	/*	Locate and verify any needed shared libraries.
	 *
	 *	Note: ip is unlocked in getshlibs().
	 */

	bcopy((caddr_t)u.u_dent.d_name, (caddr_t)exec_file, DIRSIZ);

	if (u.u_exdata.ux_nshlibs) {
		shlb_buf = vwinadr + 3*(NCARGS + NBPW);
		shlb_dat = (struct exdata *)(shlb_buf + shlb_scnsz);

		if (getshlibs(shlb_buf, shlb_dat))
			goto done;
	} else {
		ip->i_flag |= ITEXT;
		prele(ip);
	}

	/* collect arglist */

	uap = (struct execa *)u.u_ap;
	ap = uap->argp;
	cp = (char *)vwinadr;

	for (;;) {
		if (ap) {
			while (sp = (char *)fuword((caddr_t)ap)) {
				ap++;
				++np;
				num_bytes += 4;
				if (num_bytes > NCARGS) {
				      u.u_error = E2BIG;
				      exec_err(shlb_dat, u.u_exdata.ux_nshlibs);
				      goto done;
				}
				if ((c = upath(sp, cp, NCARGS-num_bytes)) < 0) {
				      if (c == -2)
				      	      u.u_error = E2BIG;
				      else
					      u.u_error = EFAULT;
				      exec_err(shlb_dat, u.u_exdata.ux_nshlibs);
				      goto done;
				}
				nc += ++c;
				cp += c;
				num_bytes += c;
			}
		}
		if (env) 
			break;
		env = 1;
		num_arg_ptrs = np;	/* save argc */
		num_arg_bytes = nc;
		ap = uap->envp; /* switch to env */
	}

	nc = (nc+NBPW-1)&~(NBPW-1);

	/*
	 * Remove the old process image
	 */

	punlock();	/* unlock locked regions before detaching */

	u.u_prof.pr_scale = 0;

	prp = pp->p_region;
	while (rp = prp->p_reg) {
		if (ip = rp->r_iptr)
			plock(ip);
		reglock(rp);
		detachreg(prp, &u);
	}

	/*
	 * load any shared libraries that are needed
	 */

	if (u.u_exdata.ux_nshlibs) {
		for(i = 0; i < u.u_exdata.ux_nshlibs; i++, shlb_dat++) {
			if (getxfile(shlb_dat, PT_LIBTXT, PT_LIBDAT)) {
				exec_err(++shlb_dat,
				  u.u_exdata.ux_nshlibs - i - 1);
				psignal(pp, SIGKILL);
				goto done;
			}
		}
	}

	/*
	 * load the a.out's text and data.
	 *
	 *	If this is A1000 binary, treat it separately
	 */

	if (a1000) {
		if (A1000_getxfile(&u.u_exdata)) {
			psignal(pp, SIGKILL);
			goto done;
		}
	}
	else {
		if (getxfile(&u.u_exdata, PT_TEXT, PT_DATA)) {
			psignal(pp, SIGKILL);
			goto done;
		}
	}

	/*
	 *	Set up the user's stack.
	 */

	if (stackbld(SA(nc) + SA((np + LIST_END) * NBPW) + REG_SPACE)) {
		psignal(pp, SIGKILL);
		goto done;
	}

	/*
	 * copy back arglist -- i.e.
	 *	set up argument and environment pointers
	 */
	/* location to copy args */
	sp = (char *) ((uint)USERSTACK_END - SA(nc)); 
	cp = (char *)SA((int)(sp - ((np+LIST_END)*NBPW + REG_SPACE)));

	ASTK_SP = (unsigned int)cp;
	copyout((caddr_t)vwinadr, (caddr_t)sp, nc);
#if REG_SPACE > 0
	cp += REG_SPACE; /* shut the compiler up: "expression has no effects" */
#endif
	suword((caddr_t)cp, num_arg_ptrs);
	i = np - num_arg_ptrs;			/* no. of env pointers */
	for (;;) {
		cp += NBPW;
		if (np == i) {
			suword((caddr_t)cp, 0);	/* terminate argv */
			cp += NBPW;
		}
		if (--np < 0)
			break;
		suword((caddr_t)cp, sp);
		j = findnull(sp, NCARGS);
		if (j == -1)
			cmn_err(CE_WARN,"exec: findnull return error\n");
		sp += (NCARGS - j);
		
	}

	/* do psargs */
	sp = u.u_psargs;
	cp = (char *)vwinadr;
	np = min(num_arg_bytes, PSARGSZ-1);
	while (np--) {
		if ((*sp = *cp++) == '\0')
			*sp = ' ';
		sp++;
	}
	*sp = '\0';

	/*
	 * Remember file name for accounting.
	 */
	u.u_acflag &= ~AFORK;
	bcopy((caddr_t)exec_file, (caddr_t)u.u_comm, DIRSIZ);

	setregs();

	fpu_clear();

	/* execed after forked; useful in setpgid 
	 * not inherited by child in fork.
	 */
	pp->p_posix_flags |= WAS_EXECED;

done:

	sat_exec(exec_file);
	sptfree(vwinadr, size, 1);
	atom_add(&availrmem, size);
	atom_add(&availsmem, size);

	return;
}


/*
 * Do the following code here.
 * The 'ip' pointer must be valid and NOT NULL.
 *
 * If the inode is marked as a size/clamp LEADER OR parent
 * was not a size/clamp LEADER, then we copy info from the inode,
 * otherwise we keep parent's values.
 *
 * By default or upon failures keep parent's quantum size.
 * By default or upon failures keep parent's slice clamp.
 * By default or upon failures keep parent's pri clamp.
 * By default or upon failures keep parent's usrpri clamp.
 * By default or upon failures keep parent's cpu clamp.
 *
 * If security is off, then we must copy the define from sys/mls.h.
 * This define should probably be in sys/param.h anyway.
 */
#ifndef	SECON
#define SECURE_INODE	128
#endif	/* !SECON */

exec_perf_chk(ip, pp)
inode_t		*ip;
register proc_t	*pp;
{
	register struct s5inode	*s5ip;
	register long		vl;
	register uint		s5i_pfl;
	register uint		p_pfl;

	if (!ip->i_mntdev || ip->i_mntdev->m_isize != SECURE_INODE)
		return;
	if (!(s5ip = (struct s5inode *)ip->i_fsptr))
		return;
	s5i_pfl = s5ip->s5i_perf_flags;
	p_pfl = pp->p_perf_flags;
#ifdef PERF
	if ((s5i_pfl & PERF_QUANTUM_LEADER) || !(p_pfl & PERF_QUANTUM_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_QUANTUM_MASK;
		if ((vl = s5ip->s5i_quantum) == 0)
			pp->p_quantum = quantum_size;
		else if (vl > 0 && vl <= max_quantum_size)
			pp->p_quantum = vl;
	}
	if ((s5i_pfl & PERF_SLICE_LEADER) || !(p_pfl & PERF_SLICE_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_SLICE_MASK;
		if ((vl = s5ip->s5i_slice_clamp) == 0)
			pp->p_slice_clamp = 0;
		else if (vl > 0 && vl <= max_slice_clamp)
			pp->p_slice_clamp = vl;
	}
	if ((s5i_pfl & PERF_PRI_LEADER) || !(p_pfl & PERF_PRI_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_PRI_MASK;
		if ((vl = s5ip->s5i_pri_clamp) == 0)
			pp->p_pri_clamp = 0;
		else if (vl > PZERO && vl <= max_pri_clamp)
			pp->p_pri_clamp = vl;
	}
	if ((s5i_pfl & PERF_USRPRI_LEADER) || !(p_pfl & PERF_USRPRI_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_USRPRI_MASK;
		if ((vl = s5ip->s5i_usrpri_clamp) == 0)
			pp->p_usrpri_clamp = 0;
		else if (vl > PZERO && vl <= max_usrpri_clamp)
			pp->p_usrpri_clamp = vl;
	}
	if ((s5i_pfl & PERF_CPU_LEADER) || !(p_pfl & PERF_CPU_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_CPU_MASK;
		if ((vl = s5ip->s5i_cpu_clamp) == 0)
			pp->p_cpu_clamp = 0;
		else if (vl >= (PUSER - NZERO) && vl <= max_cpu_clamp)
			pp->p_cpu_clamp = vl;
	}
#endif	/* PERF */
	if ((s5i_pfl & PERF_PRIADJ_LEADER) || !(p_pfl & PERF_PRIADJ_LEADER)) {
		pp->p_perf_flags |= s5i_pfl & PERF_PRIADJ_MASK;
		if ((vl = s5ip->s5i_pri_adj) == 0)
			pp->p_pri_adj = 0;
		else if (vl > 0 && vl <= max_pri_adj)
			pp->p_pri_adj = vl;
	}
}

/*
 * Read the a.out headers.  There must be at least three sections,
 * and they must be .text, .data and .bss (although not necessarily
 * in that order).
 *
 * Possible magic numbers are 0410, and 0413.  If there is no 
 * optional UNIX header then magic number 0410 is assumed.
 */


/*
 *   Common object file header
 */

struct filehdr {
	ushort	f_magic;	/* f_magic (magic number) */
	ushort	f_nscns;	/* number of sections */
	long	f_timdat;	/* time & date stamp */
	long	f_symptr;	/* file pointer to symtab */
	long	f_nsyms;	/* number of symtab entries */
	ushort	f_opthdr;	/* sizeof(optional hdr) */
	ushort	f_flags;
};

/*
 *  Common object file section header
 */

/*
 *  s_name
 */
#define _TEXT ".text"
#define _DATA ".data"
#define _BSS  ".bss"
#define _LIB  ".lib"

/*
 * s_flags
 */
#define	STYP_TEXT	0x0020	/* section contains text only */
#define STYP_DATA	0x0040	/* section contains data only */
#define STYP_BSS	0x0080	/* section contains bss only  */
#define STYP_LIB	0x0800	/* section contains lib only  */

/*
 * f_flags
 */
#define F_S3000_EXE	0x4000	/* file contains S3000 executable binary */
#define F_POSIX_EXE	0x8000	/* file contains POSIX executable binary */

struct scnhdr {
	char	s_name[8];	/* section name */
	long	s_paddr;	/* physical address */
	long	s_vaddr;	/* virtual address */
	long	s_size;		/* section size */
	long	s_scnptr;	/* file ptr to raw data for section */
	long	s_relptr;	/* file ptr to relocation */
	long	s_lnnoptr;	/* file ptr to line numbers */
	ushort	s_nreloc;	/* number of relocation	entries */
	ushort	s_nlnno;	/* number of line number entries */
	long	s_flags;	/* flags */
};

/*
 * Common object file optional unix header
 */

struct aouthdr {
	short	o_magic;	/* magic number */
	short	o_stamp;	/* stamp */
	long	o_tsize;	/* text size */
	long	o_dsize;	/* data size */
	long	o_bsize;	/* bss size */
	long	o_entloc;	/* entry location */
	long	o_tstart;
	long	o_dstart;
};

gethead(ip, exec_data)
struct   inode  *ip;
register struct exdata *exec_data;
{
	register struct file	*fp;
	register struct proc	*pp;
	struct filehdr filhdr;
	struct aouthdr aouthdr;
	struct scnhdr  scnhdr;
	int    opt_hdr = 0;
	int    scns    = 0;
	int    retval  = 0;

	pp = u.u_procp;

	if (FS_ACCESS(ip, IOBJEXEC)
	    || (PTRACED(pp) && FS_ACCESS(ip, IREAD)))
		goto bad;

	/*
	 * First, read the file header
	 */

	u.u_base = (caddr_t) &filhdr;
	u.u_count = sizeof(filhdr);
	u.u_offset = 0;
	u.u_segflg = 1;

	FS_READI(ip);

	if (u.u_count != 0) {
		u.u_error = ENOEXEC;
		goto bad;
	}

	/* 522 is 68020 object 
	 * 570 is common object
	 * 575 is common object
	 */
	switch (filhdr.f_magic) {
	case 0522:
	case 0570:
	case 0575:
		break;				/* ok */
	default:
		u.u_error = ENOEXEC;
		goto bad;
	}

	/*
	 *	Check if S3000 binary
	 */
	if ((filhdr.f_flags & F_S3000_EXE) == 0)
		retval = 1;

	/*
	 *	Check if POSIX binary
	 */
	if (filhdr.f_flags & F_POSIX_EXE) 
		pp->p_posix_flags |= F_POSIX_BINARY;
	else
		pp->p_posix_flags &= ~F_POSIX_BINARY;

	/*
	 * Next, read the optional unix header if present; if not,
	 * then we will assume the file is a 410.
	 */

	if (filhdr.f_opthdr >= sizeof(aouthdr)) {
		u.u_base = (caddr_t) & aouthdr;
		u.u_count = sizeof(aouthdr);

		FS_READI(ip);

		if (u.u_count != 0) {
			u.u_error = ENOEXEC;
			goto bad;
		}

		opt_hdr = 1;
		exec_data->ux_mag = aouthdr.o_magic;
		exec_data->ux_entloc = aouthdr.o_entloc;
		switch (exec_data->ux_mag) {
		case 0410:
		case 0413:
		case 0443:
		case 0407:
			break;				/* OK */
		default:
			u.u_error = ENOEXEC;
			goto bad;
		}
	}

	/*
	 * Next, read the section headers; there had better be at
	 * least three: .text, .data and .bss. The shared library
	 * section is optional, initialize the number needed to 0.
	 */

	exec_data->ux_nshlibs = 0;

	u.u_offset = sizeof(filhdr) + filhdr.f_opthdr;

	while ((short)filhdr.f_nscns-- > 0) {

		u.u_base = (caddr_t) &scnhdr;
		u.u_count = sizeof( scnhdr );

		FS_READI(ip);

		if (u.u_count != 0) {
			u.u_error = ENOEXEC;
			goto bad;
		}

		switch ((int) scnhdr.s_flags) {

		case STYP_TEXT:
			scns |= STYP_TEXT;

			if (!opt_hdr) {
				exec_data->ux_mag = 0410;
				exec_data->ux_entloc = scnhdr.s_vaddr;
			}

			exec_data->ux_txtorg = scnhdr.s_vaddr;
			exec_data->ux_toffset = scnhdr.s_scnptr;
			u.u_execsz += btoc(exec_data->ux_tsize = scnhdr.s_size);
			break;

		case STYP_DATA:
			scns |= STYP_DATA;
			exec_data->ux_datorg = scnhdr.s_vaddr;
			exec_data->ux_doffset = scnhdr.s_scnptr;
			u.u_execsz += btoc(exec_data->ux_dsize = scnhdr.s_size);
			break;

		case STYP_BSS:
			scns |= STYP_BSS;
			u.u_execsz += btoc(exec_data->ux_bsize = scnhdr.s_size);
			break;

		case STYP_LIB:
			++shlbinfo.shlblnks;

			exec_data->ux_nshlibs = scnhdr.s_paddr;
			if (exec_data->ux_nshlibs > shlbinfo.shlbs) {
				++shlbinfo.shlbovf;
				u.u_error = ELIBMAX;
				goto bad;
			}

			exec_data->ux_lsize = scnhdr.s_size;
			exec_data->ux_loffset = scnhdr.s_scnptr;
			break;
		}
	}

	if (scns != (STYP_TEXT|STYP_DATA|STYP_BSS)) {
		u.u_error = ENOEXEC;
		goto bad;
	}

	if ((exec_data->ux_txtorg < 0)  ||
	    (exec_data->ux_datorg < 0)  ||
	    (exec_data->ux_tsize < 0) ||
	    (exec_data->ux_dsize < 0) ||
	    (exec_data->ux_bsize < 0))  {
		u.u_error = ENOEXEC;
		goto bad;
	}

	/*
 	 * Check total memory requirements (in clicks) for a new process
	 * against the available memory or upper limit of memory allowed.
	 */

	if (u.u_execsz > tune.t_maxumem) {
		u.u_error = ENOMEM;
		goto bad;
	}

	/*
	 * no need to check for opens with FWRITE on binary if it is a 407
	 */
	if (exec_data->ux_mag != 0407) {
		if (!(ip->i_flag & ITEXT) && ip->i_count != 1) {
			for (fp = file; fp < (struct file *)v.ve_file; fp++)
				if (fp->f_count && fp->f_inode == ip &&
				    (fp->f_flag&FWRITE)) {
					u.u_error = ETXTBSY;
					goto bad;
				}
		}
	}

	exec_data->ip = ip;
	return(retval);
bad:
	iput(ip);
	return(-1);
}
 

getxfile(exec_data, tpregtyp, dpregtyp)
register struct exdata	*exec_data;
short			tpregtyp;
short			dpregtyp;
{
	register reg_t	*rp;
	register preg_t	*prp;
	register struct inode  *ip = exec_data->ip;
	register struct proc	*pp;
	int doffset = exec_data->ux_doffset;
	int dbase   = exec_data->ux_datorg;
	int dsize   = exec_data->ux_dsize;
	int bsize   = exec_data->ux_bsize;
	int npgs;

	pp = u.u_procp;

	plock(ip);

	/*	Load text region.  Note that if xalloc returns
	 *	an error, then it has already done an iput.
	 */

	if (dpregtyp == PT_DATA)
		u.u_datorg = (caddr_t) -1;

	if ((struct inode *)xalloc(exec_data, tpregtyp) == NULL) 
		return(-1);

	/*
	 *	Allocate the data region.
	 */

	if ((rp = allocreg(ip, RT_PRIVATE)) == NULL) {
		prele(ip);
		goto out;
	}

	/*
	 *	Attach the data region to this process.
	 */

	if (dpregtyp == PT_DATA) {
		u.u_datorg = (caddr_t)dbase;		/* beginning of data */
		u.u_tsize = btoc(exec_data->ux_tsize);
		u.u_dsize = btoc(dsize + bsize);
	}

	prp = attachreg(rp, &u, dbase & ~SOFFMASK, dpregtyp, SEG_RW);
	if (prp == NULL) {
		freereg(rp);
		goto out;
	}

	/*
	 * Load data region
	 */

	if (dsize) {
		switch (exec_data->ux_mag) {
		case 0413:
		case 0443:
			if (mapreg(prp, dbase, ip, doffset, dsize)) {
				detachreg(prp, &u);
				goto out;
			}
			break;
			/* fall thru case if REMOTE */
		default: 
			if (loadreg(prp, dbase,  ip, doffset, dsize)) {
				detachreg(prp, &u);
				goto out;
			}
		}
	}

	/*
	 * Allocate bss as demand zero
	 */

	npgs = btoc(dbase + dsize + bsize) - btoc(dbase + dsize);

	if (npgs)  {
		if (growreg(prp, npgs, DBD_DZERO) < 0) {
			detachreg(prp, &u);
			goto out;
		}
	}

	regrele(rp);

	/* set SUID/SGID protections, if no tracing */

	if (tpregtyp == PT_TEXT) {
		if (!PTRACED(pp)) {
			auth_exec(ip);
		}
		if (pp->p_flag & STRC)
			psignal(pp, SIGTRAP);
	}

	if ( IS_POSIX() )
		FS_IUPDAT(ip, &time, &time);
	iput(ip);
	return(0);
out:
	if (u.u_error == 0)
		u.u_error = ENOEXEC;

	plock(ip);
	iput(ip);

	return(-1);
}


/*
 * Build the user's stack.
 */

stackbld(nargc)
register int	nargc;
{
	reg_t   *rp;
	preg_t  *prp;

	/*	Allocate a region for the stack and attach it to
	 *	the process.
	 */

	if ((rp = allocreg(NULL, RT_PRIVATE)) == NULL)
		return(-1);

	if ((prp = attachreg(rp, &u, USERSTACK_END, PT_STACK, SEG_RW)) == NULL){
		freereg(rp);
		return(-1);
	}
	
	/*	Grow the stack but don't actually allocate
	 *	any pages.
	 */
	nargc = btoc(nargc);

	if (growreg(prp, SSIZE+nargc, DBD_DZERO) < 0) {
		detachreg(prp,&u);
		return(-1);
	}
	
	u.u_sub = (uint)userstack - ctob(rp->r_pgsz);
	u.u_ssize = rp->r_pgsz;
	regrele(rp);

	return(0);
}


exec_err(shlb_data, n)
register struct exdata *shlb_data;
register int    n;
{
	for (; n > 0; --n, ++shlb_data) {
		plock(shlb_data->ip);
		iput(shlb_data->ip);
	}

	plock(u.u_exdata.ip);
	iput(u.u_exdata.ip);
}


/* 
 * read in pathname from kernel space
 * returns -2 is pathname is too long, otherwise
 * returns the pathname length
 */

spath(from, to, maxbufsz)
register char *from, *to;
register int	maxbufsz;
{
register i;

	for (i=0; i<maxbufsz; i++) 
		if (from[i] == 0)
			break;
	if (i == maxbufsz)	
		return(-2);	/* pathname too long */

	bcopy(from, to, i+1);
	return(i+1);		/* length of pathname, null char included */
}

/*
 * read in pathname from user space
 * returns -2 if the pathname is too long, -1 if a bad user 
 * address is supplied, otherwise returns the pathname length
 */

upath(from, to, maxbufsz)
register char *from, *to;
register int	maxbufsz;
{
register int ret;

	if (server())		/* if server process */
		return(spath(from, to, maxbufsz));

	if ((int)from < 0 || from >= (char *)USERSTACK_END)
		return(-1);

	if ((ret = findnull(from, maxbufsz)) == -1)
		return(-2);		/* pathname too long */

	copyin(from, to, maxbufsz-ret);

	return(maxbufsz-ret-1);
}


getshlibs(bp, dat_start)
register unsigned	*bp;
register struct exdata	*dat_start;
{
	register struct inode	*ip  = u.u_exdata.ip;
	register struct exdata	*dat = dat_start;
	register unsigned	nlibs = u.u_exdata.ux_nshlibs;
	register unsigned	rem_wrds;
	register unsigned	current_lib = 0;

	u.u_base = (caddr_t)bp;
	u.u_count = u.u_exdata.ux_lsize ;
	u.u_offset = u.u_exdata.ux_loffset ;
	u.u_segflg = 1;				/* read into system space */

	FS_READI(ip);

	if (u.u_count != 0) {
		iput(ip);
		return(-1);
	}

	ip->i_flag |= ITEXT;
	prele(ip);

	/* dat is the first address past the shared library section header */
	while ((bp < (unsigned int *)dat_start) && (current_lib < nlibs)) {

		/* Check the validity of the shared lib entry. */

		if ((bp[0] > (rem_wrds = (unsigned int *)dat_start - bp)) ||
		    (bp[1] > rem_wrds) || (bp[0] < 3)) {
			u.u_error = ELIBSCN;
			goto bad;
		}

		/* Locate the shared lib and get its header info.  */

		u.u_syscall = DUEXEC;	/* ?? */

		u.u_dirp = (caddr_t)(bp + bp[1]);
		bp += bp[0];

		if ((ip = namei(spath, 0)) == NULL) {
			u.u_error = ELIBACC;
			goto bad;
		}

		if (gethead(ip, dat) == -1) {
			if (u.u_error == EACCES)
				u.u_error = ELIBACC;
			else if (u.u_error != ENOMEM)
				u.u_error = ELIBBAD;
			goto bad;
		}

		if (dat->ux_mag != 0443) {
			u.u_error = ELIBBAD;
			iput(ip);
			goto bad;
		}

		ip->i_flag |= ITEXT;
		prele(ip);

		++dat;
		++current_lib;
	}

	if (current_lib != nlibs) {
		u.u_error = ELIBSCN;
		goto bad;
	}

	return(0);
bad:
	exec_err(dat_start, current_lib);
	return(-1);
}


/*
 *	Run Time Library System Calls
 */

struct libargs	{
	char	*l_path;
	char	*l_buf;
	int	l_flags;
};

struct lib_stat {
	caddr_t		lb_lib;		/* library control */
	unsigned long	lb_status;	/* status of attach */
	unsigned long	lb_flags;	/* library flags */
};

/* lb_status flags */

#define	LS_PREV	0x1	/* Library was previously attached */

/* Format of a .lib section */

#define MAXLIB	256	/*maximum size of a .lib section */
#define L_TOTAL 0	/* total number of words in the .lib entry */
#define L_TOPATH 1	/* number of words to the pathname information */
#define L_EXTRA 2	/* the start of the "extra" structure */

/* Format of an "extra" structure */

#define L_LENGTH 0	/* Length of an "extra" structure */
#define L_CODE	1	/* The "type" of information */
#define L_VALUE 2	/* the start of the value */

/* L_CODE values */

#define L_FLAGS 1	/* the type of a flags entry */
#define L_LBLIB 2	/* the type of a library section */

/* l_flags must be 0, or (ARIX extension) LAF_ANYWHERE */

#define LAF_NORMAL	0	/* attach at COFF header address	*/
#define LAF_ANYWHERE	1	/* if COFF address in use, try anywhere	*/


/*
 * libchk -- do a quick test to see if the shared library's desired
 *		virtual address is available
 *	Return 0 if available, else return 1.
 */

static
libchk(exec_data)
register struct exdata	*exec_data;
{
	register preg_t	*prp;
	register reg_t	*rp;
	register uint	start, end, tstart, tend, dstart, dend;

	tstart = exec_data->ux_txtorg;
	tend = ctost(btoct(tstart + exec_data->ux_tsize - 1));
	tstart = ctost(btoct(tstart));
	dstart = exec_data->ux_datorg;
	dend = dstart + exec_data->ux_dsize + exec_data->ux_bsize - 1;
	dend = ctost(btoct(dend));
	dstart = ctost(btoct(dstart));

	for (prp = u.u_procp->p_region; rp = prp->p_reg; prp++) {
		if (prp->p_type == PT_STACK) {
			end = (uint)prp->p_regva + USERSTACK_OFF - 1;
			start = end - ctob(rp->r_pgsz) + 1;
		}
		else {
			start = (uint)prp->p_regva;
			end = start + ctob(rp->r_pgsz) - 1;
		}
		end = ctost(btoct(end));
		if (tstart > end && dstart > end)
			continue;			/* addr too high */
		start = ctost(btoct(start));
		if (dend < start && tend < start)
			continue;			/* addr too low */

		return (1);				/* occupied */
	}

	return (0);					/* available */
}

/*
 * librelocate -- relocate a shared library, returns non-zero on failure
 */

static
librelocate(exec_data)
register struct exdata	*exec_data;
{
	register uint	size, tsize;
	extern uint	shmaddr();

	/* find the size of the combined shlib text and data segments */

	exec_data->ux_datorg &= SOFFMASK;	/* now segment offsets	*/
	exec_data->ux_txtorg &= SOFFMASK;
	tsize = exec_data->ux_txtorg;
	tsize += exec_data->ux_tsize - 1;
	tsize = (tsize + SOFFMASK) & ~SOFFMASK;	/* round up to segment	*/

	size = tsize + exec_data->ux_datorg;
	size += exec_data->ux_dsize + exec_data->ux_bsize;

	/* use shmaddr to find enough segments to hold size bytes */

	if ((size = shmaddr(size)) == 0)	/* new starting address	*/
		return (1);

	/* new origins = new starting addresses + old segment offsets */

	exec_data->ux_txtorg += size;
	exec_data->ux_datorg += size + tsize;

	return (0);
}


libattach()
{
	struct	inode	*ip;
	struct	exdata	lib_head;
	unsigned long	libdata[MAXLIB/sizeof(unsigned long)];
	struct	lib_stat lb_ret;
	preg_t	*prp;
	unsigned	ep, t;
	uint		anywhere;

	/*
	 * l_flags is available for future system call expansion.
	 */
	switch (((struct libargs *)u.u_ap)->l_flags) {
	case LAF_NORMAL:
		anywhere = 0;
		break;
	case LAF_ANYWHERE:
		anywhere = 1;
		break;
	default:
		u.u_error = EINVAL;
		return;
	}

	/*
	 * In case the system call goes remote set u_syscall.
	 */
	u.u_syscall = DUEXEC;

	/*
	 * gethead does iput on error
	 */
	if (((ip = namei(upath, 0)) == NULL) || (gethead(ip, &lib_head) == -1))
		return;

	if (lib_head.ux_mag != 0443) {
		u.u_error = ELIBBAD;
		iput(ip);
		return;
	}

	/*
	 * Truncate the size of the .lib section if too big and try
	 * to process anyways.
	 */

	if (lib_head.ux_lsize > MAXLIB)
		lib_head.ux_lsize = MAXLIB;

	ip->i_flag |= ITEXT;
	prele(ip);

	lb_ret.lb_lib = (caddr_t) NULL;
	lb_ret.lb_flags = NULL;
	lb_ret.lb_status = NULL;

	/*
	 * Verify that a .lib section exists.  If it doesn't, continue
	 * without generating an error.  Otherwise, extract the "extra"
	 * information from the first .lib entry.  Ignore the remaining
	 * .lib entries
	 */
	if (lib_head.ux_loffset != 0 && lib_head.ux_lsize != 0) {
		register int lsize;

		u.u_base = (caddr_t) libdata;
		u.u_count = lib_head.ux_lsize;
		u.u_offset = lib_head.ux_loffset;
		u.u_segflg = 1;

		FS_READI(ip);

		if (u.u_count != 0) {
			if (u.u_error == 0)
				u.u_error = ELIBSCN;
			goto badatt;
		}

		lsize = lib_head.ux_lsize/sizeof(unsigned long);

		if (libdata[L_TOPATH] > lsize) {
			u.u_error = ELIBSCN;
			goto badatt;
		}
		ep = L_EXTRA;
		while( ep < libdata[L_TOPATH]) {
			/*
			 * Ignore without error any entries that aren't
			 * known types
			 */
			switch (libdata[ep + L_CODE]) {
			 case L_FLAGS:
				lb_ret.lb_flags = libdata[ep + L_VALUE];
				break;
			 case L_LBLIB:
				lb_ret.lb_lib = (caddr_t)libdata[ep + L_VALUE];
				break;
			}
			/*
			 * cast to a long to avoid carries on the increment
			 */
			t = ep;
			if ((long)libdata[t + L_LENGTH] <= 0 ||
			    (ep += libdata[t + L_LENGTH]) > libdata[L_TOPATH]) {
				u.u_error = ELIBSCN;
				goto badatt;
			}
		}
		/*
		 * Check for a malformed .lib entry
		 */
		if (ep != libdata[L_TOPATH]) {
			u.u_error = ELIBSCN;
			goto badatt;
		}

	}

	/*
	 * Check to see if this library was previously attached
	 */
	for(prp = curproc->p_region;prp->p_reg; prp++)
		if (prp->p_reg->r_iptr == ip) {
			lb_ret.lb_status |= LS_PREV;
			break;
		}

	if (!(lb_ret.lb_status & LS_PREV)) {
		/*
		 * Verify the library can be attached and attach it
		 */
		if (u.u_exdata.ux_nshlibs >= shlbinfo.shlbs) {
			u.u_error = ELIBMAX;
			goto badatt;
		}
		/*
		 * Check if the libary's destination virtual address is
		 * already occupied.  If so, and anywhere is true, try to
		 * relocate the library, otherwise return EINVAL;
		 */
		if (libchk(&lib_head)) {
			if (!anywhere || librelocate(&lib_head)) {
				u.u_error = EINVAL;
				goto badatt;
			}
		}
		if (getxfile(&lib_head, PT_LIBTXT, PT_LIBDAT) < 0) {
			(void) libdetacher(lib_head.ux_txtorg);
			return;
		}
		u.u_exdata.ux_nshlibs++;
	} else {
		/*
		 * The library is already attached so don't increment
		 * the use count.
		 */
		plock(ip);
		iput(ip);
	}

	/*
	 * Return the libinfo structure to the caller.  If the
	 * copyout fails, detach the library and return a fault.
	 */
	if(copyout(&lb_ret, ((struct libargs *)u.u_ap)->l_buf, sizeof(lb_ret))) {
		if(!(lb_ret.lb_status & LS_PREV)) {
			(void) libdetacher(lib_head.ux_txtorg);
			u.u_exdata.ux_nshlibs--;
		}
		u.u_error = EFAULT;
		return;
	}

	u.u_rval1 = lib_head.ux_txtorg;
	shlbinfo.shlbatts++;
	return;

badatt:
	plock(ip);
	iput(ip);
}

libdetach()
{
	struct  libdes {
		caddr_t	libdes;
	};

	if(libdetacher(((struct libdes *)u.u_ap)->libdes))
		u.u_exdata.ux_nshlibs--;
	else
		u.u_error = EINVAL;
}

libdetacher(libd)
caddr_t libd;
{
	register preg_t	*prp;
	register reg_t	*rp;
	struct inode	*lib_inode = 0;

	prp = u.u_procp->p_region;

	/*
	 * Scan the pregion table for the inode number of the attached
	 * library.  If none, is found, the address is invalid.
	 */

	for (prp = curproc->p_region; prp->p_reg; prp++)
		if ((prp->p_regva == libd) && prp->p_type == PT_LIBTXT) {
			lib_inode = prp->p_reg->r_iptr;
			break;
		}

	if (lib_inode == 0) {
		return(0);
	}

	/*
	 * Scan the pregion table for the library's regions and detach
	 * them.
	 */
	while (rp = prp->p_reg) {
		if (rp->r_iptr != lib_inode) {
			prp++;
			continue;
		}
		plock(lib_inode);
		reglock(rp);
		u.u_execsz -= rp->r_pgsz - rp->r_gapsz;
		detachreg(prp, &u);
	}
	return(1);
}

A1000_getxfile(exec_data)
register struct exdata	*exec_data;
{
	register reg_t	*rp;
	register preg_t	*prp;
	register struct inode	*ip = exec_data->ip;
	register int 		doffset = exec_data->ux_doffset;
	register int		dbase   = exec_data->ux_datorg;
	register int		dsize   = exec_data->ux_dsize;
	register int		bsize   = exec_data->ux_bsize;
	caddr_t 		org = (caddr_t)(exec_data->ux_toffset);
	int			tsize = exec_data->ux_tsize;
	int 			tbase = exec_data->ux_txtorg;
	int 			regva = tbase & ~SOFFMASK; 
	int			npgs;

	plock(ip);

	/*
	 *	Allocate a region. Note that since A1000 binaries are
	 *	not made at segment boundary, we have to load both text
	 *	and data into a read/write region.
	 */
	if ((rp = allocreg(ip, RT_PRIVATE)) == NULL) {
		prele(ip);
		goto out;
	}

	/*
	 *	Attach the region to this process as data
	 *	and mark it as A1000 attach.
	 */
	prp = attachreg(rp, &u, regva, PT_DATA | PF_A1000, SEG_RW);
	if (prp == NULL) {
		ip->i_count--;
		freereg(rp);
		goto out;
	}

	/*
	 *	Load text
	 */
	if (tsize && A1000_loadreg(prp, (caddr_t)tbase, ip, (int)org, tsize)) {
		ip->i_count--;
		detachreg(prp, &u);
		goto out;
	}
	if (u.u_exdata.ux_mag != 0407)
		chgprot(prp, SEG_TEXT);

	/*
	 *	Load data
	 */
	u.u_datorg = (caddr_t)dbase;		/* beginning of data page */
	u.u_tsize = btoc(tsize);
	u.u_dsize = btoc(dsize + bsize);
	if (dsize && A1000_loadreg(prp, (caddr_t)dbase,  ip, doffset, dsize)) {
		detachreg(prp, &u);
		goto out;
	}

	spin_lock(&region_lock_sem);
	rp->r_flags |= RG_DONE;
	if (rp->r_flags & RG_WAITING) {
		rp->r_flags &= ~RG_WAITING;
		wakeup(&rp->r_flags);
	}
	spin_unlock(&region_lock_sem);

	/*
	 *	Allocate bss as demand zero
	 */
	npgs = btoc(dbase + dsize + bsize) - btoc(dbase + dsize);
	if (npgs > 0 && growreg(prp, npgs, DBD_DZERO) < 0) {
		detachreg(prp, &u);
		goto out;
	}

	regrele(rp);

	/*
	 *	Set SUID/SGID protections, if no tracing
	 */
	if (!PTRACED(u.u_procp)) {
		auth_exec(ip);
	}
	if (u.u_procp->p_flag & STRC)
		psignal(u.u_procp, SIGTRAP);

	iput(ip);
	return(0);
out:
	if (u.u_error == 0)
		u.u_error = ENOEXEC;

	plock(ip);
	/* JTOF - posix wants us to update inode now */
	if ( IS_POSIX() )
		FS_IUPDAT(ip, &time, &time);
	iput(ip);
	return(-1);
}
