/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) errlog.c: version 25.1 created on 11/27/91 at 15:09:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)errlog.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/


#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/map.h"
#include "sys/utsname.h"
#include "sys/elog.h"
#include "sys/erec.h"
#include "sys/err.h"
#include "sys/iobuf.h"
#include "sys/var.h"
#include "sys/synch.h"
#include "sys/debug.h"
#include "sys/mfs.h"

int	blkacty;

errinit()
{
	if (err.e_nslot) {
		mapinit(err.e_map, (err.e_nslot+3)/2);
		mfree(err.e_map, err.e_nslot, 1);
	}
	err.e_org = err.e_ptrs;
	err.e_nxt = err.e_ptrs;
}
struct errhdr *
geteslot(size)
{
	register ns, *p;
	register struct errhdr *ep;
	int n;

	ns = (size+sizeof(struct errhdr)+sizeof(struct errslot)-1)
		/sizeof(struct errslot);

	spin_lock(&errlog_sem);
	n = malloc(err.e_map, ns);
	if (n == 0) {
		spin_unlock(&errlog_sem);
		return(NULL);
	}

	ep = (struct errhdr *)(&err.e_slot[--n]);
	ns *= sizeof(struct errslot)/sizeof(int);
	p = (int *)ep;
	do {
		*p++ = 0;
	} while(--ns);
	ep->e_len = size + sizeof(struct errhdr);
	spin_unlock(&errlog_sem);
	return(++ep);
}

freeslot(ep)
register struct errhdr *ep;
{
	register ns;

	ns = (ep->e_len+sizeof(struct errslot)-1)/sizeof(struct errslot);
	spin_lock(&errlog_sem);
	mfree(err.e_map, ns, (((struct errslot *)ep)-err.e_slot)+1);
	spin_unlock(&errlog_sem);
}

struct errhdr *
geterec()
{
	register struct errhdr *ep;

	spin_lock(&errlog_sem);
	while(*err.e_org == NULL) {
		err.e_flag |= E_SLP;
		mfs_sleep_with_sig_check(&err.e_org, PZERO+1, &errlog_sem);
	}
	ep = *err.e_org;
	*err.e_org++ = NULL;
	if (err.e_org >= &err.e_ptrs[err.e_nslot])
		err.e_org = err.e_ptrs;
	spin_unlock(&errlog_sem);
	return(ep);
}

puterec(ep, type)
register struct errhdr *ep;
{

	(--ep)->e_type = type;
	ep->e_time = time;
	spin_lock(&errlog_sem);
	*err.e_nxt++ = ep;
	if (err.e_nxt >= &err.e_ptrs[err.e_nslot])
		err.e_nxt = err.e_ptrs;
	if (err.e_flag&E_SLP) {
		err.e_flag &= ~E_SLP;
		mfs_wakeup(&err.e_org);
	}
	spin_unlock(&errlog_sem);
}

logstart()
{
	register struct estart *ep;

	ASSERT(is_upkern_lock());

	for(err.e_org = &err.e_ptrs[err.e_nslot-1]; err.e_org >= err.e_ptrs;
	  err.e_org--)
		if (*err.e_org != NULL) {
			freeslot(*err.e_org);
			*err.e_org = NULL;
		}
	err.e_org = err.e_ptrs;
	err.e_nxt = err.e_ptrs;
	ep = (struct estart *)geteslot(sizeof(struct estart));
	if (ep == NULL)
		return;
	ep->e_name = utsname;
	puterec(ep, E_GOTS);
}

logtchg(nt)
time_t nt;
{
	register struct etimchg *ep;

	if ((ep = (struct etimchg *)geteslot(sizeof(struct etimchg))) != NULL) {
		ep->e_ntime = nt;
		puterec(ep, E_TCHG);
	}
}

logstray(addr,type)
physadr addr;
int	type;
{
	register struct estray *ep;

	if ((ep = (struct estray *)geteslot(sizeof(struct estray))) != NULL) {
		ep->e_saddr = addr;
		ep->e_flag = type;
		puterec(ep, E_STRAY);
	}
}

logberr(dp, erf)
register struct iobuf *dp;
{
	register struct eblock *ep;

	if ((ep = dp->io_erec) == NULL)
		return;
	if (erf)
		ep->e_bflags |= E_ERROR;
	puterec(ep, E_BLK);
	dp->io_erec = NULL;
}

logmemory
(er, ad, pmb_priority, rmw, uncorrectable, bytesel, code_access, user_access)
char  pmb_priority, rmw, uncorrectable, bytesel, code_access, user_access;

{
	register struct ememory *ep;

	if ((ep = (struct ememory *)geteslot(sizeof(struct ememory)))!=NULL) {
		ep->e_syndrome = er;
		ep->e_memcad = ad;
		ep->e_pmb_priority = pmb_priority;
		ep->e_rmw = rmw;
		ep->e_uncorrectable = uncorrectable;
		ep->e_bytesel = bytesel;
		ep->e_code_access = code_access;
		ep->e_user_access = user_access;
		puterec(ep, E_PRTY);
	}
}

log_disk_error(phys_drive_no, log_drive_no, log_blk_no, err_code)
{
	register struct edisk *ep;

	if ((ep = (struct edisk *)geteslot(sizeof(struct edisk))) != NULL) {
		ep->e_phys_drive_no = phys_drive_no;
		ep->e_log_drive_no = log_drive_no;
		ep->e_log_blk_no = log_blk_no;
		ep->e_err_code = err_code;
		puterec(ep, E_DISK);
	}
}

#ifndef SYS_VD_H
#include "sys/vd.h"
#endif

log_mirror_err(m, blkno, err_code)
mirror_t	*m;
uint		blkno;
uint		err_code;
{
	register struct emirror *ep;

	if ((ep = (struct emirror *)geteslot(sizeof(struct emirror))) != NULL) {
		ep->em_mirror = m - mr_data;
		ep->em_pri = denotminored(m->m_pri);
		ep->em_sec = denotminored(m->m_sec);
		ep->em_blkno = blkno;
		ep->em_flags = m->m_flags;
		ep->em_err_code = err_code;
		puterec(ep, E_MIRROR);
	}
}
