/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) disp.c: version 25.1 created on 11/27/91 at 15:09:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)disp.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:disp.c	4.2"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/var.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/cmn_err.h"
#include "sys/proc.h"
#include "sys/debug.h"
#include "sys/own.h"
#include "sys/mfs.h"
#include "sys/spm_mem.h"

extern RUNQ	runqs, upkern_runqs;
own_t		*find_best_pm();
proc_t 		*troll_runqs(), *troll(), *refill_next_upkern_proc();
uint		idle_pm_bits;
uint		num_idle_pms;
uint		user_pm_bits;
proc_t		*next_upkern_proc;
uint		next_upkern_pm_id;
uint		upkern_disp_pm_id = NO_PM_ID;

static disp_int_t	resched_int_data;

proc_t *
disp()
{
	register proc_t	*p;

	spin_lock(&runqs_lock);

	own.o_runrun = 0;
	ASSERT(! (idle_pm_bits & own.o_id_bit));

	/* FIX THIS, DS: add o_siderail handling here */

	ASSERT((own.o_curproc->p_stat != SPARKED || 
	  own.o_curproc->p_running == own.o_pm_id));

	own.o_curproc->p_running = NO_PM_ID;
	if (own.o_curproc->p_stat == SPARKED)
		if (own.o_curproc->p_upkern_cnt)
			upkern_setrq(own.o_curproc);
		else
			normal_setrq(own.o_curproc);

	if (next_upkern_proc && upkern_disp()) {
		p = refill_next_upkern_proc();
		ASSERT(p && p->p_upkern_cnt && p->p_stat == SUPKERN);
		p->p_stat = SONPROC;	
		p->p_running = own.o_pm_id;
		own.o_upkern_proc = 1;
		own.o_curproc = p;
		spin_unlock(&runqs_lock);
		ASSERT(is_upkern_lock());
		return(p);
	}

	if (runqs.rq_cnt)
		p = troll_runqs(&runqs, own.o_id_bit);
	else
		p = 0;

	if (! p) {
		if (next_upkern_proc && 
		  (next_upkern_proc->p_dests & own.o_id_bit))
			next_upkern_pm_id = own.o_pm_id;
		own.o_curproc = &own.o_proc;
		own.o_curpri  = PIDLE;
		idle_pm_bits |= own.o_id_bit;
		num_idle_pms++;
	}
	else {
		own.o_curproc = p;
		p->p_stat = SONPROC;
		p->p_running = own.o_pm_id;
	}

	spin_unlock(&runqs_lock);

	return(p);
}


upkern_disp()
{
	extern upkern_t	upkern;

	if (upkern_disp_pm_id == own.o_pm_id) {
		ASSERT(next_upkern_proc);
		ASSERT(next_upkern_proc->p_dests & own.o_id_bit);
		ASSERT(next_upkern_proc->p_stat == SUPKERN);
		ASSERT(is_upkern_lock());
		upkern_disp_pm_id = NO_PM_ID;
		return(1);
	}
	else if (upkern_disp_pm_id != NO_PM_ID)
		return(0);

	if (! (next_upkern_proc->p_dests & own.o_id_bit))
		return(0);
	if (! is_upkern_lock())
		return(0);
	if (! (atom_and(&upkern, ~UPKERN_WAITING_BIT_LONG) & 
	  UPKERN_WAITING_BIT_LONG))
		return(0);

	return(1);
}

proc_t *
troll_runqs(rqp, mask)
register RUNQ	*rqp;
uint		mask;
{
	register proc_t		*p;
	register		index, offset;

	for ( offset = 0; offset < NUM_PRIORITIES; offset = index + 1 ) {

		index = find_first_bit_set(rqp->rq_map, offset, NUM_PRIORITIES);

		if ( index < 0 )
			return(0);

		ASSERT(index < NUM_PRIORITIES);
		ASSERT(rqp->rq_hash[index].rq_head);
		ASSERT(rqp->rq_hash[index].rq_tail);

		if ( p = troll(rqp->rq_hash[index].rq_head, mask) )
			break;			/* got a live one */
	}

	if ( ! p )
		return(0);

	rqp->rq_cnt--;

	if ( rq_remove(p, &rqp->rq_hash[index]) ) {
		ASSERT(is_bit_set(rqp->rq_map, index));
		clear_bit(rqp->rq_map, index);
		ASSERT(! is_bit_set(rqp->rq_map, index));
	}

	ASSERT(p->p_stat == SRUN  &&  (p->p_flag & SLOAD));
	return(p);
}

proc_t	*
troll(p, mask)
register proc_t	*p;
register uint	mask;
{
	for (; p; p = p->p_link) {

		ASSERT(p->p_stat == SRUN);

		if (! (p->p_dests & mask))
			continue;

		if (p->p_swapout)
			continue;

		return(p);
	}
	return(0);
}

setrq(p)
proc_t	*p;
{
	ASSERT(p->p_pri <= 127);

	spin_lock(&runqs_lock);

	/* this stack is still in use, disp() will call setrq() later */
	if (p->p_running != NO_PM_ID) {
		ASSERT(spm_mem.pm_own[p->p_running]->o_curproc == p);
		p->p_stat = SPARKED;
		spin_unlock(&runqs_lock);
		return;
	}

	if (p->p_upkern_cnt)
		upkern_setrq(p);
	else
		normal_setrq(p);

	spin_unlock(&runqs_lock);

}

upkern_setrq(p)
register proc_t	*p;
{
	register own_t	*o;

	ASSERT(p->p_stat != SUPKERN);

	if (next_upkern_proc || p->p_swapout) {
		if (rq_insert(p, &upkern_runqs.rq_hash[p->p_pri])) {
			ASSERT(! is_bit_set(upkern_runqs.rq_map, p->p_pri));
			set_bit(upkern_runqs.rq_map, p->p_pri);
			ASSERT(is_bit_set(upkern_runqs.rq_map, p->p_pri));
		}
		upkern_runqs.rq_cnt++;
		p->p_stat = SRUN;
		return;
	}

	ASSERT(! (upkern.up_cnt & UPKERN_WAITING_BIT_SHORT));
	o = find_best_pm(p);
	next_upkern_pm_id = o->o_pm_id;
	next_upkern_proc = p;
	p->p_stat = SUPKERN;

	if (! upkern_slot_inc(o->o_pm_id))
		return;		/* incremented and set waiting */

	ASSERT(upkern.up_pm_id == o->o_pm_id && upkern.up_cnt);

	/* we got upkern for o */

	if (idle_pm_bits & o->o_id_bit) {
		mate_proc_to_pm(p, o);
		next_upkern_proc = 0;
	}
	else {
		upkern_disp_pm_id = o->o_pm_id;

		if (user_pm_bits & o->o_id_bit)
			queue_level_one(o, resched_int_data);
		else
			o->o_runrun = 1;
	}
}

normal_setrq(p)
register proc_t	*p;
{
	uint	pm_id, suitable_pms;

	ASSERT(! p->p_upkern_cnt);

	if (p->p_swapout || ! (suitable_pms = (idle_pm_bits & p->p_dests))) {
		if ((p->p_dests & own.o_id_bit) && (p->p_pri < own.o_curpri))
			own.o_runrun = 1;

		if (rq_insert(p, &runqs.rq_hash[p->p_pri])) {
			ASSERT(! is_bit_set(runqs.rq_map, p->p_pri));
			set_bit(runqs.rq_map, p->p_pri);
			ASSERT(is_bit_set(runqs.rq_map, p->p_pri));
		}
		runqs.rq_cnt++;
		/*
		 * prevent race with upkern_clock looking at SRUN by setting
		 * SRUN here within the runqs_lock and having SRUN signify
		 * that the process is actually on the runq.
		 */
		p->p_stat = SRUN;

		return;
	}

	/* affinity test */
	if (p->p_last_ran_on & suitable_pms)
		pm_id = find_first_bit_set(&p->p_last_ran_on, 0, SBUS_MAX_NUM_PM);
	/* or me next */
	else if (own.o_id_bit & suitable_pms)
		pm_id = own.o_pm_id;
	/* or wherever */
	else
		pm_id = find_first_bit_set(&suitable_pms, 0, SBUS_MAX_NUM_PM);

	ASSERT(pm_id < spm_mem.num_pm);
	ASSERT(spm_mem.pm_own[pm_id]);
	mate_proc_to_pm(p, spm_mem.pm_own[pm_id]);
}

chgnice(pnice, nice)
int pnice, nice;
{
	if (((nice < 0) || (nice > (NZERO << 1))) && !auth_nice())
		nice = 0;
	nice += pnice;
	if (nice >= (NZERO << 1))
		nice = (NZERO << 1) - 1;
	if (nice < 0)
		nice = 0;
	return (nice);
}

/*
 * set_swapout:
 *
 *	stop p from being dispatched by setting the swapout flags
 */

set_swapout(p)
register proc_t	*p;
{
	register uint	pm_id;

	while (1) {
		spin_lock(&runqs_lock);
		if (next_upkern_proc != p)
			p->p_swapout = 1;
		spin_unlock(&runqs_lock);

		if (p->p_swapout)
			break;
		delay(1);
	}

	while ((pm_id = p->p_running) != NO_PM_ID) {
		ASSERT(pm_id < spm_mem.num_pm);
		ASSERT(spm_mem.pm_own[pm_id]);
		spm_mem.pm_own[pm_id]->o_runrun = 1;
		delay(1);
	}
	atom_and(&p->p_flag, ~SLOAD);
}

/*
 * clr_swapout -- clear the swapout flags, set SLOAD, p is on the runq
 */

clr_swapout(p)
register proc_t	*p;
{
	proc_t	*troll_p;

	spin_lock(&runqs_lock);
	ASSERT(p->p_stat != SUPKERN);
	p->p_swapout = 0;
	atom_or(&p->p_flag, SLOAD);
	if (p->p_upkern_cnt && ! next_upkern_proc && p->p_stat == SRUN) {
		troll_p = troll_runqs(&upkern_runqs, ~0);
		ASSERT(troll_p == p);
		upkern_setrq(p);
	}
	spin_unlock(&runqs_lock);
}

/*
 * cancel_swapout -- clear the swapout flags, set SLOAD, p's state is unknown
 */

cancel_swapout(p)
register proc_t	*p;
{
	proc_t	*troll_p;

	spin_lock(&runqs_lock);
	ASSERT(p->p_stat != SUPKERN);
	p->p_swapout = 0;
	atom_or(&p->p_flag, SLOAD);
	spin_unlock(&runqs_lock);
}

/*
 * rq_remove:
 *
 *	remove proc *p from doubly linked list.  p->p_link is the forward
 *	pointer, and we are using p->p_mlink for the backward pointer.
 *	p->p_mlink is shared with the swapping code.
 *
 * 	return 1 if p was the only proc on queue, otherwise 0.
 */

rq_remove(p, rqhp)
register proc_t		*p;
register RQHASH		*rqhp;
{
	ASSERT(rqhp->rq_head);
	ASSERT(rqhp->rq_tail);
	if ( p == rqhp->rq_head ) {
		ASSERT(!p->p_mlink);
		if ( p == rqhp->rq_tail ) {
			ASSERT(!p->p_link);
			rqhp->rq_head = rqhp->rq_tail = 0;
			return(1);
		}
		else {
			ASSERT(p->p_link);
			rqhp->rq_head = p->p_link;
			p->p_link->p_mlink = 0;
		}
	}
	else if ( p == rqhp->rq_tail ) {
		ASSERT(!p->p_link);
		ASSERT(p->p_mlink);
		rqhp->rq_tail = p->p_mlink;
		p->p_mlink->p_link = 0;
	}
	else {
		ASSERT(p->p_mlink);
		ASSERT(p->p_link);
		p->p_mlink->p_link = p->p_link;
		p->p_link->p_mlink = p->p_mlink;
	}
	return(0);
}

/*
 * rq_insert:
 *
 * 	return 1 if p is the only proc on queue, otherwise 0.
 */

rq_insert(p, rqhp)
register proc_t		*p;
register RQHASH		*rqhp;
{
	uint	retcode;

	if ( rqhp->rq_head ) {
		ASSERT(rqhp->rq_tail);
		ASSERT(!rqhp->rq_head->p_mlink);
		ASSERT(!rqhp->rq_tail->p_link);
		rqhp->rq_tail->p_link = p;
		p->p_mlink = rqhp->rq_tail;
		retcode = 0;
	}
	else {
		ASSERT(!rqhp->rq_tail);
		rqhp->rq_head = p;
		p->p_mlink = 0;
		retcode = 1;
	}
	rqhp->rq_tail = p;
	p->p_link = 0;
	return(retcode);
}

own_t *
find_best_pm(p)
register proc_t	*p;
{
	uint		pm_id, suitable_pms;

	if (! (suitable_pms = (idle_pm_bits & p->p_dests)))
		if (! (suitable_pms = (user_pm_bits & p->p_dests)))
			suitable_pms = p->p_dests;

	ASSERT(suitable_pms);

	/* affinity test */
	if (p->p_last_ran_on & suitable_pms)
		pm_id = find_first_bit_set(&p->p_last_ran_on, 0, SBUS_MAX_NUM_PM);
	/* or me next */
	else if (own.o_id_bit & suitable_pms)
		pm_id = own.o_pm_id;
	/* or wherever */
	else
	pm_id = find_first_bit_set(&suitable_pms, 0, SBUS_MAX_NUM_PM);

	ASSERT(pm_id < spm_mem.num_pm);
	ASSERT(spm_mem.pm_own[pm_id]);
	return(spm_mem.pm_own[pm_id]);
}

/*
 * we have just transisition the upkern from a count of 2 and wanted,
 * to a count of 1 with the wanted bit cleared.
 */

upkern_waiting_handler()
{
	register own_t	*o;
	extern upkern_t	upkern;

	spin_lock(&runqs_lock);

	ASSERT(next_upkern_proc);
	ASSERT(next_upkern_proc->p_stat == SUPKERN);
	ASSERT(upkern.up_pm_id < spm_mem.num_pm);
	ASSERT(spm_mem.pm_own[upkern.up_pm_id]);
	ASSERT(upkern.up_cnt);
	ASSERT(! (upkern.up_cnt & UPKERN_WAITING_BIT_SHORT));
	ASSERT(upkern_disp_pm_id == NO_PM_ID);

	o = spm_mem.pm_own[upkern.up_pm_id];

	ASSERT(next_upkern_proc->p_dests & o->o_id_bit);

	if (idle_pm_bits & o->o_id_bit)
		mate_proc_to_pm(refill_next_upkern_proc(), o);
	else {
		upkern_disp_pm_id = o->o_pm_id;

		if (user_pm_bits & o->o_id_bit)
			queue_level_one(o, resched_int_data);
		else
			o->o_runrun = 1;
	}

	spin_unlock(&runqs_lock);
}


/* initialize interrupt data to be used for resched interrupts */

resched_intr_init()
{

	resched_int_data.fields.vector = RESCHED;
	resched_int_data.fields.level = MOT_LEVEL_ONE;
	resched_int_data.fields.directed = NON_DIRECTED;
}

void
resched_intr()
{
	own.o_runrun = 1;
}

upkern_slot_inc(pm_id)
ushort	pm_id;
{
	register uint	retval;
	upkern_t	old_upkern, new_upkern;
	extern upkern_t	upkern;

	do {
		old_upkern = upkern;
		new_upkern = old_upkern;

		new_upkern.up_cnt++;

		if (! old_upkern.up_cnt) {
			new_upkern.up_pm_id = pm_id;
			retval = 1;
		}
		else if (old_upkern.up_pm_id == pm_id)
			retval = 1;
		else {
			new_upkern.up_cnt |= UPKERN_WAITING_BIT_SHORT;
			retval = 0;
		}
	} while (! cas_long(&upkern,*(uint *)&old_upkern,*(uint *)&new_upkern));

	return(retval);
}


mate_proc_to_pm(p, o)
proc_t	*p;
own_t	*o;
{
	extern upkern_t	upkern;

	idle_pm_bits &= ~o->o_id_bit;
	num_idle_pms--;
	p->p_stat = SONPROC;
	p->p_running = o->o_pm_id;
	if (p->p_upkern_cnt) {
		ASSERT(upkern.up_cnt && upkern.up_pm_id == o->o_pm_id);
		o->o_upkern_proc = 1;
	}
	o->o_curproc = p;	/* go */
}

proc_t *
refill_next_upkern_proc()
{
	proc_t		*p;
	extern upkern_t	upkern;

	ASSERT(upkern.up_cnt);
	p = next_upkern_proc;
	ASSERT(p);
	if (next_upkern_proc = troll_runqs(&upkern_runqs, ~0)) {
		next_upkern_proc->p_stat = SUPKERN;
		next_upkern_pm_id = find_best_pm(next_upkern_proc)->o_pm_id;
		upkern_waiting_inc();
		ASSERT(upkern.up_cnt >= 2);
	}
	return(p);
}

disp_change_pri(p, new_pri)
register proc_t	*p;
register uchar	new_pri;
{
	if (p->p_upkern_cnt) {
		if (rq_remove(p, &upkern_runqs.rq_hash[p->p_pri]))
			clear_bit(upkern_runqs.rq_map, p->p_pri);
		if (rq_insert(p, &upkern_runqs.rq_hash[new_pri]))
			set_bit(upkern_runqs.rq_map, new_pri);
	} else	{
		if (rq_remove(p, &runqs.rq_hash[p->p_pri]))
			clear_bit(runqs.rq_map, p->p_pri);
		if (rq_insert(p, &runqs.rq_hash[new_pri]))
			set_bit(runqs.rq_map, new_pri);
	}
	p->p_pri = new_pri;
}
