/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) clock.c: version 25.1 created on 11/27/91 at 15:08:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)clock.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/os:clock.c	1.7"

#include "sys/types.h"
#include "sys/tuneable.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/callo.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/conf.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/cmn_err.h"
#include "sys/map.h"
#include "sys/swap.h"
#include "sys/psl.h"
#include "sys/debug.h"
#include "sys/own.h"
#include "sys/sbus.h"
#include "sys/spm_mem.h"
#include "sys/lio.h"
#include "sys/sbus_pm.h"
#include "sys/sbus_spm.h"
#include "sys/pm_iomap.h"
#include "sys/ints.h"
#include "sys/kmem.h"
#include "sys/synch.h"
#include "sys/time.h"
#include "sys/mfs.h"
#ifdef	PERF
#include "sys/perf.h"
#include "sys/perfext.h"
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#endif	/* PERF */

/*
 * clock is called straight from
 * the real time clock interrupt.
 *
 * Functions:
 *	reprime clock
 *	implement callouts
 *	maintain user/system times
 *	maintain date
 *	profile
 *	alarm clock signals
 *	jab the scheduler
 */

#define	PRF_ON	01
unsigned	prfstat;
extern struct sit cicsit;
extern int	vhand();
extern int	bdflush();
extern int	s54kbdflush();

extern time_t	time;

static disp_int_t	timein_val;	 /* used by upkern_clock 
					  * to queue timein interrupts
					  */

#define	TIN_QUEUED	0x01		/* timein has been scheduled	*/
#define	TIN_NEEDED	0x02		/* need to schedule timein	*/

static int	timein_queued;		/* NOT protected by callout_lock */
static int	callouts_active;	/* protected by callout_lock */
static int	one_sec = 1;	/* get stats immediately upon boot */

int		vhandcnt;	/* counter for t_vhandr	*/
int		bdflushcnt;	/* counter for t_bdflushr */
uint		sxbrkcnt;	/* count of procs whose current stat is SXBRK */

clock(pc, ps)
caddr_t pc;
{
	register struct proc	*pp;
	register preg_t		*prp;
	register reg_t		*rp;
	register struct callo	*p1;
	register unsigned long	tvar;
	swpt_t			*st;
	int	 		rqlen, sqlen;
	int			doaddupc;

	ASSERT(own.o_clock != 0);
	ASSERT(own.o_clock != CLOCK_ENABLE);
	ASSERT(((own.o_clock == CLOCK_LEADER) && is_upkern_lock())
		|| (own.o_clock == CLOCK));

	/*
	 * if panic stop clock
	 */
	if (panicstr) {
		clkreld();
		if (own.o_clock == CLOCK_LEADER)
			upkern_dec();
		return;
	}
	doaddupc = 0;
	pp = u.u_procp;
	if (USERMODE(ps)) {
		tvar = CPU_USER;
		u.u_utime++;
		/* return 1 to tell clock to do user profiling */
		if (u.u_prof.pr_scale)
			doaddupc = 1;
		if (u.u_timer[ITIMER_VIRTUAL].it_value) {
			if (--(u.u_timer[ITIMER_VIRTUAL].it_value) <= 0) {
				u.u_timer[ITIMER_VIRTUAL].it_value =
					u.u_timer[ITIMER_VIRTUAL].it_interval;
				psignal(pp, SIGVTALRM);
			}
		}
	} else {
		if (own.o_is_idle) {
			if (syswait.iowait+syswait.swap+syswait.physio) {
				tvar = CPU_WAIT;
				if (syswait.iowait)
					atom_inc(&sysinfo.wait[W_IO]);
				if (syswait.swap)
					atom_inc(&sysinfo.wait[W_SWAP]);
				if (syswait.physio)
					atom_inc(&sysinfo.wait[W_PIO]);
			} else
				if (sxbrkcnt)
					tvar = CPU_SXBRK;
				else
					tvar = CPU_IDLE;
		} else {
			tvar = CPU_KERNEL;
			u.u_stime++;
#ifdef RFS
			if (server()) dinfo.serve++;/* ticks servicing remote */
#endif
		}
	}
	atom_inc(&sysinfo.cpu[tvar]);
	if (prfstat & PRF_ON)
		prfintr(pc, ps);
	if (!own.o_is_idle) {
		if (u.u_timer[ITIMER_PROF].it_value) {
			if (--(u.u_timer[ITIMER_PROF].it_value) <= 0) {
				u.u_timer[ITIMER_PROF].it_value =
					u.u_timer[ITIMER_PROF].it_interval;
				psignal(pp, SIGPROF);
			}
		}
	}
	/* update memory usage for the currently running process */
	if (pp->p_stat==SONPROC)  {
		for (prp = pp->p_region; (rp = prp->p_reg); prp++)
			if (rp->r_type == RT_PRIVATE)
				u.u_mem += rp->r_nvalid;
			else
				if (rp->r_refcnt)
					u.u_mem += rp->r_nvalid/rp->r_refcnt;
	}
#ifdef	PERF
	CLKCPU(pp);
	CLKPRI(pp,ps);
#else	/* PERF */
	if (!own_switching && (pp->p_cpu < 80))
		pp->p_cpu++;
#endif	/* PERF */
	if (--pp->p_lticks <= 0)
		own.o_runrun = 1;
	if (own.o_clock == CLOCK) {
		own.o_clock = CLOCK_ENABLE;
		if (doaddupc)
			addupc(pc,&u.u_prof,1);
		return;
	}
	/*
	 * Update real-time timeout queue.
	 * At front of queue are some number of events which are ``due''.
	 * The time to these is <= 0 and if negative represents the
	 * number of ticks which have passed since it was supposed to happen.
	 * The rest of the q elements (times > 0) are events yet to happen,
	 * where the time for each is given as a delta from the previous.
	 * Decrementing just the first of these serves to decrement the time
	 * to all events.
	 *
	 * Converted to use forward link list ala BSD.
	 */
	if (callouts_active > 0) {	/* Should this be protected ??? */
		spin_lock(&callout_lock);
		p1 = calltodo.c_next;
		while (p1) {
			if (--p1->c_time > 0)
				break;
			timein_queued |= TIN_NEEDED;	/* OR it in */
			if (p1->c_time == 0)
				break;
			p1 = p1->c_next;
		}
		spin_unlock(&callout_lock);
		if ((timein_queued & TIN_NEEDED) &&
				(!(timein_queued & TIN_QUEUED))) {
			timein_queued = TIN_QUEUED; /* turns off TIN_NEEDED */
			queue_level_one(spm_mem.pm_own[upkern_inc()],
				timein_val);
		}
	}
	/* "double" long arithmetic for minfo.freemem */
	if (!BASEPRI(ps)) {
		tvar = minfo.freemem[0];
		minfo.freemem[0] += freemem;
		if (minfo.freemem[0] < tvar)
			minfo.freemem[1]++;
	}
	/* if interrupted an interrupt routine, then return */
	if ((--one_sec <= 0) && !BASEPRI(ps)) {
		one_sec += HZ;
		minfo.freeswap = 0;
		for (tvar = 0, st = swaptab; tvar < MSFILES; tvar++, st++) {
			if (st->st_ucnt != NULL)
				minfo.freeswap += st->st_nfpgs << DPPSHFT;
		}
		++time;
		rqlen = 0;
		sqlen = 0;
		spin_lock(&runqs_lock);
		for (pp = &proc[0]; pp < (struct proc *)v.ve_proc; pp++) {
			if (!pp->p_stat)
				continue;
			if (pp->p_time != 127)
				pp->p_time++;
			if (pp->p_clktim > 0) {
				if (--pp->p_clktim == 0) {
					spin_unlock(&runqs_lock);
					psignal(pp, SIGALRM);
					spin_lock(&runqs_lock);
				}
			}
			if (pp->p_stat == SRUN) {
				if (pp->p_flag & SLOAD)
					rqlen++;
				else
					sqlen++;
			}
			/*
			 *	DON'T change the order of the following calls.
			 */
#ifdef	PERF
			UKCLKCPU(pp);		/* modifies p_cpu	*/
			if (UKCLKSLP(pp) > 1)
				continue;
			UKCLKPRI(pp);		/* modifies p_pri	*/
#else	/* PERF */
			pp->p_cpu >>= 1;
			if (pp->p_pri < (PUSER - NZERO))
				return;
			{
				register uchar	pri;

				pri = calcppri(pp);
				ASSERT((pri >= (PUSER - NZERO)) &&
					(pri < NUM_PRIORITIES));
				if ((pri != pp->p_pri) && (pp->p_stat == SRUN)){
					disp_change_pri(pp, pri);
					ASSERT((pp->p_pri >= (PUSER - NZERO)) &&
						(pp->p_pri < NUM_PRIORITIES));
				}
			}
#endif	/* PERF */
		}
		spin_unlock(&runqs_lock);
		if (rqlen) {
			sysinfo.runque += rqlen;
			sysinfo.runocc++;
		}
		if (sqlen) {
			sysinfo.swpque += sqlen;
			sysinfo.swpocc++;
		}
#ifdef RFS
		dinfo.nservers += nservers;	/* cumul. tally of servers */
		if (idleserver) {
			dinfo.srv_que += idleserver;	/* idle servers in Q */
			dinfo.srv_occ++;		/* sec's srv Q occ'd */
		}
		if (msglistcnt) {
			dinfo.rcv_que += msglistcnt;	/* receive descr in Q */
			dinfo.rcv_occ++;		/* sec's rcv Q occ'd */
		}
#endif
		/*
		 * Wake up page ageing proc every t_vhandr secs
		 * unless memory is available.
		 */
		if (--vhandcnt <= 0)  {
			vhandcnt = tune.t_vhandr;
			if (freemem < tune.t_vhandl)
				wakeup(vhand);
		}
		/*	Wake up bdflush to write out DELWRI
		**	buffers which have been around too long.
		*/

		/* this is to stagger this by one second from bdflush */
		if (bdflushcnt-- == tune.t_bdflushr)
			wakeup(s54kbdflush);

		if (bdflushcnt <= 0) {
			bdflushcnt = tune.t_bdflushr;
			wakeup(bdflush);
		}

		if (runin != 0) {
			runin = 0;
			setrun(&proc[0]);
		} else	{
			if ((sqlen > 0) && (freemem >= tune.t_gpgslo)
				/* && runout */ )
			{
				runout = 0;
				setrun(&proc[0]);
			}
		}
	}
	upkern_dec();
	own.o_clock = CLOCK_ENABLE;
	if (doaddupc)
		addupc(pc,&u.u_prof,1);
	return;
}

/*
 * timeout is called to arrange that fun(arg) is called in tim/HZ seconds.
 * An entry is sorted into the callout structure.
 * The time in each structure entry is the number of HZ's more
 * than the previous entry. In this way, decrementing the
 * first entry has the effect of updating all entries.
 *
 * The panic is there because there is nothing
 * intelligent to be done if an entry won't fit.
 *
 * Converted to use forward link list ala BSD.
 */

int	timeid;

timeout(fun,arg,t)
int		(*fun)();
caddr_t		arg;
register int	t;
{
register struct	callo	*p1, *p2, *pnew;

	if (t <= 0)
		t = 1;
	spin_lock(&callout_lock);
	pnew = callfree;
	if (pnew == NULL)
		cmn_err(CE_PANIC,"Timeout table overflow");
	callfree = pnew->c_next;
	for (p1 = &calltodo; (p2 = p1->c_next) && (p2->c_time < t); p1 = p2)
		if (p2->c_time > 0)
			t -= p2->c_time;
	p1->c_next	= pnew;
	pnew->c_next	= p2;
	pnew->c_arg	= arg;
	pnew->c_func	= fun;
	pnew->c_time	= t;
	pnew->c_id	= ++timeid;
	if (pnew->c_id == 0)
		pnew->c_id = ++timeid;
	if (p2)
		p2->c_time -= t;
	callouts_active++;
	spin_unlock(&callout_lock);
	return(pnew->c_id);		/* HH: timeid may have changed */
}

/*
 * The untimeout() routine is called to remove a function timeout call
 * from the callout structure.
 *
 * Converted to use forward link list ala BSD.
 */
untimeout(id)
register id;
{
	register struct callo *p1, *p2;

	spin_lock(&callout_lock);
	for (p1 = &calltodo; (p2 = p1->c_next) != 0; p1 = p2) {
		if (p2->c_id == id) {
			callouts_active--;
			if (p2->c_next && p2->c_time > 0)
				p2->c_next->c_time += p2->c_time;
			p1->c_next = p2->c_next;
			p2->c_next = callfree;
			callfree = p2;
			break;
		}
	}
	spin_unlock(&callout_lock);
}

/*
 * The chk_timeout() routine is called to remove a function timeout call
 * from the callout structure based on the argument.
 * It is called from qdetach to clean up after queues that may not clean
 * up after themselves.
 */
chk_timeout(arg1, arg2)
register caddr_t  arg1, arg2;
{
	register struct callo *p1, *p2;

	spin_lock(&callout_lock);
	for (p1 = &calltodo; (p2 = p1->c_next) != 0; p1 = p2) {
		if (p2->c_arg == arg1 || p2->c_arg == arg2) {
			callouts_active--;
			if (p2->c_next && p2->c_time > 0)
				p2->c_next->c_time += p2->c_time;
			p1->c_next = p2->c_next;
			p2->c_next = callfree;
			callfree = p2;
			break;
		}
	}
	spin_unlock(&callout_lock);
}

/*
 * This routine is protected by the callout_lock.
 */
void
timein()
{
	register struct callo *p1;
	register caddr_t arg;
	register int (*func)();

	spin_lock(&callout_lock);
	timein_queued = 0;	/* turn off TIN_QUEUED and TIN_NEEDED */
	if (callouts_active <= 0) {
		spin_unlock(&callout_lock);
		upkern_dec();
		return;
	}
	while ((p1 = calltodo.c_next) && (p1->c_time <= 0)) {
		arg = p1->c_arg;
		func = p1->c_func;
		calltodo.c_next = p1->c_next;
		p1->c_next = callfree;
		callfree = p1;
		callouts_active--;
		spin_unlock(&callout_lock);
		(*func)(arg);
		spin_lock(&callout_lock);
	}
	spin_unlock(&callout_lock);
	upkern_dec();
}

delay_done(arg)
caddr_t arg;
{
	spin_lock(&delay_lock);
	mfs_wakeup(arg);
	spin_unlock(&delay_lock);
}

#define	PDELAY	(PZERO-1)
delay(ticks)
register int	ticks;
{
	int	time_to_wakeup;

	time_to_wakeup = ticks + lbolt;
	while (ticks > 0) {
		spin_lock(&delay_lock);
		timeout(delay_done, (caddr_t)u.u_procp+1, ticks);
		mfs_sleep((caddr_t)u.u_procp+1, PDELAY, &delay_lock);
		spin_unlock(&delay_lock);
		ticks = time_to_wakeup - lbolt;
	}
}

clkstart()
{
	register int	n;
	register own_t	**o;
	struct callo	*cp;

	/*
	 * Initialize callouts
	 */
	for (n = v.v_call, cp = &callout[n - 1]; --n >= 0; --cp) {
		cp->c_next = callfree;
		callfree = cp;
	}
	ASSERT(callfree == callout);
	time = spm_mem.spm_time;
	timein_val.fields.vector = TIMEIN;
	timein_val.fields.level = MOT_LEVEL_ONE;
	timein_val.fields.directed = NON_DIRECTED;

	for (n = spm_mem.num_pm, o = spm_mem.pm_own; --n >= 0; o++)
		(*o)->o_clock= CLOCK_ENABLE;
}
