/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) trap.c: version 25.1 created on 11/27/91 at 15:08:31	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)trap.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

#ident	"@(#)uts/os/M68040:trap.c	23.2"

#include "sys/types.h"
#include "sys/immu.h"
#include "sys/cmn_err.h"
#include "sys/systm.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/state.h"
#include "sys/psl.h"
#include "sys/trap.h"
#include "sys/own.h"
#include "sys/utsname.h"
#include "sys/elog.h"
#include "sys/erec.h"
#include "sys/sysmacros.h"
#include "sys/pwrf.h"
#include "sys/var.h"
#include "sys/spl.h"
#include "sys/lio.h"
#include "sys/debug.h"
#include "sys/sysinfo.h"
#ifdef	PERF
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#endif	/* PERF */


extern	int	bootstate;
char	*get_except_name();

/*
 * u_resched -- request to reschedule processor when in user mode
 */

extern uint		user_pm_bits;

u_resched(stk_frame)
struct	state	stk_frame;	/* stk_frame is value/result */
{
	register struct proc 	*pp;
	register time_t   	syst;

	atom_and(&user_pm_bits, ~own.o_id_bit);

	pp = u.u_procp;
	syst = u.u_stime;
	u.u_astk = &stk_frame;

	qswtch();

	if (ISSIG(pp, FORREAL)) {
		upkern_lock();
		psig();
	}

	if (u.u_prof.pr_scale)
		addupc(stk_frame.s_pc, &u.u_prof, (int)(u.u_stime-syst));

#ifdef	PERF
	USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
	own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */

	u_trap_done();
}


/*
 * u_trap -- general exception handler when in user mode
 */

u_trap(stk_frame)
struct	state	stk_frame;	/* stk_frame is value/result */
{
	register struct proc 	*pp;
	register time_t   	syst;
	register unsigned 	sig_pending;
	extern uint		user_pm_bits;

	atom_and(&user_pm_bits, ~own.o_id_bit);

	pp = u.u_procp;
	syst = u.u_stime;
	u.u_astk = &stk_frame;
	sig_pending = 0;

	switch (stk_frame.s_vector) {
	case ZDVDERR:
		sig_pending = SIGIOT;
		goto usertrap;

	case CHKTRAP:	/* CHK and CHK2 (M68020 only) trap */
		sig_pending = SIGFPE;
		goto usertrap;

	case ADDRERR:	/* address error */
		sig_pending = SIGBUS;
		goto usertrap;

	case TRAPVFT:	/* TRAPV instruction */
		sig_pending = SIGFPE;
		goto usertrap;

	case FMTERR:	/* bad exception format */
		sig_pending = SIGILL;
		goto usertrap;

	case FPTBSUN:
		if ( own.o_fpu_loaded )
			fpu_save();	/* make sure fpu has been saved */
		/* clear FPCC_N status bit to avoid continual exceptions */
		u.u_fpu.regs.status &= ~FPCC_NAN;
		/* no break */

	case FPTINEX:
	case FPTDZ:
	case FPTUNFL:
	case FPTOPER:
	case FPTOVFL:
	case FPTSNAN:
		sig_pending = SIGFPE;
		break;

	case UNINTR:
	case STRAYFT:
		stray(stk_frame.s_vector<<2);

		u_trap_done();
		return;

#ifndef	M68040	/* 68040 doesn't use this */
	case COPROTV:
		sig_pending = SIGILL;
		break;
#endif	/* M68040 */

	case TRCTRAP:	/* trace trap */
		stk_frame.s_ps &= ~PS_T;	/* turn off trace bit */
		/*
		 * If we traced to send signal after coproc inst, or because
		 * of a pending signal during bus error handling, then don't
		 * set SIGTRAP.
		 */
		if (pp->p_flag & (SSIGTRC | SBUSTRC))
			atom_and(&pp->p_flag, ~(SSIGTRC | SBUSTRC));
		else
			sig_pending = SIGTRAP;
		break;

	case PRIVFLT:	/* privileged instruction fault */
#ifndef	M68040	/* should have been caught by fp emulation for unimpl. instr */
	case L1111FT:	/* Line 1111 emulator trap */
#endif	/* M68040 */
	case L1010FT:	/* Line 1010 emulator trap */
	case INSTERR:	/* Illegal instruction */
		sig_pending = SIGILL;
		goto usertrap;

	case TRAP2:
	case TRAP3:
		sig_pending = SIGILL;
		goto usertrap;

	case TRAP1:
		stk_frame.s_ps &= ~PS_T;		/* turn off trace bit */
		sig_pending = SIGTRAP;
		break;

	default:
usertrap:
		own_runrun++;
		showtrap(&stk_frame);
	}

	if (sig_pending)
		psignal(pp, sig_pending);

	if (u.u_prof.pr_scale)
		addupc(stk_frame.s_pc, &u.u_prof, (int)(u.u_stime-syst));

	if (own.o_runrun != 0) {
#ifdef	PERF
		USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
		own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */
		qswtch();
	}

	if (ISSIG(pp, FORREAL))
		psig();

#ifdef	PERF
	USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
	own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */

	u_trap_done();
}

/*
 * Called from the trap handler when a system call occurs.
 */

systrap(stk_frame)
struct	state	stk_frame;		/* stk_frame is value/result */
{
	register uint		*ap;
	register struct user	*uptr = &u;
	register struct sysent	*callp;
	register proc_t		*pp;
	register int		call_num;
	struct {
		time_t		syst;
	} l;				/* must not be register */

	extern uint		user_pm_bits;

	atom_and(&user_pm_bits, ~own.o_id_bit);

	l.syst = uptr->u_stime;
	atom_inc(&sysinfo.syscall);
	uptr->u_error = 0;
	stk_frame.s_ps &= ~PS_C;
	uptr->u_astk = &stk_frame;

	ap = (uint *) stk_frame.s_sp;
	ap++;					/* skip over return pc */

	call_num = stk_frame.s_d0;
	if (call_num == 0)			/* indir system call */
		call_num = fuword(ap++);
	if (call_num < 0 || call_num >= num_sysent) {
		callp = sysent;
		call_num = 0;
	}
	else
		callp = &sysent[call_num];

	if (callp->sy_narg) {
		copyin(ap, u.u_arg, callp->sy_narg * sizeof(*ap));
		uptr->u_dirp = (caddr_t)uptr->u_arg[0];
	}
	uptr->u_rval1 = 0;
	uptr->u_rval2 = stk_frame.s_d1;
	uptr->u_ap = uptr->u_arg;

	if ( ! callp->sy_multiproc )
		upkern_lock();

	if (bootstate) {
		/*
		 * For performance there is some replication of code
		 * here, so that the references to u_rflags can be
		 * avoided if RFS is not running.
		 */
		uptr->u_syscall = call_num;
		if (setjmp(uptr->u_qsav)) {
			if (!(uptr->u_rflags & U_RSYS) && !uptr->u_error)
				uptr->u_error = EINTR;
		} else
			(*callp->sy_call)();
		uptr->u_rflags &= ~(U_RSYS|U_DOTDOT);
	} else if (!callp->sy_setjmp && shsetjmp(u.u_qsav)) {
/*
 *		WARNING: Since we called shsetjmp and not
 *		setjmp the values of all register variables are 
 *		undefined.
 */
		uptr = &u;
		if (!uptr->u_error)
			uptr->u_error = EINTR;
	} else
		(*callp->sy_call)();

	if (u.u_error) {
		stk_frame.s_d0 = uptr->u_error;
		uptr->u_error = 0;
		stk_frame.s_ps |= PS_C;
		if (++u.u_errcnt & 0x10) {
			u.u_errcnt = 0;
			own_runrun++;
		}
	} else {
		stk_frame.s_d0 = u.u_rval1;
		stk_frame.s_d1 = u.u_rval2;
	}
	pp = uptr->u_procp;
	if (own.o_runrun != 0) {
#ifdef	PERF
		USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
		own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */
		qswtch();
	}

	if (u.u_prof.pr_scale)
		addupc(stk_frame.s_pc, &u.u_prof, (int)(u.u_stime - l.syst));

	if (ISSIG(pp, FORREAL))
		psig();

#ifdef	PERF
	USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
	own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */

	u_trap_done();
}

u_trap_done()
{
	if ( own.o_upkern_proc )
		upkern_unlock_all();	/* give up the uni-processor kernel */

	ASSERT((u.u_procp->p_pri >= (PUSER - NZERO)) &&
		(u.u_procp->p_pri < NUM_PRIORITIES));

	if (own.o_runrun)
		qswtch();

	ASSERT((u.u_procp->p_pri >= (PUSER - NZERO)) &&
		(u.u_procp->p_pri < NUM_PRIORITIES));

	/* check for fpu mask number mismatch */

	if (! own.o_fpu_loaded) {
		if (u.u_fpu.fsave[FPU_VERSION] != FPU_VERSION_NULL &&
		    u.u_fpu.fsave[FPU_FORMAT] == FPU_FORMAT_BUSY) {
			u.u_procp->p_dests &= u.u_procp->p_fpu_dests;
			if (! (own.o_id_bit & u.u_procp->p_dests))
				qswtch();
		}
		fpu_restore();
	}
	u.u_procp->p_dests = ~0;
	atom_or(&user_pm_bits, own.o_id_bit);
}

/*
 * nonexistent system call-- signal bad system call.
 */
nosys()
{
	psignal(u.u_procp, SIGSYS);
}

/* 
 * package not installed -- return ENOPKG error  (STUBS support)
 */
nopkg()
{
	u.u_error = ENOPKG;
}


/*
 * internal function call for uninstalled package -- panic system.  If the
 * system ever gets here, it means that an internal routine was called for
 * an optional package, and the OS is in trouble.  (STUBS support)
 */
noreach()
{
	cmn_err(CE_PANIC,"Call to internal routine of uninstalled package");
}

/*
 * Ignored system call
 */
nullsys()
{
}

static	char	bad_trap_name[] = "Unknown exception";

char *nametrap[] = {
	"Bad Trap (reset SP)",
	"Bad Trap (reset PC)",
	"Bus Error",
	"Address Error",
	"Illegal Instruction",
	"Zero Divide",
	"CHK Instruction",
	"TRAPV Instruction",
	"Privileged Instruction",
	"Trace Trap",
	"Unimplemented instruction (A-line)",
	"Unimplemented instruction (F-line)",
	bad_trap_name,
	"Coprocessor protocol violation",
	"Format error",
	"Unitialized interrupt",
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	bad_trap_name,
	"Spurious Interrupt",
	"Auto 1",
	"Auto 2",
	"Auto 3",
	"Auto 4",
	"Auto 5",
	"Auto 6",
	"Auto 7",
	"Trap 0 Instruction",
	"Trap 1 Instruction",
	"Trap 2 Instruction",
	"Trap 3 Instruction",
	"Trap 4 Instruction",
	"Trap 5 Instruction",
	"Trap 6 Instruction",
	"Trap 7 Instruction",
	"Trap 8 Instruction",
	"Trap 9 Instruction",
	"Trap 10 Instruction",
	"Trap 11 Instruction",
	"Trap 12 Instruction",
	"Trap 13 Instruction",
	"Trap 14 Instruction",
	"Trap 15 Instruction",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception",
	"Floating Point Exception--Unimplemented Data Type",
};

char *
get_except_name(vector_number)
uint	vector_number;
{
	if (vector_number >= (sizeof(nametrap) / sizeof(nametrap[0])))
		return(bad_trap_name);
	return(nametrap[vector_number]);
}

showtrap(stk_ptr)
register struct	state *stk_ptr;
{
	ulong		sp;
	char		procname[DIRSIZ+1];
	extern uchar	stkfmtsz[];
#ifdef GOT_SPRINTF
	extern char	*symstr();
#endif /* GOT_SPRINTF */
	extern void	display_sym();

	/* prevent endless loop if u page clobbered */

	if (own.o_trap_hap)
		stop_processor();

	strncpy(procname, u.u_comm, DIRSIZ);
	procname[DIRSIZ] = 0;

	/* print user/sys mode, decode trap type into ascii */
	if (USERMODE(stk_ptr->s_ps)) {
		sp = (ulong) stk_ptr->s_sp;
		printf("\nUser");
	} else {
		sp = (ulong) &stk_ptr->s_proc + stkfmtsz[stk_ptr->s_format];
		printf("\nSystem");
	}

	printf(" %s while ", get_except_name(stk_ptr->s_vector));

	if ( own.o_curproc == &own.o_proc )
		printf("idling\n");
	else
		printf("running \"%s\", pid = %u\n", procname,u.u_procp->p_pid);

	own.o_trap_hap = 1;

	printf("d0:");
	display_sym(&stk_ptr->s_d0, 4);
	printf("\nd4:");
	display_sym(&stk_ptr->s_d4, 4);
	printf("\na0:");
	display_sym(&stk_ptr->s_a0, 4);
	printf("\na4:");
	display_sym(&stk_ptr->s_a4, 2);
	printf(" %0x %0x\n", stk_ptr->s_a6, sp);

#ifdef GOT_SPRINTF
	printf("pc = %s, sr = %x, format = %x, vector = %x\n",
	  symstr(stk_ptr->s_pc), stk_ptr->s_ps,
	  stk_ptr->s_format, stk_ptr->s_vector);
#else /* GOT_SPRINTF */
	printf("pc = ");
	symstr(stk_ptr->s_pc);
	printf(", sr = %x, format = %x, vector = %x\n",
	  stk_ptr->s_ps, stk_ptr->s_format, stk_ptr->s_vector);
#endif /* GOT_SPRINTF */

	own.o_trap_hap = 0;
}

stray(addr)
{
	upkern_lock();
	logstray(addr, E_SPUR);
	upkern_unlock();
	printf("stray interrupt at %x\n", addr);
}

/*
 * Called by the trap2 handler when somebody tries an old trap 2 TAS emulation.
 *	The M68040 doesn't do CAS exactly the same way any more, so we can't
 *	support this.  Therefore, send SIGSYS to the process.
 */

trap_2(stk_frame)
struct state	stk_frame;		/* stk_frame is value/result */
{
	register proc_t	*pp = u.u_procp;
	time_t		syst = u.u_stime;
	static time_t	last_lbolt;

	if (lbolt - last_lbolt > 10 * HZ) {
		cmn_err(CE_NOTE, "PID=%d (%s): Trap 2 no longer supported.",
		  pp->p_pid, u.u_comm);
		last_lbolt = lbolt;
	}

	psignal(pp, SIGSYS);

	if (ISSIG(pp, FORREAL)) {
		upkern_lock();
		psig();
	}

	/*
	 * JPC: I'm not sure if we should recalc priorities or do user
	 * profiling, when trap 2 is defunct, but there is that priority
	 * assert in u_trap_done, so why not?
	 */
	if (u.u_prof.pr_scale)
		addupc(stk_frame.s_pc, &u.u_prof, (int)(u.u_stime-syst));
#ifdef	PERF
	USERPRI(pp);	/* modifies p_pri & own.o_curpri */
#else	/* PERF */
	own.o_curpri = pp->p_pri = calcppri(pp);
#endif	/* PERF */

	own.o_runrun = 1;		/* give up CPU in u_trap_done */
	u_trap_done();
}
