/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) shm.c: version 25.2 created on 6/5/92 at 19:38:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)shm.c	25.2	6/5/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * 002 JPC	3/9/88	Add a lock to shmatt to avoid any chance of corrupting
 *			the shmid_ds.  Atomize availrmem and availsmem.
 */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/dir.h"
#include "sys/errno.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/ipc.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/pfdat.h"
#include "sys/proc.h"
#include "sys/systm.h"
#include "sys/sysmacros.h"
#include "sys/shm.h"
#include "sys/debug.h"
#include "sys/tuneable.h"
#include "sys/cmn_err.h"
#include "sys/synch.h"
#include "sys/mfs.h"
#include "sys/inode.h"
#include "sys/kmem.h"


/* #define FULL_SHMEM_DEBUG		/* full debug shm */
/* #define SHMEM_DEBUG		/* debug shm */

#define A1000_WARN_DELAY (60 * HZ)	/* A1000 warning delay value	*/

					/* synchronizer for shmget	*/
suspend_lock_t		shm_lock = SUSPEND_INIT(PZERO - 1);

extern struct shmid_ds	shmem[];	/* shared memory data structures*/
extern suspend_lock_t	shmlk[];	/* shared memory lock structures*/
extern struct shminfo	shminfo;	/* shared memory info structure	*/
extern	time_t		time;		/* system idea of date		*/

struct	shmid_ds	*ipcget(),
			*shmconv();

/*
 * JPC 3/11/91
 * Now that we are able to write-protect a segment at the segment table level,
 * and we don't have to support A1000 binaries, we are able to use very
 * AT&T-like shared memory routines.
 */

/*
 * Shmat (attach shared segment) system call.
 */
static
shmatt()
{
	register struct a {
		int	shmid;
		uint	addr;
		int	flag;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;
	register struct region		*rp;
	register struct pregion		*prp;
	register int			num, rwflag, initflag;
	int				size;
	int				a1000;
	preg_t				*shmattach();
	uint				shmaddr();
	static time_t			last_a1000_warn;

	if ((sp = shmconv(uap->shmid)) == NULL)
		return;
	if (ipcaccess(&sp->shm_perm, SHM_R)) {
		shmunlock(sp);
		return;
	}
	if ( !(uap->flag & SHM_RDONLY) && ipcaccess(&sp->shm_perm, SHM_W)) {
		shmunlock(sp);
		return;
	}
	a1000 = 0;
	num = 0;			/* attached too many segments? */
	prp = u.u_procp->p_region;
	for ( ; prp->p_reg; prp++) {
		if (prp->p_type == PT_SHMEM) {
			++num;
		}
		else if (prp->p_type == PT_DATA && (prp->p_flags & PF_A1000))
			a1000 = 1;
	}
	if (num >= shminfo.shmseg) {
		shmunlock(sp);
		u.u_error = EMFILE;
		return;
	}
	if (uap->addr == 0) {
		if ((uap->addr = shmaddr(ctob(sp->shm_reg->r_pgsz))) == 0) {
			shmunlock(sp);
			u.u_error = EMFILE;	/* no room for segment */
			return;
		}
	}
	else if (uap->flag & SHM_RND)
		uap->addr &= ~SOFFMASK;
	else if (uap->addr & SOFFMASK) {	/* misaligned addr? */
		if (a1000 && time - last_a1000_warn > A1000_WARN_DELAY) {
			cmn_err(CE_NOTE,
"68040 doesn't do non-seg-aligned A1000 shared mem! Use shmat 0, or SHM_RND");
			last_a1000_warn = time;
		}
		shmunlock(sp);
		u.u_error = EINVAL;	/* won't do non-aligned A1000 shmem */
		return;
	}

	size = btoc(sp->shm_segsz);
	rwflag = (uap->flag & SHM_RDONLY) ? SEG_RO : SEG_RW;

	initflag = sp->shm_perm.mode & SHM_INIT;

	rp = sp->shm_reg;
	reglock(rp);
#ifdef FULL_SHMEM_DEBUG
	printf("shm: sp=%x rp=%x addr=%x size=%x rwf=%x initf=0%o a1000=%x\n",
	  sp, rp, uap->addr, size, rwflag, initflag, a1000);
#endif
	if (prp = shmattach(rp, uap->addr, size, rwflag, initflag)) {
		prp->p_regva = (caddr_t)uap->addr;

		if (initflag)
			sp->shm_perm.mode &= ~SHM_INIT;
		regrele(rp);

		u.u_rval1 = (int) prp->p_regva;
		sp->shm_atime = time;
		sp->shm_lpid = u.u_procp->p_pid;
	}
	shmunlock(sp);
}

/*
 * Shmattach -- internal attach shared segment function.
 *
 * attaches region to process, at virt addr, returns preg
 * (receives and returns a locked region; unlocks the region on error)
 */

static preg_t *
shmattach(rp, addr, pgs, rwflag, initflag)
register reg_t	*rp;
register uint	addr;
register int	pgs;
int		rwflag, initflag;
{
	preg_t	*prp;

	if (rp->r_pgsz > 0 && chkpgrowth(rp->r_pgsz) < 0) {
		regrele(rp);
		u.u_error = ENOMEM;
		return (NULL);
	}

	if (!(prp = attachreg(rp, &u, addr & ~SOFFMASK, PT_SHMEM, rwflag))) {
		regrele(rp);
		return (NULL);
	}
	if (initflag) {
		if (chkpgrowth(pgs) < 0 || growreg(prp, pgs, DBD_DZERO) < 0) {
			detachreg(prp, &u);
			u.u_error = ENOMEM;
			return (NULL);
		}
		regrele(rp);
		/* reference each page */
		for ( ; --pgs >= 0; addr += ctob(1))
			(void) fubyte(addr);
		reglock(rp);
	}
	return (prp);
}


/*
 * 002
 * Since the reglock in the middle of attaching a ro segment may sleep,
 * use a simple lock to make sure that shm_ro_reg and other data in sp
 * aren't corrupted.
 */
static
shmlock(sp)
struct shmid_ds	*sp;
{
	suspend_lock(&shmlk[sp - shmem]);
}

/*
 * shmunlock -- release lock on shmid_ds -- 002
 */
static
shmunlock(sp)
struct shmid_ds	*sp;
{
	suspend_unlock(&shmlk[sp - shmem]);
}

/*
 * Convert user supplied shmid into a ptr to the associated
 * shared memory header.  Does a shmlock on sp.
 */
static struct shmid_ds *
shmconv(s)
register int	s;	/* shmid */
{
	register struct shmid_ds	*sp;	/* ptr to associated header */

	if (s < 0)
	{
		u.u_error = EINVAL;
		return(NULL);
	}
	sp = &shmem[s % shminfo.shmmni];
	shmlock(sp);
	if (!(sp->shm_perm.mode & IPC_ALLOC) ||
	    s / shminfo.shmmni != sp->shm_perm.seq) {
		shmunlock(sp);
		u.u_error = EINVAL;
		return(NULL);
	}
	return(sp);
}

/*
 * Shmctl system call.
 */
static
shmctl()
{
	register struct a {
		int		shmid,
				cmd;
		struct shmid_ds	*arg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	register struct region		*rp;	/* shmem region */
	struct shmid_ds			ds;	/* hold area for IPC_SET */

	/* avoid deadlock: if RMID, get shm_lock before shmlock in shmconv */
	if (uap->cmd == IPC_RMID)
		suspend_lock(&shm_lock);
	if ((sp = shmconv(uap->shmid)) == NULL) {
		if (uap->cmd == IPC_RMID)
			suspend_unlock(&shm_lock);
		return;
	}

	switch (uap->cmd) {

	/* Remove shared memory identifier. */
	case IPC_RMID:
		if (u.u_uid != sp->shm_perm.uid &&
		    u.u_uid != sp->shm_perm.cuid && !auth_shm()) {
			suspend_unlock(&shm_lock);
			break;
		}
#ifdef SECON
		sat_ipcrm(&sp->shm_perm);
#endif
		sp->shm_perm.mode = 0;
		sp->shm_segsz = 0;
		if ((int)(++(sp->shm_perm.seq) * shminfo.shmmni + (sp - shmem))
		    < 0)
			sp->shm_perm.seq = 0;

		if (rp = sp->shm_reg) {
			sp->shm_reg = NULL;
			reglock(rp);
			if (rp->r_refcnt == 0)
				freereg(rp);
			else {
				rp->r_flags &= ~RG_NOFREE;
				regrele(rp);
			}
		}
		suspend_unlock(&shm_lock);
		break;

	/* Set ownership and permissions. */
	case IPC_SET:
		if (u.u_uid != sp->shm_perm.uid &&
		    u.u_uid != sp->shm_perm.cuid && !auth_shm())
			 break;
		if (copyin(uap->arg, &ds, sizeof(ds))) {
			u.u_error = EFAULT;
			break;
		}
#ifdef SECON
		sat_ipcdac(sp->shm_perm.uid, ds.shm_perm.uid,
			sp->shm_perm.gid, ds.shm_perm.gid,
			sp->shm_perm.mode, (sp->shm_perm.mode & ~0777)
					   | (ds.shm_perm.mode & 0777) );
#endif
		sp->shm_perm.uid = ds.shm_perm.uid;
		sp->shm_perm.gid = ds.shm_perm.gid;
		sp->shm_perm.mode = (ds.shm_perm.mode & 0777) |
			(sp->shm_perm.mode & ~0777);
		sp->shm_ctime = time;
		break;

	/* Get shared memory data structure. */
	case IPC_STAT:
		if (ipcaccess(&sp->shm_perm, SHM_R))
			break;

		/*	The following is needed because
		**	a user can look at it.  In
		**	particular, the regression tests
		**	require it.
		*/

		sp->shm_nattch = sp->shm_reg->r_refcnt;

		if (copyout(sp, uap->arg, sizeof(*sp)))
			u.u_error = EFAULT;
		break;

	/* Lock segment in memory */
	case SHM_LOCK:
		if (!auth_shm())
			break;

		rp = sp->shm_reg;
		reglock(rp);
		ASSERT(rp->r_noswapcnt >= 0);
		if (rp->r_noswapcnt == 0) {
			atom_sub(&availrmem, rp->r_pgsz - rp->r_gapsz);
			if (availrmem < tune.t_minarmem) {
				atom_add(&availrmem, rp->r_pgsz - rp->r_gapsz);
				regrele(rp);
				shmunlock(sp);
				cmn_err(CE_NOTE,
				   "shmctl - couldn't lock %d pages in memory",
				   rp->r_pgsz - rp->r_gapsz);
				u.u_error = ENOMEM;
				return;
			}
		}
		++rp->r_noswapcnt;
		regrele(rp);
		break;

	/* Unlock segment */
	case SHM_UNLOCK:
		if (!auth_shm())
			break;

		rp = sp->shm_reg;
		reglock(rp);
		if (rp->r_noswapcnt == 0) {
			/*	User didn't really lock it.
			 */
			regrele(rp);
			break;
		}
		ASSERT(rp->r_noswapcnt > 0);
		--rp->r_noswapcnt;
		if (rp->r_noswapcnt == 0)
			atom_add(&availrmem, rp->r_pgsz - rp->r_gapsz);
		regrele(rp);
		break;

	default:
		u.u_error = EINVAL;
	}
	shmunlock(sp);
}


/*
 * Detach shared memory segment
 */
static
shmdt()
{
	register struct a {
		caddr_t	addr;
	} *uap = (struct a *)u.u_ap;
	register struct pregion		*prp;
	register struct region		*rp;
	register struct shmid_ds	*sp;
	register int			n;

	/*
	 * Find matching shmem address in process region list
	 */

	for (prp = u.u_procp->p_region; prp->p_reg; prp++)
		if (prp->p_type == PT_SHMEM && prp->p_regva == uap->addr)
			break;
	if (prp->p_reg == NULL) {
		u.u_error = EINVAL;
		return;
	}

	/*
	 * Detach region from process
	 * We must remember rp here since detach clobbers p_reg
	 */

	rp = prp->p_reg;
	reglock(rp);
	detachreg(prp, &u);

	/*
	 * Find shmem region in system wide table.  Update detach time
	 * and pid, and free if appropriate
	 */
	for (sp = shmem, n = shminfo.shmmni; --n >= 0; sp++)	/* 002 */
		if (sp->shm_reg == rp)
			break;
	if (n < 0)						/* 002 */
		return;	/* shmem has been removed already */
	shmlock(sp);
	sp->shm_dtime = time;
	sp->shm_lpid = u.u_procp->p_pid;
	shmunlock(sp);
}

/*
 * Exec, exit, and fork subroutines not needed any longer
 * Their function is implemented gratis by normal region handling
 */
/*  shmexec() { }  */

/*
 * Shmget (create new shmem) system call.
 */
static
shmget()
{
	register struct a {
		key_t	key;
		uint	size,
			shmflg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	register struct region		*rp;	/* shared memory region ptr */
	int				s;	/* ipcget status */

	suspend_lock(&shm_lock);
	sp = ipcget(uap->key, uap->shmflg, shmem, shminfo.shmmni,
		 sizeof(*shmem), &s);
	if (sp == NULL) {
		suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
		printf("shmget:  ipcget failed\n");
#endif
		return;
	}
	shmlock(sp);
	if (s) {

		/*
		 * This is a new shared memory segment.
		 * Allocate a region and init shmem table
		 */
		if (uap->size < shminfo.shmmin || uap->size > shminfo.shmmax) {
			sp->shm_perm.mode = 0;
			shmunlock(sp);
			suspend_unlock(&shm_lock);
			u.u_error = EINVAL;
#ifdef SHMEM_DEBUG
			printf("shmget: seg size %d out of range (%d to %d)\n",
			  uap->size, shminfo.shmmin, shminfo.shmmax);
#endif
			return;
		}
		if ((rp = allocreg((inode_t *)NULL, RT_SHMEM)) == NULL) {
			sp->shm_perm.mode = 0;
			shmunlock(sp);
			suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
			printf("shmget: can't allocate region\n");
#endif
			return;
		}
		/* grow on first attach */
		sp->shm_perm.mode |= SHM_INIT;
		sp->shm_segsz = uap->size;
		sp->shm_reg = rp;
		sp->shm_ro_reg = NULL;
		sp->shm_atime = sp->shm_dtime = 0;
		sp->shm_ctime = time;
		sp->shm_lpid = 0;
		sp->shm_cpid = u.u_procp->p_pid;
		rp->r_flags |= RG_NOFREE;
		regrele(rp);
	} else {
		/*
		 * Found an existing segment.  Check size
		 */
		if (uap->size && uap->size > sp->shm_segsz) {
			shmunlock(sp);
			suspend_unlock(&shm_lock);
			u.u_error = EINVAL;
#ifdef SHMEM_DEBUG
			printf("shmget: size %d greater than seg size %d\n",
			  uap->size, sp->shm_segsz);
#endif
			return;
		}
	}

	u.u_rval1 = sp->shm_perm.seq * shminfo.shmmni + (sp - shmem);
	shmunlock(sp);
	suspend_unlock(&shm_lock);
#ifdef SECON
	sat_ipccreat( s );
#endif 
}

shminit()
{
	register suspend_lock_t	*slp;
	register int		n;
	register unsigned	pri;

	pri = PZERO - 1;
	for (n = shminfo.shmmni, slp = shmlk; --n >= 0; slp++) {
		slp->s_priority = pri;
	}
}


/*
 * System entry point for shmatt, shmctl, shmdt, and shmget system calls.
 */

static int	(*shmcalls[])() = { shmatt, shmctl, shmdt, shmget };

shmsys()
{
	register struct a {
		uint	id;
	}	*uap = (struct a *)u.u_ap;

	if (uap->id > 3) {
		u.u_error = EINVAL;
		return;
	}
	u.u_ap = &u.u_arg[1];
	(*shmcalls[uap->id])();
}

/*
 * find the virtual start and end addresses of the given pregion
 *	(even for PT_STACK, vstart <= vend)
 */

preg_limits(prp, vstartp, vendp)
register preg_t	*prp;
uint		*vstartp, *vendp;
{
	register uint	size;

	size = ctob(prp->p_reg->r_pgsz);
	switch (prp->p_type) {
	case PT_STACK:
		*vstartp = (*vendp = (uint)prp->p_regva + USERSTACK_OFF - 1) -
		  (size ? size + 1 : 0);
		break;
	case PT_TEXT:
	case PT_DATA:
	case PT_SHMEM:
	case PT_LIBTXT:
	case PT_LIBDAT:
		*vendp = (*vstartp = (uint)prp->p_regva) + (size ? size-1 : 0);
		break;
	default:
		cmn_err(CE_PANIC,
"preg_limits: unknown pregion type = 0x%x, prp=0x%x, rp=0x%x, regva=0x%x\n",
		  prp->p_type, prp, prp->p_reg, prp->p_regva);
		break;
	}
}

/*
 * Select attach address based on segment size -- returns 0 if no room
 */

uint
shmaddr(size)
register uint	size;
{
	register preg_t	*prp;
	register uint	addr, end;
	uint		vstart, vend;

	--size;			/* anticipate:  end = addr + size - 1 */
	addr = NBPS;
	end = addr + size;
	for (prp = u.u_procp->p_region; prp->p_reg; prp++) {
		preg_limits(prp, &vstart, &vend);

		if (prp->p_type == PT_DATA)
			vend += ctob(shminfo.shmbrk);

		if (addr < vstart && end < vstart)
			break;				/* found it */

		addr = (vend + NBPS) & ~SOFFMASK;
		end = addr + size;
	}

	if (is_kern_addr(addr))
		addr = 0;				/* bad addr / no room */

	return (addr);
}

shmseg()
{
	return(shminfo.shmseg);
}
