/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) machdep.c: version 25.3 created on 5/12/92 at 19:53:33	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)machdep.c	25.3	5/12/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * os/M68040/machdep.c
 */


#include "sys/param.h"
#include "sys/types.h"
#include "sys/immu.h"
#include "sys/buf.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/pfdat.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/state.h"
#include "sys/psl.h"
#include "sys/clock.h"
#include "sys/ipc.h"
#include "sys/var.h"
#include "sys/shm.h"
#include "sys/lio.h"
#include "sys/kmem.h"
#include "sys/debug.h"
#include "sys/sbus.h"
#include "sys/spm_mem.h"
#include "sys/own.h"

rde_t	km_to_rde();
qde_t	km_to_qde();
sde_t	km_to_sde();
pde_t	km_to_pde();

uint	rde_to_km();
uint	qde_to_km();
uint	sde_to_km();
uint	pde_to_km();

unsigned char stkfmtsz[16] = {		/* (# bytes-8) on stack frame */
	0, 0, 4, 4, 0, 0, 0, 50,		/* for the exceptions */
	0, 12, 24, 84, 0, 0, 0, 0};	/* index is the format code */

/*
 * Stop the clock.
 */

clkreld()  
{
	own.o_clock = 0;
}


/*
 * Send an interrupt to process
 */
sendsig(hdlr)
{
	register *usp;
	register char *temp_usp;
	register state_t *stp = u.u_astk;


	ASSERT(stp->s_format != COP_MIDINSTR);
	usp = (int *) stp->s_sp;
	grow((unsigned)(usp-6));
	/* simulate an interrupt on the user's stack */
	suword((int *)--usp, stp->s_pc);
	temp_usp = (char *)usp;
	subyte((char *)--temp_usp, lobyte(stp->s_ps));
	subyte((char *)--temp_usp, hibyte(stp->s_ps));
	stp->s_ps &= ~PS_T;
	stp->s_sp = (ulong) temp_usp;
	stp->s_pc = hdlr;
	if (stkfmtsz[stp->s_format])
		stp->s_crunch = 1;	/* force trap.s to crunch stack */
}


/*
 * Clear registers on exec
 */

setregs()
{
	register int	i;
	register proc_t *p;
	void (* *rp)();
	register state_t *stp = u.u_astk;

	p = u.u_procp;
	p->p_chold = 0;	/* clear p_chold */

	/* Any pending signal remain held, so don't clear p_hold and
	p_sig */	

	/* If the action was to catch the signal, then the action
	must be reset to SIG_DFL */

	for (rp = &u.u_signal[0]; rp < &u.u_signal[NSIG]; rp++)
		if (*rp != SIG_IGN)
			*rp = SIG_DFL;


	/*
	 * check if the execed file is not posix binary.  If so,
	 * set signal handler for jobcontrol signals as SIG_IGN.
	 * set CHILDNOSTOP flag in p_posix_flags so that in case of
	 * system V binary parent needn't be sent SIGCHLD signal
	 * if the child stops.  This is done to support system V
	 * binary in posix kernel.
	 */
	if(!(p->p_posix_flags & F_POSIX_BINARY))  {
		p->p_posix_flags |= SA_NOCLDSTOP;
	}

	stp->s_pc = u.u_exdata.ux_entloc;

	stp->s_ps = 0;
	stp->s_d7 = stp->s_d6 = stp->s_d5 = stp->s_d4 = 0;
	stp->s_d3 = stp->s_d2 = stp->s_d1 = stp->s_d0 = 0;

	stp->s_a6 = stp->s_a5 = stp->s_a4 = 0;
	stp->s_a3 = stp->s_a2 = stp->s_a1 = stp->s_a0 = 0;

	for (i=0; i < u.u_nofiles; i++)
		if (GET_OFILE(i) && (GET_OFLAG(i) & EXCLOSE)) {
			closef(GET_OFILE(i));
			SET_OFILE(i, NULL);
		}
}

/*
 * The number of bits to clip off of the bottom of an sbus address
 * to convert it into an sbus_u32
 */
#define SBUS_U32_LOSS	(SBUS_SLOT_BITS + SBUS_OFFSET_BITS - 32)

/* 
 * spfn_to_lpfn
 * convert a system bus page frame number to the linear page frame number.
 */
uint
spfn_to_lpfn(spfn) 
register uint spfn;
{
	register uint	sbus_slot = slot_fm_spfn(spfn);
	return(   index_to_lpfn(sbus_slot)	/* kv_iomap map index */
		- spm_mem.pfn_adjust[sbus_slot] 
		+ (spfn & SPFN_MB_MASK)		/* which mb in that slot */ 
		+ pg_fm_spfn(spfn));		/* page offset into that Mb */

} /* spfn_to_lpfn */

static uint
kpfn_to_spfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum((uint) ADDR_SYS_SEGS));
	ASSERT(pfn < pnum((uint) ADDR_SYS_SEGS) + maxmem);
	return(lpfn_to_spfn(pg_valpfn(&kptbl[pfn - pnum(ADDR_SYS_SEGS)])));
}

#if 0 /* not currently used */
static uint
kpfn_to_lpfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum((uint) ADDR_SYS_SEGS));
	ASSERT(pfn < pnum((uint) ADDR_SYS_SEGS) + maxmem);
	return(pg_valpfn(&kptbl[pfn - pnum(ADDR_SYS_SEGS)]));
}
#endif	/* 0 */ /* not currently used */

static uint
pfn_to_spfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum(MAINSTORE));
	ASSERT(pfn < maxclick);
	return(lpfn_to_spfn(pg_valpfn(&spm_mem.mem_ptbl[pfn-pnum(MAINSTORE)])));
}

static uint
pfn_to_lpfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum(MAINSTORE));
	ASSERT(pfn < maxclick);
	return(pg_valpfn(&spm_mem.mem_ptbl[pfn-pnum(MAINSTORE)]));
}

static uint
lpfn_to_pfn(lpfn)
uint	lpfn;
{
	return(spm_mem.lpfn_tbl[pg_fm_lpfn(lpfn)+(index_fm_lpfn(lpfn)*0x100)]);
}

static uint
spfn_to_pfn(spfn)
register uint	spfn;
{
	return(lpfn_to_pfn(spfn_to_lpfn(spfn)));
}


/* 
 * lpfn_to_spfn
 * Convert from a linear page frame addr to an sbus (system) page frame addr.
 * The lpfn contains the kv_iomap index (pointing to a megabyte of memory)
 *  and the page offset into that megabyte.
 * The kv_iomap contains the slot of the megabyte and the megabyte offset
 * into that slot.
 */
uint
lpfn_to_spfn(lpfn)
	uint lpfn;
{
	uint * kv_iomap_entry = ((uint *)(PM_MAP_START))+index_fm_lpfn(lpfn);
	uint sbus_slot = slot_fm_kv_iomap(kv_iomap_entry);
	uint mb_off = mb_to_spfn(mb_fm_kv_iomap( kv_iomap_entry ));

	    /* now assemble all the pieces together */
	return( slot_to_spfn(sbus_slot) | mb_off | pg_fm_lpfn(lpfn));

} /* lpfn_to_spfn */



/* 
 * [rqsp]de <--> km conversion routines
 *
 * . General notes.
 *   . Each descriptor entry consists of:
 *     . various permissions/modes/status bits.
 *     . for [rqs]de's there are some unused bits (these should be 0).
 *     . an lpfn (in the fn field) with the granularity of 1 page (0x1000).
 *       For the higher level tables, there is an additional offset on the
 *       fn to point into the next level table (since the tables are smaller
 *       than one page.)
 *   . No other fields are set in the descriptor entry other than pfn.
 *     It is the responsibility of the caller to set these.
 * 
 * . Converting a kernel virtual address to a mmu descriptor entry
 *   . Compute the lpfn from the virtual address.
 *   . Shift this so it is left justified in the descriptor entry
 *     (via LPFN_XDE_SHFT)
 *   . If the descriptor entry points to a table that is less than 1 page
 *     (which is the granularity of the lpfn), then compute the additional
 *     offset according to the size of the table this descriptor points to
 *     (that is the size of the next level down, not its own level table).
 *     The bits for this additional offset are offset in the virtual addr
 *     by the shift of the tablesize in question.  The mask for this offset
 *     can be computed by taking the difference between the shifts of a 
 *     pagesize (the granularity of an lpfn) and the tablesize in question.
 *     The additional offset is added (or or'd in) to the fn field.
 * . Converting an mmu descriptor entry to a kernel virtual address.
 *     . Convert the lpfn portion of the descriptor to a km address.
 *       (Right justifying the lpfn by shifting right by LPFN_XDE_SHFT, 
 *        then calling the conversion routines).
 *       This yields a kernel virtual address aligned to a page boundary.
 *     . If the mmu entry is an upper level descriptor, the appropriate
 *       lower bits of the fn can be or'd in to the kernel address, reversing
 *       the translation described above. (Recalling that the conversion
 *       constants used are that for the next lower table, not the same
 *       level table as the descriptor).
 */


uint
rde_to_km(rde)
rde_t	rde;
{
    register uint km;

	/* compute virtual addr of page of the table */
    km = pfn_to_km(lpfn_to_pfn(rde.rde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((rde.rde.fn & ((1 << (PNUMSHFT - BQTSHFT)) - 1)) << BQTSHFT));

} /* rde_to_km */

rde_t
km_to_rde(km)
uint	km;
{
	rde_t	retval;

	ASSERT( !(km & ((1 << BQTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.rde_all = pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.rde.fn += (km>>BQTSHFT) & ((1 << (PNUMSHFT - BQTSHFT)) - 1);
	return(retval);
} /* km_to_rde */


uint
qde_to_km(qde)
qde_t	qde;
{
    register uint km;

	/* compute virtual addr of page of the table */
    km = pfn_to_km(lpfn_to_pfn(qde.qde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((qde.qde.fn & ((1 << (PNUMSHFT - BSTSHFT)) - 1)) << BSTSHFT));

} /* qde_to_km */

qde_t
km_to_qde(km)
uint	km;
{
	qde_t	retval;

	ASSERT( !(km & ((1 << BSTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.qde_all = pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.qde.fn += (km>>BSTSHFT) & ((1 << (PNUMSHFT - BSTSHFT)) - 1);

	retval.qde.u = 1;		/* avoid extra RMW cycle */
	retval.qde.udt = UDT_PRES;	/* assume present */

	return(retval);
} /* km_to_qde */


uint
sde_to_km(sde)
sde_t	sde;
{
    register uint km;

	/* compute virtual addr of page of the table */
    km = pfn_to_km(lpfn_to_pfn(sde.sde_all >> LPFN_XDE_SHFT));

	    /* add in the table offset */
    return(km + ((sde.sde.fn & ((1 << (PNUMSHFT - BPTSHFT)) - 1)) << BPTSHFT));

} /* sde_to_km */

sde_t
km_to_sde(km)
uint	km;
{
	sde_t	retval;

	ASSERT( !(km & ((1 << BPTSHFT) - 1)));

		/* compute lpfn of page and shift into position */
	retval.sde_all = pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

		/* add in the offset to the table */
	retval.sde.fn += (km>>BPTSHFT) & ((1 << (PNUMSHFT - BPTSHFT)) - 1);

	retval.sde.u = 1;		/* avoid extra RMW cycle */
	retval.sde.udt = UDT_PRES;	/* assume present */

	return(retval);
} /* km_to_sde */


uint
pde_to_km(pde)
pde_t	pde;
{

    return(pfn_to_km(lpfn_to_pfn(pde.pde_all >> LPFN_XDE_SHFT)));

} /* pde_to_km */

pde_t
km_to_pde(km, mode)
uint	km, mode;
{
	pde_t	retval;
	ASSERT( !(km & ((1 << PNUMSHFT) - 1)));

	/* compute lpfn of page and shift into position */
		/* don't set any other fields. */
	retval.pde_all = pfn_to_lpfn(pnum(km)) << LPFN_XDE_SHFT;

	/* hanna FIX -- do i need to set present?? */
	retval.pde_all |= pde_mode_to_mask(mode);
	return(retval);

} /* km_to_pde */

uint
mkpde(mode, pfn)
uint	mode;
uint	pfn;
{
	pde_t	retval;
	
	/* compute lpfn of page and shift into position */
		/* don't set any other fields. */
	retval.pde_all = pfn_to_lpfn(pfn) << LPFN_XDE_SHFT;
	retval.pde_all |= pde_mode_to_mask(mode);
	return(retval.pde_all);
}


uint
pde_to_pfn(pde)
pde_t	pde;
{
	return(lpfn_to_pfn(pde.pde.fn));
}

pfd_t *
pde_to_pfdat(pde)
pde_t	pde;
{
	ASSERT(pfdat);
	return (&pfdat[pde_to_pfn(pde) - pnum(kpbase)]);
}


#if 0 	/* not currently used */
static uint
pfdat_to_spfn(pfd)
struct	pfdat	*pfd;
{
	ASSERT(pfdat);
	return(pfn_to_spfn(pfd - pfdat + pnum(kpbase)));
}
#endif /* 0 */ /* not currently used */

struct pfdat *
kvtopfdat(kv)
char	*kv;
{
	ASSERT(pfdat);
	return(&pfdat[pnum(kv - kpbase)]);
}

struct	pfdat *
pfn_to_pfdat(pfn)
uint	pfn;
{
	ASSERT(pfdat);
	return(&pfdat[(pfn) - pnum(kpbase)]);
}

uint
pfdattopfn(pfd)
struct pfdat	*pfd;
{
	ASSERT(pfdat);
	return((pfd) - pfdat + pnum(kpbase));
}

char *
pfntokv(pfn)
uint	pfn;
{
	return((char *) ((pfn) << PNUMSHFT));
}

uint
svtopfn(sv)
uint	sv;
{
	return(sv >> PNUMSHFT);
}

pg_setaddr(pdp, pfn)
pde_t	*pdp;
uint	pfn;
{
	atom_and_or(pdp, ~PG_ADDR, pfn_to_lpfn(pfn) << LPFN_XDE_SHFT);
}

sbus_t
kv_to_sbus(kv)
uint	kv;
{
	register uint	spfn;
	sbus_t		retval;
	uint		pfn;

	pfn = pnum(kv);

	/* get offset in page bits */
	kv &= ((1 << PNUMSHFT) - 1);

	spfn = kpfn_to_spfn(pfn);
	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | kv;

	return(retval);
}

uint
kv_to_sbus_u32(kv)
uint	kv;
{
	register uint	spfn, retval;


	spfn = kpfn_to_spfn(pnum(kv));

	kv &= ((1 << PNUMSHFT) - 1);

	/* get slot */
	retval = (spfn & SpfnSlotMask) << SpfnSlotToU32Shft;

	spfn &= ((1 << SpfnToSlotShft) - 1);
	/* get offset */
	retval |= ((spfn << PNUMSHFT) | kv) >> SBUS_U32_LOSS;

	return(retval);
}

#define	u32_to_spfn(x)	((x) >> (PNUMSHFT - SBUS_U32_LOSS))
#define	u32_to_poff(x)	(poff((x) << SBUS_U32_LOSS))

uint
u32_to_kv(u32)
register uint	u32;
{
	return((spfn_to_pfn(u32_to_spfn(u32)) << PNUMSHFT) | u32_to_poff(u32));
}

uint
u32_to_pfn(u32)
register uint	u32;
{
	return(spfn_to_pfn(u32_to_spfn(u32)));
}

sbus_t
km_to_sbus(sv)
uint	sv;
{
	sbus_t	retval;
	uint	pfn, spfn;

	pfn = pnum(sv);

	sv &= ((1 << PNUMSHFT) - 1);

	spfn = pfn_to_spfn(pfn);
	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | sv;

	return(retval);
}

uint
km_to_sbus_u32(sv)
uint	sv;
{
	register uint	spfn, retval;

	spfn = pfn_to_spfn(pnum(sv));

	sv &= ((1 << PNUMSHFT) - 1);

	/* get slot */
	retval = (spfn & SpfnSlotMask) << SpfnSlotToU32Shft;

	spfn &= ((1 << SpfnToSlotShft) - 1);

	/* get offset */
	retval |= (((spfn << PNUMSHFT) | sv) >> SBUS_U32_LOSS);

	return(retval);
}

/* kernel u page to sbus 32 converter -- uv must be within u page */
uint
ku_to_sbus_u32(uv)
uint	uv;
{
	ASSERT(uv >= ADDR_U && uv < (ADDR_U + ctob(USIZE)));
	return ((pg_all(u.u_procp->p_ubptbl) & ~0xff) +
	  ((uv - ADDR_U) >> SBUS_U32_LOSS));
}


/* 
 * find the page descriptor entry that causes the bus fault.
 * NULL will be returned if virtual address not defined in the regions.
 * address of the page descriptor entry associated with the faulted
 * virtual address will be returned if found in the active regions.
 */
pde_t *
findpde(vaddr, p)
register ulong	vaddr;		/* bus fault virutal address */
proc_t		*p;
{
	union {
		rde_t	* rde_p;
		qde_t	* qde_p;
		sde_t	* sde_p;
		pde_t	* pde_p;
	} xptr;

	xde_t	xde;

	ASSERT(UMEM_START == KUMEM_START);
	ASSERT(UMEM_SIZE == KUMEM_SIZE);
	ASSERT(UMEM_START == 0);

	/* addr out of range. that is, in kernel space */
	if (vaddr >= UMEM_START + (ulong) UMEM_SIZE)
		return(NULL);

 /*
  * assumes that pagetable pointers are at the lowest level (pde).
  * so does not support indirect mappings.
  */
#ifdef DEBUG_FINDPDE
	printf("FINDPDE(%x) rde=%x", vaddr, p->p_urde);	
#endif
	/* compute Ssegment table address from root pointer */
	xptr.qde_p = (qde_t *)rde_to_km(p->p_urde);
	xde.qde.qde_all = xptr.qde_p[qnum(vaddr)].qde_all;
#ifdef DEBUG_FINDPDE
	printf("&qde=%x qde=%x%c", &xptr.qde_p[qnum(vaddr)], xde.qde.qde_all,
	  (xde.qde.qde.udt == UDT_INVALID ? '\n' : ' '));
#endif
	if (xde.qde.qde.udt == UDT_INVALID)
		return(NULL);

	/* compute segment table address from Ssegment pointer */
	xptr.sde_p = (sde_t *)qde_to_km(xde.qde);
	xde.sde.sde_all = xptr.sde_p[snum(qoff(vaddr))].sde_all;
#ifdef DEBUG_FINDPDE
	printf("sde=%x%c", xde.sde.sde_all,
	  (xde.sde.sde.udt == UDT_INVALID ? '\n' : ' '));
#endif
	if (xde.sde.sde.udt == UDT_INVALID)
		return(NULL);

	/* compute page table address from segment pointer */
	xptr.pde_p = (pde_t *)sde_to_km(xde.sde);

	/* Return the address of the pagetable entry */
	vaddr = pnum(soff(vaddr));
#ifdef DEBUG_FINDPDE
	printf("&pde=%x pde=%x dbd=%x\n",
	  &xptr.pde_p[vaddr], xptr.pde_p[vaddr].pde_all,
	  xptr.pde_p[NEPPT + vaddr].pde_all);
#endif
	return(&xptr.pde_p[vaddr]);
}

/* 
 * find a kernel page descriptor entry.
 */

pde_t *
kfindpde(vaddr)
register ulong	vaddr;		/* bus fault virutal address */
{
	union {
		rde_t	* rde_p;
		qde_t	* qde_p;
		sde_t	* sde_p;
		pde_t	* pde_p;
	} xptr;

	xde_t	xde;

	ASSERT(UMEM_START == KUMEM_START);
	ASSERT(UMEM_SIZE == KUMEM_SIZE);
	ASSERT(UMEM_START == 0);

	/* addr out of range. that is, in kernel space */
	if (!(vaddr >= UMEM_START + (ulong) UMEM_SIZE))
		return(NULL);

 /*
  * This does not currently support large linear address mapping, but
  * assumes that pagetable pointers are at the lowest level (pde).
  */
	
	/* compute Qsegment table address from root pointer */
	xptr.qde_p = own.o_qtbl;
	xde.qde.qde_all = xptr.qde_p[qnum(vaddr)].qde_all;
	if (xde.qde.qde.udt == UDT_INVALID)
	    return(NULL);

	/* compute segment table address from Qsegment pointer */
	xptr.sde_p = (sde_t *)qde_to_km(xde.qde);
	xde.sde.sde_all = xptr.sde_p[snum(qoff(vaddr))].sde_all;
	if (xde.sde.sde.udt == UDT_INVALID)
	    return(NULL);

	/* compute page table address from segment pointer */
	xptr.pde_p = (pde_t *)sde_to_km(xde.sde);

	/* Return the address of the pagetable entry */
	return(&xptr.pde_p[pnum(soff(vaddr))]);

} /* kfindpde */

static pde_t
v_to_pde(vaddr, p)
register uint	vaddr;
proc_t		*p;
{
	pde_t * pde_p;

    if (p) {
	ASSERT(vaddr < (UMEM_START + (ulong) UMEM_SIZE));
	pde_p = findpde(vaddr, p);
    } else {
	ASSERT(vaddr >= KMEM_START);
	pde_p = kfindpde(vaddr);
    } /* if */

    ASSERT (pde_p != NULL);
    return( *pde_p);

} /* v_to_pde */

/*
 * vmap
 *
 *	return a virtual address through which p's vaddr
 *	can be accessed.
 *
 *	a NULL p indicates the kernel.
 *
 *	the map is valid up to the next page boundary.
 *
 *	this map is NOT VALID across a context switch
 *
 */

caddr_t
vmap(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	/* keep the same attributes that apply to the actual pde */
	own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)] = v_to_pde(vaddr, p);

	return((caddr_t)(ADDR_OWN_VMAP + poff(vaddr)));
}

uint
vmap_save()
{
	return(own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)].pde_all);
}

void
vmap_restore(prev_map)
uint	prev_map;
{
	own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)].pde_all = prev_map;
}


uint
v_to_spfn(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	pde_t	pde;

	pde = v_to_pde(vaddr, p);
	ASSERT(pde.pde.pres);

	return(lpfn_to_spfn(pde.pde.fn));
}

sbus_t
v_to_sbus(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	register uint	spfn;
	sbus_t		retval;
	pde_t		pde;

	pde = v_to_pde(vaddr, p);
	ASSERT(pde.pde.pres);

	spfn = lpfn_to_spfn(pde.pde.fn);
	vaddr &= ((1 << PNUMSHFT) - 1);

	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | vaddr;

	return(retval);
}


/*
 * v_to_sbus_u32
 *
 *
 *	return an sbus_u32 corresponding to p's vaddr.
 *
 *	a NULL p indicates the kernel.
 *
 *	the value returned is valid up to the next page boundary,
 *	and is valid across context switches, as long as the page
 *	has been locked in memory ( userdma() via physio() )
 *
 *	an sbus_u32 can only describe a 16 byte boundary.
 *	if vaddr is not on a 16 byte boundary the returned
 *	sbus_u32 will round it down to the nearest 16 byte
 *	boundary.
 *
 */

uint
v_to_sbus_u32(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	return((v_to_spfn(vaddr, p) << SpfnSlotToU32Shft) |
	  poff(vaddr) >> SBUS_U32_LOSS);
}


/*
 * backtrace -- print a stack backtrace
 */

#define OP_ADDA_A7	0xdefc		/* 68020 opcode for adda.w #xx, a7 */
#define OP_ADDQ_A7	0x504f		/* 68020 opcode for addq.l #xx, a7 */
#define ADDQ_MASK	0x0e00		/* mask to remove data from addq */
#define ADDQ_SHIFT	9		/* shift to extract data from addq */

/* U_FITS is true if the u-page address is in the system stack or own stack */
#define U_FITS(ua)	((ua) >= (uint *)ADDR_EXTRA_STK && (ua) < sys_stk_end \
			 || \
			 (ua) >= (uint *)ADDR_OWN_EXTRA && (ua) < own_stk_end)
/* IS_KERN is true if pc is within the kernel text */
#define IS_KERN(pc)	((pc) >= ADDR_KERNEL && (pc) <= (uint)etext)

backtrace(arg)
uint	arg;
{
	register uint	n, retpc;
	register int	args;
	register uint	*fp, *lastfp;
	register ushort	*addr;
	ushort		opcode;
	extern	uint	sys_stk_end[], own_stk_end[], etext[];

	fp = &arg - 2;	/* stack frame is fp, pc, arg, .... */
	printf("Stack Backtrace:\n");
	if (U_FITS(fp)) {
		retpc = fp[1];
		fp = (uint *) *fp;
	}
	lastfp = 0;

	while (U_FITS(fp) && IS_KERN(retpc) && fp > lastfp) {
		addr = (ushort *) fp[1];
		symstr(retpc);			/* print return pc */
		retpc = (uint) addr;

		/*
		 * Find the number arguments by looking at the opcode
		 * pointed at by the return pc and checking how much is added
		 * to the stack.  Divide by 4 to get the number of arguments.
		 */
		if (probe_short(addr, &opcode))
			n = opcode;
		else
			n = 0;
		if ((n & ~ADDQ_MASK) == OP_ADDQ_A7) {
			switch (n = (n & ADDQ_MASK) >> ADDQ_SHIFT) {
			case 0:		/* addq 8 */
				args = 2;
				break;
			case 4:		/* addq 4 */
				args = 1;
				break;
			default:
				printf("[addq %d]", n);
				args = 0;
			}
		}
		else if (n == OP_ADDA_A7)
			args = ((short *)addr)[1] / 4;
		else {
#ifdef BACKTRACE_DEBUG
			printf("[%x=%x] ", addr, n);
#endif
			args = 0;		/* 0 args */
		}

		if (args > 0) {
			printf(" (");
			if (args > 8) {
				printf("{%d} ", args);
				args = 8;
			}
			for (n = 2; --args >= 0; n++) {
				symstr(fp[n]);
				printf("%s", (args ? ", " : ")\n"));
			}
		}
		else
			printf("\n");

		/* advance along linked list of frame pointers */
		lastfp = fp;
		fp = (uint *)*fp;
	}
	symstr(retpc);				/* final return pc */
	printf("\n");
}


/*
 *  This routine is called to update the user stack with proper signal handler
 *  from psig() routine.  This routine is called ONLY if that signal is being
 *  manupulated by sigaction().  By the end of this routine user stack will be 
 *  as follows:
 *
 *	#	  usp-> |               |
 *	#		+===============+
 *	#		| returnmask	|
 *	#		+---------------+
 *	#		| trapped PSW	| : GATE
 *	#		+---------------+
 *	#		| trapped PC	|
 *	#		+===============+
 *	#		| user stack	|
 *	#               |               |
 *      #		|		|
 *
 */
pos_sendsig(hdlr,returnmask)
{
	register *usp;
	register char *temp_usp;
	register state_t *stp = u.u_astk;

	usp = (int *) stp->s_sp;
	grow((unsigned)(usp-10));
	/* simulate an interrupt on the user's stack */
	suword((int *)--usp, stp->s_pc);
	temp_usp = (char *)usp;
	subyte((char *)--temp_usp, lobyte(stp->s_ps));
	subyte((char *)--temp_usp, hibyte(stp->s_ps));
	usp = (int *)temp_usp;
	/* put returnmask also on the stack...hmm...more work for posix...*/
	suword((int *)--usp, returnmask);
	temp_usp = (char *)usp;
	stp->s_ps &= ~PS_T;
	stp->s_sp = (ulong) temp_usp;
	stp->s_pc = hdlr;
	if (stkfmtsz[stp->s_format])
		stp->s_crunch = 1;	/* force trap.s to crunch stack */
}

/*
 * loadstbl and friends
 */

/* change < 0 .  Reduce the region size */

static
shrink_stbl(up, prp, change)
user_t	*up;
preg_t	*prp;
int	change;
{
	register sde_t	*sd, *sdbeg;
	register qde_t	*qd;
	register int	count, num, sd_cnt, sd_idx;
	register uint	invalid_sde, udt_pres;
	caddr_t 	regva;
	reg_t		*rp;
	int 		osize;
	int 		nsize;
	int		is_stack;

	/* initialize local variables */
	is_stack = (prp->p_type == PT_STACK);
	regva = prp->p_regva;
	rp = prp->p_reg;
	osize = rp->r_pgsz;
	nsize = osize + change;
	sd_cnt = ctos(osize) - ctos(nsize); /* # of segment entries to delete */
	num = btoct(regva);
	count = num + (is_stack ? -osize + 1: osize - 1);
	sd_idx = ctost(count);			/* delete this segment first */

	invalid_sde = spm_mem.invalid_sde.sde_all;
	udt_pres = UDT_PRES;

	/* Point to Qsegment table entry for regva (end of Qseg for stack) */
	qd = (qde_t *) rde_to_km(up->u_procp->p_urde);
	qd += ctoqt(count);			/* go to end-o-seg */

	if (!is_stack) {
		/* non-stack region */

		for (; sd_cnt > 0; qd--, sd_cnt -= num, sd_idx -= num) {
			/* Index to the proper place in the Segment table */
			ASSERT(qd->qde.udt == udt_pres);
			sdbeg = sd = (sde_t *) qde_to_km(*qd);

			sd += (num = segidx(sd_idx));	/* advance sd */
			++num;			/* invalidate num sdes in seg */
			if (num > sd_cnt)
				num = sd_cnt;
			else if (num == NEPST) {
				/*
				 * free entire segment table
				 */
				uptfree((uint)sdbeg, 2);
				*qd = spm_mem.invalid_qde;
				continue;
			}
			/*
			 * free a portion of a segment table
			 * (may be the whole table if the rest is unused)
			 */
			ASSERT(num < NEPST);

			/*
			 * Invalidate Segment entries
			 */
			for (count = num; --count >= 0; sd--) {
				ASSERT(sd->sde.udt == udt_pres);
				sd->sde_all = invalid_sde;
			}
			/*
			 * if the entire segment table contains invalid
			 * entries, free the whole segment table.
			 */
			for (sd = sdbeg, count = NEPST; --count >= 0; sd++) {
				if (sd->sde.udt == udt_pres)
					break;
			}
			if (count < 0) {
				ASSERT(qd->qde.udt == udt_pres);
				uptfree((uint)sdbeg, 2);
				*qd = spm_mem.invalid_qde;
			}
		}
	}
	else {
		/*
		 * Stack segments are backwards on the M68K family.
		 * They grow down from regva, which is the last valid long
		 * word in the region (0x7ffffffc for us).  However, we
		 * try to pretend that they grow upwards as much as possible
		 * to avoid special cases like the one below.
		 */

		for (; sd_cnt > 0; qd++, sd_cnt -= num, sd_idx += num) {
			/* Index to the proper place in the Segment table */
			ASSERT(qd->qde.udt == udt_pres);
			sdbeg = sd = (sde_t *) qde_to_km(*qd);
			sd += (num = segidx(sd_idx));
			num = NEPST - num;
			if (num > sd_cnt)
				num = sd_cnt;
			else if (num == NEPST) {
				/*
				 * free entire segment table
				 */
				uptfree((uint)sdbeg, 2);
				*qd = spm_mem.invalid_qde;
				continue;
			}
			/*
			 * free a portion of a segment table
			 * (may be the whole table if the rest is unused)
			 */
			ASSERT(num < NEPST);

			/*
			 * Invalidate Segment entries
			 */
			for (count = num; --count >= 0; sd++) {
				ASSERT(sd->sde.udt == udt_pres);
				sd->sde_all = invalid_sde;
			}
			/*
			 * if the entire segment table contains invalid
			 * entries, free the whole segment table.
			 */
			sd = sdbeg + NEPST - 1;
			for (count = NEPST; --count >= 0; sd--) {
				if (sd->sde.udt == udt_pres)
					break;
			}
			if (count < 0) {
				ASSERT(qd->qde.udt == udt_pres);
				uptfree((uint)sdbeg, 2);
				*qd = spm_mem.invalid_qde;
			}
		}
	}
	ASSERT(sd_cnt == 0);

	flush_all_user_tlb();
	return(1);	/* successful shrink */
}

static
grow_stbl(up, prp, change)
user_t	*up;
preg_t	*prp;
int	change;
{
	register pde_t	**lp;
	register sde_t	*sd;
	register qde_t	*qd;
	register int	count, num, sd_cnt, sd_idx;
	caddr_t 	regva;
	reg_t		*rp;
	int 		osize;
	int 		nsize;
	int		is_stack;
	int		sd_alloc;

	/* initialize local variables */
	is_stack = (prp->p_type == PT_STACK);
	regva = prp->p_regva;
	rp = prp->p_reg;
	lp = rp->r_list;
	osize = rp->r_pgsz;
	nsize = osize + change;
	ASSERT(nsize > 0);
	sd_cnt = ctos(nsize);		/* number of segment entries to fill */
	num = btoct(regva);			/* region page offset */
	if (!is_stack) {
		count = num + osize;		/* osize page offset */
		if (change) {
			sd_idx = ctos(count);	/* expand/attach existing reg */
			sd_cnt -= (num = ctos(osize));
			lp += num;
		}
		else
			sd_idx = ctost(num);	/* attach existing region */
	}
	else {
		count = num - osize;		/* osize page offset */
		if (change) {
			sd_idx = ctost(count + 1) - 1;
			sd_cnt -= (num = ctos(osize));
			lp += num;
		}
		else
			sd_idx = ctost(num);	/* attach existing region */
	}

	/* index to the correct Qsegment entry */
	qd = (qde_t *)rde_to_km(up->u_procp->p_urde);
	qd += stoqt(sd_idx);			/* advance qd to end-o-seg */

	sd_alloc = 0;

	if (!is_stack) {
		/* Fill the Qsegment table */
		for (; sd_cnt > 0; qd++, sd_idx += num, sd_cnt -= num) {
			/* allocate a Seg table, if there is not one */
			if (qd->qde.udt == UDT_INVALID)	{
				if (!(sd = (sde_t *)ptalloc(2, 0, rp, NBPST))) {
					/*
					 * free any allocated segment tables
					 */
					for (count = sd_alloc; --count >= 0; ) {
						--qd;
						ASSERT(qd->qde.udt == UDT_PRES);
						uptfree(qde_to_km(*qd), 2);
						*qd = spm_mem.invalid_qde;
					}
					return(0);
				}
				bset_long(sd, spm_mem.invalid_sde, NEPST);
				*qd = km_to_qde(sd);
				++sd_alloc;
			}
			else {
				/* entry already there */
				ASSERT(qd->qde.udt == UDT_PRES);
				sd = (sde_t *) qde_to_km(*qd);
			}
			/* Index to the proper place in the Segment table */
			sd += (num = segidx(sd_idx));
			if ((num = NEPST - num) > sd_cnt)
				num = sd_cnt;

			/* Fill the Segment entries with page table pointers */
			for (count = num; --count >= 0; ) {
				ASSERT(sd->sde.udt == UDT_INVALID);
				*sd++ = km_to_sde(*lp++);
			}
		}
	}
	else {
		/*
		 * Stack segments are backwards on the M68K family.
		 * They grow down from regva, which is the last valid long
		 * word in the region (0x7ffffffc for us).  However, we
		 * try to pretend that they grow upwards as much as possible
		 * to avoid special cases like the one below.
		 */

		/* Fill the Qsegment table */
		for (; sd_cnt > 0; qd--, sd_idx -= num, sd_cnt -= num) {
			/* allocate a Seg table, if there is not one */
			if (qd->qde.udt == UDT_INVALID)	{
				if (!(sd = (sde_t *)ptalloc(2, 0, rp, NBPST))) {
					/*
					 * free any allocated segment tables
					 */
					for (count = sd_alloc; --count >= 0; ) {
						++qd;
						ASSERT(qd->qde.udt == UDT_PRES);
						uptfree(qde_to_km(*qd), 2);
						*qd = spm_mem.invalid_qde;
					}
					return(0);
				}
				bset_long(sd, spm_mem.invalid_sde, NEPST);
				*qd = km_to_qde(sd);
				++sd_alloc;
			}
			else {
				/* entry already there */
				ASSERT(qd->qde.udt == UDT_PRES);
				sd = (sde_t *) qde_to_km(*qd);
			}
			/* Index to the proper place in the Segment table */
			sd += (num = segidx(sd_idx));
			++num;			/* number of avail seg slots */
			if (num > sd_cnt)
				num = sd_cnt;

			/* Fill the Segment entries with page table pointers */
			for (count = num; --count >= 0; sd--) {
				ASSERT(sd->sde.udt == UDT_INVALID);
				*sd = km_to_sde(*lp++);
			}
		}
	}
	ASSERT(sd_cnt == 0);

	flush_all_user_tlb();
	return(1);	/* successful load */
}

/*
 * loadstbl(up, prp, change)
 *
 * Change the content of a process's segment descriptor entries:
 *    	change > 0 -> load segment table using the entries of prp->p_reg->r_list
 *	change = 0 -> load segment table using prp->p_reg->r_list.
 *	change < 0 -> invalidate affected segment table entries.
 *
 * return 1 on success, 0 on failure.
 */

loadstbl(up, prp, change)
user_t	*up;
preg_t	*prp;
int	change;
{
	if (change >= 0)
		return (grow_stbl(up, prp, change));
	else
		return (shrink_stbl(up, prp, change));
}


/* 
 * DPM40 has 7 types of level seven interrupts (nmi's).
 * 1. Snoop Fifo Overflow
 *	per pm, recoverable
 * 2. Level Seven Interrupt
 *	per pm, recoverable -- used to call tdb
 * 3. Bus Freeze
 *	serviced per pm, recoverable -- used to call tdb
 * 4. Map Fault (someone did a WRITE to an invalid Map entry )
 *	per pm, nonrecoverable. error info in shared bus error register.
 *	(Read map fault errors come in as exception 2 -- bus error)
 * 5. CSS Error
 *	sent to pm A only (pertains to the board). nonrecoverable.
 *	info in shared bus error register.
 * 6. Non-Read Error
 *	per pm, nonrecoverable.
 *	[grant/response] timeout error bits are shared.
 *	info in shared bus error register.
 *	info in [grant/response] timeout error registers is shared but is
 *	keyed to the pm.
 *	(Some non-read errors come in as exception 2 -- bus error)
 * 7. IPC Command Error -- an ipc command was received in unix
 *	per pm, nonrecoverable.
 *	there is a bit to turn off receipt of ipc commands, which is set when
 *	unix is run, so: "you should never see this error".
 * As shown, above, some of these errors share registers to show their error
 * information (bus error register).  An additional register attempts to
 * display the FIRST non-recoverable error, to help key the information in
 * the bus error register to a specific error.  However, it is possible that
 * errors will come in simultaneously.  At that point, all bets are off.  It
 * may be impossible to match an error with error register contents.
 * To add to the complication, some errors affecting these registers may come
 * in as buserrors.
 * Because of the sharing of registers between the two pm's, and the 
 * possibility of buserr also manipulating these registers, a coordinating lock
 * has been added to aid in the coherent presentation of error information.
 * ie: keep error info from different sources from intermingling on the screen.
 * The lock is used to lock out & signify to the other handlers (other pm and 
 * buserr) that manipulation of the error registers is in process.
 * In addition to hardware errors, tdb is called using a level 7 interrupt.
 * Once running, tdb actually runs at level 6, so that the recoverable,
 * snoop fifo overflow error can be serviced, and so that breakpoints can be
 * set inside of level_seven routines.  Other, fatal nmi's are ignored, once
 * the first fatal one is handled.
 */
hard_error(whence, tdb_state)
ulong whence;		/* Did I come from bus err (1), or from an nmi(0)? */
state_t	tdb_state;
{
	register ulong	pm_sts = *(ulong *)PM_STS;
	register uint	pmA;	
	register int	save_lock_val;

#ifdef DEBUG
	printf("GOT HARD ERROR %x %x\n", whence, pm_sts);
#endif

	if (pm_sts & STS_SFIFOFULL) {	/* recoverable */ 
		clear_chip_cache();
		clear_caches();		/* HW disabled caches */
		printf("Warning: Snoop FIFO Overflow\n");
		if (!(pm_sts & (STS_SWINT7 | STS_FRZ | STS_GOTIPC |
				STS_NONRDERR | STS_MAPFAULT | STS_CSSERR)))
			return (0);
	} 

	/* was tdb called explicitly? */
	whence = whence ? ERR_LOCK_BERR : ERR_LOCK_NMI;

	if (pm_sts & STS_SWINT7)	/* by Software Interrupt 7 */
		*(ulong *)(PM_CLRINT) = CLR_SW7;

	if (pm_sts & STS_FRZ)	/* or by Bus Freeze */
		*(ulong *)(PM_CLRINT) = CLR_FRZ;


	/* Check for unrecoverable NMI's */

	if (pm_sts & (STS_GOTIPC | STS_NONRDERR | STS_MAPFAULT | STS_CSSERR)) {
		register ulong	pm_fst = ~*(ulong *)PM_FST; /* note inversion */
		register ulong	pm_rcv = *(ulong *)PM_RCV;
		register ulong	pm_tmout = *(ulong *)PM_TMOUT;

		pmA = (own.o_pm_id == own.o_base_pm_id);
		/* 
		 * Lock out other error handlers on this pm and board.
		 */
		save_lock_val = spin_for_err_lock(
		    &(spm_mem.pm_own[own.o_base_pm_id]->o_err_lock),
					(ERR_LOCK_GOT | whence | pmA));

		/* Display current state of error and status registers */
		printf("UNRECOVERABLE NMI:\n");
		if (save_lock_val)
			printf(
		"Warning: NMI HDLR lifted lock (0x%x) from: %s of CPU %c\n", 
			  save_lock_val,
			  (save_lock_val & ERR_LOCK_BERR) ?
			    "BUS ERROR" : "NMI HDLR", 
			  (save_lock_val & ERR_LOCK_CPUA) ? 'A': 'B');

		showtrap(&tdb_state); 
		break_out_pm_fst(pm_fst, 1);
		break_out_pm_sts(pm_sts, 0);
		break_out_pm_rcv(pm_rcv, 0);
		break_out_pm_tmout(pm_tmout, 0);
		printf("\n");

		if (pm_sts & STS_GOTIPC) {
			printf("IPC ENABLED.\n");
			*(ulong *)(PM_SCTL) |= SCTL_IPCOFF; /* clear IPC BIT */
			*(ulong *)(PM_CLRINT) = CLR_IPC;
		}

		if (((pm_fst & FST_NONRDERR_NA) && pmA) ||
		    ((pm_fst & FST_WRERR_NB) && !pmA))
			clear_timeout_err(pm_fst, pm_tmout, pm_sts);

		if ((pm_fst & FST_CSSERR_N) && pmA) {
			printf("CSS ERROR (interrupt)\n");
			break_out_pm_rcv(pm_rcv, 1);
			*(ulong *)(PM_CLRINT) = CLR_BUSERR;
		}

		if (((pm_fst & FST_MF_NA) && pmA) ||
		    ((pm_fst & FST_MF_NB) && !pmA)) {
			printf("MAP FAULT ERROR (interrupt)\n");
			break_out_pm_rcv(pm_rcv, 1);
			*(ulong *)(PM_CLRINT) = CLR_MAP;
		} /* MAPFAULT */

		atom_set_err_lock(
		  &(spm_mem.pm_own[own.o_base_pm_id]->o_err_lock), 0,
		  (ERR_LOCK_GOT | whence | pmA), 1);
	} /* CSSERR | NRDERR | IPCERR | MAPERR */

	if (whence == ERR_LOCK_NMI) {
#ifdef DEBUG
		printf("ENTERING TO TDB FROM HARD_ERROR\n");
#endif
		return (1);
	}

	if (! spm_mem.cache_off) {
		printf("CLEARING CACHES IN HARD_ERROR\n");
		clear_chip_cache();
		printf("ENABLING CACHES IN HARD_ERROR\n");
		re_enable_caches();
		printf("FINISHED CACHE STUFF\n");
	}

	return (0);
} /* hard_error */




/* 
 * spin_for_err_lock is used by buserr and level_seven to lock out manipulation 
 * of error registers by your own pm or the other pm.  The lock location 
 * contains a bit to say the lock is busy, a bit to identify the pm holding the
 * lock, and a bit to identify whether buserr of the interrupt handler
 * currently holds the lock. Unlocked value is zero.
 * This may be non-elegant, but it is used basically once, when the system
 * is going down due to some unrecoverable error.  The point is to minimize
 * any chaotic reporting and clearing of errors on the way.
 * The idea here is:
 * 1. just try setting the lock.  if you get it, great, return.
 * 2. lock already set by your own pm? then grab it.
 *    There's no returning now to let the guy finish.  If you are level_seven()
 *    taking the lock, if you returned, you'd just get another interrupt and
 *    buserr() would never get done.  If you are buserr, you can't return to the
 *    place that gave you the error in the first place.
 * 3. in trying to set the lock, however, the other pm may have stolen it
 *    from you (unlikely, but possible), so drop down to the case where you
 *    spin on the lock for a fixed time, waiting for the other pm to clear it.
 *    If it never clears, assume the other guy died and just steal it and 
 *
 *    In all cases, return the old value of the lock.
 */
spin_for_err_lock(lock_loc, lock_val)
char	*lock_loc;
char	lock_val;
{
	char	ret_val, save_val;
	uint	num_spin = 2 * 10000; /* hanna FIX: what's a good number? */

	if( !(ret_val = save_val = atom_tset_byte(lock_loc, lock_val)))
		return(0);				 

	if (ret_val == lock_val) { 
		/* we must have left locked before. how? */
		printf("spin_for_err_lock error: 0x%x\n", ret_val);
		return(0);
	}

	/*
	 * You're locking own pm out: buserr locks out level 7 or vice-versa.
	 */
	if ((lock_val & ERR_LOCK_CPUA) == (ret_val & ERR_LOCK_CPUA) &&
	    (save_val ==
	      (ret_val = atom_set_err_lock(lock_loc, lock_val, ret_val, 1))))
		return(ret_val);	

	/* 
	 * The other pm has the lock, spin for awhile waiting for it.
	 */
	if (!(atom_set_err_lock(lock_loc, lock_val, 0, num_spin)))
		return(0);	/* got it */

	ret_val = *lock_loc;		/* No hope, just take the lock. */
	*lock_loc = lock_val;
	return(ret_val); 		

} /* spin_for_err_lock */



/* 
 * Since some non-read errors come in as nmi's, others as bus errors, this
 * routine is called by both routines.  
 * The grant and response timeout bits and registers are shared between the
 * two processors.
 * At this point, the pm should have gotten the  own_err_lock to prevent the 
 * other pm on the board from entering this same routine and clearing any of 
 * the registers.
 * A bus error reset will clear the timeout registers regardless of whose
 * error is in the registers.  Consequently, when both pm's on a board get
 * some sort of non-read error, whoever gets there first, clears both errors,
 * and must set a common flag to say so.
 */
clear_timeout_err(pm_fst, pm_tmout, pm_sts)
register ulong	pm_fst, pm_tmout, pm_sts;
{
	register uint	clr_other = 0; /* clearing other pm's error? */
	register char	pmA = (own.o_pm_id == own.o_base_pm_id);
	register uint	valid_rto =
			  ((pm_fst & FST_NORSP_N) && (pm_sts & STS_NORSP));
	register uint	valid_gto =
			  ((pm_fst & FST_NOGRANT_N) && (pm_sts & STS_NOGRANT));

	if (valid_rto)
		clr_other = (!(pm_tmout & TM_WHO) && pmA); 

	if (valid_gto)
		clr_other += (!(pm_tmout & TM_CFIFO) && pmA); 

	printf("NON_READ ERROR: %s %s\n", valid_gto ? "GRANT_TIMEOUT" : "",
	  valid_rto ? "RESPONSE_TIMEOUT" : ""); 

	if (valid_gto || valid_rto) {
		break_out_pm_tmout(pm_tmout, 1);
		spm_mem.pm_own[own.o_base_pm_id]->o_bus_reset = 0;
	}

	if (pm_sts & STS_NONRDERR)
		*(ulong *)(PM_CLRINT) = CLR_NONRD;

	/* 
	 * If no one's reset the bus for current errors, do so.
	 */
	if (!spm_mem.pm_own[own.o_base_pm_id]->o_bus_reset)
		*(ulong *)(PM_CLRINT) = CLR_BUSERR;

	/* 
	 * If you cleared something that was not your own, set the flag in 
	 * pmA's own structure so the other pm won't also do bus reset.
	 */
	spm_mem.pm_own[own.o_base_pm_id]->o_bus_reset = clr_other;
}


break_out_pm_sts(statusreg, verbose)
register uint	statusreg;
{
	register uint	ints;
	register int	intnum;
	register uint	is_a = (statusreg & STS_WHO);

	printf("CPU Status/Control Register: 0x%x: ", statusreg);
	if (!verbose) {
		printf("\n");
		return;
	}

	printf("Slot %d/%c", statusreg >> STS_MYSLOT_SHFT, is_a ? 'A' : 'B');

	/* only CPU A has hardware and software interrupts */
	ints = is_a ? (STS_HWINT | STS_SWINT | STS_SWINT7) : (STS_SWINT7);

	if (statusreg & ints) {
		printf(", Ints Pend: ");
		if (statusreg & ints & STS_HWINT) {
			ints = (statusreg & STS_HWINT) >> STS_HWINT_SFT;
			printf("HW(");
			for (intnum = 1; intnum < 7; intnum++, ints >>= 1)
				if (ints & 1)
					printf("%d,", intnum);
			printf(")");
		}

		ints = is_a ? (STS_SWINT | STS_SWINT7) : (STS_SWINT7);
		if (statusreg & ints) {
			ints &= (statusreg & STS_SWINT);
			printf(", SW(");
			for (intnum = 1; intnum < 7; intnum++, ints >>= 1)
				if (ints & 1)
					printf("%d,", intnum);
			if (statusreg & STS_SWINT7)
				printf("7");
			printf(")");
		}
	}

	printf("\nErrors: ");
	if (!(statusreg & (STS_FRZ | STS_MAPFAULT | STS_NONRDERR |
	    STS_NOGRANT | STS_NORSP | STS_CSSERR | STS_SFIFOFULL | STS_GOTIPC)))
		printf("None.\n");
	else {
		if (statusreg & STS_MAPFAULT)
			printf("mapfault,");

		if (statusreg & STS_NONRDERR)
			printf("non-read,");

		if ((statusreg & STS_NOGRANT) && (statusreg & STS_NORSP))
			printf("grant & response timeouts,");
		else if (statusreg & STS_NOGRANT)
			printf("grant timeout,");
		else if (statusreg & STS_NORSP)
			printf("response timeout,");

		if (statusreg & STS_CSSERR)
			printf("CSS bus,");

		if (statusreg & STS_FRZ)
			printf("freeze,");

		if (statusreg & STS_GOTIPC)
			printf("ipc cmd,");

		if (statusreg & STS_SFIFOFULL)
			printf("fifo full");
		printf("\n");
	}

	if (statusreg & (STS_IF | STS_DIAGBAG)) {
		printf("Misc: ");
		if (statusreg & STS_IF)
			printf("Bus interface enabled, ");
		if (statusreg & STS_DIAGBAG)
			printf("Diagbag present");
		printf("\n");
	}
} /* break_out_pm_sts */


/*
 * Print out the First Error Register.
 * The first error register is "active low".
 * The pm_fst argument is expected to be "active high".
 */
break_out_pm_fst(pm_fst, verbose)
register uint	pm_fst;
uint	verbose;
{
	if (verbose) {
		printf("FIRST ERROR ~0x%x:", pm_fst);

		/* grant & response timeouts -- shared */
		if (pm_fst & FST_NORSP_N) {
			printf(" Response");
			if (pm_fst & FST_NOGRANT_N)
				printf(" & Grant");
			printf(" Timout.");
		}
		else if (pm_fst & FST_NOGRANT_N)
			printf(" Grant Timeout.");


		/*
		 * A gets nonread errors (bus error/nmi),
		 * B write errs only (buserr)
		 */
		if (pm_fst & FST_NONRDERR_NA) {
			printf(" 'A' NonRead");
			if (pm_fst & FST_WRERR_NB)
				printf(" & 'B' Write");
			printf(" Error.");
		}
		else if (pm_fst & FST_WRERR_NB)
			printf(" 'B' Write Error.");

		/* CSS error -- A receives only */
		if (pm_fst & FST_CSSERR_N)
			printf(" CSS Error.");

		/* Mapfaults -- either */
		if (pm_fst & FST_MF_NA) {
			printf(" 'A'");
			if (pm_fst & FST_MF_NB)
				printf(" & 'B'");
			printf(" Map Fault.");
		}
		else if (pm_fst & FST_MF_NB)
			printf(" 'B' Map Fault.");

		/* ALSO WARN OF MULT ERRORS here. */
		printf("\n");
	}
	else
		printf("1E: ~0x%x. ", pm_fst);
} /* break_out_pm_fst */


/* 
 * Print out the contents of the general "bus error" register.
 */
break_out_pm_rcv(pm_rcv, verbose)
register uint	pm_rcv;
uint		verbose;
{
	if (verbose) {
		printf("BUSERR REG 0x%x: ", pm_rcv);
		/* no verbose for now */
		printf("\n");
	} else
		printf("BE: 0x%x. ", pm_rcv);
}



/* 
 * Print out the contents of the general "timeout error" register.
 * This is actually, Two. Two. Two regs in one!
 */
break_out_pm_tmout(content, verbose)
register uint	content;
uint		verbose;
{
	if (verbose) {
		printf("RESPONSE REG: 0x%x: ", content & 0xff);
		printf(" pm %s from slot %d.\n", 
		  (content & TM_WHO) ? "A" : "B", 
		  (content & TM_RSRC) >> 4);

		printf("GRANT REG: 0x%x: ", content & 0xffff0000);
		printf("pm %s, xmit dest: %d, arb dest: %d, type: %d.\n", 
		  (content & TM_CFIFO) ? "B" : "A", 
		  (content & TM_XDST) >> 20,
		  (content & TM_ADST) >> 24,
		  (content & TM_XTYP) >> 28); /* any strings for this? */
	}
	else
		printf("T/O: 0x%x. ", content);
}

/* 
 * Invalidate both the 68040's cache and the DPM40's cache.
 * This routine is called by hard_error, where both caches were disabled by a
 * Snoop FIFO overflow.
 */
static
clear_caches()
{
	register ulong	*entry;
	register int	num_entry;
	register ulong	invalid;

	ASSERT(get_spl());

	clear_chip_cache();		/* See Mot Manual Corrections # 7 */

	entry = (ulong *)PM_CTAG_START;
	invalid = CTAG_INVALID;
	num_entry = PM_CTAG_MANY;
	while (--num_entry >= 0) {	/* invalidate the secondary cache */
		*entry = invalid; 
		entry += PM_CTAG_STEP / sizeof(ulong);
	}

	clear_chip_cache();		/* clear again 'cuz of pure paranoia */

	*(ulong *)(PM_CLRINT) = CLR_SFIFO;	/* clear snoop fifo overflow --
						 * turns on snoop fifo loading
						 */
	*(ulong *)(PM_CLRINT) = CLR_CACHE;	/* clear cache inhibit --
						 * removes inhibit on primary
						 * and secondary caches
						 */
}


/* 
 * Hardware has turned off caches. This turns them back on.
 * This is different than the initial enabling of caches, when bits get
 * twiddled in the 040's cache enable register and the DPM40's control reg
 */
re_enable_caches() 
{
	*(ulong *)(PM_CLRINT) = CLR_CACHE;
	*(ulong *)(PM_PCTL) |= PCTL_SCACHE | PCTL_PCACHE;
}

/* 
 * Turn off the caches.
 */
disable_caches()
{
	clear_chip_cache();		/* See Mot Manual Corrections # 7 */
	*(ulong *) PM_PCTL &= ~(PCTL_SCACHE | PCTL_PCACHE);
	clear_chip_cache();		/* See Mot Manual Corrections # 7 */
}

static ulong int_err_entry[] = {
    CLR_SW, CLR_HW,
    CLR_NMI,
    CLR_SW1, CLR_SW2, CLR_SW3, CLR_SW4, CLR_SW5, CLR_SW6, CLR_SW7,
    CLR_HW1, CLR_HW2, CLR_HW3, CLR_HW4, CLR_HW5, CLR_HW6,
    CLR_BUSERR, CLR_NONRD,
    CLR_CSSERR, CLR_SNOOPERR,
    CLR_SFIFO,
    CLR_IPC, CLR_FRZ, CLR_MAP,
    CLR_CACHE,
    0
};


clear_pm_int_err_reg()
{
	ulong *p = int_err_entry;
	while (*p)
		*(ulong *)(PM_CLRINT) = *p++;
}


/* M68040 C/B tag consistency checking from shihnan */
/*
	r_btag_on() - enable btag
*/
void
r_btag_on()
{
	ulong	val;

	atom_or(PM_SCTL, SCTL_BTAG);
	val = *(ulong *)PM_PCTL;
	val |= PCTL_SCACHE | PCTL_PCACHE;
	*(ulong *)PM_PCTL = val;
}

/*
	r_btag_off() - disable btag
*/
void
r_btag_off()
{
	ulong	val;

	clear_chip_cache();		/* See Mot Manual Corrections # 7 */
	val = *(ulong *)PM_PCTL;
	val &= ~(PCTL_SCACHE | PCTL_PCACHE);
	*(ulong *)PM_PCTL = val;
	clear_chip_cache();		/* See Mot Manual Corrections # 7 */
	atom_and(PM_SCTL, ~SCTL_BTAG);
}


/*
	M68040 C/B tag consistency checking from shihnan.
	tagchk 
*/
tagchk()
{
	register int	i;
	register uint	ctagaddr, btagaddr;
	BTAG		btag;
	CTAG		ctag;
	DIAG_MAP	map;
	uint	ba31_18, btag_v_u, btag_v_l;
	int	ret, is_cpu_a;

	is_cpu_a = ( own.o_pm_id == own.o_base_pm_id );
	printf("Check Tag Consistency\n");
	r_btag_off();
	for ( ctagaddr=PM_CTAG_START,btagaddr=PM_BTAG_START,i=0;
		i<PM_CTAG_MANY; 
		i++, ctagaddr+=PM_CTAG_STEP,btagaddr+=PM_BTAG_STEP )
	{
		ctag.ctagw = *(uint *)ctagaddr;
		btag.btagw = *(uint *)btagaddr;
		map.mapw = *(uint *)(PM_MAP_START+(ctag.ctage.ndx<<2));
		ba31_18 = (map.mapf.ba31_20<<2) + (ctag.ctage.pa19_18);
		if (is_cpu_a)	/* cpuA */
		{
			btag_v_u = btag.btagf.v_ua;
			btag_v_l = btag.btagf.v_la;
		}
		else		/* cpuB */
		{
			btag_v_u = btag.btagf.v_ub;
			btag_v_l = btag.btagf.v_lb;
		}
		if (!(ctag.ctagf.v_l ^ btag_v_l || ctag.ctagf.v_u ^ btag_v_u ||
		      (ctag.ctagf.v_l || ctag.ctagf.v_u ) &&
		     (ba31_18 != btag.btagf.ba31_18 || 
		       map.mapf.slot != btag.btagf.slot)))
			continue;

		ret++;
#if 0
		printf(" BTAG[0x%04x]: vbit_la=%d vbit_ua=%d vbit_lb=%d vbit_ub=%d a31_18=0x%04x slot=0x%02x\n",
			i, btag.btagf.v_la, btag.btagf.v_ua, 
			btag.btagf.v_lb, btag.btagf.v_ub, 
			btag.btagf.ba31_18, btag.btagf.slot);
		printf(" CTAG[0x%04x]: vbit_l=%d vbit_u=%d addr31_18=0x%04x\n",
			i, ctag.ctagf.v_l, ctag.ctagf.v_u, 
			ctag.ctagf.pa31_18);
		printf(" MAP[0x%03x]: slot=0x%x segment=0x%03x valid=%d\n",
			ctag.ctage.ndx, map.mapf.slot, 
			map.mapf.ba31_20, map.mapf.v);
#else
		printf(
		  "BTAG[0x%x]: la=%d ua=%d lb=%d ub=%d a31_18=0x%x slot=0x%x\n",
		  i, btag.btagf.v_la, btag.btagf.v_ua,
		  btag.btagf.v_lb, btag.btagf.v_ub,
		  btag.btagf.ba31_18, btag.btagf.slot);
		printf("CTAG[0x%x]: vbit_l=%d vbit_u=%d addr31_18=0x%x\n",
		  i, ctag.ctagf.v_l, ctag.ctagf.v_u, ctag.ctagf.pa31_18);
		printf("MAP[0x%x]: slot=0x%x segment=0x%x valid=%d\n",
		  ctag.ctage.ndx, map.mapf.slot, map.mapf.ba31_20, map.mapf.v);
#endif
	}
	r_btag_on();
	printf("Check %s\n", ( ret ) ? "Failed" : "OK");
	return(ret);
}

board_init()
{
	register ulong	*entry;
	register int	num_entry;
	register ulong	invalid;
	register uint	ctrl_reg;

	clear_chip_cache();		/* See Mot Manual Corrections # 7 */

	entry = (ulong *)PM_CTAG_START;
	invalid = CTAG_INVALID;
	num_entry = PM_CTAG_MANY;
	while (--num_entry >= 0) {	/* invalidate the secondary cache */
		*entry = invalid; 
		entry += (PM_CTAG_STEP) / sizeof(ulong);
	} 

	/* make sure that these bits are set before using the secondary cache */
	atom_or(PM_SCTL, SCTL_LED_RDY_FLT | SCTL_CFIFO | SCTL_BTAG);

	*(ulong *)(PM_CLRINT) = CLR_SFIFO;	/* clear snoop fifo overflow --
						 * turns on snoop fifo loading
						 */
	*(ulong *)(PM_CLRINT) = CLR_CACHE;	/* clear cache inhibit --
						 * removes inhibit on primary
						 * and secondary caches
						 */

	/* finish activating the cache */
	ctrl_reg = *(ulong *)PM_PCTL;
	ctrl_reg |= PCTL_SELFOFF | PCTL_DECODE | PCTL_SFIFO;
	*(ulong *)PM_PCTL = ctrl_reg;

	if (own.o_last_pm_id == own.o_pm_id)
		atom_or(PM_SCTL, SCTL_IPCOFF);	/* last CPU up turns off IPC */
}

/*
 * do_bus_freeze -- hit the bus freeze line and stop all intelligent boards
 */

do_bus_freeze()
{
	*(ulong *)PM_FRZ = 0;
}
