/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) shm.c: version 25.1 created on 11/27/91 at 15:07:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)shm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * 002 JPC	3/9/88	Add a lock to shmat to avoid any chance of corrupting
 *			the shmid_ds.  Atomize availrmem and availsmem.
 */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/dir.h"
#include "sys/errno.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/ipc.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/pfdat.h"
#include "sys/proc.h"
#include "sys/systm.h"
#include "sys/sysmacros.h"
#include "sys/shm.h"
#include "sys/debug.h"
#include "sys/tuneable.h"
#include "sys/cmn_err.h"
#include "sys/synch.h"
#include "sys/mfs.h"
#include "sys/inode.h"
#include "sys/kmem.h"


/* #define FULL_SHMEM_DEBUG		/* full debug shm */
/* #define SHMEM_DEBUG		/* debug shm */

					/* synchronizer for shmget	*/
suspend_lock_t		shm_lock = SUSPEND_INIT(PZERO - 1);

extern struct shmid_ds	shmem[];	/* shared memory data structures*/
extern suspend_lock_t	shmlk[];	/* shared memory lock structures*/
extern struct shminfo	shminfo;	/* shared memory info structure	*/
extern	time_t		time;		/* system idea of date		*/

struct	shmid_ds	*ipcget(),
			*shmconv();

/*
 * JPC 3/10/88
 * The most important difference between our TLB hardware and AT&T's (for
 * shared memory) is the fact that AT&T can write-protect a segment at the
 * segment table level, while we must modify individual page descriptors.
 * So, to attach a read-only segment, the read-write segment must have
 * its page descriptors duplicated and write protected.  To avoid swapping
 * the pages twice (once for the rw segment, and once for the ro segment),
 * I lock the pages in physical memory.  In fact, the pages are locked, and
 * all referenced, before the rw segment is duplicated.  So, shared memory
 * is swappable until someone attaches the segment read-only.
 * See the comments in shmat and shm_ro_reg for further details.
 */

/*
 * Shmat (attach shared segment) system call.
 */
shmat()
{
	register struct a {
		int	shmid;
		uint	addr;
		int	flag;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;
	register struct region		*rp, *oldrp;
	register struct pregion		*prp;
	register int			n, num, rwflag, initflag, resv;
	register uint			size;
	preg_t				*shmattach();
	reg_t				*shm_ro_reg();
	uint				shmaddr();
	int				a1000, a1000_big, s90;

	if ((sp = shmconv(uap->shmid)) == NULL)
		return;
	if (ipcaccess(&sp->shm_perm, SHM_R))
		return;
	if ((uap->flag & SHM_RDONLY) == 0)
		if (ipcaccess(&sp->shm_perm, SHM_W))
			return;
	s90 = 0;
	a1000 = 0;
	a1000_big = 0;
	num = 0;			/* attached too many segments? */
	prp = u.u_procp->p_region;
	for ( ; prp->p_reg; prp++) {
		if (prp->p_type == PT_SHMEM) {
			++num;
/* FIX THIS, BK: handle mixed s90 and a1000 shared memory more gracefully */
			if ((prp->p_flags & PF_A1000) == 0)
				s90 = 1;
		}
		/*
		 *	Find the data region and check if it was A1000 binary
		 *	that is doing shared memory attach.
		 */
		if ((prp->p_type == PT_DATA) && (prp->p_flags & PF_A1000)) {
			a1000 = PF_A1000;
			oldrp = prp->p_reg;
			/*
			 *	If forked with A1000 shared memory
			 *	shrink the region for the size of shared mem.
			 */
			reglock(oldrp);
			if (oldrp->r_flags & RG_WASSHM) {
				(void) growreg(prp, -btoc(sp->shm_segsz),
						DBD_NONE); 
				oldrp->r_flags &= ~RG_WASSHM;
			}
			regrele(oldrp);
		}
	}
	if (num >= shminfo.shmseg) {
		u.u_error = EMFILE;
		return;
	}
	if (uap->addr == 0) {
		if ((uap->addr = shmaddr(ctob(sp->shm_reg->r_pgsz))) == 0) {
			u.u_error = EMFILE;	/* no room for segment */
			return;
		}
	}
	else if (uap->flag & SHM_RND)
		uap->addr &= (a1000 ? ~(SHMLBA - 1) : ~SOFFMASK);

	/*
	 *	Handle A1000 binary as normal if shared memory was
	 *	attached on segment boundary.
	 */
	if ((uap->addr & SOFFMASK) == 0)
		a1000 = 0;

/* FIX THIS, BK: handle mixed s90 and a1000 shared memory more gracefully */
	if ((s90 && a1000) || (uap->addr & (a1000 ? (SHMLBA - 1) : SOFFMASK))) {
		u.u_error = EINVAL;
#ifdef SHMEM_DEBUG
		printf("shmat: bad addr=0x%x\n", uap->addr);
#endif
		return;
	}

	/*
	 *	If A1000 binary is doing shared memory attach to an address
	 *	above the data region, then attach the region on segment
	 *	boundary, grow the hole to attach address and then grow the
	 *	region for the size of attach (see shmattach).
	 */
	if (a1000 && uap->addr & ~SOFFMASK) {
		a1000 = 0;
		a1000_big = 1;
	}

	size = btoc(sp->shm_segsz);
	rwflag = (uap->flag & SHM_RDONLY) ? SEG_RO : SEG_RW;

	/*
	 * 002
	 * Since the reglock in the middle of attaching a ro segment may sleep,
	 * use a simple lock to make sure that shm_ro_reg and other data in sp
	 * aren't corrupted.
	 */
	shmlock(sp);

	initflag = sp->shm_perm.mode & SHM_INIT;

	/*
	 *	If it was A1000 binary that is doing shared memory,
	 *	and attach address is not on a segment boundary
	 *	and this is first attach of shared memory
	 *	then free region allocated in shmget and attach to
	 *	the A1000 "common" region as shared memory.
	 */
	if (a1000 && initflag) {
		rp = sp->shm_reg;
		reglock(rp);
		freereg(rp);
		sp->shm_reg = oldrp;
#ifdef SHMEM_DEBUG
		printf("shm: {A1000} original rp=%x, new rp=%x\n", rp, oldrp);
#endif
	}

	/*
	 * for read-only attaches of S3000 native binaries:
	 *   if the ro region is NULL, attach the rw seg, dup it, and detach it
	 *   attach the ro seg
	 */
	rp = sp->shm_reg;
	reglock(rp);
#ifdef FULL_SHMEM_DEBUG
	printf("shm: sp=%x rp=%x addr=%x size=%x rwf=%x initf=0%o a1000=%x\n",
	  sp, rp, uap->addr, size, rwflag, initflag, a1000);
#endif
	if (rwflag == SEG_RO && ! a1000) {
		if (sp->shm_ro_reg == NULL) {
			/* attach to force a growreg and for reference */
			++rp->r_noswapcnt;		/* can't swap with ro */
			/*
			 * if going to initialize, or SHM_LOCKed, shm_ro_reg
			 * won't have to reserve extra physical pages
			 * resv: true => reserve, false => don't reserve
			 */
			resv = (initflag || rp->r_noswapcnt > 1) ? 0 : 1;
			if ((prp = shmattach(rp, (caddr_t)uap->addr, size,
			  SEG_RW, initflag, a1000, a1000_big)) == NULL) {
				--rp->r_noswapcnt;
				goto out;		/* failed */
			}
			if (initflag) {
				sp->shm_perm.mode &= ~SHM_INIT;
				initflag = 0;
			}
			regrele(rp);
			/* reference each page */
			num = sp->shm_segsz;
			for (n = 0; n < num; n += ctob(1))
				(void) fubyte(&prp->p_regva[n]);
			reglock(rp);
			if ((sp->shm_ro_reg = shm_ro_reg(rp, resv)) == NULL)
				--rp->r_noswapcnt;
			detachreg(prp, &u);
			if ((rp = sp->shm_ro_reg) == NULL)
				goto out;
		}
		else {
			regrele(rp);
			rp = sp->shm_ro_reg;
			reglock(rp);
		}
	}
	if (a1000) {
		if (initflag == 0) {
			regrele(rp);
			rp = oldrp;
			if (reg_islocked(rp) == 0)
				reglock(rp);
		}
		/*
		 *	Since we are now converting from swapping
		 *	A1000 text & data only "common" region to
		 *	non swapping A1000 text & data & shm "common"
		 *	region, we have to sacrifice some real memory
		 *	in anticipation of freereg. (Memory is cheap?)
		 */
		rp->r_noswapcnt = 1;	/* can't swap A1000 shmem */
		atom_sub(&availrmem, rp->r_pgsz);
		if (availrmem < tune.t_minarmem) {
			atom_add(&availrmem, rp->r_pgsz);
			nomemmsg("shmat (A1000)", rp->r_pgsz, 0, 0);
			u.u_error = EAGAIN;
			goto out;
		}
	}
	if ((prp = shmattach(rp, (caddr_t)uap->addr, size, rwflag, initflag,
	  a1000, a1000_big)) == NULL)
		goto out;

	prp->p_regva = (caddr_t)uap->addr;

	/*
	 *	If this was A1000 shared memory attach
	 *	then remember the size of attach, and mark
	 *	it as  A1000 shared memory.
	 */
	if (a1000) {
		prp->p_pgsz = size;
		prp->p_flags |= PF_A1000;
		if (initflag) {
			/*
			 *	If this was first attach after shmget, then
			 *	create "parent" shared memory region, to
			 *	which all processes can attach.
 			 *	In anticipation of freereg , decrement
 			 *	both availmem counters.
			 */
			atom_sub(&availrmem, size);
			if (availrmem < tune.t_minarmem) {
				atom_add(&availrmem, size);
				nomemmsg("shmat (A1000)", size, 0, 0);
				u.u_error = EAGAIN;
				goto out;
			}
			atom_sub(&availsmem, size);
			if (availsmem < tune.t_minasmem) {
				atom_add(&availrmem, size);
				atom_add(&availsmem, size);
				nomemmsg("shmat (A1000)", size, 0, 0);
				u.u_error = EAGAIN;
				goto out;
			}
			if (A1000_dupshmreg(rp, sp, prp)) {
				atom_add(&availrmem, size);
				atom_add(&availsmem, size);
				goto out;
			}
		}
		else {
			/*
			 *	Copy page table entries from shared memory
			 *	region to the shared memory section of
			 *	"common" A1000 region.
			 *
			 *	shm_ro_reg has parent virtual attach address
			 */
			A1000_shmfixptbl(sp->shm_reg, sp->shm_ro_reg,
					 rp, prp, rwflag);
		}
		reglock(sp->shm_reg);
		++sp->shm_reg->r_refcnt;
		regrele(sp->shm_reg);
		prp->p_shm_reg = sp->shm_reg;
		sp->shm_perm.mode |= SHM_A1000;
	}

	if (initflag)
		sp->shm_perm.mode &= ~SHM_INIT;
	regrele(rp);

	u.u_rval1 = (int) prp->p_regva;
/*	u.u_nshmseg++;	*/
	sp->shm_atime = time;
	sp->shm_lpid = u.u_procp->p_pid;
out:
	if (a1000 && initflag && u.u_error)
		rp->r_noswapcnt = 0;
	shmunlock(sp);
}

/*
 * Shmattach -- internal attach shared segment function.
 *
 * attaches region to process, at virt addr, returns preg
 * (receives and returns a locked region; unlocks the region on error)
 */

preg_t *
shmattach(rp, addr, pgs, rwflag, initflag, a1000, a1000_big)
register reg_t	*rp;
caddr_t		addr;
uint		pgs;
int		rwflag, initflag, a1000, a1000_big;
{
	register preg_t	*prp;
	register int	n;

	if (rp->r_pgsz > 0 && chkpgrowth(rp->r_pgsz) < 0) {
		regrele(rp);
		u.u_error = ENOMEM;
		return (NULL);
	}

	if ((prp = attachreg(rp, &u, (uint)addr & ~SOFFMASK,
			PT_SHMEM | a1000, rwflag)) == NULL) {
		regrele(rp);
		return (NULL);
	}
	if (initflag || a1000) {
		if (chkpgrowth(pgs) < 0)
			goto error_cleanup;

		if (a1000)
			if (growreg(prp, btoc((uint)addr -
			    ((uint)addr&~SOFFMASK))-rp->r_pgsz, DBD_NONE) < 0) 
				goto error_cleanup;
		if (a1000_big)
			if (growreg(prp, btoc((uint)addr -
			    ((uint)addr & ~SOFFMASK)), DBD_NONE) < 0) 
				goto error_cleanup;

		if (growreg(prp, pgs, DBD_DZERO) < 0) {
error_cleanup:
			detachreg(prp, &u);
			u.u_error = ENOMEM;
			return (NULL);
		}
		if (initflag) {
			regrele(rp);
			/* reference each page */
			for (n = pgs; --n >= 0; addr += ctob(1))
				(void) fubyte(addr);
			reglock(rp);
		}
	}
	return (prp);
}


/*
 * 002
 * Since the reglock in the middle of attaching a ro segment may sleep,
 * use a simple lock to make sure that shm_ro_reg and other data in sp
 * aren't corrupted.
 */
shmlock(sp)
struct shmid_ds	*sp;
{
	suspend_lock(&shmlk[sp - shmem]);
}

/*
 * shmunlock -- release lock on shmid_ds -- 002
 */
shmunlock(sp)
struct shmid_ds	*sp;
{
	suspend_unlock(&shmlk[sp - shmem]);
}

/*
 * Convert user supplied shmid into a ptr to the associated
 * shared memory header.
 */
struct shmid_ds *
shmconv(s)
register int	s;	/* shmid */
{
	register struct shmid_ds	*sp;	/* ptr to associated header */

	if (s < 0)
	{
		u.u_error = EINVAL;
		return(NULL);
	}
	sp = &shmem[s % shminfo.shmmni];
	if (!(sp->shm_perm.mode & IPC_ALLOC) ||
	    s / shminfo.shmmni != sp->shm_perm.seq) {
		u.u_error = EINVAL;
		return(NULL);
	}
	return(sp);
}

/*
 * Shmctl system call.
 */
shmctl()
{
	register struct a {
		int		shmid,
				cmd;
		struct shmid_ds	*arg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	register struct region		*rp;	/* shmem region */
	struct shmid_ds			ds;	/* hold area for IPC_SET */
	register int			i, a1000;

	if ((sp = shmconv(uap->shmid)) == NULL)
		return;

	/*
	 *	Find out if this is A1000 shared memory shmctl
	 */
	a1000 = sp->shm_perm.mode & SHM_A1000;

	switch (uap->cmd) {

	/* Remove shared memory identifier. */
	case IPC_RMID:
		if (u.u_uid != sp->shm_perm.uid &&
		    u.u_uid != sp->shm_perm.cuid && !auth_shm())
			return;
		shmlock(sp);
		sp->shm_perm.mode = 0;
		sp->shm_segsz = 0;
		i = ++(sp->shm_perm.seq) * shminfo.shmmni + (sp - shmem);
		if (i < 0)
			sp->shm_perm.seq = 0;

		if (a1000) {
			rp = sp->shm_reg;
			sp->shm_reg = NULL;
			sp->shm_ro_reg = NULL;
			reglock(rp);
			if (rp->r_refcnt == 0)
				freereg(rp);
			else {
				rp->r_flags &= ~RG_NOFREE;
				regrele(rp);
			}
#ifdef SECON
			sat_ipcrm();
#endif
		}
		else {
			for (i = 0; i < 2; i++) {
				if (i == 0) {
					rp = sp->shm_reg;
					sp->shm_reg = NULL;
				}
				else {
					rp = sp->shm_ro_reg;
					sp->shm_ro_reg = NULL;
				}
				if (rp == NULL)
					continue;
				reglock(rp);
				if (rp->r_refcnt == 0)
					freereg(rp);
				else {
					rp->r_flags &= ~RG_NOFREE;
					regrele(rp);
				}
			}
		}
		shmunlock(sp);
		break;

	/* Set ownership and permissions. */
	case IPC_SET:
		if (u.u_uid != sp->shm_perm.uid && u.u_uid != sp->shm_perm.cuid
			 && !auth_shm())
			 return;
		/*
		 * For A1000 compatibillity
		 */
		if (copyin(uap->arg, &ds, sizeof(ds) - sizeof(ds.shm_ro_reg))) {
			u.u_error = EFAULT;
			return;
		}
#ifdef SECON
		sat_ipcdac(sp->shm_perm.uid, ds.shm_perm.uid,
			sp->shm_perm.gid, ds.shm_perm.gid,
			sp->shm_perm.mode, (sp->shm_perm.mode & ~0777)
					   | (ds.shm_perm.mode & 0777) );
#endif
		shmlock(sp);
		sp->shm_perm.uid = ds.shm_perm.uid;
		sp->shm_perm.gid = ds.shm_perm.gid;
		sp->shm_perm.mode = (ds.shm_perm.mode & 0777) |
			(sp->shm_perm.mode & ~0777);
		sp->shm_ctime = time;
		shmunlock(sp);
		break;

	/* Get shared memory data structure. */
	case IPC_STAT:
		if (ipcaccess(&sp->shm_perm, SHM_R))
			return;

		/*	The following is needed because
		**	a user can look at it.  In
		**	particular, the regression tests
		**	require it.
		*/

		shmlock(sp);
		if (a1000)
			sp->shm_nattch = sp->shm_reg->r_refcnt;
		else
			sp->shm_nattch = sp->shm_reg->r_refcnt +
			  (sp->shm_ro_reg ? sp->shm_ro_reg->r_refcnt : 0);

		/*
		 * For A1000 compatibillity
		 */
		if (copyout(sp, uap->arg, sizeof(*sp) - sizeof(sp->shm_ro_reg)))
			u.u_error = EFAULT;
		shmunlock(sp);
		break;

	/* Lock segment in memory */
	case SHM_LOCK:
		if (!auth_shm())
			return;

		shmlock(sp);
		rp = sp->shm_reg;
		reglock(rp);
		ASSERT(rp->r_noswapcnt >= 0);
		if (rp->r_noswapcnt == 0) {
			atom_sub(&availrmem, rp->r_pgsz - rp->r_gapsz);
			if (availrmem < tune.t_minarmem) {
				atom_add(&availrmem, rp->r_pgsz - rp->r_gapsz);
				regrele(rp);
				shmunlock(sp);
				cmn_err(CE_NOTE,
				   "shmctl - couldn't lock %d pages in memory",
				   rp->r_pgsz - rp->r_gapsz);
				u.u_error = ENOMEM;
				return;
			}
		}
		++rp->r_noswapcnt;
		regrele(rp);
		shmunlock(sp);
		break;

	/* Unlock segment */
	case SHM_UNLOCK:
		if (!auth_shm())
			return;

		shmlock(sp);
		rp = sp->shm_reg;
		reglock(rp);
		if (rp->r_noswapcnt == 0) {
			/*	User didn't really lock it.
			*/

			if (a1000 || sp->shm_ro_reg)
				++rp->r_noswapcnt; /* no swap with A1000 & ro*/
			regrele(rp);
			shmunlock(sp);
			break;
		}
		ASSERT(rp->r_noswapcnt > 0);
		--rp->r_noswapcnt;
		if (rp->r_noswapcnt == 0)
			if (a1000 || sp->shm_ro_reg)
				++rp->r_noswapcnt; /* no swap with A1000 & ro*/
			else
				atom_add(&availrmem, rp->r_pgsz - rp->r_gapsz);
		regrele(rp);
		shmunlock(sp);
		break;

	default:
		u.u_error = EINVAL;
	}
}


/*
 * Detach shared memory segment
 */
shmdt()
{
	register struct a {
		caddr_t	addr;
	} *uap = (struct a *)u.u_ap;
	register struct pregion		*prp;
	register struct region		*rp, *srp;
	register struct shmid_ds	*sp;
	register int			n;

	/*
	 * Find matching shmem address in process region list
	 */

	for (prp = u.u_procp->p_region; prp->p_reg; prp++)
		if (prp->p_type == PT_SHMEM && prp->p_regva == uap->addr)
			break;
	if (prp->p_reg == NULL) {
		u.u_error = EINVAL;
		return;
	}

	/*
	 * Detach region from process
	 * We must remember rp here since detach clobbers p_reg
	 */

	rp = prp->p_reg;
	reglock(rp);
	if (prp->p_flags & PF_A1000) {
		/*
		 *	For A1000 shared memory we have to do extra
		 *	work in checking the region that doesn't
		 *	belong to any process.
		 */
		srp = prp->p_shm_reg;
		reglock(srp);
		if ((--srp->r_refcnt == 0) && !(srp->r_flags & RG_NOFREE)) {
			freereg(srp);
		}
		else {
			regrele(srp);
		}
	}
	else {
		srp = rp;
	}
	detachreg(prp,&u);

	/*
	 * Find shmem region in system wide table.  Update detach time
	 * and pid, and free if appropriate
	 */
	for (sp = shmem, n = shminfo.shmmni; --n >= 0; sp++)	/* 002 */
		if (sp->shm_reg == srp || sp->shm_ro_reg == srp)
			break;
	if (n < 0)						/* 002 */
		return;	/* shmem has been removed already */
	shmlock(sp);
	sp->shm_dtime = time;
	sp->shm_lpid = u.u_procp->p_pid;
	shmunlock(sp);
}

/*
 * Exec, exit, and fork subroutines not needed any longer
 * Their function is implemented gratis by normal region handling
 */
shmexec() { }
shmexit() { }
/* shmfork() { } */

/*
 * Shmget (create new shmem) system call.
 */
shmget()
{
	register struct a {
		key_t	key;
		uint	size,
			shmflg;
	}	*uap = (struct a *)u.u_ap;
	register struct shmid_ds	*sp;	/* shared memory header ptr */
	register struct region		*rp;	/* shared memory region ptr */
	int				s;	/* ipcget status */

	suspend_lock(&shm_lock);
	sp = ipcget(uap->key, uap->shmflg, shmem, shminfo.shmmni,
		 sizeof(*shmem), &s);
	if (sp == NULL) {
		suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
		printf("shmget:  ipcget failed\n");
#endif
		return;
	}
	if (s) {

		/*
		 * This is a new shared memory segment.
		 * Allocate a region and init shmem table
		 */
		if (uap->size < shminfo.shmmin || uap->size > shminfo.shmmax) {
			u.u_error = EINVAL;
			sp->shm_perm.mode = 0;
			suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
			printf("shmget: seg size %d out of range (%d to %d)\n",
			  uap->size, shminfo.shmmin, shminfo.shmmax);
#endif
			return;
		}
		if ((rp = allocreg((inode_t *)NULL, RT_SHMEM)) == NULL) {
			sp->shm_perm.mode = 0;
			suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
			printf("shmget: can't allocate region\n");
#endif
			return;
		}
		/* grow on first attach */
		sp->shm_perm.mode |= SHM_INIT;
		sp->shm_segsz = uap->size;
		sp->shm_reg = rp;
		sp->shm_ro_reg = NULL;
		sp->shm_atime = sp->shm_dtime = 0;
		sp->shm_ctime = time;
		sp->shm_lpid = 0;
		sp->shm_cpid = u.u_procp->p_pid;
		rp->r_flags |= RG_NOFREE;
		regrele(rp);
	} else {
		/*
		 * Found an existing segment.  Check size
		 */
		if (uap->size && uap->size > sp->shm_segsz) {
			u.u_error = EINVAL;
			suspend_unlock(&shm_lock);
#ifdef SHMEM_DEBUG
			printf("shmget: size %d greater than seg size %d\n",
			  uap->size, sp->shm_segsz);
#endif
			return;
		}
	}

	u.u_rval1 = sp->shm_perm.seq * shminfo.shmmni + (sp - shmem);
	suspend_unlock(&shm_lock);
#ifdef SECON
	sat_ipccreat( s );
#endif 
}

shminit()
{
	register suspend_lock_t	*slp;
	register int		n;
	register unsigned	pri;

	pri = PZERO - 1;
	for (n = shminfo.shmmni, slp = shmlk; --n >= 0; slp++) {
		slp->s_priority = pri;
	}
}


/*
 * System entry point for shmat, shmctl, shmdt, and shmget system calls.
 */

int	(*shmcalls[])() = {shmat, shmctl, shmdt, shmget};

shmsys()
{
	register struct a {
		uint	id;
	}	*uap = (struct a *)u.u_ap;
	int		shmat(),
			shmctl(),
			shmdt(),
			shmget();

	if (uap->id > 3) {
		u.u_error = EINVAL;
		return;
	}
	u.u_ap = &u.u_arg[1];
	(*shmcalls[uap->id])();
}

/*
 * find the virtual start and end addresses of the given pregion
 *	(even for PT_STACK, vstart <= vend)
 */

preg_limits(prp, vstartp, vendp)
register preg_t	*prp;
uint		*vstartp, *vendp;
{
	switch (prp->p_type) {
	case PT_STACK:
		*vstartp = (*vendp = (uint)prp->p_regva) -
		  ctob(prp->p_reg->r_pgsz) + 4;
		break;
	case PT_TEXT:
	case PT_DATA:
	case PT_SHMEM:
	case PT_LIBTXT:
	case PT_LIBDAT:
		*vendp = (*vstartp = (uint)prp->p_regva) +
		  ctob(prp->p_reg->r_pgsz) - 1;
		break;
	case PT_DMM:
		cmn_err(CE_PANIC,
		  "preg_limits: pregion type PT_DMM not supported, prp=0x%x\n",
		  prp);
		break;
	default:
		cmn_err(CE_PANIC,
		  "preg_limits: unknown pregion type = 0x%x, prp=0x%x\n",
		  prp->p_type, prp);
		break;
	}
}

/*
 * Select attach address based on segment size -- returns 0 if no room
 */

uint
shmaddr(size)
register uint	size;
{
	register preg_t	*prp;
	register uint	addr, end;
	uint		vstart, vend;

	--size;			/* anticipate:  end = addr + size - 1 */
	addr = NBPS;
	end = addr + size;
	for (prp = u.u_procp->p_region; prp->p_reg; prp++) {
		preg_limits(prp, &vstart, &vend);

		if (prp->p_type == PT_DATA)
			vend += ctob(shminfo.shmbrk);

		if (addr < vstart && end < vstart)
			break;				/* found it */

		addr = (vend + NBPS) & ~SOFFMASK;
		end = addr + size;
	}

	if (is_kern_addr(addr))
		addr = 0;				/* bad addr / no room */

	return (addr);
}

shmseg()
{
	return(shminfo.shmseg);
}

/*
 * Make a read-only region from a read-write region of shared memory
 *
 * We don't have read/write protection bits at the segment level, so read-only
 * shm attaches need duplicate pde's with the write bit unset.
 * returns a locked region.
 *
 * code stolen from dupreg
 */

reg_t *
shm_ro_reg(rp, resvflag)
register reg_t	*rp;
int		resvflag;
{
	register pde_t	*ppte;
	register pde_t	*cpte;
	register reg_t	*rp2;
	register int	i;
	register int	j;
	register int	rsize, ssize, size;
	pfd_t		*pfd;
	dbd_t		map;
	extern pde_t	*ptalloc();

	ASSERT(reg_mylock(rp));

	/*	Make sure we have enough space to duplicate
	**	this region without potential deadlock.
	*/

/*
 * JPC:
 *	Since the duped region will have r_pgsz and r_noswapcnt set, decrement
 *	both availmem counters to anticipate freereg.  Unfortunately, this
 *	sets rmem less than the actual value and may force unneeded swapping
 *	or falsely reject some rmem requests.  Reserve extra physical pages if
 *	the rw region wasn't just initialized and if it was not previously
 *	SHM_LOCKed (if it was, growreg or shmctl took care of the rw's pages)
 */
	ssize = rp->r_pgsz;
	rsize = (resvflag ? 2*ssize : ssize);
	atom_sub(&availrmem, rsize);
	if (availrmem < tune.t_minarmem) {
		atom_add(&availrmem, rsize);
		nomemmsg("shm_ro_reg", rsize, 0, 0);
		u.u_error = EAGAIN;
		return(NULL);
	}
	atom_sub(&availsmem, ssize);
	if (availsmem < tune.t_minasmem) {
		atom_add(&availrmem, rsize);
		atom_add(&availsmem, ssize);
		nomemmsg("shm_ro_reg", ssize, 0, 0);
		u.u_error = EAGAIN;
		return(NULL);
	}

	/*
	 * Need to copy the region.
	 * Allocate a region descriptor
	 */

	rp2 = allocreg(rp->r_iptr, rp->r_type);
	if (rp2 == NULL) {
		atom_add(&availrmem, rsize);
		atom_add(&availsmem, ssize);
		u.u_error = EAGAIN;
		return(NULL);
	}

	/*	Allocate a list for the new region.
	 */

	rp2->r_listsz = rp->r_listsz;
	rp2->r_list = (pde_t **)ptalloc(rp2->r_listsz, 0, rp,0);
	rp2->r_lock = rp->r_lock;	/* lock moved from r_flags to r_lock */
#ifdef REG_DEBUG
	regcheckpoint(rp2);
#endif
	if (rp2->r_list == NULL) {
		rp2->r_listsz = 0;
		freereg(rp2);
		atom_add(&availrmem, rsize);
		atom_add(&availsmem, ssize);
		u.u_error = EAGAIN;
		return(NULL);
	}


	/*
	 * Copy pertinent data to new region
	 */

	rp2->r_pgsz = rp->r_pgsz;
	rp2->r_gapsz = rp->r_gapsz;
	rp2->r_filesz = rp->r_filesz;
	rp2->r_nvalid = rp->r_nvalid;
	rp2->r_flags = rp->r_flags;
	rp2->r_noswapcnt = 1;

	/* Scan the parents page table list and fix up each page table.
	 * Allocate a page table and map table for the child and
	 * copy it from the parent.
	 */

	for (i = 0;  i < ctos(rp->r_pgsz);  i++) {
		/* Allocate a page descriptor (table) and 
		 * map table for the child.
		 */

		/* allocate the 2 paired page tables: pde + dbd */
		if ((cpte = ptalloc(2, 0, rp,0)) == 0) {
			rp2->r_pgsz = stoc(i);
			freereg(rp2);
			u.u_error = EAGAIN;
			return(NULL);
		}

		/* Set pointer to the newly allocated page descriptor (table)
		 * and dbd into the child's list.  Then get a
		 * pointer to the parents page descriptor (table) and dbd.
		 */

		rp2->r_list[i] = cpte;
		ppte = rp->r_list[i];

		/* Get the total number of unmapped pages remaining.
		 * This is the total size of the region minus the
		 * number of segments for which we have allocated
		 * page tables already.
		 */

		size = rp->r_pgsz - stoc(i);

		/* If this size is greater than a segment, then
		 * we will only process a segment.
		 */

		if (size > NPGPT)
			size = NPGPT;

		/* Check each parents page and then copy it to
		 * the childs pte.  Also check the map table
		 * entries.
		 */

		for (j = 0;  j < size;  j++, ppte++, cpte++) {
			/* Copy parents page to child w/o the write bit  */
			pg_setall(cpte, pg_all(ppte) & ~PG_W);

			/*	If the page is in core, then
			 *	increment the page use count.
			 */

			if (pg_isvalid(ppte)) {
				pfd = pde_to_pfdat(*ppte);
				memlock();
				ASSERT(pfd->pf_use > 0); 
				pfd->pf_use++;
				memunlock();
			}

			/* Increment the swap use count for pages which
			 * are on swap.
			 */

			map = *(dbd_t *)(ppte + NPGPT);
			if (map.dbd_type == DBD_SWAP) {
				ASSERT(swpuse(&map) != 0);
				if (!swpinc(&map, "shm_ro_reg")) {

					/* The swap use count overflowed.
					 * Free the region and return
					 * an error.
					 */

					((dbd_t *)(cpte + NPGPT))->dbd_type =
						DBD_NONE;
					freereg(rp2);
					u.u_error = EAGAIN;
					return(NULL);
				}
			}
			*(dbd_t *)(cpte + NPGPT) = map;
		}
	}

	return(rp2);
}


/*
 *	Copy shared memory page table entries from original
 *	A1000 region to the newly attached A1000 region.
 *
 *	No need for any checking, because child region has grown
 *	to proper size allready.
 */

A1000_shmfixptbl(rp, pregva, crp, cprp, rwflag)
register reg_t	*rp, *crp;
reg_t		*pregva;
preg_t		*cprp;
{
	register pde_t	*ppte, *cpte;
	register int	i, j, pind, pind1, size;
	pfd_t		*pfd;

	reglock(rp);
	pind = pgndx((uint)pregva);
	pind1 = pgndx((uint)cprp->p_regva);
	for (i = 0; i < ctos(cprp->p_pgsz); i++) {
		if (i) {
			pind = 0;
			pind1 = 0;
		}
		ppte = rp->r_list[i] + pind;
		cpte = crp->r_list[i] + pind1;
		size = cprp->p_pgsz - stoc(i);
		if (size > NPGPT)
			size = NPGPT;
		for (j = 0; j < size; j++, ppte++, cpte++) {
			pg_setall(cpte, (rwflag == SEG_RO) ?
				  pg_all(ppte) & ~PG_W : pg_all(ppte));
			if (pg_isvalid(ppte)) {
				pfd = pde_to_pfdat(*ppte);
				memlock();
				ASSERT(pfd->pf_use > 0);
				pfd->pf_use++;
				memunlock();
			}
			*(dbd_t *)(cpte + NPGPT) = *(dbd_t *)(ppte + NPGPT);
		}
	}
	regrele(rp);
}

/*
 *	Create A1000 shared memory region.
 *	We need a standalone region so that any process that wants can
 *	attach to it. The region stays allocated until the shared memory
 *	is explicitly removed.
 *
 *	This is somewhat specialised version of dupreg (yet another).
 */

A1000_dupshmreg(rp, sp, prp)
register reg_t *rp;
struct shmid_ds *sp;
register struct pregion	*prp;
{
	register reg_t *rp2;
	register pde_t *ppte, *cpte;
	register int i, j, pind, size;
	pfd_t *pfd;

	ASSERT(reg_mylock(rp));

	rp2 = allocreg((inode_t *)NULL, RT_PRIVATE);
	if (rp2 == NULL) {
		u.u_error = EAGAIN;
		return(-1);
	}

	rp2->r_listsz = ctos(rp->r_pgsz);
	rp2->r_list = (pde_t **)ptalloc(rp2->r_listsz, 0, rp,0);
	rp2->r_lock = rp->r_lock;

	if (rp2->r_list == NULL) {
		rp2->r_listsz = 0;
		freereg(rp2);
		u.u_error = EAGAIN;
		return(-1);
	}

	rp2->r_pgsz = rp->r_pgsz;
	rp2->r_gapsz = rp->r_gapsz;
	rp2->r_filesz = 0;
	rp2->r_nvalid = rp->r_nvalid;
	rp2->r_flags = rp->r_flags | RG_NOFREE;
	rp2->r_noswapcnt = 1;

	pind = pgndx((uint)prp->p_regva);
	for (i = 0; i < ctos(rp->r_pgsz); i++) {
		if (i)
			pind = 0;
		/* allocate the 2 paired page tables: pde + dbd */
		if ((rp2->r_list[i] = ptalloc(2, 0, rp,0)) == 0) {
			rp2->r_pgsz = stoc(i);
			freereg(rp2);
			u.u_error = EAGAIN;
			return(-1);
		}
		ppte = rp->r_list[i] + pind;
		cpte = rp2->r_list[i] + pind;
		size = rp->r_pgsz - stoc(i);
		if (size > NPGPT)
			size = NPGPT;
		for (j = 0; j < size; j++, ppte++, cpte++) {
			*cpte = *ppte;
			if (pg_isvalid(ppte)) {
				pfd = pde_to_pfdat(*ppte);
				memlock();
				ASSERT(pfd->pf_use > 0);
				pfd->pf_use++;
				memunlock();
			}
			*(dbd_t *)(cpte + NPGPT) = *(dbd_t *)(ppte + NPGPT);
		}
	}

	sp->shm_reg = rp2;
	sp->shm_ro_reg = (reg_t *)prp->p_regva;
	regrele(rp2);
	return(0);
}
