/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) machdep.c: version 25.1 created on 11/27/91 at 15:07:54	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)machdep.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* machdep.c */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/immu.h"
#include "sys/buf.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/pfdat.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/state.h"
#include "sys/psl.h"
#include "sys/clock.h"
#include "sys/ipc.h"
#include "sys/var.h"
#include "sys/shm.h"
#include "sys/lio.h"
#include "sys/kmem.h"
#include "sys/debug.h"
#include "sys/sbus.h"
#include "sys/spm_mem.h"


unsigned char stkfmtsz[16] = {		/* (# bytes-8) on stack frame */
	0, 0, 4, 0, 0, 0, 0, 0,		/* for the exceptions */
	0, 12, 24, 84, 0, 0, 0, 0};	/* index is the format code */

/*
 * Stop the clock.
 */

clkreld()  
{
	own.o_clock = 0;
}


/*
 * Send an interrupt to process
 */
sendsig(hdlr)
{
	register *usp;
	register char *temp_usp;
	register state_t *stp = u.u_astk;


	ASSERT(stp->s_format != COP_MIDINSTR);
	usp = (int *) stp->s_sp;
	grow((unsigned)(usp-6));
	/* simulate an interrupt on the user's stack */
	suword((int *)--usp, stp->s_pc);
	temp_usp = (char *)usp;
	subyte((char *)--temp_usp, lobyte(stp->s_ps));
	subyte((char *)--temp_usp, hibyte(stp->s_ps));
	stp->s_ps &= ~PS_T;
	stp->s_sp = (ulong) temp_usp;
	stp->s_pc = hdlr;
	if (stkfmtsz[stp->s_format])
		stp->s_crunch = 1;	/* force trap.s to crunch stack */
}


/*
 * Clear registers on exec
 */

setregs()
{
	register int	i;
	register proc_t *p;
	void (* *rp)();
	register state_t *stp = u.u_astk;

	p = u.u_procp;
	p->p_chold = 0;	/* clear p_chold */

	/* Any pending signal remain held, so don't clear p_hold and
	p_sig */	

	/* If the action was to catch the signal, then the action
	must be reset to SIG_DFL */

	for (rp = &u.u_signal[0]; rp < &u.u_signal[NSIG]; rp++)
		if (*rp != SIG_IGN)
			*rp = SIG_DFL;


	/*
	 * check if the execed file is not posix binary.  If so,
	 * set signal handler for jobcontrol signals as SIG_IGN.
	 * set CHILDNOSTOP flag in p_posix_flags so that in case of
	 * system V binary parent needn't be sent SIGCHLD signal
	 * if the child stops.  This is done to support system V
	 * binary in posix kernel.
	 */
	if(!(p->p_posix_flags & F_POSIX_BINARY))  {
		p->p_posix_flags |= SA_NOCLDSTOP;
	}

	stp->s_pc = u.u_exdata.ux_entloc;

	stp->s_ps = 0;
	stp->s_d7 = stp->s_d6 = stp->s_d5 = stp->s_d4 = 0;
	stp->s_d3 = stp->s_d2 = stp->s_d1 = stp->s_d0 = 0;

	stp->s_a6 = stp->s_a5 = stp->s_a4 = 0;
	stp->s_a3 = stp->s_a2 = stp->s_a1 = stp->s_a0 = 0;

	for (i=0; i < u.u_nofiles; i++)
		if (GET_OFILE(i) && (GET_OFLAG(i) & EXCLOSE)) {
			closef(GET_OFILE(i));
			SET_OFILE(i, NULL);
		}
}

/*
 * The number of bits to clip off of the bottom of an sbus address
 * to convert it into an sbus_u32
 */
#define SBUS_U32_LOSS	(SBUS_SLOT_BITS + SBUS_OFFSET_BITS - 32)

static uint
spfn_to_lpfn(spfn)
register uint	spfn;
{
	register uint	sbus_slot;

	sbus_slot = spfn >> SpfnToSlotShft;
	return(spfn - spm_mem.pfn_adjust[sbus_slot]);
}

static uint
kpfn_to_spfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum((uint) ADDR_SYS_SEGS));
	ASSERT(pfn < pnum((uint) ADDR_SYS_SEGS) + maxmem);
	return(pg_valpfn(&kptbl[pfn - pnum(ADDR_SYS_SEGS)]));
}

static uint
pfn_to_spfn(pfn)
register uint	pfn;
{
	ASSERT(pfn >= pnum(MAINSTORE));
	ASSERT(pfn < maxclick);
	return(pg_valpfn(&spm_mem.mem_ptbl[pfn - pnum(MAINSTORE)]));
}

static uint
lpfn_to_pfn(lpfn)
uint	lpfn;
{
	return(spm_mem.lpfn_tbl[lpfn]);
}

static uint
spfn_to_pfn(spfn)
register uint	spfn;
{
	return(lpfn_to_pfn(spfn_to_lpfn(spfn)));
}

uint
rde_to_km(rde)
rde_t	rde;
{
	/* WARNING: This code assumes that rfn and pfn are the same thing */
	return(spfn_to_pfn(rde.rdm.rde_rfn) << PNUMSHFT);
}

uint
sde_to_km(sde)
sde_t	sde;
{
	uint	ssfn;
	uint	vsfn;

	ssfn = sde.sgm.sg_sfn;

	vsfn = spfn_to_pfn(ssfn >> NPTPPSHFT) << NPTPPSHFT;
	vsfn += ssfn & ((1 << NPTPPSHFT) - 1);
	return(vsfn << BPTSHFT);
}

sde_t
km_to_sde(sv)
uint	sv;
{
	sde_t	retval;
	register uint	vsfn, pfn, ssfn;

	vsfn = sv >> BPTSHFT;
	pfn = vsfn >> NPTPPSHFT;
	vsfn &= (1 << NPTPPSHFT) - 1;
	ssfn = (pfn_to_spfn(pfn) << NPTPPSHFT) + vsfn;

	retval.sg_sge = 0;
	retval.sgm.sg_sfn = ssfn;
	return(retval);
}

uint
pde_to_pfn(pde)
pde_t	pde;
{
	ASSERT(spm_mem.sbus_slot_id[pg_all(&pde) >> (SpfnToSlotShft + SpfnSlotToU32Shft)] == SBUS_MM);
	return(spfn_to_pfn(pg_valpfn(&pde)));
}

pfd_t *
pde_to_pfdat(pde)
pde_t	pde;
{
	ASSERT(pfdat);
	return (&pfdat[pde_to_pfn(pde) - pnum(kpbase)]);
}

uint
pde_to_km(pde)
pde_t	pde;
{
	return(pde_to_pfn(pde) << PNUMSHFT);
}

static uint
pfdat_to_spfn(pfd)
struct	pfdat	*pfd;
{
	ASSERT(pfdat);
	return(pfn_to_spfn(pfd - pfdat + pnum(kpbase)));
}

struct pfdat *
kvtopfdat(kv)
char	*kv;
{
	ASSERT(pfdat);
	return(&pfdat[pnum(kv - kpbase)]);
}

struct	pfdat *
pfn_to_pfdat(pfn)
uint	pfn;
{
	ASSERT(pfdat);
	return(&pfdat[(pfn) - pnum(kpbase)]);
}

uint
pfdattopfn(pfd)
struct pfdat	*pfd;
{
	ASSERT(pfdat);
	return((pfd) - pfdat + pnum(kpbase));
}

char *
pfntokv(pfn)
uint	pfn;
{
	return((char *) ((pfn) << PNUMSHFT));
}

uint
svtopfn(sv)
uint	sv;
{
	return(sv >> PNUMSHFT);
}

pg_setaddr(pdp, pfn)
pde_t	*pdp;
uint	pfn;
{
	atom_and_or(pdp, ~PG_ADDR, pfn_to_spfn(pfn) << SpfnSlotToU32Shft);
}

uint
mkpde(mode, pfn)
uint	mode;
uint	pfn;
{
	pde_t	retval;
	
	retval.pgi.pg_pde = mode;
	retval.pgm.pg_pfn = pfn_to_spfn(pfn);
	return(retval.pgi.pg_pde);
}

sbus_t
kv_to_sbus(kv)
uint	kv;
{
	register uint	spfn;
	sbus_t		retval;
	uint		pfn;

	pfn = pnum(kv);

	/* get offset in page bits */
	kv &= ((1 << PNUMSHFT) - 1);

	spfn = kpfn_to_spfn(pfn);
	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | kv;

	return(retval);
}

uint
kv_to_sbus_u32(kv)
uint	kv;
{
	register uint	spfn, retval;


	spfn = kpfn_to_spfn(pnum(kv));

	kv &= ((1 << PNUMSHFT) - 1);

	/* get slot */
	retval = (spfn & SpfnSlotMask) << SpfnSlotToU32Shft;

	spfn &= ((1 << SpfnToSlotShft) - 1);
	/* get offset */
	retval |= ((spfn << PNUMSHFT) | kv) >> SBUS_U32_LOSS;

	return(retval);
}

#define	u32_to_spfn(x)	((x) >> (PNUMSHFT - SBUS_U32_LOSS))
#define	u32_to_poff(x)	(poff((x) << SBUS_U32_LOSS))

uint
u32_to_kv(u32)
register uint	u32;
{
	return((spfn_to_pfn(u32_to_spfn(u32)) << PNUMSHFT) | u32_to_poff(u32));
}

uint
u32_to_pfn(u32)
register uint	u32;
{
	return(spfn_to_pfn(u32_to_spfn(u32)));
}

sbus_t
km_to_sbus(sv)
uint	sv;
{
	sbus_t	retval;
	uint	pfn, spfn;

	pfn = pnum(sv);

	sv &= ((1 << PNUMSHFT) - 1);

	spfn = pfn_to_spfn(pfn);
	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | sv;

	return(retval);
}

uint
km_to_sbus_u32(sv)
uint	sv;
{
	register uint	spfn, retval;

	spfn = pfn_to_spfn(pnum(sv));

	sv &= ((1 << PNUMSHFT) - 1);

	/* get slot */
	retval = (spfn & SpfnSlotMask) << SpfnSlotToU32Shft;

	spfn &= ((1 << SpfnToSlotShft) - 1);

	/* get offset */
	retval |= (((spfn << PNUMSHFT) | sv) >> SBUS_U32_LOSS);

	return(retval);
}

/* kernel u page to sbus 32 converter -- uv must be within u page */
uint
ku_to_sbus_u32(uv)
uint	uv;
{
	ASSERT(uv >= ADDR_U && uv < (ADDR_U + ctob(USIZE)));
	return ((pg_all(u.u_procp->p_ubptbl) & ~0xff) +
	  ((uv - ADDR_U) >> SBUS_U32_LOSS));
}

rde_t
km_to_rde(vaddr)
uint	vaddr;
{
	uint	vpfn;
	uint	spfn;
	rde_t	retval;

	vpfn = vaddr >> PNUMSHFT;
	spfn = pfn_to_spfn(vpfn);

	retval.rde_all = (spfn << 8);
	return(retval);
}

/* 
 * find the page descriptor entry that causes the bus fault.
 * NULL will be returned if virtual address not defined in the regions.
 * address of the page descriptor entry associated with the faulted
 * virtual address will be returned if found in the active regions.
 */

pde_t *
findpde(vaddr)
register ulong vaddr;		/* bus fault virtual address */
{
	register sde_t	*sde_ptr;
	register pde_t	*pde_ptr;
	sde_t		ppt;

	ASSERT(UMEM_START == KUMEM_START);
	ASSERT(UMEM_SIZE == KUMEM_SIZE);
	ASSERT(UMEM_START == 0);

	if (vaddr >= UMEM_START + (ulong) UMEM_SIZE)
		return(NULL);

	sde_ptr= (sde_t *) rde_to_km(u.u_procp->p_urde);
	ppt = sde_ptr[SNUM(vaddr)];

	if (ppt.sg_sge == spm_mem.invalid_sde.sg_sge)
		return(NULL);

	pde_ptr = (pde_t *) sde_to_km(ppt);
	return(&pde_ptr[pnum(soff(vaddr))]);
}

static pde_t
v_to_pde(vaddr, p)
register uint	vaddr;
proc_t		*p;
{
	extern sde_t	own_stbl[];

	register sde_t	*sde_ptr;
	register pde_t	*pde_ptr;
	sde_t		ppt;


	if (p) {
		ASSERT(vaddr < (UMEM_START + (ulong) UMEM_SIZE));
		sde_ptr= (sde_t *) rde_to_km(p->p_urde);
		ppt = sde_ptr[SNUM(vaddr)];
	}
	else {
		ASSERT(vaddr >= KMEM_START);
		ppt = own_stbl[SNUM(vaddr - KMEM_START)];
	}


	ASSERT(ppt.sg_sge != spm_mem.invalid_sde.sg_sge);

	pde_ptr = (pde_t *) sde_to_km(ppt);
	return(pde_ptr[pnum(soff(vaddr))]);
}

/*
 * vmap
 *
 *	return a virtual address through which p's vaddr
 *	can be accessed.
 *
 *	a NULL p indicates the kernel.
 *
 *	the map is valid up to the next page boundary.
 *
 *	this map is NOT VALID across a context switch
 *
 */

caddr_t
vmap(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	/* keep the same attributes that apply to the actual pde */
	own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)] = v_to_pde(vaddr, p);
	flush_sys_tlb_entry(ADDR_OWN_VMAP);
/***	*OWN_VMAP_FLUSH = 0;	***/

	return((caddr_t)(ADDR_OWN_VMAP + poff(vaddr)));
}

uint
vmap_save()
{
	return(own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)].pgi.pg_pde);
}

void
vmap_restore(prev_map)
uint	prev_map;
{
	own_ptbl[pnum(ADDR_OWN_VMAP - ADDR_OWN_SEGS)].pgi.pg_pde = prev_map;
	flush_sys_tlb_entry(ADDR_OWN_VMAP);
/***	*OWN_VMAP_FLUSH = 0;	***/
}


uint
v_to_spfn(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	pde_t	pde;

	pde = v_to_pde(vaddr, p);
	ASSERT(pde.pgm.pg_pres);

	return(pde.pgm.pg_pfn);
}

sbus_t
v_to_sbus(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	register uint	spfn;
	sbus_t		retval;
	pde_t		pde;

	pde = v_to_pde(vaddr, p);
	ASSERT(pde.pgm.pg_pres);

	spfn = pde.pgm.pg_pfn;
	vaddr &= ((1 << PNUMSHFT) - 1);

	retval.sbus_slot = spfn >> SpfnToSlotShft;
	spfn &= ((1 << SpfnToSlotShft) - 1);
	retval.sbus_offset = (spfn << PNUMSHFT) | vaddr;

	return(retval);
}


/*
 * v_to_sbus_u32
 *
 *
 *	return an sbus_u32 corresponding to p's vaddr.
 *
 *	a NULL p indicates the kernel.
 *
 *	the value returned is valid up to the next page boundary,
 *	and is valid across context switches, as long as the page
 *	has been locked in memory ( userdma() via physio() )
 *
 *	an sbus_u32 can only describe a 16 byte boundary.
 *	if vaddr is not on a 16 byte boundary the returned
 *	sbus_u32 will round it down to the nearest 16 byte
 *	boundary.
 *
 */

uint
v_to_sbus_u32(vaddr, p)
uint	vaddr;
proc_t	*p;
{
	return((v_to_spfn(vaddr, p) << SpfnSlotToU32Shft) |
	  poff(vaddr) >> SBUS_U32_LOSS);
}


/*
 * backtrace -- print a stack backtrace
 */

#define OP_ADDA_A7	0xdefc		/* 68020 opcode for adda.w #xx, a7 */
#define OP_ADDQ_A7	0x504f		/* 68020 opcode for addq.l #xx, a7 */
#define ADDQ_MASK	0x0e00		/* mask to remove data from addq */
#define ADDQ_SHIFT	9		/* shift to extract data from addq */

/* U_FITS is true if the u-page address is in the system stack or own stack */
#define U_FITS(ua)	((ua) >= (uint *)ADDR_EXTRA_STK && (ua) < sys_stk_end \
			 || \
			 (ua) >= (uint *)ADDR_OWN_EXTRA && (ua) < own_stk_end)
/* IS_KERN is true if pc is within the kernel text */
#define IS_KERN(pc)	((pc) >= ADDR_KERNEL && (pc) <= (uint)etext)

backtrace(arg)
uint	arg;
{
	register uint	n, retpc;
	register int	args;
	register uint	*fp, *lastfp;
	register ushort	*addr;
	ushort		opcode;
	extern	uint	sys_stk_end[], own_stk_end[], etext[];

	fp = &arg - 2;	/* stack frame is fp, pc, arg, .... */
	printf("Stack Backtrace:\n");
	if (U_FITS(fp)) {
		retpc = fp[1];
		fp = (uint *) *fp;
	}
	lastfp = 0;

	while (U_FITS(fp) && IS_KERN(retpc) && fp > lastfp) {
		addr = (ushort *) fp[1];
		symstr(retpc);			/* print return pc */
		retpc = (uint) addr;

		/*
		 * Find the number arguments by looking at the opcode
		 * pointed at by the return pc and checking how much is added
		 * to the stack.  Divide by 4 to get the number of arguments.
		 */
		if (probe_short(addr, &opcode))
			n = opcode;
		else
			n = 0;
		if ((n & ~ADDQ_MASK) == OP_ADDQ_A7) {
			switch (n = (n & ADDQ_MASK) >> ADDQ_SHIFT) {
			case 0:		/* addq 8 */
				args = 2;
				break;
			case 4:		/* addq 4 */
				args = 1;
				break;
			default:
				printf("[addq %d]", n);
				args = 0;
			}
		}
		else if (n == OP_ADDA_A7)
			args = ((short *)addr)[1] / 4;
		else {
#ifdef BACKTRACE_DEBUG
			printf("[%x=%x] ", addr, n);
#endif
			args = 0;		/* 0 args */
		}

		if (args > 0) {
			printf(" (");
			if (args > 8) {
				printf("{%d} ", args);
				args = 8;
			}
			for (n = 2; --args >= 0; n++) {
				symstr(fp[n]);
				printf("%s", (args ? ", " : ")\n"));
			}
		}
		else
			printf("\n");

		/* advance along linked list of frame pointers */
		lastfp = fp;
		fp = (uint *)*fp;
	}
	symstr(retpc);				/* final return pc */
	printf("\n");
}

/*
 *	check for incoherent tag values
 *		return the number of bad links
 *
 * 8-9-88 CS: removed banner, don't complain about mismatched btags,
 *		don't count messages that weren't printed, btag sanity
 */
	/*  how many pair-displays can we stand before summarizing  */
#define MAXMSG 8

#define NLIC	4096

#define PRINT_ORPHANS 0

uint
cache_tag_check(fixit)
char	fixit;
{
	register uint	btag_d, *btag_p, or_term = (uint)BTAG_START,
		ctag_d, *ctag_p = CTAG_START, lup;
	uint	invalid_btags = 0, mis_matches = 0, orphan_btags,
		valid_ctags = 0, wrong_bits;
	uint	msg1 = 0;	/*  how many messages printed this call  */

	/*  for each ctag entry  */
	for( lup = NLIC; lup != 0; lup-- )
	{
		ctag_d = *ctag_p;

		/*  if ctag is valid  */
		if( (ctag_d & CTAG_VBIT) == 0 )
		{
			valid_ctags++;

			/*  find the btag it refers to  */
			btag_p = (uint *)
				( or_term | ((ctag_d & 0x00000f00) << 4));
			btag_d = *btag_p;

			/*  is it valid?  */
			if( !(btag_d & BTAG_VBIT) )
			{
				/*---NO!---*/
				if( fixit )
					*ctag_p = CTAG_CLEAR;
				else
				{
					if( msg1++ < MAXMSG )
					{
					  printf("%s%x)=%x%s%x)=%x%s",
						"ctag(", (uint)ctag_p & 0xffff,
						ctag_d >> 8,
						"v but btag(",
						(uint)btag_p & 0xffff,
						btag_d >> 4, " INVALID\n");
					  invalid_btags++;
					}
				}
			}
			else {
			/*  does it match the ctag?  */
				if( wrong_bits =
					(ctag_d & 0xffffff00) ^
					(btag_d & 0xffffff00) )
				{
					mis_matches++;
					if( fixit )
					{
						*ctag_p = CTAG_CLEAR;
						*btag_p = BTAG_CLEAR;
					}
					else
					{
						if( msg1++ < MAXMSG )
							printf(
					   "%s%x)=%x%s%x)=%x%s%x%s",
							"ctag(",
							(uint)ctag_p & 0xffff,
							ctag_d >> 8,
							"v but btag(",
							(uint)btag_p & 0xffff,
							btag_d >> 4,
							"v (bits ", wrong_bits,
							" mismatch)\n");
					}
				}
				/*  is the btag sane? p15-12 match the offset */
				if(  (btag_d & 0x00000f00)
					!= (((uint)btag_p & 0x0000f000) >> 4)  )
				{
					if( fixit )
						*ctag_p = CTAG_CLEAR;
					else
						if( msg1++ < MAXMSG )
						printf(
						  "incorrect btag(%x)=%x\n",
						  (uint)btag_p & 0xffff,
						  btag_d & 0xfffffff8);
				}
			}
		}

		ctag_p += 4;
		or_term = (or_term + 16) & 0xffff0fff;
	}

	/*
	 *  now look for btags without matching ctag
	 */
	btag_p = BTAG_START;
	or_term = (uint)CTAG_START;
	orphan_btags = 0;
	for( lup = NLIC; lup != 0; lup-- )
	{
		btag_d = *btag_p;

		/*  for each valid btag entry  */
		if( btag_d & BTAG_VBIT )
		{
			/*  find the ctag it refers to ("links" to)  */
			ctag_p = (uint *)
				( or_term | ((btag_d & 0x000000f0) << 8));
			ctag_d = *ctag_p;
			if( ctag_d &  /* active low */ CTAG_VBIT )
			{
				orphan_btags++;
				if( fixit )
					/*  nothing wrong with orphans!  */;
				else
				{
					if( (msg1 < MAXMSG) && PRINT_ORPHANS)
					{
						msg1++;
						printf(
						"%s%x)=%x%s%x)=%x%s",
						"orphan btag(",
						(uint)btag_p & 0xffff,
						btag_d >> 4,
						"v but ctag(",
						(uint)ctag_p & 0xffff,
						ctag_d >> 8,
						" INVALID\n");
					}
				}
			}

			/*  if the ctag doesn't point back at the btag */
			if( (!(ctag_d & CTAG_VBIT )) &&
				 (wrong_bits = (btag_d & 0xfffff000) ^
					  (ctag_d & 0xfffff000)) )
			{
				if( fixit )
				{
					*ctag_p = CTAG_CLEAR;
		/*			*btag_p = BTAG_CLEAR;	*/
				}
				else
				{
					if( (msg1 < MAXMSG) && PRINT_ORPHANS)
					{
						msg1++;
						printf(
					"%s%x)=%x%s%x)=%x%s%x\n",
						"btag(",
						(uint)btag_p & 0xffff,
						btag_d >> 4,
						"v but ctag(",
						(uint)ctag_p & 0xffff,
						ctag_d >> 8,
						"v mismatch bits=", wrong_bits);
					}
				}
			}
		}

		btag_p += 4;
		or_term = (or_term + 16) & 0xffff0fff;
	}

	if( msg1 >= MAXMSG && !(fixit))
		printf("... total %d mismatches, %d INVALID btags\n",
			mis_matches, invalid_btags);

	if((orphan_btags) && !(fixit) && ((msg1 >= MAXMSG) || !(PRINT_ORPHANS)))
		printf("%d orphan btag entr%s\n",
			orphan_btags, (orphan_btags > 1) ? "ies":"y");

	printf("Of %d ctags, %d are marked valid.\n", NLIC, valid_ctags);
	
	return( invalid_btags );
}
/*
 *  This routine is called to update the user stack with proper signal handler
 *  from psig() routine.  This routine is called ONLY if that signal is being
 *  manupulated by sigaction().  By the end of this routine user stack will be 
 *  as follows:
 *
 *	#	  usp-> |               |
 *	#		+===============+
 *	#		| returnmask	|
 *	#		+---------------+
 *	#		| trapped PSW	| : GATE
 *	#		+---------------+
 *	#		| trapped PC	|
 *	#		+===============+
 *	#		| user stack	|
 *	#               |               |
 *      #		|		|
 *
 */
pos_sendsig(hdlr,returnmask)
{
	register *usp;
	register char *temp_usp;
	register state_t *stp = u.u_astk;

	usp = (int *) stp->s_sp;
	grow((unsigned)(usp-10));
	/* simulate an interrupt on the user's stack */
	suword((int *)--usp, stp->s_pc);
	temp_usp = (char *)usp;
	subyte((char *)--temp_usp, lobyte(stp->s_ps));
	subyte((char *)--temp_usp, hibyte(stp->s_ps));
	usp = (int *)temp_usp;
	/* put returnmask also on the stack...hmm...more work for posix...*/
	suword((int *)--usp, returnmask);
	temp_usp = (char *)usp;
	stp->s_ps &= ~PS_T;
	stp->s_sp = (ulong) temp_usp;
	stp->s_pc = hdlr;
	if (stkfmtsz[stp->s_format])
		stp->s_crunch = 1;	/* force trap.s to crunch stack */
}

clear_nmi()
{
	/* clear NMI bit, either from freeze or command register */
	while (*STATUS_REG & ST_CMD_PENDG)
		*CLR_NMI = 0;
}

/*
 *  initialize and enable Processor Module's cache
 */
pm_cache_on()
{
	register int	tag_loop;
	register uint	*ctag, *btag;

	/*  mark cpu's and bus' tags invalid  */
	ctag = CTAG_START;
	btag = BTAG_START;
	for (tag_loop = CTAG_MANY; --tag_loop >= 0; ) {
		/* the values are not yet fixed: see lio.h */
		*ctag = CTAG_CLEAR;
		*btag = BTAG_CLEAR;

		btag += 4;	/* each tag reg appears 4 times */
		ctag += 4;	/* so 4096 tags occupy 64KB logical */
	}

	/* reset the spy */
	*CLR_FIFO = 0;

	if ( spm_mem.cache_off ) {
		printf("Data cache disabled\n");
		*CACHE_CTL_REG = CACHE_CTL_OFF;
		return;
	}

	/*  enable cache  */
	*CACHE_CTL_REG = CACHE_CTL_FILL | CACHE_CTL_HIT | CACHE_CTL_SPYIN |
			 CACHE_CTL_SPYOUT | CACHE_CTL_WABON;	/* cache | wab*/
}

board_init()
{
	/* turn on green led for i'm alive indication */
	*GREEN_LED = PM_LED_ON;

	*LED0 = *LED1 = PM_LED_OFF;
	*PERMIT_FLT_ENBL = 0xFF; /* enforce protection and fault */

	/*
	 * just in case the PROMs don't do it, invalidate all the maps
	 */
	bset_long(PM_IO_MAPPER, 0, USEABLE_IOMAPS);
}

/*
 * loadstbl(up, prp, change)
 *
 * Change the content of a process's segment descriptor entries:
 *    	change > 0 -> load segment table using the entries of prp->p_reg->r_list
 *	change = 0 -> load segment table using prp->p_reg->r_list.
 *	change < 0 -> invalidate affected segment table entries. 
 *
 */

loadstbl(up, prp, change)
user_t		*up;
register preg_t	*prp;
register int	change;
{
	register pde_t	**lp;
	register sde_t	*sd;
	register reg_t	*rp;
	register int	i, osize, nsize, isstack;
	extern sde_t	edata[];

	rp = prp->p_reg;
	osize = rp->r_pgsz;
	nsize = osize + change;
	isstack = (prp->p_type == PT_STACK);
	sd = (sde_t *)rde_to_km(up->u_procp->p_urde);
	ASSERT(sd > edata);
	sd += SNUM(prp->p_regva);

	if (change >= 0) {
		i = ctos(nsize);
		lp = rp->r_list;
		while (--i >= 0) {
			*sd = km_to_sde(*lp);
			isstack ? sd-- : sd++;
			lp++;
		}
	} else {
		i = ctos(osize) - ctos(nsize);
		sd += ctos(nsize);
		while (--i >= 0) {
			*sd = spm_mem.invalid_sde;
			isstack ? sd-- : sd++;
		}
	}
	flush_all_own_tlb();  /*Ravi: should this be all user tlbs? */
}

/*
 * do_bus_freeze -- hit the bus freeze line and stop all intelligent boards
 */

do_bus_freeze()
{
	*YANK_FREEZE = 0;
}
