/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) buserr.c: version 25.1 created on 11/27/91 at 15:07:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)buserr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * buserr.c -- deal with different kinds of bus errors
 */

#ident	"@(#)uts/os/M68020:buserr.c	20.1"

/*
 * 001 JPC	4/21/88	Added ST_BERR test to usrxmemflt.  See comments there.
 */
#include "sys/types.h"
#include "sys/psl.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/inode.h"
#include "sys/mount.h"
#include "sys/fstyp.h"
#include "sys/var.h"
#include "sys/buf.h"
#include "sys/utsname.h"
#include "sys/sysinfo.h"
#include "sys/pfdat.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/state.h"
#include "sys/map.h"
#include "sys/swap.h"
#include "sys/getpages.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/conf.h"
#include "sys/lio.h"
#include "sys/spm_mem.h"
#include "sys/own.h"
#ifdef	PERF
#include "sys/schedcpu.h"
#include "sys/schedext.h"
#endif	/* PERF */

extern pde_t *findpde();

/*
 * bus fault handlers
 * the following bus fault cases will be fixed:
 * 
 *	page not present
 * 	write protect    (user violation)
 * 	copy on write	 (data page is shared)
 *	stack growth
 *	wriiten bit simulation
 *	access bit simulation
 */

int userbuserrcnt = 0;

/*
 * k_buserr -- Motorola bus error while in kernel mode
 */

k_buserr(stk_frame)
struct	state stk_frame;		/* stk_frame is value/result */
{
	register int	signo;
	register uint	faultreg;
	register int	caddrsave;
	uint		saved_cpu_dests = own.o_cpu_same;

	faultreg = *(unsigned *)STATUS_REG;
		/* clear faults outs of status register */
	*(char *)CLR_FAULTS = 0;
	signo = 0;
	

	if (own.o_cpu_type == 0 && stk_frame.s_format == 0xB) {
		own.o_cpu_type = 0x10 | stk_frame.s_proc.formatB.fB_cpu_type;
		stk_frame.s_pc = u.u_caddrflt;
		stk_frame.s_crunch = 1;
		return;
	}

	/*
	 * Try to correct the fault.
	 * usrxmemflt will return:
	 *	SIGBUS if hardware or kernel problem
	 *	SIGSEGV if attempting to access an invalid user page
	 *	0 if a page fault that has been fixed
	 */

	caddrsave = u.u_caddrflt;
	u.u_caddrflt = 0;
	signo = usrxmemflt(&stk_frame, faultreg);
	u.u_caddrflt = caddrsave;

	switch (signo) {
	case SIGSEGV:
		if (u.u_caddrflt) {
			stk_frame.s_pc = u.u_caddrflt;
			stk_frame.s_crunch = 1;
			break;
		}
		/* no break */

	default:
	case SIGBUS:
		showbuserr(&stk_frame, faultreg);
		panic("Kernel mode bus error");
		/* NOTREACHED */

	case 0:
		if (stk_frame.s_format == 0xB &&
		  (stk_frame.s_proc.formatB.fB_cpu_type != own.o_cpu_type) ) {
			ASSERT(u.u_procp->p_dests == ~0);
			u.u_procp->p_dests = saved_cpu_dests;
			qswtch();
			u.u_procp->p_dests = ~0;
		}

		/* Force reschedule.  This is needed to deal with the
		 * case where we are called from an interrupt routine
		 * (e.g. addupc from clock interrupt) or some other
		 * kernel routine that doesn't call u_trap_done before
		 * returning to user mode.
		 */
		own.o_runrun = 1;
	}
}

/*
 * u_buserr -- Motorola bus error while in user mode 
 */

u_buserr(stk_frame)
struct	state stk_frame;		/* stk_frame is value/result */
{
	register int	signo;
	register time_t	syst;
	register uint	faultreg;
	uint		saved_cpu_dests = own.o_cpu_same;
	extern uint	user_pm_bits;

	faultreg = *(unsigned *)STATUS_REG;
		/* clear faults out of status register */
	*(char *)CLR_FAULTS = 0;

	atom_and(&user_pm_bits, ~own.o_id_bit);

	syst = u.u_stime;
	u.u_astk = &stk_frame;
	signo = usrxmemflt(&stk_frame, faultreg);
	if (signo) {
		if (!u.u_signal[signo - 1])
			showbuserr(&stk_frame, faultreg);
		fpu_stuck_check();
		psignal(u.u_procp, signo);

		if (ISSIG(u.u_procp, FORREAL)) {
			upkern_lock();
			psig();
		}
	}
	else if (ISSIG(u.u_procp, FORREAL)) {
		/*
		 * If we have a pending signal, we can't process it now or we
		 * will lose information in the extended stack frame, so
		 * arrange to take a trace trap at the end of this instruction.
		 */
		stk_frame.s_ps |= PS_T;
		atom_or(&u.u_procp->p_flag, SBUSTRC);
	}

	if (u.u_prof.pr_scale)
		addupc(stk_frame.s_pc, &u.u_prof,(int)(u.u_stime-syst));

#ifdef	PERF
	USERPRI(u.u_procp); /* modifies p_pri & own.o_curpri */
#else	/* PERF */
	own.o_curpri = u.u_procp->p_pri = calcppri(u.u_procp);
#endif	/* PERF */

	/* check for cpu mask number mismatch */

	if (stk_frame.s_format == 0xB && !stk_frame.s_crunch) {
		u.u_procp->p_dests &= saved_cpu_dests;
		if (! (own.o_id_bit & u.u_procp->p_dests))
			own.o_runrun++;
	}

	u_trap_done();
	/*
	 * reclear the status reg to avoid lingering error bits if switched
	 * during fault handling
	 */
	*(char *)CLR_FAULTS = 0;
}

usrxmemflt(stk_ptr, faultreg)
register struct	state	*stk_ptr;
uint			faultreg;
{
	register ulong	vaddr;		 
	register pde_t	*pde;
	register uint	signo;
	register uint		statusreg;

	statusreg = faultreg ^ ST_ACTIVE_LOW;	/* invert active low stuff */

	/*
	 * buserr if there was any hardware fault
	 */
	if (statusreg &
	  (ST_IMASK & ( ST_TIMEOUT | ST_WRONG_COP | ST_NAK | ST_WALK_ERR | 
	    ST_BAD_DATA)) ) {

		printf("usrxmemflt: unexpected fault: ^statusreg=%x\n",
		  statusreg);
		return(SIGBUS);
	}

	/* On most systems, we would have to look at function codes
	 * or use other methods to determine if a reference is user or
	 * kernel.  In our case, however, User Virtual and Kernel
	 * Virtual do not overlap and the kernel is not demand paged.
	 * This means is most cases, we don't care about function
	 * codes.
	 */

	vaddr = busviol(stk_ptr);

#if 0
if ((statusreg & (ST_EXECUTE | ST_X_PERM)) == ST_EXECUTE) {
	printf("bad stack: stk_ptr->s_pc=%x vaddr=%x ^statusreg=%x proc=%x\n",
	  stk_ptr->s_pc, vaddr, statusreg, u.u_procp);
	return (SIGKILL);	/* FIX THIS JPC, bad page trap */
}
if ((vaddr > 0x1000000 && vaddr < 0x7f000000) || vaddr >= 0x80000000) {
	printf("bad addr: stk_ptr->s_pc=%x vaddr=%x ^statusreg=%x proc=%x\n",
	  stk_ptr->s_pc, vaddr, statusreg, u.u_procp);
	return (SIGKILL);	/* FIX THIS JPC, bad page trap */
}
#endif

	pde = findpde(vaddr);	/* pde is in kernel space */

	if (pde == NULL || pg_isuninit(pde)) {
		if ((vaddr > KMEM_START && kernel_ref(stk_ptr->s_ABssw)) ||
				(u.u_procp == &own.o_proc))
			return(SIGSEGV);		/* kernel problem */
		/*
		 * Check for A1000 stack probing and grow stack
		 */
		if (USERMODE(stk_ptr->s_ps) && syncpc(stk_ptr->s_pc)) {
			if (!grow(vaddr))
				return(SIGSEGV);
		}
		/* If the user SP is below the stack segment,
		 * grow the stack automatically.
		 */
		else if (!grow(stk_ptr->s_sp))
			return(SIGSEGV);
	}
	else if (statusreg & ST_PAGE_FAULT) {
		if (signo = vfault(vaddr, pde))
			return(signo);
	}

	/* No write permission and (a write or read/modify/write) */

	else if (!(statusreg & ST_W_PERM) &&
	  ((stk_ptr->s_ABssw & (SSW_RMW|SSW_READ)) != SSW_READ)) {

		if (signo = pfault(vaddr, pde))
			return(signo);
	}
	else if (!(statusreg & ST_R_PERM) && (stk_ptr->s_ABssw & SSW_READ)) {
		printf("usrxmemflt: no read permission! statusreg=%x, ssw=%x\n",
		  statusreg, stk_ptr->s_ABssw);
		return(SIGSEGV);		/* no read permission */
	}

/*
 * The following test was needed because of an interaction between our TLB
 * hardware, the 68020, and vhand.  Occasionally in some triple page fault
 * situations, the contents of the fault register are lost.  Example:
 *	mov.b	(%a0)+, %d1		# gets a page fault while reading (%a0)
 *	cmp.b	(%a1)+, %d1		# gets a page fault while reading (%a1)
 *	beq.b	loop_top		# faults when prefetched because stolen
 * Hardware page fault order:  1. (%a0), 2. prefetch beq.b, 3. (%a1)
 * 020 fault processing order: 1. (%a0), 2. (%a1), 3. invalid entry in pipeline
 * which would have been beq.b if the text page hadn't been stolen while
 * servicing page fault # 1.
 * The status register was cleared when servicing the (%a1) fault, so there
 * is nothing to say what caused the prefetch fault.
 * Fix: if no bus error in the status register, then try again.
 */
	else if (!(statusreg & ST_BERR)) {
		return (0);			/* prefetch fault, try again */
	}
	else {
		printf("usrxmemflt: misc. fault! statusreg=%x, ssw=%x\n",
		  statusreg, stk_ptr->s_ABssw);
		return(SIGBUS);			/* some hardware failure? */
	}

	/* flush this entry from tlb */
	flush_user_tlb_entry(vaddr);
	return(0);
}

busviol(stk_ptr)
register struct state *stk_ptr;
{
	register ushort	ssw;

	switch (stk_ptr->s_format) {

	case 0xA:	/* format A */
		/* get special status word */
		ssw = stk_ptr->s_proc.formatA.fA_ssw;

		if (DF(ssw))
			/* data cycle fault address */
			return(stk_ptr->s_proc.formatA.fA_faultaddr);

		if (stageC(ssw))
			return((ulong)stk_ptr->s_pc + 2);

		if (stageB(ssw))
			return((ulong)stk_ptr->s_pc + 4);

		break;

	case 0xB:	/* format B */
		/* get special status word */
		ssw = stk_ptr->s_proc.formatB.fB_ssw;

		if (DF(ssw))
			/* data cycle fault address */
			return(stk_ptr->s_proc.formatB.fB_faultaddr);

		if (stageC(ssw))
			return(stk_ptr->s_proc.formatB.fB_stBaddr - 2);

		if (stageB(ssw))
			return(stk_ptr->s_proc.formatB.fB_stBaddr);

		break;
	}

	panic("unknown cause of bus error");
/*NOTREACHED*/
}

showbuserr(stk_ptr, faultreg)
register struct state *stk_ptr;
register faultreg;
{
	ulong	vaddr;

	showtrap(stk_ptr);

	vaddr = busviol(stk_ptr);

	printf("fault address %x\n",vaddr);
	if ((!USERMODE(stk_ptr->s_ps)) && is_iomap(vaddr))
		printf("Address mapped to system bus address %x:%x\n",
			iomap_to_slot(vaddr), iomap_to_offset(vaddr));

	printf("fault register = 0x%x, ", faultreg);
	break_out_faultreg(faultreg);

	printf("special status word = 0x%x, ", stk_ptr->s_proc.formatA.fA_ssw);
	break_out_ssw(stk_ptr->s_proc.formatA.fA_ssw);

	if (!USERMODE(stk_ptr->s_ps)) {
		spm_mem.panic_pm_id = own.o_pm_id;
		spm_mem.panic_slot = (uint)-1;	/* to signify panic from PM */
		spm_mem.panic_flag = 1;
		stop_all_processors();
	}
}

break_out_faultreg(faultreg)
register unsigned	faultreg;
{
	unsigned char	pending;

	printf("slot 0x%x, ", (faultreg & ST_SLOT_MASK)>>28);

	if ( (faultreg & ST_BAD_IO) == 0 )
		printf("invalid page descriptor in i/o space, ");
	if ( faultreg & ST_TIMEOUT )
		printf("timeout, ");
	if ( (faultreg & ST_WRONG_SPACE) == 0 )
		printf("wrong space, ");
	if ( (faultreg & ST_WRONG_COP) == 0 )
		printf("wrong coprocessor, ");
	if ( faultreg & ST_PAGE_FAULT )
		printf("page fault, ");
	if ( faultreg & ST_NAK )
		printf("nak, ");
	if ( faultreg & ST_WALK_ERR )
		printf("walk failed, ");
	if ( faultreg & ST_BAD_DATA )
		printf("error data response, ");
	if ( faultreg & ST_EXECUTE )
		printf("code fetch fault, ");
	else 
		printf("data access fault, ");

	if (faultreg & (ST_TIMEOUT | ST_NAK | ST_WALK_ERR | ST_BAD_DATA))
		if ( faultreg & ST_ARB_REQ )
			printf("waiting for grant, ");

	printf("\n");

	if ( (pending = ((~faultreg) & ST_IPL_REG)))
		printf("level %d interrupt pending\n", pending);
}

break_out_ssw(ssw)
register unsigned	ssw;
{
	if ( kernel_ref(ssw) )
		printf("system");
	else
		printf("user");

	printf(" mode ");

	if ( DF(ssw) ) {

		if ( ssw & SSW_RMW )
			printf("modify ");

		if ( ssw & SSW_READ )
			printf("read");
		else
			printf("write");
	}
	else
		printf("instruction fetch");

	printf("\n");
}

/*
 * syncpc is taken directly from the A1000 syncpc
 * it returns 1 if the user was executing a tst.b or similar
 * instruction.
 */

#define TST 0x4a2f8000   /* tstw, tstb, or tstl for NCR tower */
#define TSTEXT 0x4a370170   /*  extended offset */

syncpc(pc)
register short *pc;
{
	register i,temp;

	for (i = 0; i < 4; i++)  {
		temp = fuword(pc--);
		if (temp == -1) return(0);
		if (((temp & 0xff3f8000) == TST)  ||
		    ((temp & TSTEXT) == temp))
			 return(1);
	}
	return(0);
}

flush_user_tlb_entry(vaddr)
register uint	vaddr;
{
	/*  these l. a. bits index mtag  */
	vaddr &= MTAG_INDEX_MASK;

	/*  turn mtag index into an io offset  */
	vaddr >>= LOG_TO_TLB_OFFSET_SHIFT;

	/*  get the rest of the bits in the io location  */
	vaddr |= (uint)MTAG_START;

	/*  trash the entry  */
	*(uint *)vaddr = ~MTAG_VBIT;
}
