/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) canon.c: version 25.1 created on 11/27/91 at 15:06:03	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)canon.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-port:nudnix/canon.c	10.5"

#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"


/*
 *convert from canonical to local representation
 */
fcanon(fmt,from,to)
register char *fmt, *from, *to;
{
	register short tmp;
	long ltmp;
	register char *cptr;
	char *lfmt, *tptr;

	tptr = to;
	while(*fmt){
		switch(*fmt++){
		case 's':
			to = SALIGN(to);
			from = CAN_ALIGN(from);
			cptr = (char *)&ltmp;
			*cptr++ = hibyte(hiword(*from));
			*cptr++ = lobyte(hiword(*from));
			*cptr++ = hibyte(loword(*from));
			*cptr++ = lobyte(loword(*from));
			*(short *)to = ltmp;
			to = SNEXT(to);
			from = LNEXT(from);
			continue;
		case 'i':
			to = IALIGN(to);
			from = CAN_ALIGN(from);
			cptr = (char *)&ltmp;
			*cptr++ = hibyte(hiword(*from));
			*cptr++ = lobyte(hiword(*from));
			*cptr++ = hibyte(loword(*from));
			*cptr++ = lobyte(loword(*from));
			*(int *)to = ltmp;
			to = INEXT(to);
			from = LNEXT(from);
			continue;
		case 'l':
			to = LALIGN(to);
			from = CAN_ALIGN(from);
			ltmp = *(long *)from;
			*to++ = hibyte(hiword(ltmp));
			*to++ = lobyte(hiword(ltmp));
			*to++ = hibyte(loword(ltmp));
			*to++ = lobyte(loword(ltmp));
			from = LNEXT(from);
			continue;
		case 'b':
			*to++ = *from++;
			continue;
		case 'c':
			from = CAN_ALIGN(from);
			lfmt = fmt;
			ltmp = duatoi(&lfmt);
			fmt = lfmt;
			if(ltmp == 0) {
				ltmp = *(long *)from;
				*from++ = hibyte(hiword(ltmp));
				*from++ = lobyte(hiword(ltmp));
				*from++ = hibyte(loword(ltmp));
				*from++ = lobyte(loword(ltmp));
				from -= 4;
				ltmp = *(long *)from;
			}
			from = LNEXT(from);	
			if (ltmp > 64+1) {	/* protect thyself */
printf("fcanon: string len %d seen!!!\n", ltmp);
				ltmp = 15;
			}
			while(ltmp--)
				*to++ = *from++;	
			continue;
		default:
			return(0);

		}
	}
	return(to - tptr);
}

static char rfs_tbuf[2048];

/*
 *This routine converts from local to cononical representation
 */
tcanon(fmt, from, to, flag)
register char *fmt, *from, *to;
{
	register short tmp;
	long ltmp;
	char *lfmt, *tptr;
	register char *cptr = 0;

	tptr = to;
	if(flag && from == to){
		cptr = to;
		to = rfs_tbuf;
	}
	while(*fmt){
		switch(*fmt++){
		case 's':
			to = CAN_ALIGN(to);
			from = SALIGN(from);
			ltmp = *(short *)from;
			*to++ = hibyte(hiword(ltmp));
			*to++ = lobyte(hiword(ltmp));
			*to++ = hibyte(loword(ltmp));
			*to++ = lobyte(loword(ltmp));
			from = SNEXT(from);
			continue;
		case 'i':
			to = CAN_ALIGN(to);
			from = IALIGN(from);
			ltmp = *(int *)from;
			*to++ = hibyte(hiword(ltmp));
			*to++ = lobyte(hiword(ltmp));
			*to++ = hibyte(loword(ltmp));
			*to++ = lobyte(loword(ltmp));
			from = INEXT(from);
			continue;
		case 'l':
			to = CAN_ALIGN(to);
			from = LALIGN(from);
			ltmp = *(long *)from;
			*to++ = hibyte(hiword(ltmp));
			*to++ = lobyte(hiword(ltmp));
			*to++ = hibyte(loword(ltmp));
			*to++ = lobyte(loword(ltmp));
			from = LNEXT(from);
			continue;

		case 'b':
			*to++ = *from++;
			continue;
		case 'c':
			lfmt = fmt;
			ltmp = duatoi(&lfmt);
			fmt = lfmt;
			if(ltmp == 0){
				ltmp = strlen(from) + 1;
			}
			to = CAN_ALIGN(to);
			*to++ = hibyte(hiword(ltmp));
			*to++ = lobyte(hiword(ltmp));
			*to++ = hibyte(loword(ltmp));
			*to++ = lobyte(loword(ltmp));
			while(ltmp--)
				*to++ = *from++;	
			to = CAN_ALIGN(to);
			continue;
		default:
			return(0);
		}
	}
	if(cptr){
		bcopy(rfs_tbuf,cptr,(to - rfs_tbuf));
		return(to - rfs_tbuf);
	}
	return(to - tptr);
}

int
duatoi(str)
register char **str;
{
	register short i, n;

	n = 0;
	for( ; **str >= '0' && **str <= '9'; ++(*str))
		n = 10 * n + **str - '0';
	return(n);
}
