/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) build_addr.c: version 25.1 created on 11/27/91 at 15:05:30	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)build_addr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * build_addr.c -- create symbols for system data structures
 */


char version[] = "22.1";		/* version to stamp the .s file with */

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/pfdat.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/buf.h"
#include "sys/utsname.h"
#include "sys/tty.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/sbus.h"
#include "sys/sbus_pm.h"
#include "sys/spm_mem.h"
#include "sys/own.h"
#include "sys/lio.h"
#include "sys/kmem.h"
#include "sys/vmem.h"
#include "sys/pm_iomap.h"
#include "sys/stdio.h"

struct	kvtab {
	char	*name;
	unsigned int	value;
}; 

struct kvtab kvtab[] = {
	/* USER virtual addresses */
	{"userstack",	UMEM_START + UMEM_SIZE},

	/* OWN segments */

	{"u",		ADDR_U_STRUCT},
	{"sys_stk_end",	ADDR_U_STRUCT - sizeof(int)},
	{"u_caddr_flt",	(uint) &((user_t *)ADDR_U_STRUCT)->u_caddrflt},
	{"u_fpu_control", 
		(uint)&((user_t *)ADDR_U_STRUCT)->u_fpu.regs.control},
 	{"u_fpu_data",	(uint) ((user_t *)ADDR_U_STRUCT)->u_fpu.regs.reg},
	{"u_fpu_state",	(uint) ((user_t *)ADDR_U_STRUCT)->u_fpu.fsave},
	{"u_procp",	(uint) &((user_t *)ADDR_U_STRUCT)->u_procp},

	{"own_stbl",	ADDR_OWN_STBL},
	{"own_ptbl",	ADDR_OWN_PTBL},
	{"uarea_ptbl",	ADDR_OWN_PTBL +
		pnum(ADDR_U - ADDR_OWN_SEGS) * sizeof(pde_t)},

	/* per processor variables */
	{"own",		ADDR_OWN},
	{"own_runrun",	(uint) &((struct own *)ADDR_OWN)->o_runrun},
	{"own_fpu_type", (uint) &((struct own *)ADDR_OWN)->o_fpu_type},
	{"own_fpu_loaded", (uint) &((struct own *)ADDR_OWN)->o_fpu_loaded},
	{"own_lock_id", (uint) &((struct own *)ADDR_OWN)->o_lock_id},
	{"own_lock_req_ptr", (uint) &((struct own *)ADDR_OWN)->o_lock_req_ptr},
	{"own_spin_lock_cnt",
		(uint) &((struct own *)ADDR_OWN)->o_spin_lock_cnt},
	{"own_in_tdb", (uint) &((struct own *)ADDR_OWN)->o_tdb.in_tdb},
	{"own_upkern_dec_val",
	  (uint) &((struct own *)ADDR_OWN)->o_upkern_dec_val},

	/* per processor u area, used when switching contexts */
	{"own_u",	ADDR_OWN_U_STR},
	{"own_stk_end",	ADDR_OWN_U_STR - sizeof(int)},

	/* stream elements moved to spm_mem */
	{"qrunflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->qrunflag},
	{"strbcflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strbcflag},
	{"allocb_lock",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->allocb_lock},
	{"dballoc",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dballoc},
	{"mbfreelist",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->mbfreelist},
	{"dbfreelist",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dbfreelist},
	{"strst",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strst},

	/* KERNEL VIRTUAL SYS segs */

	{"syssegs",	ADDR_SYS_SEGS}, /* kernel dynamic area */

	/* MEMORY segs */

	{"kmem_start",	KMEM_START},
	{"spm_mem",	ADDR_SPM_MEM},
	{"lbolt",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->lbolt},
	{"time",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->time},
	{"mem_stbl",	ADDR_MEM_STBL},	/* stbl that describes memory */

#ifdef	M68020
	{"bad_ptbl",	ADDR_BAD_PTBL},	/* ptbl of invalid_pde */
	{"bad_stbl",	ADDR_BAD_STBL},	/* user stbl of invalid_sde */
#endif

	{"p0_u_area",	ADDR_P0_U_AREA},	/* proc 0's u area */
	{"p0_u",	ADDR_P0_U_STR},	/* proc 0's u structure */

	/* Cache  & Memory Management control */
#ifdef	M68040
	{"pm_pctl",		PM_PCTL},
	{"PCTL_CACHE_MMU_ON",	PCTL_MMU|PCTL_PCACHE|PCTL_SCACHE},
#endif

	/* I/O */
#ifdef	M68040
	/* 68040 system map array */
	{"kv_iomap",		PM_MAP_START},
#endif
#ifdef	M68020
	{"urxxt",	(uint)URXXT},	/* reload user rde and flush */
#endif

	/* address of a pm's interrupt request register on the bus */
	{"pm_int_req_reg", (KIO_START + 
	  (PM_Int_Req_Reg_Index<<PM_UnmappedBits) + PM_STAT_MIN_BITS)},

#ifdef	M68040
	{"pm_int_clear_reg", PM_INT_CLEAR_REG},
#endif

	/* VALUES FOR INTERRUPT REQUEST REGISTER */
	{"pm_clear_level_one",		PM_CLEAR_LEVEL_ONE},
	{"pm_clear_level_two",		PM_CLEAR_LEVEL_TWO},
	{"pm_clear_level_three",	PM_CLEAR_LEVEL_THREE},
	{"pm_clear_level_four",		PM_CLEAR_LEVEL_FOUR},
	{"pm_clear_level_five",		PM_CLEAR_LEVEL_FIVE},
	{"pm_clear_level_six",		PM_CLEAR_LEVEL_SIX},
	{"pm_clear_level_seven",	PM_CLEAR_LEVEL_SEVEN},

	/* location of upkern structure in spm_mem */
	{"upkern", (uint) &((struct spm_mem *)ADDR_SPM_MEM)->upkern},
	{"o_upkern_init_val",
	  (uint) &((struct own *)ADDR_OWN)->o_upkern_init_val}, 

	/* values for assembler upkern routines to use */
	{"up_wait_bit_short",		UPKERN_WAITING_BIT_SHORT},
	{"up_cnt_long",			UPKERN_CNT_LONG},

	/* proc structure field used by ml/userio.s to check for RFS copy */
	{"p_sysid",	(uint) &((struct proc *)0)->p_sysid},

#ifdef	M68020
	/* address of logic analyzer line */
	{"addr_logic_analyzer", (uint) LOGIC_ANALYZER},
#endif

	{ 0 } /* end of list */
};

/*
 * make these symbols undefined to force them to be loaded from the following
 * libraries
 */

char	*undef[] = {
	"M68Kvec",
	"_start",
	"auto1",
	"icode",
	"min",
	"ml_fpu_save",
	"setjmp",
	"spin_lock",
	"splx",
	"sysent",
	"sys_reclock",
	NULL
};

main()
{
	register struct	kvtab	*kvptr;
	register char		**cpp;

	/* Generate warning as part of output file */
	printf("\n\tident\t\"ml/addr.s\t%s\"\n\n", version);
	printf("%s%s%s%s",
		"\t# WARNING WARNING WARNING:\n",
		"\t# This file is generated by running build_addr\n",
		"\t# Do not change this file by hand.\n",
		"\t# Changes will be lost next time build_addr is run.\n");

	for (kvptr = kvtab; kvptr->name; kvptr++) {
		printf("\tset\t%s, 0x%x\n", kvptr->name, kvptr->value);
		printf("\tglobal\t%s\n", kvptr->name);
	}

	printf("\n\t# Undefined symbols (force loading from libraries)\n\n");
	for (cpp = undef; *cpp; cpp++)
		printf("\tglobal\t%s\n", *cpp);

	return (0);
}
