#	START NEW ARIX SCCS HEADER
#
#	@(#) trap.s: version 25.1 created on 11/27/91 at 15:05:14
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)trap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)trap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"

ident	"@(#)uts/ml/M68040:trap.s	23.2"

	global	auto1,auto2,auto3,auto4,auto5,auto6,auto7
	global	trap0,trap2
	global	enter_debugger, TDB_vector

	text
#-------------------------------------------------------------------------
#
#	T  R  A  P
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
#
#	I N T E R R U P T S
#
#	entry stack:
#			|------------------------------------------|
#		SSP -->	|   status register                        |
#			|------------------------------------------|
#			|   program counter high                   |
#			|------------------------------------------|
#			|   program counter low                    |
#			|------------------------------------------|
#			|   format and vector information          |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------


#auto1:
#	mov.l	&pm_clear_level_one, pm_int_clear_reg
#	mov.b	&1, own_runrun	# set runrun
#	btst	&5,(%sp)	# supervisor?
#	beq.w	resched		# no. go reschedule
#	rte

auto1:
	mov.l	&pm_clear_level_one, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_one
	bra.w	int_ret

auto2:
	mov.l	&pm_clear_level_two, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_two
 	bra.w	int_ret

auto3:
	mov.l	&pm_clear_level_three, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_three
 	bra.w	int_ret

auto4:
	mov.l	&pm_clear_level_four, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_four
 	bra.w	int_ret

auto5:
	mov.l	&pm_clear_level_five, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_five
 	bra.w	int_ret


#
#	auto vector level 6	clock 
#
#	these interrupts originate from the spm runtime code

auto6:
	mov.l	&pm_clear_level_six, pm_int_clear_reg
	movm.l	&0xc0c0,-(%sp)				# save d0,d1,a0,a1
	mov.l	14(%sp),-(%sp)				# pass ps
	mov.l	22(%sp),-(%sp)				# pass pc
	jsr	clock
	add.w	&8,%sp
	bra.w	int_ret

auto7:
# stack format 0 (4 word stack frame)
	movm.l	&0xfffe, -(%sp)	# save your current state (registers)
	mov.l	%usp, %a0
	mov.l	%a0, -(%sp)
	mov.l	&0, -(%sp)	# 0 first arg: says comes from int, not buserr

	jsr	hard_error
	addq.l	&4, %sp		# pop the first arg

				# Ravi:
	     	   		# hard_error routine has been changed.
				# It will return 1 if we have to go to tdb.
				# If not it will return 0.
	tst.l   %d0
	beq	skip_tdb

	mov.l	(%sp)+, %a0	# restore registers.  We know that TDB
	mov.l	%a0, %usp	# will try to save the registers again.
	movm.l	(%sp)+, &0x7fff	# May be waste of time, but modular
	bra	TDB_vector

skip_tdb:
	mov.l	(%sp)+, %a0	# restore your state (registers)


	mov.l	%a0, %usp
	movm.l	(%sp)+, &0x7fff
	rte

#-------------------------------------------------------------------------
#
#	I N T    R E T
#			 15                                       0
#			|------------------------------------------|
#		SSP --> |                 a1                       |
#			|                 a0                       |
#			|                 d1                       |
#			|                 d0                       |
#			|------------------------------------------|
#	   		|   status register                        |
#			|------------------------------------------|
#	   		|   program counter high                   |
#			|------------------------------------------|
#	   		|   program counter low                    |
#			|------------------------------------------|
#	   		|   format word                            |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------

	global	int_ret		# glob'ize so fp emulation can return thru here
int_ret:
	btst	&5,0x10(%sp)	# supervisor?
	bne.b	int_r1		# yes. return
	tst.b	own_runrun	# should we reschedule?
	bne.b	int_r2		# yes
	tst.b	qrunflag	# stream q processing to do?
	bne.b	int_r2		# br if so
int_r1:
	movm.l	(%sp)+,&0x0303	# restore a1,a0,d1,d0
	rte

int_r2:
# we now need to make the stack look like a trap

	movm.l	(%sp)+,&0x0303	# restore a1,a0,d1,d0

	mov.w	&0x2000,%sr	# make sure further interrupts are enabled
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	tst.b	own_runrun	# here just for streams?
	beq.w	trap_ret	# br if so

resched:
	jsr	u_resched
	bra.w	trap_ret

#-------------------------------------------------------------------------
#
#	A L L    T R A P S (see sys/state.h)
#
#-------------------------------------------------------------------------

trap0:			# system call
	btst	&5,(%sp)	# supervisor?
	bne.w	nullvect	# yes, something wrong!! use nullvect
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	systrap
#				# Ravi: should we invalidate the internal
#				# cache here(?)
	mov.l	(%sp)+,%a0
	mov.l	%a0, %usp
	movm.l	(%sp)+,&0x7fff
	rte


# Used to implement kernel emulation of tas instruction. d0 contains ptr.
# Now is unsupported on the M68040, so call trap_2 to deal with it.
trap2:
	btst	&5,(%sp)	# supervisor?
	bne.w	nullvect	# yes, something wrong!! use nullvect
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	trap_2
#				# Ravi: should we invalidate the internal
#				# cache here(?)
	mov.l	(%sp)+,%a0
	mov.l	%a0, %usp
	movm.l	(%sp)+,&0x7fff
	rte


busint: global	busint	#vector address 8
	movm.l	&0xfffe, -(%sp)	#	save all registers
	mov.l	%usp, %a0
	mov.l	%a0, -(%sp)

	btst	&5,0x40(%sp)	# supervisor?
	bne.b	kbusint		# yes, call k_buserr
	jsr	u_buserr	# handle user mode bus error
	bra	trap_ret

kbusint:
	jsr	k_buserr	# handle kernel mode bus error
	bra	trap_ret

addr_err: global addr_err	# FIX THIS, HH - 040 kludge - vector address c.
	mov.l	%a0, -(%sp)
	mov.l	%d0, -(%sp)
	clr.l	%d0
	mov.w	&0x4e73, %d0	# RTE opcode.
	mov.l	10(%sp), %a0	
	cmp.w	%d0, (%a0) 	# instruction was not RTE.
	bne.b	not_rte_to_user
	bclr	&5, 8(%sp)	# if it was RTE, clear supervisor bit.
not_rte_to_user:
	mov.l	(%sp)+, %d0
	mov.l	(%sp)+, %a0

nullvect:	global	nullvect

	btst	&5,(%sp)	# supervisor?
	bne.w	TDB_vector

	movm.l	&0xfffe,-(%sp)		# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	u_trap

trap_ret:
	tst.b	qrunflag		# streams work to do?
	beq.b	trap_r2			# br if not
	mov.b	queueflag, %d0		# work in progress?
	bne.b	trap_r2			# br if so
	mov.l	&1, %d1			# atomic test-and-set queueflag
	cas.b	%d0, %d1, queueflag
	bne.b	trap_r2			# br if pre-empted
	jsr	queuerun

	mov.l	&1, %d0			# set compare value (flag better be 1!)
	clr.l	%d1			# set reset value.
	cas.b	%d0, %d1, queueflag


trap_r2:
	bra.b	no_crunch
#
#	STACK CRUNCHING CODE:
#	Turns any stack frame into a normal stack frame
#
#	When started, sp points to:
#		16 saved registers, ps, pc, vecoff, optional info
#
#	When finished, sp points to:
#			16 saved registers, ps, pc, 0
#
#	mov.w	70(%sp),%d0
#	lsr.w	&12,%d0			# d0 is format code
#	andi.w	&0x07ff,70(%sp)		# clear format code and "crunch bit"
#	mov.l	&0,%d1
#	mov.b	(stkfmtsz,%d0.w),%d1	# d1 is # of bytes change in size
#	lea	72(%sp),%a0		# a0 points past bottom of src area
#	lea	(%d1,%a0),%a1		# a1 points past bottom of dst area

# copy regs, ps, pc, vecoff
# crunch_loop will go around 18 times.
# 16 times for the registers, 2 times for the normal stack
#
#	mov.l	&17, %d0		# d0 contains one less than loop count
#crunch_loop:
#	mov.l	-(%a0),-(%a1)
#	dbra.w	%d0,crunch_loop
#	mov.l	%a1,%sp

no_crunch:
	mov.l	(%sp)+,%a0
	long	0x4e7b8800	# hanna FIX -- movc to usp until chip fix
# hanna FIX (see above)	mov.l	%a0, %usp
	movm.l	(%sp)+,&0x7fff
	rte

enter_debugger:
	subq.l	&4, %sp			# make room for expanded stack frame
	mov.l	4(%sp), 2(%sp)		# move return pc down one short word
	clr.w	6(%sp)			# clear format word
	mov.w	%sr, (%sp)		# save priority level for rte
	
TDB_vector:
	mov.w	&0x2700, %sr	# spl7
	tst.l	own_in_tdb
	beq.b	enter_tdb
	rte

enter_tdb:
	add.l	&1, own_in_tdb
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	tdb
#				# Ravi: shouldn't we invalidate the inernal
#				# cache here?
	mov.l	(%sp)+,%a0
	mov.l	%a0, %usp
	movm.l	(%sp)+,&0x7fff
	sub.l	&1, own_in_tdb
	rte

