#	START NEW ARIX SCCS HEADER
#
#	@(#) start.s: version 25.2 created on 4/14/92 at 11:39:34
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)start.s	25.2	4/14/92 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#

ident	"@(#)uts/ml/M68040:start.s	23.2"

#  start.s

	global	_start
	global	start_icode
	text

_start:
	# Ravi: when diagnostics gives control to kernel, it leaves the
	# 68040 in a known state.  This 'known state' is documented by
	# diagnostics group.
	# However, this startup code doesn't assume anything with respect
	# to 68040 registers. 
	# The diagnostics code gives control to kernel at this point.
	# This code does not consider the possibility of returning to
	# the proms.
	#
	# This code should work even if the M bit is set in the status register

	mov.l	&own_stk_end, %sp
	mov.l	%sp, %isp		# make sure isp is same as current sp
					# if M bit already clear, this is a nop

	mov.w	&0x2700, %sr		# S bit and spl7 (M bit cleared)

	mov.l	&M68Kvec, %d0		# load the vector base register.
	mov.l	%d0, %vbr


					
	mov.l	&0xc03fa340, %d0	# dtt0 is programmed to access
	mov.l	%d0, %dtt0		# control, status registers etc
					# of various boards in the system.
	         	             	# This reg. is programmed as below
	     	          		# for addresses from c0XXXXXX
					# to FFFFFFFF: 
					# enable dtt0, supervisor only FC2
					# matching, U0 & U1 are set,
					# cache inhibited, serialized

# Shared control register initialization
	mov.l	&0xff7c0000, %a0
	mov.l	(%a0), %d0
# enabling the IPC so that we can turn on the CPU B, if present.  But after
# turning on B, we must disable IPC.  Here IPC is enabled by making the 7th
# bit zero.
#
# JPC 4/10/92 -- Until all DPM40 boards have Dan's AFIFO bypass register fix,
# we may only enable SCTL_BYPASS on fixed boards.  To learn who's who, write
# a one at bit 15, then read it back.  A zero means fixed.
	and.l	&0xffffbf7f, %d0	# clear SCTL_BYPASS and SCTL_IPCOFF
	bset	&15, %d0		# set SCTL_BFIX_CK
	mov.l	%d0, (%a0)
	mov.l	(%a0), %d0
	btst	&15, %d0
	bne.b	L%_s01			# fixed?
	bset	&14, %d0		# yes -- turn on SCTL_BYPASS
	mov.l	%d0, (%a0)
L%_s01:
	mov.l	&0, %a0
	mov.l	%a0, %usp

	cinva	icdc			# invalidate both data and
					# instruction cache
					# we will enable this in future.

	mov.l	&1,%d0			# 1 is User data space
	mov.l	%d0,%dfc		# which is used in moves etc
	mov.l	%d0,%sfc

	mov.l	&0, %d0			# clear the registers and jmp to
	mov.l	%d0, %d1		# the startc C routine.
	mov.l	%d0, %d2
	mov.l	%d0, %d3
	mov.l	%d0, %d4
	mov.l	%d0, %d5
	mov.l	%d0, %d6
	mov.l	%d0, %d7
	mov.l	%d0, %a0
	mov.l	%d0, %a1
	mov.l	%d0, %a2
	mov.l	%d0, %a3
	mov.l	%d0, %a4
	mov.l	%d0, %a5
	mov.l	%d0, %a6

	jmp	startc
	# NO RETURN from startc




start_icode:
	mov.l	&userstack, %a0
	mov.l	%a0, %usp		# set up user stack ptr

	mov.w	&0x0,-(%sp)		# push vector = 0
	mov.l	&0, -(%sp)		# push pc = 0
	mov.w	&0x0, -(%sp)		# push status register
	rte				# switch to user state
