#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.s: version 25.2 created on 4/13/92 at 16:56:32
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)misc.s	25.2	4/13/92 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
#	ORIG:misc.s	2.1

ident	"@(#)uts/ml/M68040:misc.s	23.2"

#-----------------------------------------------------------------------------
#
#	M I S C
#
#-----------------------------------------------------------------------------

	global	addupc
# WARNING: Any modifications to spl's should be reflected in the
# inline versions of sys/*/Mspl.h
	global	spl0,spl1,spl2,spl3,spl4,spl5,spl6,spl7
	global	spl_gc, spl_edt, spl_mac, spl_console, splstr, spl_icb, spl_scsi
	global	set_pc_sp
	global	splhi, splx, get_spl
	global	bcopy, bzero, bset_long
	global	searchdir
	global	findnull
	global	probe_read
	global	probe_byte, probe_short, probe_long
	global	stop_processor
	global	clear_pm_int_req_reg
	global	get_vbr, set_vbr
	global	find_first_bit_set, clear_bit, set_bit, is_bit_set
	global	kwrword, kwrshort, kwrbyte

	text
#-----------------------------------------------------------------------------
#	WARNING, the following assumes fuisui dont change parameters
#
#
#	A D D U P C
#
#	update program counter profile
#
#	input parameters:
#		1.  pc
#		2.  &u.u_prof
#		3.  profile increment
#
#-----------------------------------------------------------------------------

addupc:
	mov.l	8(%sp),%a0		# &u.u_prof
	mov.l	4(%sp),%d0		# pc
	sub.l	8(%a0),%d0		# pc = pc - offset
	blt.b	L%addret2

	mov.l	12(%a0),%d1		# get scale
	lsr.l	&1,%d0			# divide pc by 2
	lsr.l	&1,%d1			# and scale
	mulu.l	%d1,%d1:%d0		# multiply by scaler
	mov.l	%d2,-(%sp)
	mov.l	&14,%d2
	lsr.l	%d2,%d0
	ror.l	%d2,%d1
	and.l	&0xfffc0000,%d1
	or.l	%d1,%d0
	addq.l	&1,%d0
	bclr	&0,%d0			# word boundary
	mov.l	(%sp)+,%d2
	cmp.l	%d0,4(%a0)		# within profile buffer?
	bgt.b	L%addret2		# no.

	add.l	(%a0),%d0		# add buffer base
	subq.l	&2,%d0			# make prof slot lower two bytes
	mov.l	%d0,%a1			# histo slot addr
	mov.l	&addpcerr,u_caddr_flt
	movs.l	(%a1),%d0
	add.w	14(%sp),%d0		# bump profile slot
	movs.l	%d0,(%a1)

L%addret1:
	clr.l	u_caddr_flt
L%addret2:
	rts

addpcerr:
	clr.l	12(%a0)			# disable profile more or less
	bra.b	L%addret1

#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

# WARNING: Any modifications to spl's should be reflected in the
# inline versions of sys/*/Mspl.h

# spl0 has been modified to do an rte, instead an rts.
# this is to force a pending interrupt to be taken after
# the rte (thus in the calling routine), instead of in the
# middle of spl0.  this allows the kernel profiler somewhat 
# clearer view.

spl0:
#	mov.w	%sr,%d0		# previous level
#	mov.w	&0x2000,%sr
#	rts
	# coming in
	#
	#
	#sp-->	pc high word
	#	pc low word
	#
	#
	mov.w	%sr,%d0			# previous level
	mov.l	(%sp)+, %a0		# save pc in %a0
	clr.w	-(%sp)			# clear format/vector info
	mov.l	%a0, -(%sp)		# push pc back on stack
	mov.w	&0x2000, -(%sp)		# copy sr into position
	#sp->	sr
	#	pc high word
	#	pc low word
	#	0
	rte


spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2100,%sr
	rts

spl2:
spl_edt:
spl_scsi:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2200,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2300,%sr
	rts

spl4:
spl_gc:
spl_mac:
spl_icb:
splstr:
spl_console:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2400,%sr
	rts

spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2500,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2600,%sr
	rts

spl7:
splhi:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2600,%sr
	rts

splx:
	mov.w	6(%sp),%sr
	rts

# returns current priority level
get_spl:
	mov.w	%sr,%d0
	lsr.w	&8,%d0
	and.l	&0x00000007,%d0
	rts

#------------------------------------------------------------------
# set_pc_sp
#	change pc and sp to new values
#	No return possible
#------------------------------------------------------------------

set_pc_sp:
	mov.l	(%sp)+,%a0	# toss return PC, it won't be needed
	mov.l	(%sp)+,%a0	# new pc will be needed

	mov.l	(%sp),%sp	# set new sp value


	sub.l	%fp, %fp	# got no old frame pointer
	jmp	(%a0)		# jmp to new pc


# bcopy(from, to, bytes)

bcopy:	mov.l	4(%sp),%a0	# from
	mov.l	8(%sp),%a1	# to
	mov.l	12(%sp),%d1	# number of bytes
	ble.b	L%bcdone
	mov.w	%a0,%d0		# long align (at least) one address
	and.w	&3,%d0
	beq.b	L%bc_1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	addq.w	&3,%d0
L%bc_7:	mov.b	(%a0)+,(%a1)+	# move one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%bc_7	# loop while not aligned & more bytes
L%bc_1:	mov.l	%d1,%d0		# save count
	lsr.l	&2,%d1		# adjust count for long loop
	bra.b	L%bc_5

L%bc_2:	swap	%d1		# outer dbra loop
L%bc_3:	mov.l	(%a0)+,(%a1)+	# inner dbra loop: move longs
L%bc_5:	dbra	%d1,L%bc_3
	swap	%d1
	dbra	%d1,L%bc_2

	and.w	&3,%d0
	bra.b	L%bc_6
L%bc_9:	mov.b	(%a0)+,(%a1)+
L%bc_6:	dbra	%d0,L%bc_9

L%bcdone:
	mov.l	&0,%d0		# return (0)
	rts


#	bzero(addr, size)
#	addr is a physical address
#	size is in bytes

bzero:	mov.l	4(%sp),%a0	# address
	mov.l	8(%sp),%d1	# number of bytes
	ble.b	L%bzdone
	sub.l	%a1,%a1		# constant zero
	mov.w	%a0,%d0		# long align address
	and.w	&3,%d0
	beq.b	L%bz_1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	addq.w	&3,%d0
L%bz_6:	clr.b	(%a0)+		# clear one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%bz_6	# loop while not aligned & more bytes
L%bz_1:	mov.l	%d1,%d0		# save count
	lsr.l	&2,%d1		# adjust count for long loop
	bra.b	L%bz_5

L%bz_2:	swap	%d1		# outer dbra loop
L%bz_3:	mov.l	%a1,(%a0)+	# inner dbra loop: clear longs
L%bz_5:	dbra	%d1,L%bz_3
	swap	%d1
	dbra	%d1,L%bz_2

	and.w	&3,%d0
	bra.b	L%bz_8
L%bz_7:	clr.b	(%a0)+
L%bz_8:	dbra	%d0,L%bz_7

L%bzdone:
	mov.l	&0,%d0		# return (0)
	rts

#*****************************************************************************
#
#	searchdir (buf, n, target); search a directory for target
#	returns offset of match or empty slot or -1
#
#*****************************************************************************

	text
searchdir:
	mov.l	4(%sp),%a0	# directory buffer pointer
	mov.l	8(%sp),%d0	# length in byte
	mov.l	12(%sp),%a1	# target
	clr.l	%d1
	mov.l	%d2,-(%sp)
L%s_top:
	cmp.l	%d0,&16
	blt.b	L%sfini
	cmp.w	(%a0),&0
	beq.b	L%sempty
	mov.l	2(%a0),%d2
	cmp.l	%d2,(%a1)
	bne.b	L%scont
	mov.l	6(%a0),%d2
	cmp.l	%d2,4(%a1)
	bne.b	L%scont
	mov.l	10(%a0),%d2
	cmp.l	%d2,8(%a1)
	bne.b	L%scont
	mov.w	14(%a0),%d2
	cmp.w	%d2,12(%a1)
	beq.b	L%smatch
L%scont:
	add.w	&16,%a0
	sub.w	&16,%d0
	bra.b	L%s_top

L%sempty:
	cmp.l	%d1,&0
	bne.b	L%scont
	mov.l	%a0,%d1
	bra.b	L%scont

L%smatch:
	sub.l	8(%sp),%a0
	mov.l	%a0,%d0
	bra.b	L%sout

L%sfini:
	mov.l	&-1,%d0
	cmp.l	%d1,&0
	beq.b	L%sout
	sub.l	8(%sp),%d1
	mov.l	%d1,%d0

L%sout:
	mov.l	(%sp)+,%d2
	rts

# find the first null character from an user specified
# pathname pointer
#


findnull:
	mov.l	4(%sp),%a0	# source
	clr.l	%d1
	mov.l	&finderr,u_caddr_flt
	mov.l	8(%sp),%d0	# maximal buffer size
	tst.l	4(%sp)		# check for kernel address.
	bmi.b	finderr		# WARNING: this is dependent upon
				# kernel space starting at 0x80000000
	bra.b	L%chksize
L%loop:

	movs.b	(%a0)+,%d1
	tst.b	%d1
L%chksize:
	dbeq	%d0,L%loop
	clr.l	u_caddr_flt
	cmp.w	%d0,&0xffff
	bne	L%find_exit
	ext.l	%d0
L%find_exit:
	rts

finderr:
	clr.l	u_caddr_flt
	mov.l	&-1,%d0
	rts

probe_read:
	mov.l	&probe_err,u_caddr_flt
	mov.l	4(%sp),%a1
	movs.b	(%a1),%d0
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

probe_err:
	clr.l	u_caddr_flt
	mov.l	&-1,%d0
	rts

#
# probe_byte(src, dst) 
# probe_short(src, dst)
# probe_long(src, dst)
#
# copy data from *src to *dst
# return 0 if failed, 1 if ok
#
probe_byte:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.b	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value
	bra	probe_done

probe_short:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.w	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value
	bra	probe_done

probe_long:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.l	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value

probe_done:
	clr.l	u_caddr_flt
	rts

#	kwrbyte, kwrshort, kwrword -- u_caddr_flt-trapped analogs of suword
#					for in-kernel writes
#
#	usage:  kwrbyte(void *addr, ulong data)
#
#	returns zero on success, non-zero on failure

kwrword:
	mov.l	4(%sp),%a0
	mov.l	8(%sp),%d0
	mov.l	&kwrerr,u_caddr_flt
	mov.l	%d0,(%a0)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

kwrshort:
	mov.l	4(%sp),%a0
	mov.l	8(%sp),%d0
	mov.l	&kwrerr,u_caddr_flt
	mov.w	%d0,(%a0)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

kwrbyte:
	mov.l	4(%sp),%a0
	mov.l	8(%sp),%d0
	mov.l	&kwrerr,u_caddr_flt
	mov.b	%d0,(%a0)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

kwrerr:
	clr.l	u_caddr_flt
	mov.l	&-1,%d0
	rts

#

stop_processor:
	stop	&0x2700
	bra.b	stop_processor

clear_pm_int_req_reg:
	mov.l	&pm_clear_level_one,	pm_int_clear_reg
	mov.l	&pm_clear_level_two,	pm_int_clear_reg
	mov.l	&pm_clear_level_three,	pm_int_clear_reg
	mov.l	&pm_clear_level_four,	pm_int_clear_reg
	mov.l	&pm_clear_level_five,	pm_int_clear_reg
	mov.l	&pm_clear_level_six,	pm_int_clear_reg
	mov.l	&pm_clear_level_seven,	pm_int_clear_reg
	rts

get_vbr:	global	get_vbr
	mov.l	%vbr, %d0
	rts

set_vbr:	global	set_vbr
	mov.l	4(%sp), %d0
	mov.l	%d0, %vbr
	rts

	global	chip_cache_on, chip_cache_off
chip_cache_on:
	cinva	bc		# clear text and data chip caches
	mov.l	&0x80008000,%d0	# enable text and data caches
	mov.l	%d0,%cacr	# do it
	rts

chip_cache_off:
	mov.l	&0,%d0		# disable text and data caches
	mov.l	%d0,%cacr	# do it
	cinva	bc		# clear text and data chip caches
	rts


# bset_long(addr, value, long_cnt)
#
#	set long_cnt locations starting at addr to value

bset_long:
	mov.l	4(%sp),%a0	# addr
	mov.l	8(%sp),%d1	# pattern to set
	mov.l	12(%sp),%d0	# number of longs
	bra.b	L%bs_3		# go start the loop

L%bs_1:	swap	%d0		# outer dbra loop
L%bs_2:	mov.l	%d1,(%a0)+	# inner dbra loop: set 4 bytes
L%bs_3:	dbra	%d0,L%bs_2
	swap	%d0
	dbra	%d0,L%bs_1

	mov.l	%a0,%d0		# return pointer in both registers
	rts


# find_first_bit_set(start_addr, starting_bit_offset, bit_width)
#
#	WARNING: this code requires a zeroed 32 bit pad at the end of
#		 whatever bit field that you want it to check.

find_first_bit_set:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp),	%d1		# offset
	mov.l	12(%sp), %a1		# limit
L%boffo_loop:
	cmp.l	%d1, %a1
	bge.b	L%boffo_miss
	bfffo	(%a0){%d1:&32}, %d0
	bne.b	L%boffo_out		# found a bit, oh boy!
	add.l	&32, %d1
	bra.b	L%boffo_loop
L%boffo_miss:
	mov.l	&-1, %d0
L%boffo_out:
	rts

#is_bit_set(start, bit_num)

is_bit_set:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d1		# bit num
	clr.l	%d0
	bftst	(%a0){%d1:&1}
	beq	L%ibs_out		# bit not set
	mov.l	&1, %d0
L%ibs_out:
	rts

#set_bit(start, bit_num)

set_bit:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d0		# bit num
	bfset	(%a0){%d0:&1}
	rts

#clear_bit(start, bit_num)

clear_bit:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d0		# bit num
	bfclr	(%a0){%d0:&1}
	rts

#
#	void flush_user_tlb_entry(vaddr)
#	caddr_t	vaddr;
#	Flush a user space page address (or upage) from the tlb.
#	
#
	global	flush_user_tlb_entry
flush_user_tlb_entry:
	mov.l	4(%sp), %a0	# get the address to be flushed
	pflushn	%a0		# flush that NON-global address
	rts

#
#	void flush_sys_tlb_entry(vaddr)
#	caddr_t	vaddr;
#	Flush a kernel space page address from the tlb.
#	All kernel and data (with the exception of upage) are marked GLOBAL.
#	
#
	global	flush_sys_tlb_entry
flush_sys_tlb_entry:
				# is it necessary to save the function code?
	mov.l	%dfc, %d1	# save the old destination function code.
	mov.l	&5, %d0		# set dfc to system space.
	mov.l	%d0, %dfc
	mov.l	4(%sp), %a0
	pflush	%a0		# ker-flushhhhhh.
	mov.l	%d1, %dfc	# restore old function code.
	rts

#
#	void flush_all_own_tlb()
#	Flush your own pm's entire tlb.
#	
#
	global	flush_all_own_tlb
flush_all_own_tlb:
	pflusha
	rts

	global	flush_all_user_tlb
flush_all_user_tlb:
	pflushan
	rts

#
#	void pm_cache_on()
#	This replaces the 68020 C routine in os/startup.c.
#	It initializes and enables the on chip tlb and cache, 
#	and also turns on the board's secondary cache (SC).
#
	global	pm_cache_on
pm_cache_on:
	pflusha			# clr ALL onchip tlb entries
	cinva	bc		# invalidate (clr) both on-chip cache entries

	mov.l	&0x8000, %d0	# 	mov.l	&TC_MMU_EN|TC_PGSIZE, %d0
	mov.l	%d0, %tc	# turn on chip "mmu" and set pagesize to 4k

	mov.l	&0x80008000,%d0 # mov.l	&CACR_DATA_EN|CACR_TEXT_EN, %d0
	mov.l	%d0, %cacr	# turn on onchip cache
	or.l	&0xf000, pm_pctl# turn on board's secondary cache
	rts

	global	getsp
getsp:
	mov.l	%sp, %d0
	add.l	&4, %d0
	rts

	global clear_chip_cache
clear_chip_cache:
	cinva	bc		# invalidate all of both caches
	rts

# ptest_addr(ssw, addr) -- do a ptest on the given address and return
#			the mmusr results
#
	global ptest_addr
ptest_addr:
	mov.l	4(%sp), %d0	# special status word from stack frame
	mov.l	8(%sp), %a0	# virtual address in question
	mov.l	%dfc, %d1	# save destination function code
	mov.l	%d0, %dfc	# use function code from status reg
	btst	&8, %d0		# was a read operation?
	bne.b	L%pt_a_read
	ptestw	%a0		# test write
	bra.b	L%pt_a_done
L%pt_a_read:
	ptestr	%a0		# test read
L%pt_a_done:
	mov.l	%d1, %dfc	# restore destination function code
	mov.l	%mmusr, %d0	# return mmusr
	rts

# cache_push_data -- push and invalidate the entire data cache
#
	global	cache_push_data
cache_push_data:
	cpusha	dc
	rts
