#	START NEW ARIX SCCS HEADER
#
#	@(#) useriorfs.s: version 25.1 created on 11/27/91 at 15:01:35
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)useriorfs.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)useriorfs.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"

	global	copyin, copyout
	global	fuword, fushort, fubyte,suword, sushort, subyte
	global	bzeroba
	global	rcopyin, rcopyout			# RFS copy routines
	global	rfubyte, rfushort, rfuword, rsubyte, rsushort, rsuword
	global	u_procp, p_sysid


# copyin(src, dest, bytes)
#
#	bcopy with fault handling.
#	movs's are not required on the PM20 as long as we don't access
#	kernel addresses.  accesses crossing into kernel space also
#	are fault correctly due to KMEM_START being an invalid address.

copyin:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rcopyin			# if so, go to RFS version
	mov.l	8(%sp),%a1		# dest
	mov.l	12(%sp),%d1		# number of bytes
	ble.b	L%cp_done
	mov.l	&cp_err,u_caddr_flt	# set up error routine address
	mov.l	4(%sp),%d0		# check for kernel address.
	bmi.b	cp_err			# WARNING: this is dependent upon
					# kernel space starting at 0x80000000
	mov.l	%d0, %a0		# src

cp_com:
	mov.w	%a0,%d0			# long align (at least) one address
	and.w	&3,%d0
	beq.b	L%cp_1			# already aligned
	neg.w	%d0			# compute (4-addr%4)-1 (i.e. loop count)
	addq.w	&3,%d0
L%cp_7:	mov.b	(%a0)+,(%a1)+		# move one byte
	sub.l	&1,%d1			# decrement count by one byte
	dbeq	%d0,L%cp_7		# loop while not aligned & more bytes
L%cp_1:	mov.l	%d1,%d0			# save count
	lsr.l	&2,%d1			# adjust count for long loop
	bra.b	L%cp_5

L%cp_2:	swap	%d1			# outer dbra loop
L%cp_3:	mov.l	(%a0)+,(%a1)+		# inner dbra loop: move longs
L%cp_5:	dbra	%d1,L%cp_3
	swap	%d1
	dbra	%d1,L%cp_2

	and.w	&3,%d0
	bra.b	L%cp_6
L%cp_9:	mov.b	(%a0)+,(%a1)+
L%cp_6:	dbra	%d0,L%cp_9

L%cp_done:
	mov.l	&0,%d0			# return 0 for success

L%cp_out:
	clr.l	u_caddr_flt
	rts

cp_err: mov.l	&-1,%d0			# return -1 for failure
	bra.b	L%cp_out


#	copyout (src, des, bytes)
#	char *src, des;
#	int	bytes;
#			see  copyin for removal of movs's comment

copyout:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rcopyout		# if so, go to RFS version
	mov.l	4(%sp),%a0		# source
	mov.l	12(%sp),%d1		# byte count
	ble.b	L%cp_done
	mov.l	&cp_err,u_caddr_flt	# set up error routine address
	mov.l	8(%sp), %d0		# check for kernel address.
	bmi.b	cp_err			# WARNING: this is dependent upon
					# kernel space starting at 0x80000000
	mov.l	%d0,%a1			# destination
	bra.b	cp_com


#	fuword (addr)
#	long	 *addr;

fuword:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rfuword			# if so, go to RFS version
	mov.l	4(%sp),%d0
	btst	&0,%d0
	bne.b	fuw_berr
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	clr.l	%d0
	movs.l	(%a1),%d0
L%errdone:
	clr.l	u_caddr_flt
	rts

fuw_berr:
	mov.l	&-1,%d0
	bra.b	L%errdone

#	fushort (addr)
#	short *addr;

fushort:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rfushort			# if so, go to RFS version
	mov.l	4(%sp),%d0
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	clr.l	%d0
	mov.w	(%a1),%d0
	clr.l	u_caddr_flt
	rts

#	fubyte (addr)
#	char *addr;

fubyte:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rfubyte			# if so, go to RFS version
	mov.l	4(%sp),%d0
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	clr.l	%d0
	movs.b	(%a1),%d0
	clr.l	u_caddr_flt
	rts

#	suword (addr, word)
#	caddr_t addr;
#	long	word;

suword:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rsuword			# if so, go to RFS version
	mov.l	4(%sp),%d0
	mov.l	8(%sp),%d1
	btst	&0,%d0
	bne.b	fuw_berr
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	movs.l	%d1,(%a1)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

#	sushort (addr, short)
#	ushort	*addr;
#	ushort	short;

sushort:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rsushort			# if so, go to RFS version
	mov.l	4(%sp),%d0
	mov.w	10(%sp),%d1
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	mov.w	%d1,(%a1)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts


#	subyte (addr, byte)
#	caddr_t addr;
#	char	byte;

subyte:
	tst.w	([u_procp],p_sysid.w)	# this proc RFS server?
	bne	rsubyte			# if so, go to RFS version
	mov.l	4(%sp),%d0
	mov.b	11(%sp),%d1
	mov.l	&fuw_berr,u_caddr_flt
	mov.l	%d0,%a1
	movs.b	%d1,(%a1)
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

#	clear a partial page
#	bzeroba (vaddr, bytes)
#	char 	*vaddr;
#	int	bytes;
#			see copyin for removal of movs's comment

bzeroba:
	mov.l	&cp_err,u_caddr_flt
	mov.l	4(%sp),%a1		# vaddr
	mov.l	8(%sp),%d1		# byte count
	tst.l	4(%sp)			# check for kernel address.
	bmi.w	cp_err			# WARNING: this is dependent upon
					# kernel space starting at 0x80000000
	mov.l	%d2,-(%sp)		# save d2 register
	clr.l	%d2
	mov.l	%d1,%d0
	lsr.l	&2,%d0			# number of long transfers
	and.l	&3,%d1			# number of byte transfers
	beq.b	L%dolongc
	bra.b	L%dobytec
L%doloopc:
	mov.b	%d2,(%a1)+
L%dobytec:
	dbf	%d1,L%doloopc
	bra.b	L%dolongc
L%doloplc:
	mov.l	%d2,(%a1)+
L%dolongc:
	dbf	%d0,L%doloplc
	mov.l	(%sp)+,%d2		# restore %d2
	bra	L%cp_done
