#	START NEW ARIX SCCS HEADER
#
#	@(#) trap.s: version 25.1 created on 11/27/91 at 15:01:28
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)trap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)trap.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
	global	auto1,auto2,auto3,auto4,auto5,auto6,auto7
	global	trap0,trap2
	global	enter_debugger, TDB_vector

	text
#-------------------------------------------------------------------------
#
#	T  R  A  P
#
#-------------------------------------------------------------------------

#-------------------------------------------------------------------------
#
#	I N T E R R U P T S
#
#	entry stack:
#			|------------------------------------------|
#		SSP -->	|   status register                        |
#			|------------------------------------------|
#			|   program counter high                   |
#			|------------------------------------------|
#			|   program counter low                    |
#			|------------------------------------------|
#			|   format and vector information          |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------


#auto1:
#	mov.l	&pm_clear_level_one, pm_int_req_reg
#	mov.b	&1, own_runrun	# set runrun
#	btst	&5,(%sp)	# supervisor?
#	beq.w	resched		# no. go reschedule
#	rte

auto1:
	mov.l	&pm_clear_level_one, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_one
	bra.w	int_ret

auto2:
	mov.l	&pm_clear_level_two, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_two
 	bra.w	int_ret

auto3:
	mov.l	&pm_clear_level_three, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_three
 	bra.w	int_ret

auto4:
	mov.l	&pm_clear_level_four, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_four
 	bra.w	int_ret

auto5:
	mov.l	&pm_clear_level_five, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	level_five
 	bra.w	int_ret


#
#	auto vector level 6	clock 
#
#	these interrupts originate from the spm runtime code

auto6:
	mov.l	&pm_clear_level_six, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)				# save d0,d1,a0,a1
	mov.l	14(%sp),-(%sp)				# pass ps
	mov.l	22(%sp),-(%sp)				# pass pc
	jsr	clock
	add.w	&8,%sp
	bra.w	int_ret

auto7:
	mov.l	&pm_clear_level_seven, pm_int_req_reg
	movm.l	&0xc0c0,-(%sp)	# save d0,d1,a0,a1
	jsr	clear_nmi
	movm.l	(%sp)+,&0x0303	# restore a1,a0,d1,d0
	bra.w	TDB_vector

#-------------------------------------------------------------------------
#
#	I N T    R E T
#			 15                                       0
#			|------------------------------------------|
#		SSP --> |                 a1                       |
#			|                 a0                       |
#			|                 d1                       |
#			|                 d0                       |
#			|------------------------------------------|
#	   		|   status register                        |
#			|------------------------------------------|
#	   		|   program counter high                   |
#			|------------------------------------------|
#	   		|   program counter low                    |
#			|------------------------------------------|
#	   		|   format word                            |
#			|------------------------------------------|
#
#-------------------------------------------------------------------------

int_ret:
	btst	&5,0x10(%sp)	# supervisor?
	bne.b	int_r1		# yes. return
	tst.b	own_runrun	# should we reschedule?
	bne.b	int_r2		# yes
	tst.b	qrunflag	# stream q processing to do?
	bne.b	int_r2		# br if so
int_r1:
	movm.l	(%sp)+,&0x0303	# restore a1,a0,d1,d0
	rte

int_r2:
# we now need to make the stack look like a trap

	movm.l	(%sp)+,&0x0303	# restore a1,a0,d1,d0

trap2resched:
	mov.w	&0x2000,%sr	# make sure further interrupts are enabled
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	tst.b	own_runrun	# here just for streams?
	beq.w	trap_ret	# br if so

resched:
	jsr	u_resched
	bra.w	trap_ret

#-------------------------------------------------------------------------
#
#	A L L    T R A P S (see sys/state.h)
#
#-------------------------------------------------------------------------

trap0:			# system call
	btst	&5,(%sp)	# supervisor?
	bne.w	nullvect	# yes, something wrong!! use nullvect
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	systrap
	mov.l	&9,%d0		# CLEAR CACHE | ENABLE CACHE
	mov.l	%d0,%cacr	# clear Processor's internal cache
	mov.l	(%sp)+,%a0
	mov.l	%a0,%usp
	movm.l	(%sp)+,&0x7fff
	rte


trap2:
# implement kernel emulation of tas instruction. d0 contains ptr
	btst	&5,(%sp)	# supervisor?
	bne.w	nullvect	# yes, something wrong!! use nullvect

	mov.l	&trap2err, u_caddr_flt	# prepare for possible error
	mov.l	%d0, %a0	
	movs.b	(%a0), %d0		# find current value

	mov.b	%d0, %d1		# copy current value
	bclr	&7, %d0			# old value must have msbit clear
	bset	&7, %d1			# new value will have msbit set
	cas.b	%d0, %d1, (%a0)		# atomic sequence
	tst.b	%d0			# what was it just before cas
	mov.w	%sr, %d0
	mov.b	%d0, 1(%sp)		# return condition codes
	clr	u_caddr_flt
					# runrun will be set if we paged
	tst.b	own_runrun		# should we reschedule?
	bne.w	trap2resched		# yes
	rte



trap2err:
	clr	u_caddr_flt
	bra.w	nullvect

busint: global	busint	#vector address 8
	movm.l	&0xfffe, -(%sp)	#	save all registers
	mov.l	%usp, %a0
	mov.l	%a0, -(%sp)

	btst	&5,0x40(%sp)	# supervisor?
	bne.b	kbusint		# yes, call k_buserr
	jsr	u_buserr	# handle user mode bus error
	bra	trap_ret

kbusint:
	jsr	k_buserr	# handle kernel mode bus error
	bra	trap_ret

nullvect:	global	nullvect

	btst	&5,(%sp)	# supervisor?
	bne.w	TDB_vector

	movm.l	&0xfffe,-(%sp)		# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)
	jsr	u_trap

trap_ret:
	tst.b	qrunflag	# streams work to do?
	beq.b	trap_r2		# br if not
	mov.b	queueflag, %d0	# work in progress?
	bne.b	trap_r2		# br if so
	mov.l	&1, %d1		# atomic test-and-set queueflag
	cas.b	%d0, %d1, queueflag
	bne.b	trap_r2		# br if pre-empted
	jsr	queuerun
	mov.l	&0, %d0
	mov.b	%d0, queueflag

trap_r2:
	mov.l	&9,%d0		# CLEAR CACHE | ENABLE CACHE
	mov.l	%d0,%cacr	# clear Processor's internal cache

	btst	&3,70(%sp)	# check if stack needs to be "crunched"
	beq	no_crunch

#
#	STACK CRUNCHING CODE:
#	Turns any stack frame into a normal stack frame
#
#	When started, sp points to:
#		16 saved registers, ps, pc, vecoff, optional info
#
#	When finished, sp points to:
#			16 saved registers, ps, pc, 0
#
	mov.w	70(%sp),%d0
	lsr.w	&12,%d0			# d0 is format code
	andi.w	&0x07ff,70(%sp)		# clear format code and "crunch bit"
	mov.l	&0,%d1
	mov.b	(stkfmtsz,%d0.w),%d1	# d1 is # of bytes change in size
	lea	72(%sp),%a0		# a0 points past bottom of src area
	lea	(%d1,%a0),%a1		# a1 points past bottom of dst area

# copy regs, ps, pc, vecoff
# crunch_loop will go around 18 times.
# 16 times for the registers, 2 times for the normal stack
#
	mov.l	&17, %d0		# d0 contains one less than loop count
crunch_loop:
	mov.l	-(%a0),-(%a1)
	dbra.w	%d0,crunch_loop
	mov.l	%a1,%sp

no_crunch:
	mov.l	(%sp)+,%a0
	mov.l	%a0,%usp
	movm.l	(%sp)+,&0x7fff
	rte

enter_debugger:
	subq.l	&4, %sp			# make room for expanded stack frame
	mov.l	4(%sp), 2(%sp)		# move return pc down one short word
	clr.w	6(%sp)			# clear format word
	mov.w	%sr, (%sp)		# save priority level for rte
	
TDB_vector:
	mov.w	&0x2700, %sr	# spl7
	tst.l	own_in_tdb
	beq.b	enter_tdb
	rte

enter_tdb:
	add.l	&1, own_in_tdb
	movm.l	&0xfffe,-(%sp)	# save registers
	mov.l	%usp,%a0
	mov.l	%a0,-(%sp)

	jsr	tdb

	mov.l	&9,%d0		# CLEAR CACHE | ENABLE CACHE
	mov.l	%d0,%cacr	# clear Processor's internal cache

	mov.l	(%sp)+,%a0
	mov.l	%a0,%usp
	movm.l	(%sp)+,&0x7fff
	sub.l	&1, own_in_tdb
	rte
