#	START NEW ARIX SCCS HEADER
#
#	@(#) misc.s: version 25.1 created on 11/27/91 at 15:01:17
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)misc.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#	@(#)misc.s	2.1
#-----------------------------------------------------------------------------
#
#	M I S C
#
#-----------------------------------------------------------------------------

	global	addupc
	global	spl0,spl1,spl2,spl3,spl4,spl5,spl6,spl7
	global	spl_console, splstr
	global	set_pc_sp
	global	splhi, splx, get_spl
	global	bcopy, bzero, bset_long
	global	searchdir
	global	findnull
	global	probe_read
	global	probe_byte, probe_short, probe_long
	global	stop_processor
	global	clear_pm_int_req_reg
	global	get_vbr, set_vbr
	global	chip_cache_on, chip_cache_off
	global	find_first_bit_set, clear_bit, set_bit, is_bit_set

	text
#-----------------------------------------------------------------------------
#	WARNING, the following assumes fuisui dont change parameters
#
#
#	A D D U P C
#
#	update program counter profile
#
#	input parameters:
#		1.  pc
#		2.  &u.u_prof
#		3.  profile increment
#
#-----------------------------------------------------------------------------

addupc:
	mov.l	8(%sp),%a0		# &u.u_prof
	mov.l	4(%sp),%d0		# pc
	sub.l	8(%a0),%d0		# pc = pc - offset
	blt.b	L%addret2

	mov.l	12(%a0),%d1		# get scale
	lsr.l	&1,%d0			# divide pc by 2
	lsr.l	&1,%d1			# and scale
	mulu.l	%d1,%d1:%d0		# multiply by scaler
	mov.l	%d2,-(%sp)
	mov.l	&14,%d2
	lsr.l	%d2,%d0
	ror.l	%d2,%d1
	and.l	&0xfffc0000,%d1
	or.l	%d1,%d0
	addq.l	&1,%d0
	bclr	&0,%d0			# word boundary
	mov.l	(%sp)+,%d2
	cmp.l	%d0,4(%a0)		# within profile buffer?
	bgt.b	L%addret2		# no.

	add.l	(%a0),%d0		# add buffer base
	subq.l	&2,%d0			# make prof slot lower two bytes
	mov.l	%d0,%a1			# histo slot addr
	mov.l	&addpcerr,u_caddr_flt
	movs.l	(%a1),%d0
	add.w	14(%sp),%d0		# bump profile slot
	movs.l	%d0,(%a1)

L%addret1:
	clr.l	u_caddr_flt
L%addret2:
	rts

addpcerr:
	clr.l	12(%a0)			# disable profile more or less
	bra.b	L%addret1

#-----------------------------------------------------------------------------
#
#	S Y S T E M    P R I V I L E G E    L E V E L S
#
#-----------------------------------------------------------------------------

# spl0 has been modified to do an rte, instead an rts.
# this is to force a pending interrupt to be taken after
# the rte (thus in the calling routine), instead of in the
# middle of spl0.  this allows the kernel profiler somewhat 
# clearer view.

spl0:
#	mov.w	%sr,%d0		# previous level
#	mov.w	&0x2000,%sr
#	rts
	# coming in
	#
	#
	#sp-->	pc high word
	#	pc low word
	#
	#
	mov.w	%sr,%d0			# previous level
	mov.l	(%sp)+, %a0		# save pc in %a0
	clr.w	-(%sp)			# clear format/vector info
	mov.l	%a0, -(%sp)		# push pc back on stack
	mov.w	&0x2000, -(%sp)		# copy sr into position
	#sp->	sr
	#	pc high word
	#	pc low word
	#	0
	rte

spl1:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2100,%sr
	rts

spl2:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2200,%sr
	rts

spl3:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2300,%sr
	rts

spl4:
splstr:
spl_console:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2400,%sr
	rts

spl5:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2500,%sr
	rts

spl6:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2600,%sr
	rts

spl7:
splhi:
	mov.w	%sr,%d0		# previous level
	mov.w	&0x2600,%sr
	rts

splx:
	mov.w	6(%sp),%sr
	rts

# returns current priority level
get_spl:
	mov.w	%sr,%d0
	lsr.w	&8,%d0
	and.l	&0x00000007,%d0
	rts

#------------------------------------------------------------------
# set_pc_sp
#	change pc and sp to new values
#	No return possible
#------------------------------------------------------------------

set_pc_sp:
	mov.l	(%sp)+,%a0	# toss return PC, it won't be needed
	mov.l	(%sp)+,%a0	# new pc will be needed
	mov.l	(%sp),%sp	# set new sp value
	sub.l	%fp, %fp	# got no old frame pointer
	jmp	(%a0)		# jmp to new pc


# bcopy(from, to, bytes)

bcopy:	mov.l	4(%sp),%a0	# from
	mov.l	8(%sp),%a1	# to
	mov.l	12(%sp),%d1	# number of bytes
	ble.b	L%bcdone
	mov.w	%a0,%d0		# long align (at least) one address
	and.w	&3,%d0
	beq.b	L%bc_1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	addq.w	&3,%d0
L%bc_7:	mov.b	(%a0)+,(%a1)+	# move one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%bc_7	# loop while not aligned & more bytes
L%bc_1:	mov.l	%d1,%d0		# save count
	lsr.l	&2,%d1		# adjust count for long loop
	bra.b	L%bc_5

L%bc_2:	swap	%d1		# outer dbra loop
L%bc_3:	mov.l	(%a0)+,(%a1)+	# inner dbra loop: move longs
L%bc_5:	dbra	%d1,L%bc_3
	swap	%d1
	dbra	%d1,L%bc_2

	and.w	&3,%d0
	bra.b	L%bc_6
L%bc_9:	mov.b	(%a0)+,(%a1)+
L%bc_6:	dbra	%d0,L%bc_9

L%bcdone:
	mov.l	&0,%d0		# return (0)
	rts


#	bzero(addr, size)
#	addr is a physical address
#	size is in bytes

bzero:	mov.l	4(%sp),%a0	# address
	mov.l	8(%sp),%d1	# number of bytes
	ble.b	L%bzdone
	sub.l	%a1,%a1		# constant zero
	mov.w	%a0,%d0		# long align address
	and.w	&3,%d0
	beq.b	L%bz_1		# already aligned
	neg.w	%d0		# compute (4-addr%4)-1 (i.e. loop count)
	addq.w	&3,%d0
L%bz_6:	clr.b	(%a0)+		# clear one byte
	sub.l	&1,%d1		# decrement count by one byte
	dbeq	%d0,L%bz_6	# loop while not aligned & more bytes
L%bz_1:	mov.l	%d1,%d0		# save count
	lsr.l	&2,%d1		# adjust count for long loop
	bra.b	L%bz_5

L%bz_2:	swap	%d1		# outer dbra loop
L%bz_3:	mov.l	%a1,(%a0)+	# inner dbra loop: clear longs
L%bz_5:	dbra	%d1,L%bz_3
	swap	%d1
	dbra	%d1,L%bz_2

	and.w	&3,%d0
	bra.b	L%bz_8
L%bz_7:	clr.b	(%a0)+
L%bz_8:	dbra	%d0,L%bz_7

L%bzdone:
	mov.l	&0,%d0		# return (0)
	rts

#*****************************************************************************
#
#	searchdir (buf, n, target); search a directory for target
#	returns offset of match or empty slot or -1
#
#*****************************************************************************

	text
searchdir:
	mov.l	4(%sp),%a0	# directory buffer pointer
	mov.l	8(%sp),%d0	# length in byte
	mov.l	12(%sp),%a1	# target
	clr.l	%d1
	mov.l	%d2,-(%sp)
L%s_top:
	cmp.l	%d0,&16
	blt.b	L%sfini
	cmp.w	(%a0),&0
	beq.b	L%sempty
	mov.l	2(%a0),%d2
	cmp.l	%d2,(%a1)
	bne.b	L%scont
	mov.l	6(%a0),%d2
	cmp.l	%d2,4(%a1)
	bne.b	L%scont
	mov.l	10(%a0),%d2
	cmp.l	%d2,8(%a1)
	bne.b	L%scont
	mov.w	14(%a0),%d2
	cmp.w	%d2,12(%a1)
	beq.b	L%smatch
L%scont:
	add.w	&16,%a0
	sub.w	&16,%d0
	bra.b	L%s_top

L%sempty:
	cmp.l	%d1,&0
	bne.b	L%scont
	mov.l	%a0,%d1
	bra.b	L%scont

L%smatch:
	sub.l	8(%sp),%a0
	mov.l	%a0,%d0
	bra.b	L%sout

L%sfini:
	mov.l	&-1,%d0
	cmp.l	%d1,&0
	beq.b	L%sout
	sub.l	8(%sp),%d1
	mov.l	%d1,%d0

L%sout:
	mov.l	(%sp)+,%d2
	rts

# find the first null character from an user specified
# pathname pointer
#


findnull:
	mov.l	4(%sp),%a0	# source
	clr.l	%d1
	mov.l	&finderr,u_caddr_flt
	mov.l	8(%sp),%d0	# maximal buffer size
	tst.l	4(%sp)		# check for kernel address.
	bmi.b	finderr		# WARNING: this is dependent upon
				# kernel space starting at 0x80000000
	bra.b	L%chksize
L%loop:
	mov.b	(%a0)+,%d1
	tst.b	%d1
L%chksize:
	dbeq	%d0,L%loop
	clr.l	u_caddr_flt
	cmp.w	%d0,&0xffff
	bne	L%find_exit
	ext.l	%d0
L%find_exit:
	rts

finderr:
	clr.l	u_caddr_flt
	mov.l	&-1,%d0
	rts

probe_read:
	mov.l	&probe_err,u_caddr_flt
	mov.l	4(%sp),%a1
	movs.b	(%a1),%d0
	clr.l	u_caddr_flt
	clr.l	%d0
	rts

probe_err:
	clr.l	u_caddr_flt
	mov.l	&-1,%d0
	rts

#
# probe_byte(src, dst) 
# probe_short(src, dst)
# probe_long(src, dst)
#
# copy data from *src to *dst
# return 0 if failed, 1 if ok
#
probe_byte:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.b	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value
	bra	probe_done

probe_short:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.w	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value
	bra	probe_done

probe_long:
	mov.l	&probe_done,u_caddr_flt	# protect in case of bus error
	mov.l	4(%sp),%a1	# a1 contains address to probe
	mov.l	8(%sp),%a0	# a0 contains address to store data
	mov.l	&0,%d0		# assume failed result
	mov.l	(%a1),(%a0)	# do the actual probe
	mov.l	&1,%d0		# return TRUE value

probe_done:
	clr.l	u_caddr_flt
	rts

stop_processor:
	stop	&0x2700
	bra.b	stop_processor

clear_pm_int_req_reg:
	mov.l	&pm_clear_level_one,	pm_int_req_reg
	mov.l	&pm_clear_level_two,	pm_int_req_reg
	mov.l	&pm_clear_level_three,	pm_int_req_reg
	mov.l	&pm_clear_level_four,	pm_int_req_reg
	mov.l	&pm_clear_level_five,	pm_int_req_reg
	mov.l	&pm_clear_level_six,	pm_int_req_reg
	mov.l	&pm_clear_level_seven,	pm_int_req_reg
	rts

get_vbr:	global	get_vbr
	mov.l	%vbr, %d0
	rts

set_vbr:	global	set_vbr
	mov.l	4(%sp), %d0
	mov.l	%d0, %vbr
	rts

chip_cache_on:
	mov.l	&9,%d0		# CLEAR CACHE | ENABLE CACHE
	mov.l	%d0,%cacr	# clear Processor's internal cache
	rts

chip_cache_off:
	mov.l	&8,%d0		# CLEAR CACHE
	mov.l	%d0,%cacr	# clear Processor's internal cache
	rts


# bset_long(addr, value, long_cnt)
#
#	set long_cnt locations starting at addr to value

bset_long:
	mov.l	4(%sp),%a0	# addr
	mov.l	8(%sp),%d1	# pattern to set
	mov.l	12(%sp),%d0	# number of longs
	bra.b	L%bs_3		# go start the loop

L%bs_1:	swap	%d0		# outer dbra loop
L%bs_2:	mov.l	%d1,(%a0)+	# inner dbra loop: set 4 bytes
L%bs_3:	dbra	%d0,L%bs_2
	swap	%d0
	dbra	%d0,L%bs_1

	mov.l	%a0,%d0		# return pointer in both registers
	rts


# find_first_bit_set(start_addr, starting_bit_offset, bit_width)
#
#	WARNING: this code requires a zeroed 32 bit pad at the end of
#		 whatever bit field that you want it to check.

find_first_bit_set:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp),	%d1		# offset
	mov.l	12(%sp), %a1		# limit
L%boffo_loop:
	cmp.l	%d1, %a1
	bge.b	L%boffo_miss
	bfffo	(%a0){%d1:&32}, %d0
	bne.b	L%boffo_out		# found a bit, oh boy!
	add.l	&32, %d1
	bra.b	L%boffo_loop
L%boffo_miss:
	mov.l	&-1, %d0
L%boffo_out:
	rts

#is_bit_set(start, bit_num)

is_bit_set:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d1		# bit num
	clr.l	%d0
	bftst	(%a0){%d1:&1}
	beq	L%ibs_out		# bit not set
	mov.l	&1, %d0
L%ibs_out:
	rts

#set_bit(start, bit_num)

set_bit:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d0		# bit num
	bfset	(%a0){%d0:&1}
	rts

#clear_bit(start, bit_num)

clear_bit:
	mov.l	4(%sp), %a0		# start
	mov.l	8(%sp), %d0		# bit num
	bfclr	(%a0){%d0:&1}
	rts

