#	START NEW ARIX SCCS HEADER
#
#	@(#) fpu.s: version 25.1 created on 11/27/91 at 15:01:13
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)fpu.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)fpu.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
	global	ml_fpu_idle
	global	ml_fpu_save
	global	ml_fpu_restore
	global	ml_fpu_unstick

#
# force fpu to "idle" state
#
ml_fpu_idle:
	frestore fpu_null_state		# force to an initial state
	fnop
	rts

#
# save all fpu information
#
ml_fpu_save:
	
	# first save internal state
	fsave	u_fpu_state

	# check if null state (if so, no more work required)

	tst.b	u_fpu_state
	beq.b	simple_save

	# save data and control registers

	fmovm.l	%control, %status, %iaddr, u_fpu_control
	fmovm.x	&0xff, u_fpu_data
simple_save:
	rts

#
# restore all fpu information
#
ml_fpu_restore:

	# check if null state (if so, only need to restore the state)

	tst.b	u_fpu_state
	beq.b	simple_restore

	# restore data and control registers

	fmovm.l	u_fpu_control, %control, %status, %iaddr
	fmovm.x	u_fpu_data, &0xff

simple_restore:
	# restore internal state

	frestore u_fpu_state
	rts


#
# fpu is stuck waiting for something that will never happen
# force it back to idle state, without losing more information
# than necessary
#
ml_fpu_unstick:
	frestore fpu_null_state

	# restore data and control registers

	fmovm.l	u_fpu_control, %control, %status, %iaddr
	fmovm.x	u_fpu_data, &0xff

	rts
