#	START NEW ARIX SCCS HEADER
#
#	@(#) cswitch.s: version 25.1 created on 11/27/91 at 15:01:02
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	ident	"@(#)cswitch.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#
#	END NEW ARIX SCCS HEADER
#
	ident	"@(#)cswitch.s	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
#		Copyright (c) 1985 AT&T		#
#		All Rights Reserved		#

# MC68020 version
# This file contains the routines used for context switching on UNIX V/68.
# The 1.1 level was derived from the 68000 cswitch.s level 1.3.

#	The routines contained here are:

	global	setjmp		# set up environment for external goto
	global	longjmp		# non-local goto
	global	save		# saves register sets
	global	resume		# restores register sets & u, then longjmps
	global	shsetjmp	# like setjmp, but doesn't save all registers

	set	HIGHPRI,0x2700	# supervisor state priority 7
	set	REGMASK,0xfefc	# save/restore a7-a1,d7-d2

#------------------------------------------------------------------------------
#
#	S  A  V  E
#
#	input paramters:
#		1.  save area
#
#	save area:   NOTE: When changing the size of the save area the
#		 	   size of label_t in types.h must change accordingly.
#
#	|-----------------------------------------------------------------|
#	| d2 | d3 | d4 | d5 | d6 | d7 | ret | a2 | a3 | a4 | a5 | a6 | a7 |
#	|-----------------------------------------------------------------|
#
#
#------------------------------------------------------------------------------

# setjmp (save_area)
# save (save_area)
#	saves registers and return location in save_area


	text
setjmp:
save:
	mov.l	(%sp)+,%a1	# pop return address of calling routine into %a1
	mov.l	(%sp),%a0	# address of save area
	movm.l	&REGMASK,(%a0)	# save a7-a1,d7-d2
	mov.l	&0,%d0		# return(0)
	jmp	(%a1)

#-----------------------------------------------------------------------------
#
#			shsetjmp
#
# used in trap.c to make a quick save of a process

shsetjmp:
	mov.l	(%sp)+,%a1	# pop return address of calling routine into %a1
	mov.l	(%sp),%a0	# address of save area
	mov.l	%a1,24(%a0)	# save return address
	mov.l	%sp,48(%a0)	# save stack
	mov.l	%fp,44(%a0)	# save frame ptr
	mov.l	&0,%d0		# return(0)
	jmp	(%a1)


# longjmp (save_area, [value])
#	resets registers from save_area and returns to the location
#	from WHERE setjmp() WAS CALLED.
#	** Never returns 0 - this lets the returned-to environment know that the
#	return was the result of a long jump.

longjmp:
	mov.l	4(%sp),%a0	# get address of save_area
	mov.l	8(%sp),%d0	# value returned
	bne.b	L%long1		# branch if not zero
	mov.l	&1,%d0		# set to one
L%long1:
	movm.l	(%a0),&REGMASK	# restore a7-a1,d7-d2
	jmp	(%a1)



#------------------------------------------------------------------------------
#
#	R  E  S  U  M  E
#
#	input parameters:
#		1.  page descriptor that defines user page
#		2.  address of save area
#		3.  address of user page table pointer
#
#	save area:
#
#	|-----------------------------------------------------------------|
#	| d2 | d3 | d4 | d5 | d6 | d7 | ret | a2 | a3 | a4 | a5 | a6 | a7 |
#	|-----------------------------------------------------------------|
#
#------------------------------------------------------------------------------
# resume (&u, save_area, u_rde)
#	switches to another process's "u" area. Returns non-zero.

resume:
	mov.l	8(%sp),%a0	# address of save_area
	mov.w	%sr,%d0		# save current PS
	or.w	&HIGHPRI,%sr	# inhibit interrupts
	mov.l	4(%sp),uarea_ptbl	# user area page descriptor 
#
#	POTENTIAL RACE CONDITION AT THIS POINT
#	Non maskable interrupts cannot make reference to u area
#	It is not stable at this point.
#
#	The stack is fine since it is still in the own_u_area page
#
	mov.l	12(%sp),urxxt	# reload user root pointer flush TLB
				# we are running new context now
	movm.l	(%a0),&REGMASK	# restore previous a7-a1,d7-d2
	mov.w	%d0,%sr		# restore priority
	mov.l	&1,%d0		# return (1)
	jmp	(%a1)		# return to save caller
