/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) Maddr.c: version 25.1 created on 11/27/91 at 15:00:51	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)Maddr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * Maddr.c -- symbols for system data structures (68020 tables)
 */

#ident	"@(#)uts/ml/M68020:Maddr.c	25.1"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/immu.h"
#include "sys/systm.h"
#include "sys/pfdat.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/map.h"
#include "sys/buf.h"
#include "sys/utsname.h"
#include "sys/tty.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/sbus.h"
#include "sys/sbus_pm.h"
#include "sys/spm_mem.h"
#include "sys/own.h"
#include "sys/lio.h"
#include "sys/kmem.h"
#include "sys/vmem.h"
#include "sys/pm_iomap.h"

/* Ravi: declare this structure in a header file (see build_addr.c) */
struct	kvtab {
	char	*name;
	uint	value;
	uint	alignment;
} kvtab[] = {

	/* USER virtual addresses */
	{"userstack",	UMEM_START + UMEM_SIZE, 0x80000000},

	/* OWN segments */

	{"u",		ADDR_U_STRUCT, 4},
	{"sys_stk_end",	ADDR_U_STRUCT - sizeof(int), 4},
	{"u_caddr_flt",	(uint) &((user_t *)ADDR_U_STRUCT)->u_caddrflt, 4},
	{"u_fpu_control", 
		(uint)&((user_t *)ADDR_U_STRUCT)->u_fpu.regs.control, 4},
	{"u_fpu_data",	(uint) ((user_t *)ADDR_U_STRUCT)->u_fpu.regs.reg, 8},
	{"u_fpu_state",	(uint) ((user_t *)ADDR_U_STRUCT)->u_fpu.fsave, 4},
	{"u_procp",	(uint) &((user_t *)ADDR_U_STRUCT)->u_procp, 4},

	{"own_stbl",	ADDR_OWN_STBL, 4},
	{"own_ptbl",	ADDR_OWN_PTBL, NBPPT},
	{"uarea_ptbl",	ADDR_OWN_PTBL +
		pnum(ADDR_U - ADDR_OWN_SEGS) * sizeof(pde_t), 4},

	/* per processor variables */
	{"own",		ADDR_OWN, 0x1000},
	{"own_runrun",	(uint) &((struct own *)ADDR_OWN)->o_runrun, 1},
	{"own_fpu_type", (uint) &((struct own *)ADDR_OWN)->o_fpu_type, 1},
	{"own_fpu_loaded", (uint) &((struct own *)ADDR_OWN)->o_fpu_loaded, 1},
	{"own_lock_id", (uint) &((struct own *)ADDR_OWN)->o_lock_id, 1},
	{"own_spin_lock_cnt",
		(uint) &((struct own *)ADDR_OWN)->o_spin_lock_cnt, 4},
	{"own_in_tdb", (uint) &((struct own *)ADDR_OWN)->o_tdb.in_tdb, 4},
	{"own_upkern_dec_val",
		(uint) &((struct own *)ADDR_OWN)->o_upkern_dec_val, 4},

	/* per processor u area, used when switching contexts */
	{"own_u",	ADDR_OWN_U_STR, 4},
	{"own_stk_end",	ADDR_OWN_U_STR - sizeof(int), 4},

	/* stream elements moved to spm_mem */
	{"qrunflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->qrunflag, 1},
	{"strbcflag",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strbcflag, 1},
	{"allocb_lock",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->allocb_lock,4},
	{"dballoc",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dballoc, 4},
	{"mbfreelist",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->mbfreelist, 4},
	{"dbfreelist",	(uint)((struct spm_mem *)ADDR_SPM_MEM)->dbfreelist, 4},
	{"strst",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->strst, 4},

	/* KERNEL VIRTUAL SYS segs */

	{"syssegs",	ADDR_SYS_SEGS, 0x90000000}, /* kernel dynamic area */

	/* MEMORY segs */

	{"kmem_start",	KMEM_START, 0x80000000},
	{"spm_mem",	ADDR_SPM_MEM, 0xa0000000},
	{"lbolt",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->lbolt, 4},
	{"time",	(uint)&((struct spm_mem *)ADDR_SPM_MEM)->time, 4},
	{"mem_stbl",	ADDR_MEM_STBL, 4},	/* stbl that describes memory */
	{"bad_ptbl",	ADDR_BAD_PTBL, NBPPT},	/* ptbl of invalid_pde */
	{"bad_stbl",	ADDR_BAD_STBL, 4},	/* user stbl of invalid_sde */

	{"p0_u_area",	ADDR_P0_U_AREA, 4},	/* proc 0's u area */
	{"p0_u",	ADDR_P0_U_STR, 4},	/* proc 0's u structure */

	/* I/O */
	{"urxxt",	(uint)URXXT, 1},	/* reload user rde and flush */

	/* address of a pm's interrupt request register on the bus */
	{"pm_int_req_reg", (KIO_START + 
	  (PM_Int_Req_Reg_Index<<PM_UnmappedBits) + PM_STAT_MIN_BITS), 1},

	/* VALUES FOR INTERRUPT REQUEST REGISTER */
	{"pm_clear_level_one",		PM_CLEAR_LEVEL_ONE, 1},
	{"pm_clear_level_two",		PM_CLEAR_LEVEL_TWO, 1},
	{"pm_clear_level_three",	PM_CLEAR_LEVEL_THREE, 1},
	{"pm_clear_level_four",		PM_CLEAR_LEVEL_FOUR, 1},
	{"pm_clear_level_five",		PM_CLEAR_LEVEL_FIVE, 1},
	{"pm_clear_level_six",		PM_CLEAR_LEVEL_SIX, 1},
	{"pm_clear_level_seven",	PM_CLEAR_LEVEL_SEVEN, 1},

	/* location of upkern structure in spm_mem */
	{"upkern", (uint) &((struct spm_mem *)ADDR_SPM_MEM)->upkern, 4},
	{"o_upkern_init_val",
	  (uint) &((struct own *)ADDR_OWN)->o_upkern_init_val, 4}, 

	/* values for assembler upkern routines to use */
	{"up_wait_bit_short",		UPKERN_WAITING_BIT_SHORT, 4},
	{"up_cnt_long",			UPKERN_CNT_LONG, 4},

	/* proc structure field used by ml/userio.s to check for RFS copy */
	{"p_sysid",	(uint) &((struct proc *)0)->p_sysid, 2},

	/* address of logic analyzer line */
	{"addr_logic_analyzer", (uint) LOGIC_ANALYZER, 1},

	{ 0 }	/* end of list */
};

/*
 * make these symbols undefined to force them to be loaded from the following
 * libraries
 */

char	*undef[] = {
	"M68Kvec",
	"_start",
	"auto1",
	"icode",
	"min",
	"ml_fpu_save",
	"setjmp",
	"spin_lock",
	"splx",
	"sysent",
	"sys_reclock",
	NULL
};
