#	START NEW ARIX SCCS HEADER
#
#	@(#) local.mk: version 25.1 created on 11/27/91 at 15:00:37
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)local.mk	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
VER	=	`/usr/sys/month_day`
NAME	=	arix.$(VER)
ETCDIR	=	/etc
INCRT	=	/usr/include
SGS	=	/bin/
LD	=	$(SGS)ld
CC	=	$(SGS)cc
AS	=	$(SGS)as
#LIB	=	debug/pm
LIB	=	lib
KERNEL	=	$(LIB)/addr.o $(LIB)/lib.ml $(LIB)/lib.os \
		cf/conf.o $(LIB)/lib.s5 $(LIB)/lib.s54k $(LIB)/lib.auth
STUB	=	$(LIB)/lib.stubs
SECOPT	=	SECOFF
#
#	Performance enables.
#	PERF_NOSUCHK will not do superuser check thus allowing anyone
#	to modify performance parameters.
#
PERFOPT	=	-DPERF

LCFLAGS	=	-O -SYSV -D$(SECOPT) $(PERFOPT)
LDFLAGS =	-SYSV

include iolib

all:
	@$(MAKE) -$(MAKEFLAGS) VER=$(VER) rall

install:
	@$(MAKE) -$(MAKEFLAGS) VER=$(VER) rinstall

rall:	arix

init:
	cd cf; $(MAKE) -$(MAKEFLAGS)f localcf.mk \
		LCFLAGS="$(LCFLAGS)" \
		PERFOPT="$(PERFOPT)" SECOPT="$(SECOPT)" \
		VER=$(VER) CC=$(CC) ETCDIR=$(ETCDIR) INCRT=$(INCRT) all

# WARNING, do not change order of link files

arix: init
	@echo Linking kernel...
	$(LD) $(LDFLAGS) -o arix vuifile $(KERNEL) $(IOLIB) $(STUB)
	mcs -d arix
	chmod 444 arix
	chgrp sys arix
	chown root arix
	if /bin/M68040; \
	then \
		./cf/chmagic arix 0523; \
	fi;

rinstall: rall
	cp arix /$(NAME)
	@echo "\n$(NAME) is now installed in the root directory.  Review\n\
	./README for the remainder of the installation procedure."

clean:
	cd cf; $(MAKE) -$(MAKEFLAGS)f $(CFMAKE) clean

clobber:
	cd cf; $(MAKE) -$(MAKEFLAGS)f $(CFMAKE) clobber
	rm -f arix
