#	START NEW ARIX SCCS HEADER
#
#	@(#) lint.mk: version 25.1 created on 11/27/91 at 15:00:34
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)lint.mk	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
# lint Makefile for Checkmate kernel

IROOT=.
PRE_ALL=
POST_ALL=
SHELL	= /bin/sh

MACH	= M68040

include $(IROOT)/$(MACH)/macdefs

#
# lint command
#
# lint options:	-u  suppress complaints about functions and externs used
#		    and not defined, or defined and not used.
#		-v  suppress complaints about unused arguments in functions.
#		-x  do not report variables referred to by external
#		    declarations but never used.
#		-D -U -I  same as for cpp.
#
LINT	= lint -u -x -I$(IROOT)

SGS_ROOT= $(SGS_KERN)
DEBUG=YES
# DEBUGFLAGS=-DASDEBUG=NO
DEBUGFLAGS=-DASDEBUG=YES -DIOPMDEBUG=1

SECOPT=SECOFF
#
#	Performance enables.
#	PERF_NOSUCHK will not do superuser check thus allowing anyone
#	to modify performance parameters.
#
PERFOPT=-DPERF

#
# objects
#

# PB:	do we want   'FPSP_OBJ = ml/$(MACH)/fp/fpu_sim.l'   and have a dummy
#	fpu_sim.l and makefile in M68020/;  or have   'FPSP_OBJ'   defined in
#	the  'macdefs'  files;  or have some  'if'  statements in the rules ?
FPSP_OBJ = ml/M68040/fp/fpu_sim.l

ADDR	= ml/addr.l

ML_OBJS = \
	$(FPSP_OBJ)	   ml/$(MACH)/cas.l    ml/$(MACH)/cswitch.l	\
	ml/$(MACH)/fpu.l   ml/$(MACH)/misc.l   ml/$(MACH)/scb.l		\
	ml/$(MACH)/start.l ml/$(MACH)/trap.l   ml/end.l   ml/math.l

OS_OBJS = \
	os/$(MACH)/buserr.l  os/$(MACH)/machdep.l  os/$(MACH)/trap.l	\
	os/acct.l     os/bio.l    os/bitmasks.l  os/clock.l    os/disp.l \
	os/errlog.l   os/exec.l   os/exit.l      os/fault.l    os/fio.l \
	os/flock.l    os/fork.l   os/fpp.l       os/fstyp.l    os/getpages.l \
	os/grow.l     os/iget.l   os/lock.l      os/locking.l  os/main.l \
	os/malloc.l   os/move.l   os/nami.l      os/nosys2.l   os/page.l \
	os/perf.l     os/physio.l os/pipe.l      os/printf.l   os/probe.l \
	os/region.l   os/sched.l  os/schedbsd.l  os/schedcpu.l os/schedmach.l \
	os/scheds5.l  os/sig.l    os/slp.l       os/space.l    os/startup.l \
	os/streamio.l os/subr.l   os/swapalloc.l os/swtch.l    os/synch.l \
	os/sys2.l     os/sys3.l   os/sys4.l      os/sysarix.l  os/sysent.l \
	os/tdb.l      os/text.l   os/utssys.l

AUTH_OBJS = \
	security/audit.l  security/auth.l  security/mls.l	\
	security/priv.l   security/sat.l   security/sec.l

IO_OBJS	= \
	io/clist.l      io/clone.l    io/cons.l   io/dk.l      io/dtc_int.l \
	io/err.l        io/icb.l      io/ints.l   io/iopm.l    io/iopmb.l \
	io/iopmclone.l  io/iopms.l    io/ipc.l    io/ldterm.l  io/log.l	\
	io/lpmod.l      io/mac.l      io/mem.l    io/mirror.l  io/mpt.l	\
	io/msg.l        io/mt.l       io/nt.l     io/openchk.l io/partab.l \
	io/pm_iomap.l   io/prf.l      io/ptem.l   io/queues.l  io/sar.l	\
	io/sdk.l        io/sem.l      io/shm.l    io/sp.l      io/spmlpdvr.l \
	io/spmty_rtns.l io/spmtydvr.l io/spt.l    io/stream.l  io/sxt.l	\
	io/sys.l        io/timod.l    io/tirdwr.l io/tt0.l     io/tty.l	\
	io/vd.l

GC_OBJS	=  \
	gctty/gc.l   gctty/gclp.l     gctty/gcswitch.l  gctty/gctty.l	\
	gctty/gt0.l  gctty/streamgc.l

S5_OBJS = \
	fs/s5/s5acl.l   fs/s5/s5alloc.l  fs/s5/s5blklist.l  fs/s5/s5iget.l \
	fs/s5/s5nami.l  fs/s5/s5pipe.l   fs/s5/s5rdwri.l    fs/s5/s5subr.l \
	fs/s5/s5sys2.l  fs/s5/s5sys3.l 

S54K_OBJS = \
	fs/s54k/s54kacl.l    fs/s54k/s54kalloc.l  fs/s54k/s54kbio.l	\
	fs/s54k/s54kblklst.l fs/s54k/s54kiget.l   fs/s54k/s54knami.l	\
	fs/s54k/s54kpipe.l   fs/s54k/s54krdwri.l  fs/s54k/s54ksubr.l	\
	fs/s54k/s54ksys2.l   fs/s54k/s54ksys3.l

RFS_OBJS = \
	ml/$(MACH)/useriorfs.l	\
	fs/du/duiget.l   fs/du/durdwri.l  fs/du/dusubr.l   fs/du/dusys3.l \
	nudnix/adv.l     nudnix/auth.l    nudnix/cache.l   nudnix/canon.l \
	nudnix/cirmgr.l  nudnix/comm.l    nudnix/fileop.l  nudnix/fumount.l \
	nudnix/netboot.l nudnix/que.l     nudnix/queue.l   nudnix/rbio.l \
	nudnix/rdebug.l  nudnix/recover.l nudnix/remcall.l nudnix/rfadmin.l \
	nudnix/rfcanon.l nudnix/rfsys.l   nudnix/rmount.l  nudnix/rmove.l \
	nudnix/rnami.l   nudnix/rsc.l     nudnix/serve.l

STUBS_OBJS = \
	ml/$(MACH)/userio.l	\
	ml/reclock.l		\
	nudnix/rstubs.l		\
	io/gcbsc_stub.l io/gcsdlcstub.l io/gcsna_stub.l	\
	os/nfsbio.l os/nfsifind.l os/nfsincore.l os/nfsiowait.l os/nfsnavail.l

SYS_OBJS = \
	acct.l acl.l adv.l audit.l bitmasks.l buf.l bufstat.l callo.l	\
	cir_log.l cirmgr.l clock.l cmn_err.l comm.l conf.l config.l	\
	crtctl.l debug.l debuglog.l dir.l dirent.l dk.l dtreq.l elog.l	\
	erec.l err.l errno.l fblk.l fcntl.l file.l flock.l fpu.l fsid.l	\
	fstyp.l gc.l gcatty.l gcbsc.l gclp.l gcsna.l gctio.l gctty.l	\
	gctty_map.l gdpstr.l getpages.l hetero.l icb.l idtab.l ilp.l	\
	ilp_clog.l immu.l inittab.l ino.l inode.l ints.l iobuf.l ioctl.l \
	iopm_mmu.l iopmbuf.l iopmcomm.l iopmdebug.l iopmioctl.l	\
	iopmsltbl.l iopmstream.l ipc.l iqueue.l jioctl.l kmem.l ldterm.l \
	lihdr.l lio.l lock.l locking.l log.l login_ext.l lpm.l lpm_clog.l \
	lprio.l mac.l map.l message.l mfs.l mls.l mlsfiles.l mount.l	\
	ms_lp.l msg.l mspt.l mt.l mtpr.l nami.l nserve.l open.l opt.l	\
	own.l param.l perf.l perfext.l pfdat.l phinf.l pm_iomap.l poll.l \
	priv.l proc.l psl.l ptem.l pwrf.l que.l rbuf.l rdebug.l recover.l \
	reg.l region.l rfsys.l rtb.l sakioctl.l satmap.l sbus.l sbus_iopm.l \
	sbus_pm.l sbus_spm.l schedcpu.l schedext.l security.l sem.l sema.l \
	shm.l signal.l spl.l spm_lp.l spm_mem.l st.l stat.l state.l statfs.l \
	stdio.l stermio.l stream.l strlog.l stropts.l strstat.l swap.l	\
	sxt.l synch.l sysarix.l sysinfo.l sysmacros.l systm.l tdb.l	\
	termio.l termios.l tihdr.l time.l times.l timod.l tiuser.l trace.l \
	trap.l ttold.l tty.l tuneable.l tyd_clog.l tyd_sram.l tyd_tty.l	\
	tyd_uart.l tym_cirlog.l tym_clog.l tym_tty.l types.l uadmin.l	\
	upkern.l user.l ustat.l utsname.l var.l vd.l vmem.l vreg.l wait.l

all: 	os_files io_files

os_files:	$(OS_OBJS) 

auth_files:	$(AUTH_OBJS)

s5_files:	$(S5_OBJS)

ml_files:	$(ML_OBJS)

io_files:	$(IO_OBJS)

rfs_files:	$(RFS_OBJS)

s54k_files:	$(S54K_OBJS)

stubs_files:	$(STUBS_OBJS)

gc_files:	$(GC_OBJS)

sys_files:	$(SYS_OBJS)

$(SYS_OBJS):
	cd sys; exec $(LINT) $(CFLAGS) $(<F).h

.SUFFIX =	.o .c .y .l .s .i

.c.l:
	cd $(<D); exec $(LINT) $(CFLAGS) $(<F)

.s.l:
	cd $(<D); exec $(LINT) $(CFLAGS) $(<F)

#.h.l:
#	cd $(<D); exec $(LINT) $(CFLAGS) $(<F)
