/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) tt0.c: version 25.1 created on 11/27/91 at 15:00:16	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)tt0.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#)tt0.c	2.1	*/

/*
 * Line discipline 0
 * Includes Terminal Handling
 */

#include "sys/param.h"
#include "sys/types.h"
#include "sys/systm.h"
#include "sys/conf.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/proc.h"
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/termio.h"
#include "sys/crtctl.h"
#include "sys/sysinfo.h"
#include "sys/spl.h"
#include "sys/own.h"
#include "sys/debug.h"

extern char partab[];

char colsave, rowsave;		/* temp save for high queue restore */
struct clist tempq;		/* temp for echo during high queue  */

/*
 * routine called on first teletype open.
 * establishes a process group for distribution
 * of quits and interrupts from the tty.
 */
ttopen(tp, flag)
register struct tty *tp;
{
	register struct proc *pp;

	pp = u.u_procp;

	/* JTOF - reorganize this to pass open tests properly  
	          also, I think Pete wants to remove the session leader 
	          restriction so I'll take a stab at it. The logic goes
	          like this:
		  if the proc has no ctty and 
	             the tty ain't a ctty and
	             the proc can take a ctty then
				if he's a group leader (not session!) 
					give'm the ctty
        */ 
	if ( (! u.u_ttyp) && ( ! tp->t_pgrp ) && (! (flag & FNOCTTY)) ) {
		if ( pp->p_session_id == pp->p_pid ) { 
			u.u_ttyp = &tp->t_pgrp;
			tp->t_pgrp = pp->p_pgrp;
			pp->p_my_tty = (uint)tp;
		}
	}
	ttioctl(tp, LDOPEN, 0, 0);
	tp->t_state &= ~WOPEN;
	tp->t_state |= ISOPEN;
}

ttclose(tp)
register struct tty *tp;
{
	if ((tp->t_state&ISOPEN) == 0)
		return;
	ttioctl(tp, LDCLOSE, 0, 0);
	tp->t_state &= ~ISOPEN;
	tp->t_pgrp = 0;
	u.u_ttyp = 0;
	u.u_ttyd = 0;
	u.u_procp->p_my_tty = 0;
}

/*
 * Called from device's read routine after it has
 * calculated the tty-structure given as argument.
 */
ttread(tp)
register struct tty *tp;
{
	register struct clist *tq;
	register cswtch;

	tq = &tp->t_canq;
	/*
	 * Job control checks.
	 */
	if (ttreadjobchk(u.u_procp,tp,SIGTTIN))
		return (0);
	if (tq->c_cc == 0)
		cswtch = canon(tp);
	while (u.u_count!=0 && u.u_error==0) {
		if (u.u_count >= CLSIZE) {
			register n;
			register struct cblock *cp;

			if ((cp = getcb(tq)) == NULL)
				break;
			n = min(u.u_count, cp->c_last - cp->c_first);
			if (copyout(&cp->c_data[cp->c_first], u.u_base, n))
				u.u_error = EFAULT;
			putcf(cp);
			u.u_base += n;
			u.u_count -= n;
		} else {
			register c;

			if ((c = getc(tq)) < 0)
				break;
			if (subyte(u.u_base++, c))
				u.u_error = EFAULT;
			u.u_count--;
		}
	}
	if (tp->t_state&TBLOCK) {
		if (tp->t_rawq.c_cc<TTXOLO) {
			(*tp->t_proc)(tp, T_UNBLOCK);
		}
	}
	return( cswtch );
}

/*
 * Called from device's write routine after it has
 * calculated the tty-structure given as argument.
 */

ttwrite(tp)
register struct tty *tp;
{
	int hqflag;
	int col, row;

qwait:
	/* the carrier-on check used to be after the while loop */
	if ( !(tp->t_state & CARR_ON) )
		return;
	fspl4();
	while(tp->t_tmflag & QLOCKB) {
		tp->t_state |= OASLP;
		sleep((caddr_t)&tp->t_outq, TTOPRI);
		/*
		 * Job control checks.
		 */
		if (ttwritejobchk(u.u_procp,tp,SIGTTOU)) {
			fspl0();
			return;
		}
	}
	fspl0();
	/*
	 * Job control checks.
	 */
	if (ttwritejobchk(u.u_procp,tp,SIGTTOU))
		return;
	hqflag = 0;
	while (u.u_count) {
		if (tp->t_outq.c_cc > tthiwat[tp->t_cflag&CBAUD]) {
			if (hqflag) {
				col = tp->t_col;
				row = tp->t_row;
				hqrelse(tp);
			}
			fspl4();
			(*tp->t_proc)(tp, T_OUTPUT);
			while (tp->t_outq.c_cc > tthiwat[tp->t_cflag&CBAUD]) {
				tp->t_state |= OASLP;
				if (sleep((caddr_t)&tp->t_outq,
					hqflag ? PZERO : (TTOPRI|PCATCH))) {
					fspl0();
					goto out;
				}
				/*
				 * Job control checks.
				 */
				if (ttwritejobchk(u.u_procp,tp,SIGTTOU)) {
					tp->t_tmflag &= ~(QLOCKB|QLOCKI);
					fspl0();
					return;	/* don't go to out */
				}
			}
			fspl0();
			if (hqflag) {
				tp->t_tmflag |= QLOCKI;
				colsave = tp->t_col;
				rowsave = tp->t_row;
				ttyctl(LCA, tp, col, row);
				continue;
			}
			if (tp->t_tmflag & QLOCKB)
				goto qwait;
		}
		if (u.u_count >= (CLSIZE/2) && tp->t_term == 0) {
			register n;
			register struct cblock *cp;

			if ((cp = getcf()) == NULL)
				break;
			n = min(u.u_count, cp->c_last);
			if (copyin(u.u_base, cp->c_data, n)) {
				u.u_error = EFAULT;
				putcf(cp);
				break;
			}
			u.u_base += n;
			u.u_count -= n;
			cp->c_last = n;
			ttxput(tp, cp, n);
		} else {
			register c;

			c = fubyte(u.u_base++);
			if (c<0) {
				u.u_error = EFAULT;
				break;
			}
			u.u_count--;
			if (c == ESC && tp->t_term) {
				switch (c = cpass()) {
					int col;

				case -1:
					continue;
				case ESC:
					goto norm;
				case HIQ:
					if (hqflag++)
						continue;
					tp->t_tmflag |= QLOCKB|QLOCKI;
					tp->t_hqcnt++;
					colsave = tp->t_col;
					rowsave = tp->t_row;
					continue;
				case LCA:
				case SVID:
				case DVID:
				case CVID:
					col = cpass();
				default:
					ttyctl(c, tp, col, c==LCA ? cpass() : 0);
				}
			} else {
norm:
				ttxput(tp, c, 0);
			}
		}
	}
	if (hqflag) {
		hqrelse(tp);
		putc(QESC, &tp->t_outq);
		putc(HQEND, &tp->t_outq);
		fspl4();
		if (tp->t_state & OASLP) {
			tp->t_state &= ~OASLP;
			wakeup((caddr_t)&tp->t_outq);
		}
		fspl0();
	}
out:
	tp->t_tmflag &= ~(QLOCKB|QLOCKI);
	fspl4();
	(*tp->t_proc)(tp, T_OUTPUT);
	fspl0();
}

/*
 * Place a character on raw TTY input queue, putting in delimiters
 * and waking up top half as needed.
 * Also echo if required.
 */
#define	LCLESC	0400

ttin(tp)
register struct tty *tp;
{
	register c;
	register flg, cswtch;
	register char *cp;
	ushort nchar, nc;

	nchar = tp->t_rbuf.c_size - tp->t_rbuf.c_count;
	/* reinit rx control block */
	tp->t_rbuf.c_count = tp->t_rbuf.c_size;
	if (nchar==0)
		return( 0 );
	flg = tp->t_iflag;
	/* KMC does all but IXOFF */
	if (tp->t_state&EXTPROC)
		flg &= IXOFF;
	nc = nchar;
	cp = tp->t_rbuf.c_ptr;
	if (nc < cfreelist.c_size || (flg & (INLCR|IGNCR|ICRNL|IUCLC))
		|| tp->t_term) {
			/* must do per character processing */
		for ( ;nc--; cp++) {
			c = *cp;
			if (tp->t_term) {
				c &= 0177;
				if ((c = (*termsw[tp->t_term].t_input) (c,tp))
					== -1)
					continue;
				if (c & CPRES) {
					putc(ESC, &tp->t_rawq);
					putc(c, &tp->t_rawq);
					continue;
				}
			}
			if (c == '\n' && flg&INLCR)
				*cp = c = '\r';
			else if (c == '\r')
				if (flg&IGNCR)
					continue;
				else if (flg&ICRNL)
					*cp = c = '\n';
			if (flg&IUCLC && 'A' <= c && c <= 'Z')
				c += 'a' - 'A';
			if (putc(c, &tp->t_rawq))
				continue;
			atom_inc(&sysinfo.rawch);
		}
		cp = tp->t_rbuf.c_ptr;
	} else {
		/* may do block processing */
		putcb(CMATCH((struct cblock *)cp), &tp->t_rawq);
		atom_add(&sysinfo.rawch, nc);
		/* allocate new rx buffer */
		if ((tp->t_rbuf.c_ptr = getcf()->c_data)
			== ((struct cblock *)NULL)->c_data) {
			tp->t_rbuf.c_ptr = NULL;
			return( 0 );
		}
		tp->t_rbuf.c_count = cfreelist.c_size;
		tp->t_rbuf.c_size = cfreelist.c_size;
	}


	if (tp->t_rawq.c_cc > TTXOHI) {
		if (flg&IXOFF && !(tp->t_state&TBLOCK))
			(*tp->t_proc)(tp, T_BLOCK);
		if (tp->t_rawq.c_cc > TTYHOG) {
			ttyflush(tp, FREAD);
			return( 0 );
		}
	}
	flg = tp->t_lflag;
	flg &= ~NOFLSH;
	if (tp->t_outq.c_cc > (tthiwat[tp->t_cflag&CBAUD] + TTECHI))
		flg &= ~(ECHO|ECHOK|ECHONL|ECHOE);
	cswtch = 0;
	if (flg) while (nchar--) {
		c = *cp++;
		if (flg&ISIG) {
			if (c == tp->t_cc[VINTR]) {
				signal(tp->t_pgrp, SIGINT);
				if (!(flg&NOFLSH) && tp->t_hqcnt==0)
					ttyflush(tp, (FREAD|FWRITE));
				continue;
			}
			if (c == tp->t_cc[VQUIT]) {
				signal(tp->t_pgrp, SIGQUIT);
				if (!(flg&NOFLSH) && tp->t_hqcnt==0)
					ttyflush(tp, (FREAD|FWRITE));
				continue;
			}
			if( c == tp->t_cc[VSUSP] ) {
				if (!(flg&NOFLSH) && tp->t_hqcnt==0)
					ttyflush(tp, (FREAD|FWRITE));
				signal(tp->t_pgrp,SIGTSTP);
				continue;
			}
		}
		if (flg&ICANON) {
			if (tp->t_state&CLESC) {
				flg |= LCLESC;
				tp->t_state &= ~CLESC;
			}
			if (c == '\n') {
				if (flg&ECHONL)
					flg |= ECHO;
				tp->t_delct++;
			} else if (c == '\\') {
				tp->t_state |= CLESC;
				if (flg&XCASE) {
					c |= QESC;
					if (flg&LCLESC)
						tp->t_state &= ~CLESC;
				}
			} else if (c == tp->t_cc[VEOL] || c == tp->t_cc[VEOL2])
				tp->t_delct++;
			else if (!(flg&LCLESC)) {
				if (c == tp->t_cc[VERASE] && flg&ECHOE) {
					if (flg&ECHO)
						ttxputi(tp, '\b');
					flg |= ECHO;
					ttxputi(tp, ' ');
					c = '\b';
				} else if (c == tp->t_cc[VKILL] && flg&ECHOK) {
					if (flg&ECHO)
						ttxputi(tp, c);
					flg |= ECHO;
					c = '\n';
				} else if( c == tp->t_cc[VEOF] ) {
					flg &= ~ECHO;
					tp->t_delct++;
				}
			}
		}
		if (flg&ECHO) {
			ttxputi(tp, c);
			(*tp->t_proc)(tp, T_OUTPUT);
		}
	}
	if (!(flg&ICANON)) {
		tp->t_state &= ~RTO;
		if (tp->t_rawq.c_cc >= tp->t_cc[VMIN])
			tp->t_delct = 1;
		else if (tp->t_cc[VTIME]) {
			if (!(tp->t_state&TACT))
				tttimeo(tp);
		}
	}
	if (tp->t_delct && (tp->t_state&IASLP)) {
		tp->t_state &= ~IASLP;
		wakeup((caddr_t)&tp->t_rawq);
	}
	return( cswtch );
}

/*
 * Interrupt interface to ttxput.
 * Checks for High Queue write in progress, and saves characters to be echoed.
 */
ttxputi(tp, c)
register struct tty *tp;
{
	if (tp->t_tmflag & QLOCKI) {
		putc(c,&tempq);
		return;
	} else
		ttxput(tp, c, 0);
}

/*
 * Put character(s) on TTY output queue, adding delays,
 * expanding tabs, and handling the CR/NL bit.
 * It is called both from the base level for output, and from
 * interrupt level for echoing.
 */
ttxput(tp, x, ncode)
register struct tty *tp;
unsigned int x;
{
	register c;
	register flg;
	register unsigned char *cp;
	register char *colp;
	int ctype;
	int cs;
	struct cblock *scf;
	union {
		unsigned int ch;
		struct cblock *ptr;
	} ucp;
	ucp.ch = x;

	/* KMC does all but XCASE, virt term needs CR info for t_col */
	if (tp->t_state&EXTPROC) {
		if (tp->t_term || tp->t_lflag&XCASE)
			flg = tp->t_oflag&(OPOST|OLCUC|ONLRET|ONLCR);
		else
			flg = 0;
	} else
		flg = tp->t_oflag;
	if (ncode == 0) {
		ncode++;
		if (!(flg&OPOST)) {
			atom_inc(&sysinfo.outch);
			putc(ucp.ch, &tp->t_outq);
			return;
		}
		/* WARNING! PORT problem in vax sys 5 source */
		cp = (unsigned char *)&(lobyte(loword(ucp.ch)));
		scf = NULL;
	} else {
		if (!(flg&OPOST)) {
			atom_add(&sysinfo.outch, ncode);
			putcb(ucp.ptr, &tp->t_outq);
			return;
		}
		cp = (unsigned char *)&ucp.ptr->c_data[ucp.ptr->c_first];
		scf = ucp.ptr;
	}
	while (ncode--) {
		c = *cp++;
		if (c >= 0200) {
	/* spl5-0 */
			if (c == QESC && !(tp->t_state&EXTPROC))
				putc(QESC, &tp->t_outq);
			atom_inc(&sysinfo.outch);
			putc(c, &tp->t_outq);
			continue;
		}
		/*
		 * Generate escapes for upper-case-only terminals.
		 */
		if (tp->t_lflag&XCASE) {
			colp = "({)}!|^~'`\\\\";
			while(*colp++)
				if (c == *colp++) {
					ttxput(tp, '\\'|0200, 0);
					c = colp[-2];
					break;
				}
			if ('A' <= c && c <= 'Z')
				ttxput(tp, '\\'|0200, 0);
		}
		if (flg&OLCUC && 'a' <= c && c <= 'z')
			c += 'A' - 'a';
		cs = c;
		/*
		 * Calculate delays.
		 * The numbers here represent clock ticks
		 * and are not necessarily optimal for all terminals.
		 * The delays are indicated by characters above 0200.
		 */
		ctype = partab[c];
		colp = &tp->t_col;
		c = 0;
		switch (ctype&077) {

		case 0:	/* ordinary */
			(*colp)++;

		case 1:	/* non-printing */
			break;

		case 2:	/* backspace */
			if (flg&BSDLY)
				c = 2;
			if (*colp)
				(*colp)--;
			break;

		case 3:	/* line feed */
top:
			if (tp->t_term) {
				if (tp->t_vrow && tp->t_row >= tp->t_lrow) {
					ttyctl(UVSCN, tp);
					continue;
				}
				if (tp->t_tmflag & SNL) {
					ttyctl(NL, tp);
					continue;
				}
			}
			if (flg&ONLRET)
				goto cr;
			if (tp->t_row < tp->t_lrow)
				tp->t_row++;
			if (flg&ONLCR) {
				if ((!(tp->t_state&EXTPROC)) &&
					!(flg&ONOCR && *colp==0)) {
					atom_inc(&sysinfo.outch);
					putc('\r', &tp->t_outq);
				}
				goto cr;
			}
		nl:
			if (flg&NLDLY)
				c = 5;
			break;

		case 4:	/* tab */
			c = 8 - ((*colp)&07);
			*colp += c;
			if (!(tp->t_state&EXTPROC)) {
				ctype = flg&TABDLY;
				if (ctype == TAB0) {
					c = 0;
				} else if (ctype == TAB1) {
					if (c < 5)
						c = 0;
				} else if (ctype == TAB2) {
					c = 2;
				} else if (ctype == TAB3) {
					atom_add(&sysinfo.outch, c);
					do
						putc(' ', &tp->t_outq);
					while (--c);
					continue;
				}
			}
			break;

		case 5:	/* vertical tab */
			if (flg&VTDLY)
				c = 0177;
			break;

		case 6:	/* carriage return */
			if (flg&OCRNL) {
				cs = '\n';
				goto nl;
			}
			if (flg&ONOCR && *colp == 0)
				continue;
		cr:
			if (!(tp->t_state&EXTPROC)) {
				ctype = flg&CRDLY;
				if (ctype == CR1) {
					if (*colp)
						c = max((*colp>>4) + 3, 6);
				} else if (ctype == CR2) {
					c = 5;
				} else if (ctype == CR3) {
					c = 9;
				}
			}
			*colp = 0;
			break;

		case 7:	/* form feed */
			if (flg&FFDLY)
				c = 0177;
			break;
		}
		atom_inc(&sysinfo.outch);
		if (tp->t_term && *colp >= 80 && tp->t_row >= tp->t_lrow
			&& tp->t_tmflag & LCF) {
			ttyctl(VHOME, tp);
			ttyctl(DL, tp);
			ttyctl(LCA, tp, 79, tp->t_lrow-1);
			(*colp)++;
		}
                if (tp->t_term==0)
			putc(cs, &tp->t_outq);
		else
			qputc(cs, &tp->t_outq);
		if (!(tp->t_state&EXTPROC)) {
			if (c) {
				if ((c < 32) && flg&OFILL) {
					if (flg&OFDEL)
						cs = 0177;
					else
						cs = 0;
					putc(cs, &tp->t_outq);
					if (c > 3)
						putc(cs, &tp->t_outq);
				} else {
					putc(QESC, &tp->t_outq);
					putc(c|0200, &tp->t_outq);
				}
			}
		}
		if (*colp >= 80 && tp->t_term && tp->t_tmflag&ANL)
			if (tp->t_tmflag&LCF)
				ttyctl(LCA, tp, 0, tp->t_row+1);
			else {
				if ((flg&ONLCR) == 0)
					ttxputi(tp,'\r');
				cs = '\n';
				goto top;
			}
	}
	if (scf != NULL)
		putcf(scf);
}

/*
 * Get next packet from output queue.
 * Called from xmit interrupt complete.
 */

ttout(tp)
register struct tty *tp;
{
	register struct ccblock *tbuf;
	register c;
	register char *cptr;
	register retval;
	static char esc_char=0;

	extern ttrstrt();

	if (tp->t_state&TTIOW && tp->t_outq.c_cc==0) {
		tp->t_state &= ~TTIOW;
		wakeup((caddr_t)&tp->t_oflag);
	}
delay:
	tbuf = &tp->t_tbuf;
	if (esc_char) {
		if (tbuf->c_ptr) {
			putcf(CMATCH((struct cblock *)tbuf->c_ptr));
			tbuf->c_ptr = NULL;
		}
		tp->t_state |= TIMEOUT;
		timeout(ttrstrt, tp, (esc_char&0177)+6);
		esc_char = 0;
		return(0);
	}
	retval = 0;
	if (((tp->t_state&EXTPROC) || (!(tp->t_oflag&OPOST))) &&
		tp->t_term==0) {
		if (tbuf->c_ptr)
			putcf(CMATCH((struct cblock *)tbuf->c_ptr));
		if ((tbuf->c_ptr = (char *)getcb(&tp->t_outq)) == NULL)
			return(0);
		tbuf->c_count = ((struct cblock *)tbuf->c_ptr)->c_last -
				((struct cblock *)tbuf->c_ptr)->c_first;
		tbuf->c_size = tbuf->c_count;
		tbuf->c_ptr = &((struct cblock *)tbuf->c_ptr)->c_data
				[((struct cblock *)tbuf->c_ptr)->c_first];
		retval = CPRES;
	} else {			/* watch for timing	*/
		if (tbuf->c_ptr == NULL) {
			if ((tbuf->c_ptr = getcf()->c_data)
				== ((struct cblock *)NULL)->c_data) {
				tbuf->c_ptr = NULL;
				return(0);	/* Add restart? */
			}
		}
		tbuf->c_count = 0;
		cptr = tbuf->c_ptr;
		while ((c=getc(&tp->t_outq)) >= 0) {
			if (c == QESC) {
				if ((c = getc(&tp->t_outq)) < 0)
					break;
				if (c == HQEND) {
					if (tp->t_term)
						tp->t_hqcnt--;
					continue;
				}
				if (c > 0200 && !(tp->t_state&EXTPROC)) {
					esc_char = c;
					if (!retval)
						goto delay;
					break;
				}
			}
			retval = CPRES;
			*cptr++ = c;
			tbuf->c_count++;
			if (tbuf->c_count >= cfreelist.c_size)
				break;
		}
		tbuf->c_size = tbuf->c_count;
	}

	if (tp->t_state&OASLP &&
		tp->t_outq.c_cc<=ttlowat[tp->t_cflag&CBAUD]) {
		tp->t_state &= ~OASLP;
		wakeup((caddr_t)&tp->t_outq);
	}
	return(retval);
}

tttimeo(tp)
register struct tty *tp;
{
	tp->t_state &= ~TACT;
	if (tp->t_lflag&ICANON || tp->t_cc[VTIME] == 0)
		return;
	if (tp->t_rawq.c_cc == 0 && tp->t_cc[VMIN])
		return;
	if (tp->t_state&RTO) {
		tp->t_delct = 1;
		if (tp->t_state&IASLP) {
			tp->t_state &= ~IASLP;
			wakeup((caddr_t)&tp->t_rawq);
		}
	} else {
		tp->t_state |= RTO|TACT;
		timeout(tttimeo, tp, tp->t_cc[VTIME]*(HZ/10));
	}
}

/*
 * I/O control interface
 */
ttioctl(tp, cmd, arg, mode)
register struct tty *tp;
{
	ushort	chg;
	struct termcb termblk;

	switch(cmd) {
	case LDOPEN:
		if (tp->t_rbuf.c_ptr == NULL) {
			/* allocate RX buffer */
			while((tp->t_rbuf.c_ptr = getcf()->c_data)
				== ((struct cblock *)NULL)->c_data) {
				tp->t_rbuf.c_ptr = NULL;
				cfreelist.c_flag = 1;
				sleep(&cfreelist, TTOPRI);
				/*
				 * Job control checks.
				 */
				if (ttioctljobchk(u.u_procp,tp,SIGTTOU))
					return;
			}
			tp->t_rbuf.c_count = cfreelist.c_size;
			tp->t_rbuf.c_size  = cfreelist.c_size;
			(*tp->t_proc)(tp, T_INPUT);	/* null operation */
		}
		break;

	case LDCLOSE:
		fspl4();
		(*tp->t_proc)(tp, T_RESUME);
		fspl0();
		ttywait(tp);
		txbufwait(tp);
		ttyflush(tp, (FREAD|FWRITE));
		if (tp->t_tbuf.c_ptr) {
			putcf(CMATCH((struct cblock *)tp->t_tbuf.c_ptr));
			tp->t_tbuf.c_ptr = NULL;
			tp->t_tbuf.c_count = 0;
			tp->t_tbuf.c_size = 0;
		}
		if (tp->t_rbuf.c_ptr) {
			putcf(CMATCH((struct cblock *)tp->t_rbuf.c_ptr));
			tp->t_rbuf.c_ptr = NULL;
			tp->t_rbuf.c_count = 0;
			tp->t_rbuf.c_size = 0;
		}
		tp->t_tmflag = 0;
		break;

	case LDCHG:
		chg = tp->t_lflag^arg;
		if (!(chg&ICANON))
			break;
		fspl4();
		if (tp->t_canq.c_cc) {
			if (tp->t_rawq.c_cc) {
				tp->t_canq.c_cc += tp->t_rawq.c_cc;
				tp->t_canq.c_cl->c_next = tp->t_rawq.c_cf;
				tp->t_canq.c_cl = tp->t_rawq.c_cl;
			}
			tp->t_rawq = tp->t_canq;
			tp->t_canq = ttnulq;
		}
		tp->t_delct = tp->t_rawq.c_cc;
		fspl0();
		break;

	case LDGETT:
		termblk.st_flgs = tp->t_tmflag;
		termblk.st_termt = tp->t_term;
		termblk.st_crow = tp->t_row;
		termblk.st_ccol = tp->t_col;
		termblk.st_vrow = tp->t_vrow;
		termblk.st_lrow = tp->t_lrow;
		if (copyout((caddr_t)&termblk, arg, sizeof(termblk)))
			u.u_error = EFAULT;
		break;

	case LDSETT:
		if (copyin(arg, (caddr_t)&termblk, sizeof(termblk))) {
			u.u_error = EFAULT;
			break;
		}
		if ((unsigned)termblk.st_termt >= termcnt) {
			u.u_error = ENXIO;
			break;
		}
		if (termblk.st_termt) {
			(*termsw[termblk.st_termt].t_ioctl)
			    (tp,
			    tp->t_term==termblk.st_termt ? LDCHG : LDOPEN,
			    termblk.st_vrow);
			if (u.u_error)
				break;
			tp->t_vrow = termblk.st_vrow;
			tp->t_term = termblk.st_termt;
			if (termblk.st_flgs&TM_SET)
				tp->t_tmflag = termblk.st_flgs & ~TM_SET;
		} else {
			tp->t_term = 0;
		}
		tp->t_state &= ~CLESC;
		break;

	default:
		break;
	}
}

/************** ADDITIONS FOR TERMINAL HANDLERS **********************/

/*
 * release the high priority queue for interrupts.
 * copy over any received characters while queue was locked.
 */
hqrelse(tp)
register struct tty *tp;
{
	register c;

	ttyctl(LCA, tp, colsave, rowsave);
	fspl4();
	while((c = getc(&tempq)) >= 0)
		ttxput(tp, c, 0);
	tp->t_tmflag &= ~QLOCKI;
	fspl0();
}


/*
 * put a character on the output queue,
 * checking first to see if it is a ESC.
 */
qputc(c, qp)
register c;
register qp;
{
	if (c == ESC)
		putc(c, qp);
	putc(c, qp);
}

/* simulate Up Variable SCreeN as common routine */
ttuvscn(tp)
register struct tty *tp;
{
	ttyctl(VHOME, tp);
	ttyctl(DL, tp);
	ttyctl(LCA, tp, 0, tp->t_lrow);
}

/* simulate Down Variable SCreeN as common routine */
ttdvscn(tp)
register struct tty *tp;
{
	ttyctl(VHOME, tp);
	ttyctl(IL, tp);
}

char colpres, rowpres;

ttyctl(ac, tp, acol, arow)
register struct tty *tp;
{
	register char *colp;
	register c;
	int sps;

	c = ac;
	colp = &tp->t_col;
	sps = spl4();

	colpres = *colp;
	rowpres = tp->t_row;
	switch(c) {
	case CUP:
	case DSCRL:
		if (tp->t_row == 0)
			goto out;
		tp->t_row--;
		break;
	case CDN:
	case USCRL:
		if (tp->t_row >= tp->t_lrow)
			goto out;
		tp->t_row++;
		break;
	case UVSCN:
		*colp = 0;
		tp->t_row = tp->t_lrow;
		break;
	case DVSCN:
		*colp = 0;
		tp->t_row = tp->t_vrow;
		break;
	case CRI:
	case STB:
	case SPB:
		if (*colp >= 79)
			goto out;
		(*colp)++;
		break;
	case CLE:
		if (*colp == 0)
			goto out;
		(*colp)--;
		break;
	case HOME:
	case CS:
	case CM:
		tp->t_row = 0;
	case DL:
	case IL:
		*colp = 0;
		break;
	case VHOME:
		*colp = 0;
		tp->t_row = tp->t_vrow;
		c = LCA;
		break;
	case LCA:
		*colp = acol;
		tp->t_row = arow;
		break;
	case ASEG:
		tp->t_row = (tp->t_row+24)%(tp->t_lrow+1);
		break;
	case NL:
		if (tp->t_row < tp->t_lrow)
			tp->t_row++;
	case CRTN:
		*colp = 0;
		break;
	case SVID:
		tp->t_dstat |= acol;
		c = DVID;
		break;
	case CVID:
		tp->t_dstat &= ~acol;
		c = DVID;
		break;
	case DVID:
		tp->t_dstat = acol;
		break;
	}
	(*termsw[tp->t_term].t_output)(c, tp);
    out:
	splx(sps);
}

txbufwait(tp)
register struct tty *tp;
{
	if ( !(tp->t_state & CARR_ON) )
		return;
	spl_console();
	while (tp->t_tbuf.c_count || (tp->t_state&(BUSY|TIMEOUT))) {
		tp->t_state |= TTIOW;
		sleep((caddr_t)&tp->t_oflag, TTOPRI);
		/*
		 * Job control checks.
		 */
		if (ttioctljobchk(u.u_procp,tp,SIGTTOU)) {
			fspl0();
			return;
		}
	}
	fspl0();
}

/*
 * This was added for POSIX job control. Any process that is running
 * in the background and tries to read from the controlling terminal,
 * must be sent a stop signal unless it is either ignoring or blocking
 * the signal or the process is orphaned.  In this case EIO is set and
 * an error is sent to the calling process.
 * If we were catching TTIN signal and we have a handler for it
 * then after we come back from the handler we want to do a longjmp
 * so that we get an EINTR from the read system call if nothing
 * was transferred.
 * RETURN VALUES:
 *	0	if processing can continue
 *	1	if job control signal is not allowed (return EIO)
 *	longjmp	if there is a signal handler assigned
 */
ttreadjobchk(p,tp,sig)
register struct	proc	*p;
register struct	tty	*tp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != tp->t_pgrp) && (p->p_my_tty == (uint)(tp))) {
		if ((sigval == SIG_IGN) || (p->p_hold & sigbit(sig)) ||
				isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		}
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}

/*
 * This was added for POSIX job control. Any process that is running
 * in the background and tries to write to the controlling terminal,
 * must be sent a stop signal if the TOSTOP bit is set unless it is 
 * either ignoring or blocking the signal or the process is orphaned. 
 * In this case EIO is set and an error is sent to the calling process.
 * If we were catching TTOU signal and we have a handler for it
 * then after we come back from the handler we want to do a longjmp
 * so that we get an EINTR from the write system call if nothing
 * was transferred.
 * RETURN VALUES:
 *	0	if processing can continue
 *	1	if job control signal is not allowed (return EIO)
 *	longjmp	if there is a signal handler assigned
 */
ttwritejobchk(p,tp,sig)
register struct	proc	*p;
register struct	tty	*tp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != tp->t_pgrp) && (p->p_my_tty == (uint)(tp)) &&
	    (tp->t_lflag & TOSTOP) && (sigval != SIG_IGN) &&
	    !(p->p_hold & sigbit(sig))) {
		if (isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		} 
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}

ttioctljobchk(p,tp,sig)
register struct	proc	*p;
register struct	tty	*tp;
register unsigned	sig;
{
	void	(*sigval)();	/* disposition of signals	*/

	ASSERT(sig > 0);
	if(!(IS_JOBC_PROC(p)))
		return (0);
	sigval = u.u_signal[sig-1];
	if ((p->p_pgrp != tp->t_pgrp) && (p->p_my_tty == (uint)(tp)) &&
	    (sigval != SIG_IGN) && !(p->p_hold & sigbit(sig))) {
		if (isorphaned(p,FORREAL)) {
			u.u_error = EIO;
			return (1);
		} 
		signal(p->p_pgrp,sig);
		if (sigval > SIG_HOLD)
			longjmp(u.u_qsav);
		return (1);
	}
	return (0);
}
