/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) sys.c: version 25.1 created on 11/27/91 at 15:00:05	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)sys.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)uts/io:sys.c	23.2"

/*
 *	indirect driver for controlling tty.
 */
#include "sys/param.h"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/conf.h"
#include "sys/proc.h"
#include "sys/open.h"
#include "sys/stream.h"

/*
 * sycheck -- checks for the existence of a controlling tty and returns a
 *	pointer to the device's cdevsw entry or NULL, also if successful,
 *	puts the minor device number into *devp
 */

struct cdevsw *
sycheck(devp)
dev_t	*devp;
{
	struct cdevsw	*cdp;

	if (u.u_ttyp == NULL) {
		u.u_error = ENXIO;
		return (0);
	}
	if (*u.u_ttyp != u.u_procp->p_pgrp) {
		u.u_error = EIO;
		return (0);
	}
	cdp = &cdevsw[major(notminored(u.u_ttyd))];
	if (cdp->d_str != NULL && u.u_ttyip == NULL) {
		u.u_error = ENXIO;
		return (0);
	}
	*devp = minor(notminored(u.u_ttyd));
	return (cdp);
}

syopen(dev, flag)
dev_t	dev;
{
	struct cdevsw	*cdp;

	if (cdp = sycheck(&dev))
		if (cdp->d_str)
		{
			/* if real tty is still open then open it again */
			/* (copen1) and ditch open of /dev/tty (rval2 = 1) */
			if ( u.u_ttyip->i_count == 0 ||
			     u.u_ttyip->i_rdev != u.u_ttyd )
			{
				u.u_error = ENXIO;
				return;
			}
			plock(u.u_ttyip);
			u.u_ttyip->i_count++;
			copen1(u.u_ttyip, flag);
			u.u_rval2 = 1;
		}
		else
			(*cdp->d_open)(dev, flag, OTYP_CHR);
}

syread(dev)
dev_t	dev;
{
	struct cdevsw	*cdp;

	if (cdp = sycheck(&dev))
		if (cdp->d_str)
			strread(u.u_ttyip);
		else
			(*cdp->d_read)(dev);
}

sywrite(dev)
dev_t	dev;
{
	struct cdevsw	*cdp;

	if (cdp = sycheck(&dev))
		if (cdp->d_str)
			strwrite(u.u_ttyip);
		else
			(*cdp->d_write)(dev);
}

syioctl(dev, cmd, arg, mode)
dev_t	dev;
{
	struct cdevsw	*cdp;

	if (cdp = sycheck(&dev))
		if (cdp->d_str)
			strioctl(u.u_ttyip, cmd, arg, mode);
		else
			(*cdp->d_ioctl)(dev, cmd, arg, mode);
}
