/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spt.c: version 25.1 created on 11/27/91 at 14:59:55	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spt.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)local/sys/localio:spt.c	2.1.1.1"
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*	Copyright (c) 1987, 1988 Microsoft Corporation	*/
/*	  All Rights Reserved	*/

/*	This Module contains Proprietary Information of Microsoft  */
/*	Corporation and should be treated as Confidential.	   */


/*
 ================================================================
 =   WARNING!!!! This source is not supported in future source  =
 =   releases.                                                  =
 ================================================================
 */


#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/fs/s5dir.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/signal.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/mspt.h"

#ifdef DBUG
#define DEBUG(a)	 if (spt_debug) cmn_err( CE_NOTE, a) 
#else
#define DEBUG(a)
#endif 

int spt_debug = 0;


/*
 *   Slave Stream Pipe
 */
#define PTS_ID 0xface
int sptopen(), sptclose(), sptwput(), sptrsrv(), sptwsrv();
static struct module_info spt_info = {PTS_ID, "spt", 0, 512, 512, 128};
static struct qinit sptrint = {NULL, sptrsrv, sptopen, sptclose,NULL,&spt_info, NULL};
static struct qinit sptwint = {sptwput, sptwsrv, sptopen, sptclose, NULL,&spt_info, NULL};
struct streamtab sptinfo = {&sptrint, &sptwint, NULL, NULL};

/*
 * mspt_tty[] and mspt_cnt are defined in slave.d file 
 */
extern struct mspt_ttys mspt_tty[];	
extern int mspt_cnt;

/*
 * Open the master device. Reject a clone open and do not allow the
 * driver to be pushed. If the slave/master pair is locked or if
 * the slave is not open, return OPENFAIL. If cannot allocate zero
 * length data buffer, fail open.
 * Upon success, store the write queue pointer in private data and
 * set the PTSOPEN bit in the sflag field.
 */
int 
sptopen(rqp, dev, flag, sflag)
queue_t *rqp;
dev_t dev;
int flag;
int sflag;
{
        register struct mspt_ttys *sptp;
	register mblk_t *mp;
	mblk_t *smp;
	struct stroptions *sop;
	dev_t fulldevno;

	DEBUG(("entering sptopen\n"));
	fulldevno = dev & UNMINOR_MASK;	/* to set ttyd later */
        dev = minor(dev);
        if (sflag) {
		DEBUG(("sflag is set\n"));
		u.u_error = EINVAL;
		return(OPENFAIL);
	}
        if ((dev < 0) || (dev > mspt_cnt)) {
		DEBUG(("invalid minor number\n"));
		u.u_error = ENXIO;
                return(OPENFAIL);
	}
        sptp = &mspt_tty[dev];
        if ((sptp->pt_state & PTLOCK) || !(sptp->pt_state & PTMOPEN)) {
		DEBUG(("master is locked or slave is closed\n"));
		u.u_error = EACCES;
		return(OPENFAIL);
	}
	/* 
	 * if already, open simply return...
	 */
	if (sptp->pt_state & PTSOPEN) {
		DEBUG(("master already open\n"));
		return(dev);
	}
	if (!(mp = allocb(0, BPRI_MED))) {
		DEBUG(("could not allocb(0, pri)\n"));
		u.u_error = EAGAIN;
		return(OPENFAIL);
	}

	/*
	 * set up hi/lo water marks on stream head read queue
	 */
	if ((smp = allocb(sizeof(struct stroptions), BPRI_MED)) == NULL) {
		freeb(mp);
		u.u_error = EAGAIN;
		return(OPENFAIL);
	}
	smp->b_datap->db_type = M_SETOPTS;
	smp->b_wptr += sizeof(struct stroptions);
	sop = (struct stroptions *)smp->b_rptr;
	sop->so_flags = SO_HIWAT|SO_LOWAT;
	sop->so_hiwat = 512;
	sop->so_lowat = 256;
	putnext(rqp, smp);

	sptp->pt_bufp = mp;
	sptp->spt_wrq = WR(rqp);
	WR(rqp)->q_ptr = (char *) sptp;
	rqp->q_ptr = (char *) sptp;
	sptp->pt_state |= PTSOPEN;
	/*
	 * if process leader with no controlling tty and 
	 * stream is unasigned, assign controlling tty.
	 */
	if (( u.u_procp->p_pid == u.u_procp->p_session_id)
		&& ( u.u_ttyp == NULL) && ( sptp->tty == 0)) {
		u.u_ttyp = &sptp->tty; 
		u.u_ttyd = fulldevno;
		sptp->tty = u.u_procp->p_pgrp;
	}

	DEBUG(("returning from sptopen\n"));
	return(dev);
}



/*
 * Find the address to private data identifying the slave's write 
 * queue. Send a 0-length msg up the slave's read queue to designate 
 * the master is closing. Uattach the master from the slave by nulling 
 * out master's write queue field in private data.
 */
int 
sptclose(rqp)
queue_t *rqp;
{
        register struct mspt_ttys *sptp;
	register mblk_t *mp;

	DEBUG(("entering sptclose\n"));
	/*
	 * if no private data...
	 */
	if(!rqp->q_ptr)
		return;

        sptp = (struct mspt_ttys *)rqp->q_ptr;
	if((sptp->mpt_wrq) && (sptp->pt_bufp)) {
		DEBUG(("putnext() a zero length message\n"));
		putnext(RD(sptp->mpt_wrq),sptp->pt_bufp);
	} else
		if(sptp->pt_bufp)
			freemsg(sptp->pt_bufp);
	sptp->pt_bufp = NULL;
        sptp->spt_wrq = NULL;
	sptp->pt_state &= ~PTSOPEN;
	rqp->q_ptr = NULL;
	WR(rqp)->q_ptr = NULL;
	sptp->tty = 0;
	u.u_ttyp = NULL;
	u.u_ttyd = 0;
	DEBUG(("returning from sptclose\n"));
	return;
}


/*
 * The wput procedure will only handle flush messages.
 */
int 
sptwput(qp, mp)
queue_t *qp;
mblk_t *mp;
{
        register struct mspt_ttys *sptp;
	
	DEBUG(("entering sptwput\n"));
	ASSERT(qp->q_ptr);

        sptp = (struct mspt_ttys *) qp->q_ptr;
	if(sptp->mpt_wrq == NULL) {
		DEBUG(("in write put proc but no master\n"));
		freemsg(mp);
		return;
	}
	switch(mp->b_datap->db_type) {
		/*
		 * if write queue request, flush slave's write
		 * queue and send FLUSHR to mpt. If read queue
		 * request, send FLUSHR to mpt.
		 */
		case M_FLUSH:
			DEBUG(("spt got flush request\n"));
			if (*mp->b_rptr & FLUSHW) {
				DEBUG(("flush spt write Q\n"));
				flushq(qp, FLUSHDATA);
				DEBUG(("putctl1 FLUSHR to mpt\n"));
				putctl1(RD(sptp->mpt_wrq)->q_next, M_FLUSH, FLUSHR);
			}
			if (*mp->b_rptr & FLUSHR) {
				DEBUG(("putctl1 FLUSHW to mpt\n"));
				putctl1(RD(sptp->mpt_wrq)->q_next, M_FLUSH, FLUSHW);
			}
			freemsg(mp);
			break;
		/*
		 * send other messages to master
		 */
		default:
			DEBUG(("put msg on slave's write queue\n"));
			putq(qp, mp);
			qenable(qp);  /* fixes delete-scroll problem RLS */
			break;
	}
	DEBUG(("return from sptwput()\n"));
	return;
}


/*
 * enable the write side of the master. This triggers the 
 * master to send any messages queued on its write side to
 * the read side of this slave.
 */
int 
sptrsrv(qp)
queue_t *qp;
{
        register struct mspt_ttys *sptp;
	
	DEBUG(("entering sptrsrv\n"));
	ASSERT(qp->q_ptr);

        sptp = (struct mspt_ttys *) qp->q_ptr;
	if(sptp->mpt_wrq == NULL) {
		DEBUG(("in read srv proc but no master\n"));
		return;
	}
	qenable(sptp->mpt_wrq);
	DEBUG(("leaving sptrsrv\n"));
}
		


/*
 * If there are messages on this queue that can be sent to 
 * master, send them via putnext(). Else, if queued messages 
 * cannot be sent, leave them on this queue. If priority 
 * messages on this queue, send them to master no matter what.
 */
int 
sptwsrv(qp)
queue_t *qp;
{
        register struct mspt_ttys *sptp;
        register queue_t *mpt_rdq;
	mblk_t *mp;
	
	DEBUG(("entering sptwsrv\n"));
	ASSERT(qp->q_ptr);

        sptp = (struct mspt_ttys *) qp->q_ptr;
	if(sptp->mpt_wrq == NULL) {
		DEBUG(("in write srv proc but no master\n"));
		return;
	}
	mpt_rdq = RD(sptp->mpt_wrq);
	/*
	 * while there are messages on this write queue...
	 */
	while ((mp = getq(qp)) != NULL) {
		/*
		 * if don't have control message and cannot put
		 * msg. on master's read queue, put it back on
		 * this queue.
		 */
		if (mp->b_datap->db_type<=QPCTL && 
					!canput(mpt_rdq->q_next)) {
			DEBUG(("put msg. back on Q\n"));
			putbq(qp, mp);
			break;
		}
		/*
		 * else send the message up master's stream
		 */
		DEBUG(("send message to master\n"));
		putnext(mpt_rdq, mp);
	}
	DEBUG(("leaving sptwsrv\n"));
}

