/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) spmty_rtns.c: version 25.1 created on 11/27/91 at 14:59:42	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)spmty_rtns.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*------------------------------------------------------------------*/
/*
 *	spmty_rtns.c -routines that talk to the spm
 *
 *	02-02-90 - gh01 - pass all chars upstream in tyd_read, not just 1st char
 *	02-26-90 - gh02 - process 'delay_msg' instead of freeing if FLUSHW rcv'd
 *	03-26-90 - gh03 - add sar stats
 *	07-18-90 - gh06 - check TTUSE in case called from 'bufcall' - SPMTTYVER2
 */
/*------------------------------------------------------------------*/
#include "sys/types.h"
#include "sys/user.h"
#include "sys/param.h"
#include "sys/spm_mem.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/signal.h"
#include "sys/gctio.h"
#include "sys/termio.h"
#ifdef SAK
#include "sys/sakioctl.h"
#endif /* SAK */
#include "sys/tyd_tty.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/tyd_clog.h"
#include "sys/cir_log.h"
#include "sys/tyd_sram.h"
#include "sys/tyd_uart.h"
#include "sys/sysinfo.h"
/*------------------------------------------------------------------*/
extern int tyd_cir_log_debug;	/* set non-zero to enable tyd_cir_log */
extern int tyd_cir_log_init_flag; /* non-zero if cur_log initialized */

extern int tyd_cir_index;	/* number of next tyd_cir_log_buf entry */

extern struct	cir_log	*tyd_cir_ptr;  /* ptr to next tyd_cir_log_buf entry */
extern struct	cir_log	tyd_cir_log_buf[TYD_CIR_LOG_SIZE];
/*------------------------------------------------------------------*/
extern int tyd_debug;		/* set non-zero to enable tyd_log */
/*------------------------------------------------------------------*/
#define LOG_DEBUG	tyd_debug
#define	LOG_RTN		tyd_log

#define CIRLOG_DEBUG	tyd_cir_log_debug
#define	CIRLOG_RTN	tyd_cir_logit

#include "sys/debuglog.h"
/*------------------------------------------------------------------*/
#define TYD_MOD		120
#define TYD_MSIZE	1024		/* max data msg size we will send up */
/*------------------------------------------------------------------*/
typedef struct	termio  termio_t;

mblk_t *tyd_alloc();
mblk_t *tyd_wsrv_data();

int	tyd_timer();

extern tyd_tty_t *tyd_tp_tab[];			/* check for activity in poll*/
extern int	tyd_timer_time;
extern int	tyd_timer_count;
extern int	tyd_poll_timer_id;		/* id of tyd_timer */
extern int	tyd_poll_timer_init;
extern uint	tyd_input_count;		/* no. characters received */
extern uint	tyd_output_count;		/* no. characters written */

int	tyd_ms_debug_flag = 0;	/* set non-zero to enable useq debugging */
int	ms_debug_step = 0; /* set to number of useq steps to execute */
int	ms_debug_addr = -1; /* set to address to stop at */
int	tyd_spin = 0;
int	start_of_wait[NUM_SPM_TTYS];
int	max_wait[NUM_SPM_TTYS];
tyd_tty_t tyd[NUM_SPM_TTYS];		/* one struct per port */
struct module_stat r_stat[NUM_SPM_TTYS]; /* one read module stat per port */
struct module_stat w_stat[NUM_SPM_TTYS]; /* one write module stat per port */
tyd_tty_t *tyd_tp_tab[NUM_SPM_TTYS];	/* check for activity in poll*/
int	tyd_num_ports = NUM_SPM_TTYS;

int	ms_initialized = 0;		/* non-zero = useq initialized */

unchar *tyd_start_of_sram_input;
ms_ctl_t *tyd_start_of_sram_ctl;

unchar	spm_ms_input[MS_BUF_SIZE  * 2 * NUM_SPM_TTYS + ctob(1)];
/*------------------------------------------------------------------*/
/*
 *	baud_wait table - number of milliseconds  * 4 to wait for a
 *			  data byte to be output, depending on speed
 *
 *		the '* 4' is because it only takes 1/2 millisecond for
 *		a data byte to be output at 19200, and a simple way to
 *		express 1/2 in hex is to multiply by a constant first.
 *		4 was picked so later support for 38400 could be added
 *		(1/4 millisecond for one byte at 38400)
 *
 *	- indexed by speed in cflag
 */
/* This table now serves double duty. A zero any place except entry 0
/* indicates an unsuppoerted baud rate.
*/
#define BAUD_SCALE	4

int	baud_wait[] =
{
/*	no mills * 4		cflag value	speed */
/*	--------------		-----------	----- */
	0,			/*  0		    0	not supported */
	800,			/*  1		   50 */
	600,			/*  2		   75 */
	400,			/*  3		  110 */
	300,			/*  4		  134.5 */
	267,			/*  5		  150 */
	0,			/*  6		  200	not supported */
	133,			/*  7		  300 */
	67,			/*  8		  600 */
	33,			/*  9		 1200 */
	22,			/* 10		 1800 */
	17,			/* 11		 2400 */
	8,			/* 12		 4800 */
	4,			/* 13		 9600 */
	2,			/* 14		19200 */
	0			/* 15		38400	not supported */
};
/*------------------------------------------------------------------*/
/*
 *	general initialization
 */
tyd_msinit()
{
	tyd_start_of_sram_ctl = spm_mem.spm_tty.spm_tty_ctl;

	tyd_start_of_sram_input = 
		(uchar *)(((uint)spm_ms_input + ctob(1)) & ~(ctob(1)-1));

	spm_mem.spm_tty.tty_buffer_space = (caddr_t)tyd_start_of_sram_input;

	if (ms_initialized != 0)
		return;		/* non-zero = useq initialized */
	ms_initialized = 1;

	bzero(r_stat, sizeof(struct module_stat) * NUM_SPM_TTYS);
	bzero(w_stat, sizeof(struct module_stat) * NUM_SPM_TTYS);
}/*------------------------------------------------------------------*/
/*
 *	INTERRUPT FROM TIMER
 *
 *------------------------------------------------------------------*
 *
 *	tyd_timer - check for output ready and input available
 */
int tyd_timer_toggle = 0;	/* non-zero = look at highest port first */

tyd_timer()
{
	register tyd_tty_t *tp;
	int i, j;
	register status;	/* new port eia status */
	unchar ms_event;
	int	tmp, tmp1;
	extern queue_t *qhead;
	queue_t *rq;
	ms_ctl_t *sram_ctl;	/* ptr to input control struct in sram*/
	int bytes_in_inbuf;		/* no. bytes in input buffer in sram */

	ASSERT(is_upkern_lock());
#ifdef TTYDEBUG_TIME
	extern int tyd_timer_elapsed_time;
	int start_time, elapsed_time;

	start_time = lbolt;
	tmp = lbolt;
	if ((tmp1 = tmp - tyd_timer_time) > tyd_timer_elapsed_time)
		tyd_timer_elapsed_time = tmp1;
	if (++tyd_timer_count >= HZ)
	{ 
		tyd_timer_count = 0;
		tyd_timer_elapsed_time = 0;
		BUGCIR_LOG(tyd_num_ports, tmp1, 0,TYD_CIR_TEST1, 10);
	}
	tyd_timer_time = tmp;
#endif /* TTYDEBUG_TIME */
	for (i = 0; i < NUM_SPM_TTYS; i++)
	{
		if (tyd_timer_toggle != 0)
			j = NUM_SPM_TTYS - 1 - i;
		else	j = i;
		if ((tp = tyd_tp_tab[j]) == NULL)
			continue;
		if ((ms_event = tp->sram_ctl->ms_event) != 0)
		{
			/* if waiting for msg and only input pending,
			   don't enable queue */
			if (ms_event & ~(MSE_INPUT_PENDING|MSE_OUTPUT_START_TRY))
				tyd_event(tp, ms_event);
			/* don't try to start output until the read service so
			 * that, if the char is a delete key (VINTR), it will
			 * have a chance to get to the streams module upstream
			 * (which will normally flush all queues), before we
			 * really start output. I. e., we don't want to send
			 * out what we have pending if we are stopped and the
			 * user hits the delete key, but this decision must be
			 * made by the tty module upstream. This change gives
			 * that module the chance to flush our buffers before
			 * we start up the output (assuming IXANY set)
			 */
			if (ms_event & MSE_OUTPUT_START_TRY)
				qenable(tp->rq);
			if (!(tp->state & WAITING_FOR_MSG)
			 && !(tp->sram_ctl->ms_command & MS_FLUSH_RCV_BUF)
			 && ms_event & MSE_INPUT_PENDING)
			{
				rq = tp->rq;
			  	if (!(rq->q_next->q_flag & (QFULL|QENAB))
				  && !(rq->q_flag & QENAB))
				{
					sram_ctl = tp->sram_ctl;
					bytes_in_inbuf = 
						(sram_ctl->ms_in_tail -
						 sram_ctl->ms_in_head) & 0xff;
				/*have tyd_rsrv call tyd_read if not half full*/
					if (bytes_in_inbuf < MS_HALF_BUF_SIZE)
						qenable(rq);
					else	tyd_read(tp);
				}
			}
		}
		status = tyd_get_eia_status(tp);
		if ((status & (T_DCD | T_DSR)) != (tp->state & (T_DCD | T_DSR)))
		/* eia change */
			tyd_process_eia_change(tp, status);
		if (tp->sram_ctl->ms_out_head != tp->sram_ctl->ms_out_tail)
			tp->output_in_progress = 1;
		else	tp->output_in_progress = 0;
		/* look for spm to process new cflag/iflag */
		if (tp->state & (WAIT_FOR_FLAG_ON_OPEN | WAIT_FOR_FLAG_ON_IOCTL)
		 && !(tp->sram_ctl->ms_command & MS_NEW_FLAG))
		{
			if (tp->state & WAIT_FOR_FLAG_ON_OPEN)
			{
				tp->state &= ~WAIT_FOR_FLAG_ON_OPEN;
				wakeup((caddr_t)&tp->state);
			}
			else	tyd_ack_to_ioctl(tp->delay_msg, tp);
		}
	}
	tyd_timer_toggle ^= 1;		/* switch directions every other pass */

	/* call this same routine on the next clock tick */
	tyd_poll_timer_id = timeout(tyd_timer, (tyd_tty_t *)NULL,1);
}/*------------------------------------------------------------------*/
tyd_ack_to_ioctl(mp, tp)
register mblk_t		*mp;
register tyd_tty_t	*tp;
{
	register struct iocblk	*iocbp;		/* ioctl control block */

	ASSERT(mp != NULL);
	if (mp != NULL)
	{
		/* addr of ioctl control info */
		tp->delay_msg = NULL;
		tp->state &= ~(NO_OUTPUT_ALLOWED | WAIT_FOR_FLAG_ON_IOCTL);
		mp->b_datap->db_type = M_IOCACK;
		iocbp = (struct iocblk *)mp->b_rptr;
		iocbp->ioc_count = 0;
		qreply(tp->wq, mp);
		qenable(tp->wq);	/* start output if any pending */
	}
}/*------------------------------------------------------------------*/
tyd_rsrv(rq)
register queue_t *rq;
{
	register unchar *event_ptr;	/* addr of event byte in input control*/
	register tyd_tty_t	*tp;

	ASSERT(is_upkern_lock());
	tp = (tyd_tty_t *)rq->q_ptr;
	ASSERT(tp != NULL);
	/* see if there are any messages on our own read queue */
	if (!(tp->state & WAITING_FOR_MSG)	/* if not waiting for msg */
	  && !(tp->sram_ctl->ms_command & MS_FLUSH_RCV_BUF)
	  && (tp->sram_ctl->ms_event & MSE_INPUT_PENDING))
		tyd_read(tp);	/* see if uSeq has data in S-ram */
	if(tp->sram_ctl->ms_event & MSE_OUTPUT_START_TRY)
	{	/* uSeq would like to send X-ON to terminal*/
		event_ptr  = &(tp->sram_ctl->ms_event);
		atom_and_byte(event_ptr, ~MSE_OUTPUT_START_TRY);
		BUGCIR_LOG(tp->min_dev,0,0,TYD_CIR_EV_OUTPUT_START,tp->state);
		BUGLOG1(tp,BUG_LERR, "output x-oned rq=%x", rq);
		tp->state &= ~T_TXSTOP;
		tyd_see_if_we_can_start_output(tp);
	}
}/*------------------------------------------------------------------*/
/*
 *		process events from the useq other that INPUT_PEINDING
 *
 *   1. when the poll timer expires, 'tyd_timer()' scans the event flag
 *	for each port, and for each port that has one or more events
 *	pending, the read queue is enabled.
 *
 *   2. When 'tyd_rsrv()' is called, each non-data event is processed
 *	and that event flag is cleared.
 *
 *   3. Then, if there is input data available, 'qenable()' is
 *	called for that port to enable the read service, 'tyd_rsrv()'
 *
 *   4. Finally, 'tyd_read()' is called to see if any data has been received
 *	from that device. All available data is put into one or more streams
 *	messages and sent upstream. The only possible messages that could
 *	be on this queue are data messages that were put on this queue
 *	because 'canput()' said they could not be sent upstream.
 *
 *	The possible non-data events that can occur are:
 *
 *	OVERRUN			set when input buffer wraps
 *	INPUT_STOPPED		set if X-OFF sent
 *	INPUT_STARTED		set if X-ON  sent
 *	OUTPUT_STOPPED		set if X-OFF received
 *	BREAK			set if break occurred 
 *
 * Argument: rq	read queue pointer
 */
tyd_event(tp, ms_event)
tyd_tty_t *tp;
unchar	ms_event;
{
	register unchar *event_ptr;	/* addr of event byte in input control*/
	queue_t *rq;
	dev_t	dev;

	event_ptr  = &(tp->sram_ctl->ms_event);
	rq = tp->rq;
	dev = tp->min_dev;
	/* one or more non-data events occurred, see what they are */
	if (ms_event & MSE_OUTPUT_STOPPED)
	{	/* uSeq sent an X-OFF to terminal */
		atom_and_byte(event_ptr, ~MSE_OUTPUT_STOPPED);
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_OUTPUT_STOP,tp->state);
		BUGLOG1(tp,BUG_LERR,"output x-offed rq=%x", rq);
		tp->state |= T_TXSTOP;
	}
	if (ms_event & MSE_OVERRUN)
	{	/* lost data, output only log msg for now */
		atom_and_byte(event_ptr, ~MSE_OVERRUN);
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_OVERRUN,0);
		BUGLOG1(tp, BUG_LERR, "overrun rq=%x", rq);
	}
	if ( ms_event & MSE_INPUT_STOPPED )
	{
		atom_and_byte(event_ptr, ~MSE_INPUT_STOPPED);
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_INPUT_STOP,tp->state);
		if ( !tp->state & T_RXSTOP )
		{
			tp->state |= T_RXSTOP;
			BUGLOG1(tp, BUG_LERR, "input x-offed rq=%x", rq);
		}
		if ( tp->sram_ctl->ms_in_head == tp->sram_ctl->ms_in_tail &&
		     !(tp->state & TBLOCK) )
			tyd_send_xon(tp);	/* input empty */
	}
	/* check if input started, for debug/monitoring only */
	if (ms_event & MSE_INPUT_STARTED)
	{
		atom_and_byte(event_ptr, ~MSE_INPUT_STARTED);
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_INPUT_START,tp->state);
		if ( tp->state & T_RXSTOP )
		{
			tp->state &= T_RXSTOP;
			BUGLOG1(tp, BUG_LERR, "input x-oned rq=%x", rq);
		}
	}
	if (ms_event & MSE_BREAK)
	{
		atom_and_byte(event_ptr, ~MSE_BREAK);
		BUGCIR_LOG(dev,0,0,TYD_CIR_EV_BREAK,0);
		BUGLOG0(tp, BUG_LGEN, "break received");
#ifdef SAK
		if (tp->sak.flags & SAK_BREAK)
			tyd_sak_event(tp);
		else	putctl(rq->q_next, M_BREAK);	/* send break upstream*/
#else
		putctl(rq->q_next, M_BREAK);	/* send break upstream*/
#endif /* SAK */
	}
}/*------------------------------------------------------------------*/
/*
 *	tyd_read - see if uSeq has data in S-ram
 *
 *	this routine attempts to move data from uSeq Ram to a
 *	streams message and pass the message upstream for processing
 *
 *	the buf_head points to the next byte to be removed from a buffer
 *	the buf_tail points to the next byte to be stored in a buffer
 *
 *	hence, for output, the driver uses the tail pointer
 *	while, for  input, the driver uses the head pointer
 *
 */
tyd_read(tp)
register tyd_tty_t	*tp;
{
	int bytes_in_inbuf;/* no. bytes in input buffer in sram */
	int in_head;		/* offset from base to head of input buf */
	int in_tail;		/* offset from base to tail of input buf */
	register unchar *msptr;	/* ptr to data in input buffer in sram */
	register unchar *wptr;	/* ptr to data in streams msg */
	register i;
	unchar tmp;
	ms_ctl_t *sram_ctl;	/* ptr to input control struct in sram*/
	mblk_t	*bp;		/* addr of M_DATA streams msg to send upstream*/
	int	total_room_in_msg; /*no. bytes that can be stored in msg*/
	int	bytes_this_msg;	/*no. bytes to actually store in msg*/
	int	bytes_to_move;	/* no. bytes to move at one time into msg */
	unchar	c;

	BUGLOG1(tp, BUG_LGEN, "tyd_read rq=%x", tp->rq);
	if (!(tp->state & TTUSE))
		return;			/* gh06 */
	tp->state &= ~WAITING_FOR_MSG;	/*msg is available */
	sram_ctl = tp->sram_ctl;
	in_head = sram_ctl->ms_in_head;
	in_tail = sram_ctl->ms_in_tail;
	while (in_head != in_tail)		/* while data in input buf */
	{
		bytes_in_inbuf = (in_tail - in_head) & 0xff;
		/* 'bytes_in_inbuf' should always be smaller than TYD_MSIZE,
		   but we do this just in case the buffer size or TYD_MSIZE
		   changes in the future */
		if (bytes_in_inbuf <  TYD_MSIZE)
			bytes_this_msg = bytes_in_inbuf;/*bytes this msg*/
		else	bytes_this_msg = TYD_MSIZE;	/*max msg size*/

		/* work our way down the different message sizes until
		   we either get a message or we get to the smallest size */
		bp = NULL;
		for (i = bytes_this_msg; i > 3; i >>= 1)
		{
			if ((bp = allocb(i, BPRI_MED)) != NULL)
				break;
		}
		if (bp == NULL
		 && (bp = tyd_alloc(4,BPRI_MED,tyd_read, tp)) == NULL)
		{	/* can't do any processing until streams message avail*/
			tp->state |= WAITING_FOR_MSG;/*wait for available msg*/
			start_of_wait[tp->min_dev] = lbolt;
			BUGLOG1(tp,BUG_LERR,"tyd_read no buf, rq=%x",tp->rq);
			return;
		}
		/* calculate the max amount of room in this msg */
		total_room_in_msg = bp->b_datap->db_lim - bp->b_datap->db_base;

		/* the no. of bytes we copy is the smaller of what will
		   actually fit in the msg and what is in the input buffer */
		if (total_room_in_msg < bytes_in_inbuf)
			bytes_this_msg = total_room_in_msg;
		else	bytes_this_msg = bytes_in_inbuf;
		while (bytes_this_msg != 0)
		{
			/* move in one step if data does not wrap, else
			   move in two steps if data wraps:
			   1. move from current loc to end of buffer
			   2. move from start of buffer to tail
			 */
			if (bytes_this_msg <  MS_BUF_SIZE - in_head)
				bytes_to_move = bytes_this_msg;
			else	bytes_to_move = MS_BUF_SIZE - in_head;
			if (bytes_to_move == 0)
				break;
			msptr = tp->sram_in_base + in_head; /*sram addr*/
			wptr = bp->b_wptr;	/* streams msg data block*/
			tyd_input_count += bytes_to_move;
			/* gh03 - sar stats */
			sysinfo.rcvint += bytes_to_move;	/* stats */
#ifdef SAK
			if (!(tp->sak.flags & SAK_KEYS))
			{
				for (i = 0; i < bytes_to_move; i++)
					*(wptr++) = *(msptr++);
			}
/* gh01 - pass all chars up if available, not just first char */
			else	for (i = 0; i < bytes_to_move; i++)
			{
				c = *(msptr++);
				*(wptr++) = c;
				switch(tp->sak_count)
				{
				case 0:
					if (c == tp->sak.sak_key1)
					{
						if (tp->sak.flags & SAK_1KEY)
						{
							tyd_sak_event(tp);
							return;
						}
						else	tp->sak_count++;
					}
					break;
				case 1:
					if (c == tp->sak.sak_key2)
					{
						if (tp->sak.flags & SAK_2KEYS)
						{
							tyd_sak_event(tp);
							return;
						}
						else	tp->sak_count++;
					}
					else	tp->sak_count = 0;
					break;
				case 2:	 /* SAK_3KEYS must be set to get here */
					if (c == tp->sak.sak_key3)
					{
						tyd_sak_event(tp);
						return;
					}
					else	tp->sak_count = 0;
					break;
				} /* switch(tp->sak_count) */
			}
#else
			for (i = 0; i < bytes_to_move; i++)
				*(wptr++) = *(msptr++);
#endif /* SAK */
			if ((in_head += bytes_to_move) >= MS_BUF_SIZE)
				in_head = 0;		/* buffer wrap */
			bp->b_wptr = wptr;
			bytes_this_msg -= bytes_to_move;
		}
		/* we now have the data moved into a stream message; send
		   it upstream */
		BUGCIR_LOG(tp->min_dev, bp->b_wptr - bp->b_rptr,
			*bp->b_rptr,TYD_CIR_EV_INPUT,
			(sram_ctl->ms_in_head << 8) | sram_ctl->ms_in_tail);
		sram_ctl->ms_in_head = in_head;
		putnext(tp->rq, bp);	/* send data upstream */
	}
	atom_and_byte(&sram_ctl->ms_event, ~MSE_INPUT_PENDING);
	if (sram_ctl->ms_in_head != sram_ctl->ms_in_tail)
		atom_or_byte(&sram_ctl->ms_event, MSE_INPUT_PENDING);
	tyd_enable_receiver(tp);
	tp->sram_ctl->ms_in_limit = in_head + MS_LIMIT_SIZE;

	/* if input is blocked, unblock it (start input going again) */
	tmp = tp->sram_ctl->ms_status;
	if ( !(tp->state & TBLOCK) &&
	     (tp->state & T_RXSTOP || tmp & MSS_INPUT_STOPPED) )
		tyd_send_xon(tp);
	/* if we have an activity timer running, looking for input or output,
	   restart the timer since we got input */
	if (tp->t_gctio.gt_tact != 0)
	{
		/* if activity timer running, turn off before restarting timer*/
		tyd_stop_act_timer(tp);
		tyd_start_act_timer(tp);
	}
}/*------------------------------------------------------------------*/
tyd_copy_debug(tp, msptr, wptr, bytes_to_move)
register tyd_tty_t	*tp;
register unchar *msptr;		/* ptr to data in input buffer in sram */
register unchar *wptr;		/* ptr to data in streams msg */
int	bytes_to_move;	/* no. bytes to move at one time into msg */
{
	register i;
	register unchar c;

	for (i = 0; i < bytes_to_move; i++)
	{
		c = *(msptr++);
		*(wptr++) = c;
		/*
		if (c != tp->myname[2])
		{
			if (c != tp->myname[3] && c != 0x20)
				tp->myname[0] = 0xaa;
			tp->myname[3] = c + 1;
		}
		*/
		if (c != tp->myname[3] && c != 0xa0)
			tp->myname[0] = 0xaa;	/* ERROR */
		tp->myname[3] = c + 1;
	}
}/*------------------------------------------------------------------*/
tyd_copy_debug2(tp, rptr, msptr, bytes_to_move)
register tyd_tty_t	*tp;
register unchar *rptr;		/* ptr to data in stream msg */
register unchar *msptr;		/* ptr to data in output buffer in sram */
int	bytes_to_move;	/* no. bytes to move at one time into sram */
{
	register i;
	register unchar c;

	for (i = 0; i < bytes_to_move; i++)
	{
		c = *(rptr++);
		*(msptr++) = c;
		if (c != tp->myname[1] && c != 0xa0)
			tp->myname[0] = 0xaa;	/* ERROR */
		tp->myname[1] = c + 1;
	}
}/*------------------------------------------------------------------*/
/*
 *		WRITE SERVICE - DATA
 *
 *------------------------------------------------------------------*
 *
 *	process write data - called from service routine
 *
 *	we only get here on M_DATA messages
 *
 *	the buf_head points to the next byte to be removed from a buffer
 *	the buf_tail points to the next byte to be stored in a buffer
 *
 *	hence, for output, the driver uses the tail pointer
 *	while, for  input, the driver uses the head pointer
 *
 * 	return	mp	if unable to process
 *		NULL	if processes successfully
 */
mblk_t *
tyd_wsrv_data(mp, tp)
register mblk_t		*mp;
register tyd_tty_t	*tp;
{
	register bytes_in_outbuf;/* no. bytes already in output buffer */
	register bytes_to_move;	/* no. bytes to copy to output buffer */
	register room_in_outbuf;/* space in outbuf from tail to end of buffer*/
	register bytes_in_msg;	/* no. bytes in message */
	int out_head;	 	/* offset from base to head of output buf */
	int out_tail; 		/* offset from base to tail of output buf */
	ms_ctl_t *sram_ctl;	/* addr of sram control block*/
	register unchar	*msptr;	/* addr of next byte to get in sram */
	register unchar	*rptr;	/* addr of next byte in streams msg */
	mblk_t	*next;		/* addr of next msg block in msg */
	register i;
	int	n;

	/* if we have an activity timer running, looking for input or output,
	   restart the timer since we have data to output */

	/*  NOTE: THIS TIMER WILL NOT BE ACCURATE SINCE IT DOES NOT MEASURE
	    FROM THE TIME THE LAST BYTE IS OUTPUT BY THE MICROSEQUENCER, BUT
	    BUT INSTEAD MEASURES FROM THE TIME THE LAST BYTE IS PASSED TO
	    THE MICROSEQUENCER; IT CAN BE OFF BY AS MUCH AS THE TIME REQUIRED
	    TO OUTPUT A FULL MICROSEQUENCER BUFFER (256 BYTES CURRENTLY) */

	ASSERT(mp->b_datap->db_type == M_DATA);
	if (tp->t_gctio.gt_tact != 0)
	{
		/* if activity timer running, turn off before restarting timer*/
		tyd_stop_act_timer(tp);
		tyd_start_act_timer(tp);
	}
	sram_ctl = tp->sram_ctl;
	out_head = sram_ctl->ms_out_head;
	out_tail = sram_ctl->ms_out_tail;

	/* move as many bytes as we can into the output buffer in Static ram
	   each loop will either:
	   1. empty out one streams message,
	   2. fill S-ram to end of buffer, or
	   3. fill up S-ram
	*/
	/*
	if (mp != NULL)
	{
		BUGCIR_LOG(tp->min_dev, mp->b_wptr - mp->b_rptr,
	 				*mp->b_rptr,TYD_CIR_WRITE_DATA,(int)mp);
	}
	if ((next = mp->b_cont) != NULL)
	{
		BUGCIR_LOG(tp->min_dev, next->b_wptr - next->b_rptr,
	 				*next->b_rptr,TYD_CIR_TEST2,next);
	}
	*/
	while (mp != NULL && (bytes_in_msg = mp->b_wptr - mp->b_rptr) != 0)
	{
		/* calculate number of bytes already in output buffer */
		bytes_in_outbuf = (out_tail - out_head) & 0xff;
		if (tp->state & (NO_OUTPUT_ALLOWED | T_SUSPEND | T_TXSTOP)
		 || bytes_in_outbuf >= tp->ms_out_max
		 || tp->sram_ctl->ms_command & MS_FLUSH_XMIT_BUF)
		{
			/* no room for more data */
			/* turn on 'output_pending timer' if allowed to */
			tyd_enable_transmitter(tp);
			if (!(tp->state &
				(NO_OUTPUT_ALLOWED | T_SUSPEND | T_TXSTOP)))
				tyd_restart_out_pending_timer(tp);
			BUGCIR_LOG(tp->min_dev, bytes_in_outbuf,
				tp->sram_ctl->ms_command,TYD_CIR_RPUTBQ3,tp->state);
			return(mp);	/* 'unable to process data */
		}
		/* calculate total room available in outbuf */
		bytes_to_move = MS_BUF_SIZE - bytes_in_outbuf - 1; 
		if (bytes_in_msg < bytes_to_move)
			bytes_to_move = bytes_in_msg;
		while (bytes_to_move != 0)
		{
			/* move in one step if data does not wrap, else
			   move in two steps if data wraps:
			   1. move from current loc to end of buffer
			   2. move from start of buffer to tail
			 */
			room_in_outbuf = MS_BUF_SIZE - out_tail;
			rptr = mp->b_rptr;
			msptr = tp->sram_out_base + out_tail;
			if (room_in_outbuf <  bytes_to_move)
				n = room_in_outbuf;
			else	n = bytes_to_move;
			BUGCIR_LOG(tp->min_dev,out_head,out_tail,TYD_CIR_WCOPY,
				 (int)((n << 16) + ((int)msptr & 0xffff))); 
			tyd_output_count += n;

			for (i = 0; i < n; i++)
				*(msptr++) = *(rptr++);
			/* gh03 - sar stats */
			sysinfo.xmtint += n; /* bump count of bytes output*/

			if ((out_tail += n) >= MS_BUF_SIZE)
				out_tail = 0;		/* sram buffer wrap */
			bytes_to_move	-= n;
			bytes_in_msg	-= n;
			mp->b_rptr	= rptr;
		}
		sram_ctl->ms_out_tail = out_tail;
		if (bytes_in_msg == 0)
		{
			next = mp->b_cont;	/* next msg block in msg */
			freeb(mp);		/* free this message block */
			mp = next;
		}
	}
	tyd_enable_transmitter(tp);
	return(NULL);
}/*------------------------------------------------------------------*/
/*
 *	tyd_iflag_program - tell SPM new iflag
 */
tyd_iflag_program(tp)
register tyd_tty_t	*tp;
{
	tp->sram_ctl->iflag = tp->termio.c_iflag;
}/*------------------------------------------------------------------*/
tyd_set_flag_cmd(tp)
register tyd_tty_t	*tp;
{
	atom_or_byte(&tp->sram_ctl->ms_command, MS_NEW_FLAG);
}/*------------------------------------------------------------------*/
/*
 *	routines which communicate with the uSeq
 *
 *---------------------------------------------------------------------*/
/*
 *	initialize sram pointers, tables
 */
tyd_init_pointers(tp)
register tyd_tty_t	*tp;
{
	uint	dev = (uint)tp->min_dev;  /* relative device no. on board */
	int i;
	unchar *ptr;

	/* --- control table (flags, pointers, etc.) for this device --- */
	tp->sram_ctl = tyd_start_of_sram_ctl + dev;

	tp->sram_ctl->ms_in_head = tp->sram_ctl->ms_in_tail;

	/* --- input character buffer for this device --- */
	tp->sram_in_base = (unchar *)((dev << 9) + tyd_start_of_sram_input);
	/* --- output character buffer for this device --- */
	tp->sram_out_base = tp->sram_in_base + 256; 

	/* for debugging */
	for (i = 0, ptr = tp->sram_out_base; i < 256; i++, ptr++)
		*ptr = 0;

	tp->ms_out_max = MS_BUF_SIZE - 6;	/* max no bytes in out buf*/
	tp->sram_ctl->ms_in_limit = tp->sram_ctl->ms_in_head + MS_LIMIT_SIZE;
	tp->sram_ctl->dev = dev & 0xff;		/* for debugging ms_ctl dumps*/
}/*------------------------------------------------------------------*/
/*
 *	see if ace board present for this port
 *
 *	return	0 if ace board present
 *		1 if not present
 */
tyd_check_if_port_available(dev)
dev_t dev;
{
	ms_ctl_t *ms_ctl_ptr;

	ms_ctl_ptr = tyd_start_of_sram_ctl + (uint)dev;
	if (ms_ctl_ptr->ms_status & MSS_DISABLED)
		return(1);
	else	return(0);
}/*------------------------------------------------------------------*/
/*
 *	tell uSeq to send an X-ON character to terminal
 *	to start input going again
 */
tyd_send_xon(tp)
register tyd_tty_t	*tp;
{
	tp->state &= ~(TBLOCK | T_RXSTOP);
	if (tp->termio.c_iflag & IXOFF) /* if terminal understands X-ON/X-OFF */
	{
		tp->sram_ctl->ms_spec_char = tp->xonc;
		atom_or_byte(&tp->sram_ctl->ms_command, MS_SEND_SPEC_CHAR);
		tyd_enable_transmitter(tp);
	}
}/*------------------------------------------------------------------*/
/*
 *	tell uSeq to send an X-OFF character to terminal
 *	to stop input from terminal
 */
tyd_send_xoff(tp)
register tyd_tty_t	*tp;
{
	if (tp->termio.c_iflag & IXOFF) /* if terminal understands X-ON/X-OFF */
	{
		BUGCIR_LOG(tp->min_dev, 0, 0, TYD_CIR_XOF, NULL);
		tp->state |= T_RXSTOP;
		tp->sram_ctl->ms_spec_char = tp->xofc;
		atom_or_byte(&tp->sram_ctl->ms_command, MS_SEND_SPEC_CHAR);
		tyd_enable_transmitter(tp);
	}
}/*------------------------------------------------------------------*/
#ifdef SAK
/*
 *	secure attention key
 *
 *------------------------------------------------------------------*/
/*
 *	secure attention key (SAK) event occurred
 */
tyd_sak_event(tp)
register tyd_tty_t	*tp;
{
	tyd_stop_act_timer(tp);
	tyd_flush_read_side(tp);
	tyd_flush_write_side(tp);
	putctl1(tp->rq->q_next, M_FLUSH, FLUSHR|FLUSHW);
	if (putctl1(tp->rq->q_next, M_PCSIG, SIGSAK) == 0)
		tyd_sak_wait_for_buf(tp->rq);
}/*------------------------------------------------------------------*/
tyd_sak_wait_for_buf(rq)
register queue_t *rq;
{
	register size;
	mblk_t	*bp;

	for (size = 4; size < TYD_MSIZE; size += size)
	{
		if ((bp = allocb(size, BPRI_HI)) != NULL)
			break;
	}
	if (bp == NULL)		/* no msgs in system !!! */
		timeout(tyd_sak_wait_for_buf, rq, HZ);
	else
	{
		bp->b_datap->db_type = M_PCSIG;
		*bp->b_wptr++ = SIGSAK;
		putnext(rq, bp);
	}
}/*------------------------------------------------------------------*/
#endif /* SAK */
/*
 *	flush handling
 *
 *------------------------------------------------------------------*/
tyd_flush_write_side(tp)
register tyd_tty_t	*tp;
{
	flushq(tp->wq, FLUSHALL);	/* flush streams write queue */
	/* flush uSeq output queue */
	tyd_log_status(tp, 3);
	atom_or_byte(&tp->sram_ctl->ms_command, MS_FLUSH_XMIT_BUF);
	/* don't enable transmitter for flush since 'tyd_start_output' will */
	tyd_start_output(tp);
	/* gh02 - process 'delay_msg' normally so IOCTLs are acked */
	tp->output_in_progress = 0;
	if (tp->state & WAIT_FOR_FLAG_ON_IOCTL)
		tyd_ack_to_ioctl(tp->delay_msg, tp);
	else 	tyd_process_msg_output_empty(tp);	/*do output empty step*/
}/*------------------------------------------------------------------*/
tyd_flush_read_side(tp)
register tyd_tty_t	*tp;
{
	flushq(tp->rq, FLUSHALL);	/* flush streams read queue */
	/* flush uSeq input queue */
	tyd_log_status(tp, 2);

	atom_or_byte(&tp->sram_ctl->ms_command, MS_FLUSH_RCV_BUF);
	tp->sram_ctl->ms_in_head = tp->sram_ctl->ms_in_tail;
	tp->sram_ctl->ms_in_limit = tp->sram_ctl->ms_in_head + MS_LIMIT_SIZE;
	if (tp->sram_ctl->ms_status & MSS_INPUT_STOPPED)
		tyd_send_xon(tp);
}/*------------------------------------------------------------------*/
/*
 *	start up output
 *
 *	clear any suspend condition and any output flow control
 */
tyd_start_output(tp)
register tyd_tty_t	*tp;
{
	tp->state &= ~(T_SUSPEND | T_TXSTOP);
	atom_and_byte(&tp->sram_ctl->ms_command, ~MS_STOP_OUTPUT);
	atom_or_byte(&tp->sram_ctl->ms_command, MS_START_OUTPUT);
	qenable(tp->wq);
	tyd_enable_transmitter(tp);
}/*------------------------------------------------------------------*/
tyd_stop_output(tp, reason)
register tyd_tty_t	*tp;
uint	reason;
{
	tp->state |= reason;
	atom_or_byte(&tp->sram_ctl->ms_command, MS_STOP_OUTPUT);
}/*------------------------------------------------------------------*/
/* this routine is called when the 'output pending' timer expires
 * hence we now want to enable the output service routine to see if
 * we can again transfer data to the microsequencer
 */
tyd_out_pending_expired(tp)
register tyd_tty_t	*tp;
{
	tp->timer_enable &= ~OUTPUT_PENDING_TIMER;
	if (!(tp->state & (NO_OUTPUT_ALLOWED | T_SUSPEND | T_TXSTOP)))
		qenable(tp->wq);
}/*------------------------------------------------------------------*/
tyd_check_if_output_empty(tp)
register tyd_tty_t	*tp;
{
	int old_total_delay;	/* no. mills to wait for all byte to go out*/

	ASSERT(tp != NULL);
	if (tp->timer_enable & OUTPUT_EMPTY_TIMER)
	{
		tp->timer_enable &= ~OUTPUT_EMPTY_TIMER;
		untimeout(tp->output_empty_id);
	}
	old_total_delay = tp->total_delay;
	if ((tp->total_delay = tyd_compute_delay(tp)) == 0
	 && !(tp->sram_ctl->ms_status & MSS_OUTPUT_PENDING))
	{
		tp->output_in_progress = 0;
		tyd_process_msg_output_empty(tp);	/*do output empty step*/
	}
	else
	{
		tp->output_in_progress = 1;
	 	if (tp->sram_ctl->ms_status & MSS_OUTPUT_PENDING)
		{	/* if transmit interrupt are enabled */
			/* output in progress, wait for it to empty */
			if (!(tp->timer_enable & OUTPUT_EMPTY_TIMER) &&
			    tp->total_delay == old_total_delay)
			{
				BUGLOG0(tp, BUG_LERR, "output stuck");
				tyd_start_output(tp);
			}
		}
		else if (tp->state & (T_SUSPEND|T_TXSTOP) && tp->t_closing != 0)
			tyd_start_output(tp);
		/*flag 'output_empty timer on'*/
		/* if our output buffer empty but the SPM says data still in
		   useq output buffer, allow 1/2 second */
		if (tp->total_delay == 0)
			tp->total_delay = HZ/2;
		tp->timer_enable |= OUTPUT_EMPTY_TIMER;
		tp->output_empty_id =
			timeout(tyd_check_if_output_empty,tp,tp->total_delay);
	}
}/*------------------------------------------------------------------*/
tyd_restart_out_pending_timer(tp)
register tyd_tty_t	*tp;
{
	if (tp->timer_enable & OUTPUT_PENDING_TIMER)
		untimeout(tp->out_pending_id);
	tp->total_delay = tyd_compute_delay(tp)/2;	/*wait til 1/2 empty*/
	if (tp->total_delay == 0)
		tp->total_delay = 1;
	tp->out_pending_id
		= timeout(tyd_out_pending_expired, tp, tp->total_delay);
	tp->timer_enable |= OUTPUT_PENDING_TIMER;
}/*------------------------------------------------------------------*/
/*
 *	compute amount of time it should take for the output buffer to empty
 *
 *	return	number of clock ticks (0 if buffer is empty)
 */
tyd_compute_delay(tp)
register tyd_tty_t	*tp;
{
	register struct ms_ctl *sram_ctl;
	int one_delay;		/* no. mills needed to output one byte */
	int total_delay_mills;	/* no. mills needed to output msq buffer */
	int total_delay;	/* no. clock ticks needed to output msq buffer*/
	int bytes_in_outbuf;

	sram_ctl = tp->sram_ctl;
	bytes_in_outbuf = sram_ctl->ms_out_tail - sram_ctl->ms_out_head;
	if (sram_ctl->ms_command & MS_FLUSH_XMIT_BUF || bytes_in_outbuf == 0)
		return(0);
	if (bytes_in_outbuf < 0)	/* deal with wrap of cir. buf */
		bytes_in_outbuf += MS_BUF_SIZE;
	one_delay = baud_wait[tp->termio.c_cflag & CBAUD];
	total_delay_mills = one_delay * bytes_in_outbuf;
	/* now convert milliseconds to clock ticks */
	total_delay = (total_delay_mills * HZ)/(1000*BAUD_SCALE);

	/* round up in case answer doesn't come out even, plus one more tick
	   because the next tick may be getting ready to occur */
	total_delay += 2;
	return(total_delay);
}/*------------------------------------------------------------------*/
/*
 *	routines that used to talk directly to the COM78808
 *
 *------------------------------------------------------------------*
 *
 *	tyd_cflag_program - tell SPM new cflag
 */
tyd_cflag_program(tp, cflag)
register tyd_tty_t	*tp;
register cflag;
{
	/* don't allow switch to unsupported baud rate (keep old speed) */
	if ( cflag & CBAUD && !baud_wait[cflag & CBAUD] )
		cflag = (tp->termio.c_cflag & CBAUD) | (cflag & ~CBAUD);

	tp->sram_ctl->cflag = cflag;
	tp->termio.c_cflag = cflag;		/* control mode flag */
	if (cflag & CBAUD)
		tp->state |= T_DTR_SET;			/* flag DTR on*/
	else	tp->state &= ~T_DTR_SET;		/* flag DTR off*/
}/*------------------------------------------------------------------*/
/*
 *	enable transmit interrupts for a device
 */
tyd_enable_transmitter(tp)
register tyd_tty_t	*tp;
{
/*	stub for iopattydvr on pm */
}/*------------------------------------------------------------------*/
/*
 *	enable receive interrupts for a device
 */
tyd_enable_receiver(tp)
register tyd_tty_t	*tp;
{
/*	stub for iopattydvr on pm */
}/*------------------------------------------------------------------*/
/*
 *	turn on dtr
 */
tyd_turn_on_dtr(tp)
register tyd_tty_t	*tp;
{
	tyd_cflag_program(tp, tp->termio.c_cflag);
	tyd_set_flag_cmd(tp);
}/*------------------------------------------------------------------*/
/*
 *	turn off dtr
 */
tyd_turn_off_dtr(tp)
register tyd_tty_t	*tp;
{
	tyd_cflag_program(tp, tp->termio.c_cflag & ~CBAUD);
	tyd_set_flag_cmd(tp);
}/*------------------------------------------------------------------*/
/*
 *	tell SPM to start sending a break to the terminal
 */
tyd_start_break(tp, delay)
register tyd_tty_t	*tp;
int	delay;			/* break duration in milliseconds */
{
	delay = (delay * HZ)/1000;		/* convert to clock ticks */
	tp->sram_ctl->break_duration = delay;
	atom_or_byte(&tp->sram_ctl->ms_command, MS_START_BREAK);
	tp->state |= BREAK_IN_PROGRESS;
	tyd_start_timer_for_step(tp, delay);
}/*------------------------------------------------------------------*/
/*
 *	SPM stops break on its own - this routine left in so
 *	'iopattydvr.c' doesn't have to change
 */
tyd_stop_break(tp)
register tyd_tty_t	*tp;
{
	atom_or_byte(&tp->sram_ctl->ms_command, MS_STOP_BREAK);
	tp->state &= ~BREAK_IN_PROGRESS;
}/*------------------------------------------------------------------*/
tyd_get_eia_status(tp)
register tyd_tty_t	*tp;
{
	uint 	tmp = 0, 
		status;

	status = tp->sram_ctl->eia_stat;

	if (status & UT_STATUS_DSR)
		tmp |= T_DSR;
	if (status & UT_STATUS_DCD)
		tmp |= T_DCD;

	return(tmp);
}/*------------------------------------------------------------------*/
tyd_log_status(tp, type)
register tyd_tty_t	*tp;
unchar type;			/* 0 = OPEN,
				   1 = CLOSE
				   2 = flush read_side
				   3 = flush write_side
				 */
{
	register ms_ctl_t *sram_ctl;	/* ptr to input control struct in sram*/

	sram_ctl = tp->sram_ctl;
	BUGCIR_LOG(tp->min_dev,
		(sram_ctl->ms_status << 8) | sram_ctl->ms_event,
		type, TYD_CIR_TEST3, 
		(sram_ctl->ms_in_head << 24) | (sram_ctl->ms_in_tail << 16) | 
		(sram_ctl->ms_out_head << 8) | sram_ctl->ms_out_tail);
}/*------------------------------------------------------------------*/
