/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) root.c: version 25.1 created on 11/27/91 at 14:59:21	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)root.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * root.c -- psuedo-device for accessing the root disk
 */

#include "sys/types.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/debug.h"
#include "sys/synch.h"
#include "sys/sysmacros.h"

#define NUM_ROOT_BUF	3

#define BUF_FLAG_MASK	(B_READ | B_BUSY | B_PHYS | B_ASYNC | B_READAHEAD)

/*
 * b_kern_bp should only be used by root_buf bufs, 'cuz they have no other use
 * for b_back
 */
#define b_kern_bp	b_back	
/*
 * drivers own the av_back field of kernel bufs
 */
#define b_root_ptr	av_back

extern dev_t	rootdev;

uint		root_dev;			/* pre-processed values	*/
uint		root_major, root_minor;
struct bdevsw	*root_bdev;			/* pre-processed pointers */
struct cdevsw	*root_cdev;

/* buffer management stuff */

static buf_t	*root_wait;			/* buffer waiting list	*/
static buf_t	*root_tail;			/* end of waiting list	*/
static buf_t	*root_free;			/* buffer free list	*/
static buf_t	root_buf[NUM_ROOT_BUF];		/* buffer pool		*/

static spin_lock_t	root_lock;

static void	rootiodone(), rootsend();

/*
 * rootstart -- set up root global variables after other driver
 *		init routines have been called
 *		(future mirror drivers may fool with rootdev)
 */

rootstart()
{
	register int	n;
	register buf_t	*bp;

	bp = &root_buf[NUM_ROOT_BUF - 1];
	for (n = NUM_ROOT_BUF; --n >= 0; bp--) {
		bp->b_root_ptr = root_free;
		root_free = bp;
		bp->b_iodone = rootiodone;
	}

	root_dev = notminored(rootdev);
	root_minor = minor(root_dev);
	root_major = major(root_dev);
	root_bdev = &bdevsw[root_major];
	root_cdev = &cdevsw[root_major];
	ASSERT(root_major < 128);
}

rootopen(minordev, flag, otype)
dev_t	minordev;
int	flag, otype;
{
	(*root_cdev->d_open)(root_minor, flag, otype);
}

rootclose(minordev, flag, otype)
dev_t	minordev;
int	flag, otype;
{
	(*root_cdev->d_close)(root_minor, flag, otype);
}

rootread(minordev)
dev_t	minordev;
{
	(*root_cdev->d_read)(root_minor);
}

rootwrite(minordev)
dev_t	minordev;
{
	(*root_cdev->d_write)(root_minor);
}

rootioctl(minordev, cmd, arg, mode)
dev_t	minordev;
int	cmd, arg, mode;
{
	(*root_cdev->d_ioctl)(root_minor, cmd, arg, mode);
}

rootprint(dev, msg)
dev_t	dev;
char	*msg;
{
	if (root_bdev->d_print)
		(*root_bdev->d_print)(root_dev, msg);
	else
		prdev(msg, root_dev);		/* let prdev cope with NULL */
}

/*
 * rootstrategy -- strategy routine for root psuedo-driver
 *
 *	We can't just pass kern_bp to rootdev's strategy routine, because
 *	b_dev would be wrong.  We can't change b_dev, because the buffer
 *	is hashed using it.  So, we have to alloc a buffer from our private
 *	pool, copy the necessary info into it, and send that buffer down to
 *	rootdev.  Rootiodone takes care of the recovery and reuse of our
 *	buffers, as well as doing the actual iodone on kern_bp.
 *
 *	Return so that caller can do an iowait() on the kernel bp.
 */

rootstrategy(kern_bp)
register buf_t	*kern_bp;
{
	register buf_t	*driver_bp;

	ASSERT(kern_bp->b_flags & B_BUSY);

	kern_bp->b_resid = kern_bp->b_bcount;

	/*
	 * allocate a root_buf, or wait for it
	 */
	spin_lock(&root_lock);
	if (!(driver_bp = root_free)) {
		if (root_wait)
			root_tail->b_root_ptr = kern_bp;
		else
			root_wait = kern_bp;
		root_tail = kern_bp;
		kern_bp->b_root_ptr = 0;
		spin_unlock(&root_lock);
		return;					/* wait */
	}
	else
		root_free = driver_bp->b_root_ptr;	/* got one */
	spin_unlock(&root_lock);

	rootsend(kern_bp, driver_bp);
}

/*
 * rootsend -- copy new driver info into driver_bp and send it on its way
 */

static void
rootsend(kern_bp, driver_bp)
register buf_t	*kern_bp, *driver_bp;
{
	driver_bp->b_kern_bp = kern_bp;		/* link buffers together */
	kern_bp->b_root_ptr = driver_bp;

	driver_bp->b_bcount = driver_bp->b_resid = kern_bp->b_bcount;
	driver_bp->b_un.b_addr = kern_bp->b_un.b_addr;
	driver_bp->b_dev = root_dev;
	driver_bp->b_blkno = kern_bp->b_blkno;
	driver_bp->b_flags = kern_bp->b_flags & BUF_FLAG_MASK;
	driver_bp->b_proc = kern_bp->b_proc;
	driver_bp->b_driver_flags = 0;
	driver_bp->b_error = 0;

	(*root_bdev->d_strategy)(driver_bp);
}

/*
 * rootiodone -- called by system iodone when driver_bp is finished
 *
 *	Updates kern_bp with the results in driver_bp, then does an
 *	iodone.  Recycles the driver_bp.
 */

static void
rootiodone(driver_bp)
register buf_t	*driver_bp;
{
	register buf_t	*kern_bp;

	ASSERT(driver_bp >= root_buf && driver_bp <= &root_buf[NUM_ROOT_BUF-1]);

	kern_bp = driver_bp->b_kern_bp;
	ASSERT(kern_bp);

	kern_bp->b_resid = driver_bp->b_resid;
	kern_bp->b_driver_flags |= (driver_bp->b_driver_flags & B_ERROR);
	if (! kern_bp->b_error)
		kern_bp->b_error = driver_bp->b_error;

	iodone(kern_bp);			/* done with kern_bp */

	/*
	 * if there are any requests queued up, send one out with this driver_bp
	 * otherwise, put driver_bp back on the free list
	 */

	spin_lock(&root_lock);
	if (kern_bp = root_wait) {
		root_wait = kern_bp->b_root_ptr;
		spin_unlock(&root_lock);
		rootsend(kern_bp, driver_bp);
	}
	else {
		driver_bp->b_kern_bp = 0;
		driver_bp->b_root_ptr = root_free;
		root_free = driver_bp;
		spin_unlock(&root_lock);
	}
}
