/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) openchk.c: version 25.1 created on 11/27/91 at 14:59:01	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)openchk.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * openchk.c -- keep track of open information for block devices
 *		returns non-zero on error and sets u.u_error
 */

#include "sys/types.h"
#include "sys/user.h"
#include "sys/open.h"
#include "sys/file.h"
#include "sys/errno.h"
#include "sys/debug.h"

/* convenience defines */
#define FLG_BCMS	(OFLG_BLK | OFLG_CHR | OFLG_MNT | OFLG_SWP)
#define FLG_BCMSM	(OFLG_BLK | OFLG_CHR | OFLG_MNT | OFLG_SWP | OFLG_MIR)

/*
 * ot_openchk -- keep track of open information for block devices
 *		returns non-zero on error and sets u.u_error
 */

ot_openchk(op, flag, type)
register opentyp_t	*op;
int			flag, type;
{
	int	err = 0;

	/*
	 * in all cases, its illegal to write to a mirrored device, except
	 * via the mirror driver (which intercepts the open)
	 */
	if ((flag & FWRITE) && (op->ot_flag & OFLG_MIR))
		return (u.u_error = EBUSY);

	switch (type) {
	case OTYP_BLK:
		if ((flag & FWRITE) && (op->ot_flag & OFLG_SWP))
			err = EBUSY;
		else
			op->ot_flag |= OFLG_BLK;
		break;
	case OTYP_MNT:
		if (op->ot_flag & FLG_BCMS)
			err = EBUSY;
		else
			op->ot_flag |= OFLG_MNT;
		break;
	case OTYP_CHR:
		if ((flag & FWRITE) && (op->ot_flag & (OFLG_SWP | OFLG_MNT)))
			err = EBUSY;
		else
			op->ot_flag |= OFLG_CHR;
		break;
	case OTYP_SWP:
		if (op->ot_flag & FLG_BCMS)
			err = EBUSY;
		else
			op->ot_flag |= OFLG_SWP;
		break;
	case OTYP_LYR:
		op->ot_lyrcnt++;
		break;
	case OTYP_MIR:
		if (op->ot_flag & FLG_BCMSM)
			err = EBUSY;
		else
			op->ot_flag |= OFLG_MIR;
		break;
	}

	if (err)
		u.u_error = err;

	return (err);
}

/*
 * ot_closechk -- bookeeping for block device closes
 */

ot_closechk(op, type)
opentyp_t	*op;
int		type;
{
	ASSERT(op->ot_all_opens);

	switch (type) {
	case OTYP_BLK:
	case OTYP_MNT:
	case OTYP_CHR:
	case OTYP_SWP:
	case OTYP_MIR:
		ASSERT(op->ot_flag & OTYP_FLG(type));
		op->ot_flag &= ~OTYP_FLG(type);
		break;
	case OTYP_LYR:
		ASSERT(op->ot_lyrcnt);
		op->ot_lyrcnt--;
		break;
	}
}
