/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mpt.c: version 25.1 created on 11/27/91 at 14:58:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mpt.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984, 1986, 1987, 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)nsu:io/mpt.c	1.4"
/*
  ================================================================
 =   WARNING!!!! This source is not supported in future source  =
 =   releases.                                                  =
 ================================================================
 */


#include "sys/types.h"
#include "sys/param.h"
#include "sys/sysmacros.h"
#include "sys/fs/s5dir.h"
#include "sys/stream.h"
#include "sys/stropts.h"
#include "sys/signal.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/mspt.h"

#ifdef DBUG
#define DEBUG(a)	 if (mpt_debug) cmn_err( CE_NOTE, a) 
#else
#define DEBUG(a)
#endif 

int mpt_debug = 0;


/*
 *   Master Stream Pipe
 */
#define PTM_ID 0xdead
int mptopen(), mptclose(), mptwput(), mptrsrv(), mptwsrv();
static struct module_info mpt_info = {PTM_ID, "mpt", 0, 512, 512, 128};
static struct qinit mptrint = {NULL, mptrsrv, mptopen, mptclose,NULL,&mpt_info, NULL};
static struct qinit mptwint = {mptwput, mptwsrv, mptopen, mptclose, NULL,&mpt_info, NULL};
struct streamtab mptinfo = {&mptrint, &mptwint, NULL, NULL};

/*
 * mspt_tty[] and mspt_cnt are defined in master.d file 
 */
extern struct mspt_ttys mspt_tty[];	
extern int mspt_cnt;

/*
 * Open a minor of the master device. Find an unused entry in the
 * mspt_tty array. Store the write queue pointer and set the
 * pt_state field to (PTMOPEN | PTLOCK).
 */
int 
mptopen(rqp, dev, flag, sflag)
queue_t *rqp;
dev_t dev;
int flag;
int sflag;
{
        register struct mspt_ttys *mptp;
	mblk_t *mp;
	struct stroptions *sop;
	dev_t fulldevno;

	DEBUG(("entering mptopen\n"));
	fulldevno = dev & 0xff00;	/* to set ttyd later */
	fulldevno &= UNMINOR_MASK;	/* to set ttyd later */
	for(dev=0; dev < mspt_cnt; dev++)
		if (!(mspt_tty[dev].pt_state & 
			(PTMOPEN | PTSOPEN | PTLOCK)))
				break;

	if (sflag != CLONEOPEN) {
		DEBUG(("invalid sflag\n"));
		u.u_error = EINVAL;
		return(OPENFAIL);
	}

        if (dev >= mspt_cnt) {
		DEBUG(("no more devices left to allocate\n"));
		u.u_error = ENXIO;
                return(OPENFAIL);
	}
	fulldevno |= dev & 0x00ff;	/* get the real minor number	*/
	/*
	 * set up hi/lo water marks on stream head read queue
	 */
	if ((mp = allocb(sizeof(struct stroptions), BPRI_MED)) == NULL) {
		u.u_error = EAGAIN;
		return(OPENFAIL);
	}
	mp->b_datap->db_type = M_SETOPTS;
	mp->b_wptr += sizeof(struct stroptions);
	sop = (struct stroptions *)mp->b_rptr;
	sop->so_flags = SO_HIWAT|SO_LOWAT;
	sop->so_hiwat = 512;
	sop->so_lowat = 256;
	putnext(rqp, mp);

        mptp = &mspt_tty[dev];

	/*
	 * set up the entries in the mspt_ttys structure for this
	 * device.
	 */
	mptp->pt_state = (PTMOPEN | PTLOCK);
	mptp->mpt_wrq = WR(rqp);
	mptp->spt_wrq = NULL;
	mptp->pt_bufp = NULL;
	WR(rqp)->q_ptr = (char *) mptp;
	rqp->q_ptr = (char *) mptp;

	if (mptp->spt_wrq)
		if ((mptp->spt_wrq)->q_next) {
			DEBUG(("send hangup to an already existing slave\n"));
			putctl(RD(mptp->spt_wrq)->q_next, M_HANGUP);
		}
	/*
	 * if process leader with no controlling tty and 
	 * stream is unassigned, assign controlling tty.
	 */
	if (( u.u_procp->p_pid == u.u_procp->p_session_id)
		&& ( u.u_ttyp == NULL) && ( mptp->tty == 0)) {
		u.u_ttyp = &mptp->tty; 
		u.u_ttyd = fulldevno;
		mptp->tty = u.u_procp->p_pgrp;
	}

	DEBUG(("returning from mptopen()\n"));
	return(dev);
}


/*
 * Find the address to private data identifying the slave's write queue.
 * Send a hang-up message up the slave's read queue to designate the
 * master/slave pair is tearing down. Uattach the master and slave by 
 * nulling out the write queue fields in the private data structure.  
 * Finally, unlock the master/slave pair and mark the master as closed.
 */
int 
mptclose(rqp)
queue_t *rqp;
{
        register struct mspt_ttys *mptp;
        register queue_t *spt_rdq;

	ASSERT(rqp->q_ptr);
		
	DEBUG(("entering mptclose\n"));
        mptp = (struct mspt_ttys *)rqp->q_ptr;
	if (mptp->spt_wrq) {
		spt_rdq = RD(mptp->spt_wrq);
		if(spt_rdq->q_next) {
			DEBUG(("send hangup message to slave\n"));
			putctl(spt_rdq->q_next, M_HANGUP); 
		}
	}
	freemsg(mptp->pt_bufp);
	mptp->pt_bufp = NULL;
        mptp->mpt_wrq = NULL;
	mptp->pt_state &= ~(PTMOPEN | PTLOCK);
	rqp->q_ptr = NULL;
	WR(rqp)->q_ptr = NULL;
	mptp->tty = 0;
	u.u_ttyp = NULL;
	u.u_ttyd = 0;
	DEBUG(("returning from mptclose\n"));
	return;
}

/*
 * The wput procedure will only handle ioctl and flush messages.
 */
int 
mptwput(qp, mp)
queue_t *qp;
mblk_t *mp;
{
        register struct mspt_ttys *mptp;
	struct iocblk *iocp;
	
	DEBUG(("entering mptwput\n"));
	ASSERT(qp->q_ptr);

        mptp = (struct mspt_ttys *) qp->q_ptr;
		
	switch(mp->b_datap->db_type) {
		/*
		 * if write queue request, flush master's write
		 * queue and send FLUSHR up slave side. If read 
		 * queue request, convert to FLUSHW and putctl1().
		 */
		case M_FLUSH:
			DEBUG(("mpt got flush request\n"));
			if (*mp->b_rptr & FLUSHW) {
				DEBUG(("flush mpt write Q\n"));
				flushq(qp, FLUSHDATA);
				if(mptp->spt_wrq && !(mptp->pt_state & PTLOCK)) {
					DEBUG(("putctl1 FLUSHR to spt\n"));
					putctl1(RD(mptp->spt_wrq)->q_next, M_FLUSH, FLUSHR);
				}
			}
			if (*mp->b_rptr & FLUSHR) {
				DEBUG(("got read, putctl1 FLUSHW\n"));
				if(mptp->spt_wrq && !(mptp->pt_state & PTLOCK))
					putctl1(RD(mptp->spt_wrq)->q_next, M_FLUSH, FLUSHW);
			}
			freemsg(mp);
			break;

		case M_IOCTL:
			iocp = (struct iocblk *)mp->b_rptr;
			switch(iocp->ioc_cmd) {
			default:
				 if((mptp->pt_state  & PTLOCK) || 
				    (mptp->spt_wrq == NULL)) {
					DEBUG(("got M_IOCTL but no slave\n"));
					mp->b_datap->db_type = M_IOCNAK;
					freemsg(mp->b_cont);
					mp->b_cont = NULL;
					qreply(qp, mp);
					return;
				}
				putq(qp, mp);
				break;
			case ISPTM:
				mp->b_datap->db_type = M_IOCACK;
				iocp->ioc_error = 0;
				iocp->ioc_count = 0;
				DEBUG(("ack the ISPTM\n"));
				qreply(qp, mp);
				break;
			case UNLKPT:
				mptp->pt_state &= ~PTLOCK;
				mp->b_datap->db_type = M_IOCACK;
				iocp->ioc_error = 0;
				iocp->ioc_count = 0;
				DEBUG(("ack the UNLKPT\n"));
				qreply(qp, mp);
				break;
			}
			break;
		
		/*
		 * send other messages to slave
		 */
		default:
			if((mptp->pt_state  & PTLOCK) || (mptp->spt_wrq == NULL)) {
				DEBUG(("got msg. but no slave\n"));
				putctl1(RD(qp)->q_next, M_ERROR,EINVAL);
				freemsg(mp);
				return;
			}
			DEBUG(("put msg on master's write queue\n"));
			putq(qp, mp);
			break;
	}
	DEBUG(("return from mptwput()\n"));
	return;
}


/*
 * enable the write side of the slave. This triggers the 
 * slave to send any messages queued on its write side to
 * the read side of this master.
 */
int 
mptrsrv(qp)
queue_t *qp;
{
        register struct mspt_ttys *mptp;
	
	DEBUG(("entering mptrsrv\n"));
	ASSERT(qp->q_ptr);

        mptp = (struct mspt_ttys *) qp->q_ptr;
	if (mptp->spt_wrq)
		qenable(mptp->spt_wrq);
	DEBUG(("leaving mptrsrv\n"));
}
		


/*
 * If there are messages on this queue that can be sent to 
 * slave, send them via putnext(). Else, if queued messages 
 * cannot be sent, leave them on this queue. If priority 
 * messages on this queue, send them to slave no matter what.
 */
int 
mptwsrv(qp)
queue_t *qp;
{
        register struct mspt_ttys *mptp;
        register queue_t *spt_rdq;
	mblk_t *mp;
	
	DEBUG(("entering mptwsrv\n"));
	ASSERT(qp->q_ptr);

        mptp = (struct mspt_ttys *) qp->q_ptr;
	if (mptp->spt_wrq)
		spt_rdq = RD(mptp->spt_wrq);
	else
		spt_rdq = NULL;
		
	if((mptp->pt_state  & PTLOCK) || (spt_rdq == NULL)) {
		DEBUG(("in master write srv proc but no slave\n"));
		putctl1(RD(qp)->q_next, M_ERROR, EINVAL);
		return;
	}
	/*
	 * while there are messages on this write queue...
	 */
	while ((mp = getq(qp)) != NULL) {
		/*
		 * if don't have control message and cannot put
		 * msg. on slave's read queue, put it back on 
		 * this queue.
		 */
		if (mp->b_datap->db_type <= QPCTL && 
				!canput(spt_rdq->q_next)) {
			DEBUG(("put msg. back on queue\n"));
			putbq(qp, mp);
			break;
		}
		/*
		 * else send the message up slave's stream
		 */
		DEBUG(("send message to slave\n"));
		putnext(spt_rdq, mp);
	}
	DEBUG(("leaving mptwsrv\n"));
}

