/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) mem.c: version 25.1 created on 11/27/91 at 14:58:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)mem.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#include "sys/types.h"
#include "sys/kmem.h"
#include "sys/vmem.h"
#include "sys/param.h"
#include "sys/immu.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/proc.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/ioctl.h"
#include "sys/spm_mem.h"


mmread(dev)
register dev_t	dev;
{
	register unsigned int	n, po, addr;

	dev = minor(dev);

	/*
	 * kernel virtual space exists from 0x8000000 to 0xffffffff.
	 * u.u_offset is a signed quantity.
	 * read rejects u.u_offset < 0.
	 *
	 * so for /dev/kmem we will respond to requests from
	 * 0x0 to 0x7ffffffff, as if they were requests for
	 * 0x80000000 to 0xfffffff.
	 */
	switch (dev) {
	case 0:		/* /dev/mem */
		if (u.u_offset >= ctob(physmem)) {
			u.u_error = ENXIO;			/* bad addr */
			return;
		}
		addr = (uint)u.u_offset + MAINSTORE;
		break;

	case 1:		/* /dev/kmem */
		addr = (uint)u.u_offset + KMEM_START;
		if ( !goodkv(addr) ) {
			u.u_error = ENXIO;
			return;
		}
		break;

	default:	/* /dev/null */
		addr = u.u_offset;
	}

	while (u.u_error == 0 && u.u_count != 0)  {
		n = min(u.u_count, ctob(1));

		switch (dev) {
		/*
		 * read /dev/mem
		 */
		case 0:

			/*	Don't try to read from mainstore
			**	we don't have.
			*/

			if (u.u_offset >= ctob(physmem))
				return;
			po = u.u_offset % ctob(1);
			n = min(n, ctob(1) - po);
			if (copyout(addr, u.u_base, n))
				u.u_error = EFAULT;
			break;

		/*
		 * read file /dev/kmem
		 */
		case 1:
			if ( !goodkv(addr) )
				return;
			po = u.u_offset % ctob(1);
			n = min(n, ctob(1) - po);
			if (copyout(addr, u.u_base, n))
				u.u_error = EFAULT;
			break;

		default:
			return;
		}

		u.u_offset += n;
		u.u_base += n;
		u.u_count -= n;
		addr += n;
	}
}

mmwrite(dev)
register dev_t	dev;
{

	register unsigned int	n, po, addr;

	dev = minor(dev);

	/*
	 * kernel virtual space exists from 0x8000000 to 0xffffffff.
	 * u.u_offset is a signed quantity.
	 * write rejects u.u_offset < 0.
	 *
	 * so for /dev/kmem we will responsed to requests from
	 * 0x0 to 0x7ffffffff, as if they were requests for
	 * 0x80000000 to 0xfffffff.
	 */
	switch (dev) {
	case 0:		/* /dev/mem */
		if (u.u_offset >= ctob(physmem)) {
			u.u_error = ENXIO;			/* bad addr */
			return;
		}
		addr = (uint)u.u_offset + MAINSTORE;
		break;

	case 1:		/* /dev/kmem */
		addr = (uint)u.u_offset + KMEM_START;
		if ( !goodkv(addr) ) {
			u.u_error = ENXIO;
			return;
		}
		break;

	default:	/* /dev/null */
		addr = u.u_offset;
	}

	while (u.u_error == 0 && u.u_count != 0)  {
		n = min(u.u_count, ctob(1));

		switch (dev) {
		/*
		 * write /dev/mem
		 */
		case 0:

			/*
			 * offset is beyond end of mainstore
			 */

			if (u.u_offset >= ctob(physmem))
				return;
			po = u.u_offset % ctob(1);
			n = min(n, ctob(1) - po);
			if (copyin(u.u_base, addr, n))
				u.u_error = EFAULT;
			break;

		/*
		 * write file /dev/kmem
		 */
		case 1:
			if ( !goodkv(addr) )
				return;
			po = u.u_offset % ctob(1);
			n = min(n, ctob(1) - po);
			if (copyin(u.u_base, addr, n))
				u.u_error = EFAULT;
			break;

		default:
			;
		}

		u.u_base += n;
		u.u_count -= n;
		u.u_offset += n;
		addr += n;
	}
}

/*
 * This is an ioctl for ps to use in lieu of a kernel file
 * to do an nlist on.  Since ps only cares about a few symbols
 * we will have a separate hardwired command for each symbol.
 */

mmioctl(dev, cmd, arg, mode) 
dev_t	dev;
{
	uint	addr;
	static int	fake_swplo;

	switch ( cmd ) {

	case  KV_ADDR_PROC:
		addr = (uint)proc;
		break;
	case  KV_ADDR_SWPLO:
		addr = (uint)&fake_swplo;
		break;
	case  KV_ADDR_V:
		addr = (uint)&v;
		break;
	default:
		u.u_error = EINVAL;
		return;
	}

	if ( suword(arg, addr) == -1 )
		u.u_error = EFAULT;
}

/*
** goodkv checks the validity of a kernel virtual addr for /dev/kmem.
** We allow access to all "physical" mem (ie a0000000).
** We allow access to valid pages in SYS_SEGS (ie 90000000).
** We allow access to selected pages OWN_SEGS (ie 80000000).
*/
goodkv(addr)
uint  addr;
{
	if ( addr >= MAINSTORE && addr < MAINSTORE + ctob(physmem) )
		return 1;

	if ( addr >= ADDR_SYS_SEGS &&
	     addr < ADDR_SYS_SEGS + ctob(spm_mem.kv_size) )
	{
		if ( pg_isvalid(&spm_mem.kptbl[btoct(addr - ADDR_SYS_SEGS)]) )
			return 1;
	}

	if ( addr >= ADDR_OWN_SEGS &&
	     addr < ADDR_OWN_SEGS + NBPS )	/* One segment only */
	{
		if ( pg_isvalid(&((pde_t *)ADDR_OWN_PTBL)[btoct(addr - ADDR_OWN_SEGS)]) )
			return 1;
	}

	return 0;
}
