/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopmclone.c: version 25.1 created on 11/27/91 at 14:58:04	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopmclone.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/errno.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/user.h"
#include "sys/stream.h"
#include "sys/sysmacros.h"
#include "sys/conf.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"

#if	0	/* we don't need clone debug for now */
#define CLN_DEBUG			/* debug extended minor stuff */
#endif

#define NUM_MINORS	makedev(1, 0)		/* number of minors per major */

int iopmclnopen();

static struct module_info iopm_clnm_info = { 0, "IOPMCLN", 0, 0, 0, 0 };
static struct qinit iopmclnrinit = { NULL, NULL, iopmclnopen, NULL, NULL, &iopm_clnm_info, NULL };
static struct qinit iopmclnwinit = { NULL, NULL, NULL, NULL, NULL, &iopm_clnm_info, NULL };
struct streamtab iopmclninfo = { &iopmclnrinit, &iopmclnwinit };

/* The iopmclonetable maps iopmclone minor numbers to iopm str minor numbers */
short  iopmclonetable[256];

iopmclninit()
{
	uint  i;

	for ( i = 0; i < 256; i++ )
		iopmclonetable[i] = -1;

#if defined IOPM_DRIVERS_LOADED
	iopmclonetable[0] = 0x400;
	iopmclonetable[1] = 0x500;
	iopmclonetable[2] = 0x600;
	iopmclonetable[3] = 0x700;
#endif
}

/*
 * IOPM clone open.  Dev is index into a table of IOPM stream kernel minor
 * numbers.  Call iops_open with the kernel minor number and CLONEOPEN.  Attach
 * its qinit
 * structures to the read and write queues and call its open
 * with the q and the dev CLONEOPEN.  Swap in a new inode with
 * the real device number constructed from the major and the
 * minor returned by the device open.  
 */

iopmclnopen(q, dev, flag, sflag)
queue_t *q;
dev_t	dev;
{
	register int		i, maj, mindev, rdev;
	register struct streamtab	*st;
	extern struct streamtab iopms_info;
	ushort kmin;

	if (sflag)
		return(OPENFAIL);

	/* get the iopm streams driver minor number */
	if ( (kmin = iopmclonetable[ minor(dev) ]) == -1 )
	{
		u.u_error = ENXIO;
		return(OPENFAIL);
	}

	/*
	 * Substitute the real qinit values for the current ones
	 */
	st = &iopms_info;
	setq(q, st->st_rdinit, st->st_wrinit);

	{
		register struct cdevsw	*cdp;

		/*
		 * For extended minor devices, you can't assume that the
		 * majors are adjacent, so scan cdevsw for the correct major.
		 */
		rdev = kmin / NUM_MINORS;
		cdp = cdevsw;
		for (i = 0; i < cdevcnt; i++, cdp++) {
			if (st == cdp->d_str && --rdev < 0) {
				maj = i;
				mindev = kmin &  NUM_MINORS - 1;
				break;			/* found major */
			}
		}
		if (i >= cdevcnt) {
			cmn_err(CE_NOTE,
			  "iopmclnopen: can't find major! dev=0x%x min=0x%x\n",
			  denotminored(rdev), mindev);
			u.u_error = ENXIO;
			return(OPENFAIL);
		}
#ifdef CLN_DEBUG
		printf("clnopen: found major=0x%x, minor=0x%x\n", maj, mindev);
#endif
	}
	/*
	 * Call the device open with the stream flag  CLONEOPEN.  The device
	 * will either fail this or return a minor device number.
	 */
	rdev = 0x8000 | makedev( maj, mindev );
	mindev = (*q->q_qinfo->qi_qopen)(q, rdev, flag, CLONEOPEN);
	if (mindev == OPENFAIL)
		return(OPENFAIL);

	/*
	 * Got an extended minor device if mindev is greater than the maximum
	 * number of minor devices per major device, or if the given major
	 * device number is an extended one.
	 */
	if (mindev >= NUM_MINORS ) {
		register struct cdevsw	*cdp;
		register struct streamtab  *strtab;

#ifdef CLN_DEBUG
		printf("clnopen: mindev=0x%x, rdev=0x%x, MINOR[maj]=0x%x\n",
		  mindev, rdev, MINOR[maj]);
#endif
		/*
		 * For extended minor devices, you can't assume that the
		 * majors are adjacent, so scan cdevsw for the correct major.
		 */
		strtab = cdevsw[maj].d_str;
		rdev = mindev / NUM_MINORS;
		cdp = cdevsw;
		for (i = 0; i < cdevcnt; i++, cdp++) {
			if ( strtab == cdp->d_str && --rdev < 0 ) {
				maj = i;
				mindev &= NUM_MINORS - 1;
				break;			/* found major */
			}
		}
		if (i >= cdevcnt) {
			cmn_err(CE_NOTE,
			  "clnopen: can't find major! dev=0x%x min=0x%x\n",
			  denotminored(rdev), mindev);
			u.u_error = ENXIO;
			return(OPENFAIL);
		}
#ifdef CLN_DEBUG
		printf("clnopen: found major=0x%x, minor=0x%x\n", maj, mindev);
#endif
	}

	{
	register struct file	*fp;
	register inode_t	*ip, *nip;
	register struct mount	*mp;
	register struct stdata	*sd = (struct stdata *)q->q_next->q_ptr;

	for (i = 0; i < u.u_nofiles; i++)
		if ((fp = GET_OFILE(i)) && (fp->f_inode->i_sptr == sd))
			break;
	ASSERT(i < u.u_nofiles);

	ip = fp->f_inode;

	/*
	 * Get the inode at top of this stream, allocate a new inode,
	 * and exchange the new inode for the old one.
	 */
	rdev = makedev(maj, mindev);

	ASSERT(ip->i_sptr);

	/* set up dummy inode */

	/*
	 * Allocate an inode from the pipe file system.
	 */
	ASSERT(pipefstyp > 0 && pipefstyp < nfstyp);
	mp = fsinfo[pipefstyp].fs_pipe;
	ASSERT(mp != NULL);
	if ((nip = (*fstypsw[pipefstyp].fs_getinode)(mp, FSG_CLONE, rdev)) == NULL){
		(*q->q_qinfo->qi_qclose)(q, flag);
		return(OPENFAIL);
	}

	plock(ip);

	nip->i_sptr = ip->i_sptr;

	/* 
	 * link dummy inode to file table and to the stream 
	 */
	ip->i_sptr = NULL;	/* no other clone open will get this stream */
	fp->f_inode = nip;
	nip->i_sptr->sd_rdev = rdev;

	/*
	 * set sd_icnt to 1 in case an open comes
	 * in for the same dev on a different inode.
	 */

	nip->i_sptr->sd_icnt = 1;
	nip->i_sptr->sd_strtab = st;
	iput(ip);
	prele(nip);
	}
	return(mindev);
}	
