/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopmb.c: version 25.1 created on 11/27/91 at 14:57:59	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopmb.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/errno.h"
#include "sys/sysmacros.h"
#include "sys/types.h"
#include "sys/spm_mem.h"
#include "sys/sbus_pm.h"
#include "sys/buf.h"
#include "sys/iopmcomm.h"
#include "sys/user.h"
#include "sys/sbus_iopm.h"
#include "sys/iopmbuf.h"
#include "sys/pm_iomap.h"
#include "sys/iopmsltbl.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"
#include "sys/iopmdebug.h"

extern struct buf    *geteblk();

extern uchar             *iopm_intr_addr[];
extern struct iopm_comm  *iopm_base[];

struct buf  *itokb;

struct iopmsltbl  iopmbtbl[SLTBLSZ];

#define IOPMSLOT iopmbtbl[minordev >> MNPGSHFT].iopmslot
#define MKIOSLOT(sslot, subslot)  (((sslot) << 4) | ((subslot) & 0xf))

#define	DEVS_PER_DSDB	2048
#define MAX_DSDB	16
#define	DSDB_DEVS	(MAX_DSDB * DEVS_PER_DSDB)

/******************************************************************************/
init_iopmb(slot, db_id)
uint	slot;
uint	db_id;
{
	static struct iopmsltbl	*btblp = iopmbtbl;
	uint			minor_dev;

	iopm_base[slot]->itokbp = &itokb;

	switch (db_id) {
	case IOPM_DB_ID_DSDB:
	case IOPM_DB_ID_DSDB_FIX:

		if (btblp == iopmbtbl + (DSDB_DEVS >> MNPGSHFT))
			cmn_err(CE_WARN, "Too many DSDB boards");

		for (minor_dev = 0; minor_dev != DEVS_PER_DSDB;
		  minor_dev += 1 << MNPGSHFT) {
			btblp->iopmslot = slot;
			btblp->iopmdev = notminored(minor_dev);
			btblp->valid = 1;
			btblp++;
		}
		break;
	}
}

/******************************************************************************/
dev_t
iopmb_dev(dsdb_num, phys, log)
uint	dsdb_num;
uint	phys;
uint	log;
{
	extern uint	iopmb_major;
	extern dev_t	extended_makedev();

	return (extended_makedev(iopmb_major, 
		dsdb_num * DEVS_PER_DSDB + phys * 16 + log));
}

/******************************************************************************/
iopmb_open(minordev, flag, otyp)
dev_t minordev;
{
	register buf_t	*bp;
	struct iopmbcb	*iocb;

	PRINT(OPEN, "iopmb_open: ");

	ASSERT(!(minordev & UNMINOR_BIT));

	if ( iopmbtbl[minordev >> MNPGSHFT].valid == 0 )
	{
		u.u_error = ENXIO;
		return;
	}

	ASSERT(is_IOPM(IOPMSLOT));
	ASSERT(iopm_base[IOPMSLOT]->iopm_version == IOPM_VERSION);

	if ( !iopm_base[IOPMSLOT]->itokbp )
		init_iopmb(IOPMSLOT);

	bp = geteblk();
	bp->b_dev = minordev;
	bp->b_driver_flags = I_OPEN;	/* use this to tell iopm driver open */
	iocb = (struct iopmbcb *)bp->b_un.b_addr;
	iocb->ib_pid = u.u_procp->p_pid;
	iocb->ib_pgrp = u.u_procp->p_pgrp;
	iocb->ib_session_id = u.u_procp->p_session_id;
	iocb->ib_uid = u.u_uid;
	iocb->ib_gid = u.u_gid;
	iocb->ib_ruid = u.u_ruid;
	iocb->ib_rgid = u.u_rgid;
	iocb->ib_arg1.flag = flag;
	iocb->ib_arg2.otyp = otyp;

	PRINT3(OPEN,"bp = %x, flag = %x, otyp = %x\n",bp,flag,otyp);

	sendbptoiopm(bp);
	iowait(bp);
	brelse(bp);
}

/******************************************************************************/
iopmb_close(minordev, flag, otyp)
dev_t minordev;
{
	register struct buf  *bp;

	PRINT3(CLOSE,"iopmb_close: minordev = %x, flag = %x, otyp = %x ",
	  minordev, flag, otyp);

	bp = geteblk();
	bp->b_dev = minordev;
	bp->b_driver_flags = I_CLOSE;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_pid = u.u_procp->p_pid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_pgrp = u.u_procp->p_pgrp;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_session_id =
	  u.u_procp->p_session_id;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_uid = u.u_uid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_gid = u.u_gid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_ruid = u.u_ruid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_rgid = u.u_rgid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_arg1.flag = flag;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_arg2.otyp = otyp;

	PRINT1(CLOSE, "bp = %x\n",bp);

	sendbptoiopm(bp);
	iowait(bp);
	brelse(bp);
}

/******************************************************************************/
iopmb_strategy(bp)
register struct buf  *bp;
{
	PRINT2(STRAT,"iopmb_strategy: bp = %x, dev = %x\n", bp, bp->b_dev);

	bp->b_driver_flags = I_STRAT;
	sendbptoiopm(bp);
}

/******************************************************************************/
iopmb_ioctl(minordev, cmd, arg, mode)
{
	register struct buf  *bp;

	bp = geteblk();
	bp->b_dev = minordev;
	bp->b_driver_flags = I_IOCTL;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_pid = u.u_procp->p_pid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_pgrp = u.u_procp->p_pgrp;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_session_id =
	  u.u_procp->p_session_id;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_uid = u.u_uid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_gid = u.u_gid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_ruid = u.u_ruid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_rgid = u.u_rgid;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_arg1.cmd = cmd;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_arg2.arg = arg;
	((struct iopmbcb *)bp->b_un.b_addr)->ib_arg3.mode = mode;

	PRINT4(IOCTL,"iopmb_ioctl: bp = %x, cmd = %x, arg = %x, mode = %x\n",
	  bp, cmd, arg, mode);

	sendbptoiopm(bp);
	iowait(bp);

	while ( bp->b_driver_flags & I_DATA )
	{
		arg = (int)bp->av_back;
		if ( bp->b_driver_flags & B_READ )
		{

			PRINT5(IOCTL|DATA, "iopm_ioctl: data at %x = %x,%x,%x,%x ",
			  bp->b_un.b_addr,*(uchar *)bp->b_un.b_addr,
			  *(uchar *)(bp->b_un.b_addr+1),
			  *(uchar *)(bp->b_un.b_addr+2),
			  *(uchar *)(bp->b_un.b_addr+3));
			PRINT2(IOCTL|DATA,"copied to %x, len = %x\n",
			  arg, bp->b_resid);

			if ( copyout(bp->b_un.b_addr, arg, bp->b_resid) )
				bp->b_driver_flags = I_ERROR;
		}
		else
		{
			if ( copyin(arg, bp->b_un.b_addr, bp->b_resid) )
				bp->b_driver_flags = I_ERROR;

			PRINT5(IOCTL|DATA, "iopm_ioctl: data at %x = %x,%x,%x,%x ",
			  bp->b_un.b_addr,*(uchar *)bp->b_un.b_addr,
			  *(uchar *)(bp->b_un.b_addr+1),
			  *(uchar *)(bp->b_un.b_addr+2),
			  *(uchar *)(bp->b_un.b_addr+3));
			PRINT2(IOCTL|DATA,"copied from %x, len = %x\n",
			  arg, bp->b_resid);

		}

		bp->b_flags &= ~B_DONE;	/* clear B_DONE before iowait */
		sendbptoiopm(bp);
		iowait(bp);
	}
	u.u_rval1 = ((struct iopmbcb *)bp->b_un.b_addr)->ib_rval;
	brelse(bp);
}

/******************************************************************************/
iopmb_print( dev, msg )
dev_t  dev;
char   *msg;
{
	register dev_t       minordev = minor(notminored(dev));
	register struct buf  *bp;

	if ( iopmbtbl[minordev >> MNPGSHFT].valid == 0 )
	{
		cmn_err(CE_WARN, "iopmb_print: bad IOPM dev %x, msg = '%s'",
		  dev, msg);
		return;
	}

	ASSERT(is_IOPM(IOPMSLOT));

	bp = geteblk();
	bp->b_dev = minordev;
	bp->b_driver_flags = I_PRINT;
	*(char **)bp->b_un.b_addr = msg;

	sendbptoiopm(bp);
	iowait(bp);
	brelse(bp);
}

/******************************************************************************/
iopmb_read(minordev)
dev_t  minordev;
{
	extern             iopmb_strategy();

	PRINT2(READ,"iopmb_read: base = %x, count = %x\n",u.u_base,u.u_count);

	physio(iopmb_strategy, 0, minordev, B_READ);
}

/******************************************************************************/
iopmb_write(minordev)
dev_t  minordev;
{
	extern             iopmb_strategy();

	PRINT2(READ,"iopmb_write: base = %x, count = %x\n",u.u_base,u.u_count);

	physio(iopmb_strategy, 0, minordev, B_WRITE);
}

/******************************************************************************/
/*
** use av chain to link requests until iopm gets to them and transfers them
** into the iopm local memory.
** The bufs remain in the other chain as long as they are associated with
** the device.
*/
#define IOPM_COMMP iopm_base[iopmbtbl[minordev >> MNPGSHFT].iopmslot]
#define KTOIB  IOPM_COMMP->ktoib

sendbptoiopm(bp)
register struct buf  *bp;
{
	register dev_t  minordev = minor(bp->b_dev);

	PRINT2(SEND, "sendbptoiopm: slot=%x, bp=%x ", IOPMSLOT, bp);
	BPRINT_TYPE(SEND, bp);
	PRINT(SEND, "\n");

	bp->av_back = 0;
	bp->b_resid = iopmbtbl[minordev >> MNPGSHFT].iopmdev +
	  (minordev & MNPG - 1);
	add_chain(&KTOIB, bp, &bp->av_forw);

	intriop(IOPMSLOT);
}

/*****************************************************************************/
/* interrupt from iopm
*/
iopmb_intr()
{
	struct buf  *bp;
	struct buf  *bp_next;

	bp = (buf_t *)remove_chain(&itokb);

	while ( bp )
	{
		bp_next = bp->av_forw;

		PRINT1(INTR, "BUF INTR bp=%x ", bp);
		BPRINT_TYPE(INTR, bp);
		PRINT(INTR, "\n");

		iodone(bp);
		bp = bp_next;
	}
}





/*****************************************************************************/
	/* extended_makedev, like makedev but works with extended minors */
	/* FIX MSS, move this routine to an OS file */

dev_t
extended_makedev(maj, min)
int	maj;
uint	min;
{
	ASSERT(maj >= 0);

	while (min >= 256) {
		min -= 256;
		maj = next_major(maj);
		if (maj < 0)
			return(NODEV);
	}
	return(makedev(maj, min));
}
