/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) iopm.c: version 25.1 created on 11/27/91 at 14:57:53	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)iopm.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/user.h"
#include "sys/mfs.h"
#include "sys/errno.h"
#include "sys/sbus.h"
#include "sys/sysmacros.h"
#include "sys/spm_mem.h"
#include "sys/kmem.h"
#include "sys/sbus_iopm.h"
#include "sys/iopmcomm.h"
#include "sys/iopmsltbl.h"
#include "sys/iopmioctl.h"
#include "sys/sbus_spm.h"
#include "sys/debug.h"

uchar  *iopm_intr_addr[256];

/* Base of IOPM_COMM on each IOPM. Indexed by IOPM #. Init in iomap_init */
struct iopm_comm  *iopm_base[256];

uint             iopm_slp_flag;
struct sem_lock  iopm_slp_lock;

extern uchar  *iomap();

extern struct iopmsltbl  iopmbtbl[];
extern struct iopmsltbl  iopmstbl[];

#define IOPM_COMMP iopm_base[slot]

#define SSLOT(x)  ((x) >> 4)
#define SUBSLOT(x)  ((x) & 0xf)

#ifdef IOPMDEBUG
int  iopm_dbg = IOPMDEBUG;
#else
int  iopm_dbg = 0;
#endif

/******************************************************************************/
/** only one pm runs iopm_init */
iopm_init()
{
	int slot;
	int i;
	int iopmnum = 0;
	int lastslot;
	uint	db_id;
	uint	iopm_db_id();

	for ( slot = 0; slot < 256; slot++ )
		if ( is_IOPM(slot) )
		{
			iopmnum = 1;
			db_id = iopm_db_id(slot);
			if ( SUBSLOT(slot) == 0xf )
			{
				iopm_intr_addr[slot] =
				  (uchar *)sbus_map(SSLOT(slot), INT_CTRL_REG);
				iopm_base[slot] =
				  (struct iopm_comm *)piomap(SSLOT(slot),
				  IOPM_COMM);
				lastslot = slot;
			}
			else
			{
				iopm_intr_addr[slot] =
				  (uchar *)piosba_map(SSLOT(slot),
				  SUBSLOT(slot), INT_CTRL_REG);
				iopm_base[slot] =
				  (struct iopm_comm *)piosba_map(SSLOT(slot),
				  SUBSLOT(slot), IOPM_COMM);
			}

			init_iopms(slot);
			init_iopmb(slot, db_id);
		}
		else
		{
			/* guarantee a buserr for invalid slots */
			iopm_intr_addr[slot] = (uchar *)ADDR_OWN_BAD;
			iopm_base[slot] = (struct iopm_comm *)ADDR_OWN_BAD;
		}

#if defined IOPM_DRIVERS_LINKED
	if (iopmnum == 0)
		return;
	/* 8 groups of 256 minors */
	for ( i = 0; i < 128; i++ )
	{
		iopmbtbl[i].iopmslot = lastslot;
		iopmbtbl[i].iopmdev = 0x8000|(i<<4);
		iopmbtbl[i].valid = 1;
	}
#endif
}

/******************************************************************************/
/*
 * iopm_to_kern_dev -- return the dev_t number for a given iunit_t, or NODEV.
 *
 * FIX MSS, THIS WHOLE ROUTINE NEEDS TO BE RECONSIDERED
 */
dev_t
iopm_to_kern_dev(spm_dev)
iunit_t	spm_dev;
{
	uint	dsdb_num = 0;
	uint	slot;
	/* FIX MSS, Temporary SCSI config */
	extern dev_t	iopmb_dev();

	for ( slot = 0; slot < 256; slot++ ) {
		if ( !is_IOPM(slot) )
			continue;
		switch (iopm_db_id(slot)) {
		case IOPM_DB_ID_DSDB:
		case IOPM_DB_ID_DSDB_FIX:
			break;
		default:
			continue;
		}
		if ((SSLOT(slot) == spm_dev.s.slot) &&
		    (SUBSLOT(slot) == 0xf || SUBSLOT(slot) ==spm_dev.s.subslot))

			return (iopmb_dev(dsdb_num, spm_dev.s.phys,
					  spm_dev.s.log));

		dsdb_num++;
	}
	return NODEV;
}

/******************************************************************************/
iopm_open(minordev, flag, otyp)
dev_t  minordev;
{
	if ( minordev > 0xff || !is_IOPM(minordev) )
		u.u_error = ENXIO;
}

/******************************************************************************/
iopm_read(minordev)
dev_t  minordev;
{
	register unsigned int  n;
	register unsigned int  po;
	int                    slot = minordev;	/* 'slot' for IOPM_COMMP */
	uint                   savmap;
	uchar                  *iopmap;
	extern uchar           *iopm_map();

	ASSERT(minordev < 0xff);
	ASSERT(is_IOPM(slot));

	/*
	 * IOPM common addresses (ie IOPM physical addresses) are
	 *   0xf8000000 to 0xfa000000 on each IOPM board.
	 * The IOPM board has 1 or 4 meg of memory that repeats at 4 meg
	 *   increments.
	 * u.u_offset is a signed quantity.
	 * read rejects u.u_offset < 0.
	 *
	 * so for /dev/iopmXX we will respond to requests from
	 * 0x0 to 0x3fffff, as if they were requests for
	 * 0xf8000000 to 0xf83fffff on the appropriate board
	 */

	if ( u.u_offset >= IOPM_COMMP->memsize )
	{
		u.u_error = ENXIO;
		return;
	}

	savmap = iomap_save();

	while ( u.u_error == 0 && u.u_count != 0 )
	{
		n = min(u.u_count, ctob(1));

		po = u.u_offset % ctob(1);
		iopmap = iopm_map(slot, IOPM_RAM_START + u.u_offset - po);
		n = min(n, ctob(1) - po);
		if ( copyout(iopmap + po, u.u_base, n) )
			u.u_error = ENXIO;

		u.u_offset += n;
		u.u_base += n;
		u.u_count -= n;
	}
	iomap_restore(savmap);
}

/******************************************************************************/
iopm_write(minordev)
dev_t  minordev;
{
	register unsigned int  n;
	register unsigned int  po;
	int                    slot = minordev;
	uint                   savmap;
	uchar                  *iopmap;
	extern uchar           *iopm_map();

	ASSERT(minordev < 0xff);
	ASSERT(is_IOPM(slot));

	/*
	 * IOPM common addresses (ie IOPM physical addresses) are
	 *   0xf8000000 to 0xfa000000 on each IOPM board.
	 * The IOPM board has 1 or 4 meg of memory that repeats at 4 meg
	 *   increments.
	 * u.u_offset is a signed quantity.
	 * read rejects u.u_offset < 0.
	 *
	 * so for /dev/iop we will respond to requests from
	 * 0x0 to 0x3fffff, as if they were requests for
	 * 0xf8000000 to 0xf83fffff on the appropriate board
	 */

	if ( u.u_offset >= IOPM_COMMP->memsize )
	{
		u.u_error = ENXIO;
		return;
	}

	savmap = iomap_save();

	while ( u.u_error == 0 && u.u_count != 0 )
	{
		n = min(u.u_count, ctob(1));

		po = u.u_offset % ctob(1);
		iopmap = iopm_map(slot, IOPM_RAM_START + u.u_offset - po);
		n = min( n, ctob(1) - po );
		if ( copyin(u.u_base, iopmap + po, n) )
			u.u_error = ENXIO;

		u.u_offset += n;
		u.u_base += n;
		u.u_count -= n;
	}
	iomap_restore(savmap);
}

/******************************************************************************/
/* need up_kern */
iopm_ioctl(minordev, cmd, arg, mode)
dev_t  minordev;
{
	int          slot = minordev;
	extern uint  kern2spm_cmd();
/*CMW needs while ( cmd && response ) sleep to block other procs */

	ASSERT(minordev < 0xff);
	ASSERT(is_IOPM(slot));

	switch ( cmd )
	{
	    case LOAD_WHERE:
	    {
		struct iopmioctlw  iw;

		if ( copyin(arg, &iw, sizeof iw) )
		{
			u.u_error = EFAULT;
			return;
		}

		IOPM_COMMP->iopm_cmd = cmd;
		IOPM_COMMP->iopm_arg[0] = iw.taddr;
		IOPM_COMMP->iopm_arg[1] = iw.tlength;
		IOPM_COMMP->iopm_arg[2] = iw.daddr;
		IOPM_COMMP->iopm_arg[3] = iw.dlength;

		if ( !sendcmd(slot) )
		{
			u.u_error = EIO;
			return;
		}

		iw.taddr = IOPM_COMMP->iopm_arg[0];
		iw.daddr = IOPM_COMMP->iopm_arg[2];
		if ( copyout(&iw, arg, sizeof iw) )
		{
			u.u_error = EFAULT;
			return;
		}

		u.u_rval1 = IOPM_COMMP->iopm_response;
		return;
	    }

	    case BUF_DEVSW:
	    case STR_DEVSW:
	    {
		struct iopmioctld  id;
		uint i;
		extern dev_t  iopmclonetable[];

		if ( copyin(arg, &id, sizeof id) )
		{
			u.u_error = EFAULT;
			return;
		}

		if ( id.prefix[0] == '\0' ||	/* driver must have a name */
		     id.kmin & UNMINOR_BIT ||	/* range checking */
		     id.numdev & UNMINOR_BIT ||	/* range checking */
		     id.numdev == 0 )		/* at least one minor number */
		{
			u.u_error = EINVAL;
			return;
		}

#if ! defined IOPM_DRIVERS_OVERLAY
		if ( cmd == BUF_DEVSW )
			for ( i = id.kmin >> MNPGSHFT;
			      i < (id.kmin >> MNPGSHFT) +
			          ((id.numdev + MNPG - 1) >> MNPGSHFT); i++ )
			{
				if ( iopmbtbl[i].valid )
				{
					u.u_error = EINVAL;
					return;
				}
			}

		else
			for ( i = id.kmin >> MNPGSHFT;
			      i < (id.kmin >> MNPGSHFT) +
			          ((id.numdev + MNPG - 1) >> MNPGSHFT); i++ )
			{
				if ( iopmstbl[i].valid )
				{
					u.u_error = EINVAL;
					return;
				}
			}
#endif

		IOPM_COMMP->iopm_cmd = cmd;
		/* total num minor devs of this type (IOPM maj) in from user */
		IOPM_COMMP->iopm_arg[1] = id.kmin;
		IOPM_COMMP->iopm_arg[2] = id.numdev;
		IOPM_COMMP->iopm_arg[3] = id.port;
		IOPM_COMMP->iopm_arg[4] = id.imin;

		for ( i = 0; id.prefix[i] && i < PREFIXLEN-1; i++ )
			IOPM_COMMP->iopm_arg_str[i] = id.prefix[i];

		IOPM_COMMP->iopm_arg_str[i] = '\0';

		if ( cmd == BUF_DEVSW )
		{
			IOPM_COMMP->iopm_arg[0] = (int)iopmbtbl;

			for ( i = id.kmin >> MNPGSHFT;
			      i < (id.kmin >> MNPGSHFT) +
			          ((id.numdev + MNPG - 1) >> MNPGSHFT); i++ )
			{
				iopmbtbl[i].iopmslot = slot;
				iopmbtbl[i].valid = 1;
			}
		}
		else
		{
			IOPM_COMMP->iopm_arg[0] = (int)iopmstbl;

			for ( i = id.kmin >> MNPGSHFT;
			      i < (id.kmin >> MNPGSHFT) +
			          ((id.numdev + MNPG - 1) >> MNPGSHFT); i++ )
			{
				iopmstbl[i].iopmslot = slot;
				iopmstbl[i].valid = 1;
			}
		}

		if ( cmd == STR_DEVSW && id.clonemin != 0xffff )
			iopmclonetable[id.clonemin] = id.kmin;

		if ( !sendcmd(slot) )
			return;

		u.u_rval1 = IOPM_COMMP->iopm_response;
		return;
	    }

	    case START_MOD:
	    case SET_QUEUES:
	    case SET_BP:
	    case SET_BUF:
	    case SET_NUMTCB:
		IOPM_COMMP->iopm_cmd = cmd;
		IOPM_COMMP->iopm_arg[0] = arg;

		if ( !sendcmd(slot) )
			return;

		u.u_rval1 = IOPM_COMMP->iopm_response;
		return;

	    case SET_NMSG:
	    {
		uint  nblk[9];

		if ( copyin(arg, nblk, sizeof nblk) )
		{
			u.u_error = EFAULT;
			return;
		}

		IOPM_COMMP->iopm_cmd = cmd;
		IOPM_COMMP->iopm_arg[0] = nblk[0];
		IOPM_COMMP->iopm_arg[1] = nblk[1];
		IOPM_COMMP->iopm_arg[2] = nblk[2];
		IOPM_COMMP->iopm_arg[3] = nblk[3];
		IOPM_COMMP->iopm_arg[4] = nblk[4];
		IOPM_COMMP->iopm_arg[5] = nblk[5];
		IOPM_COMMP->iopm_arg[6] = nblk[6];
		IOPM_COMMP->iopm_arg[7] = nblk[7];
		IOPM_COMMP->iopm_arg[8] = nblk[8];

		if ( !sendcmd(slot) )
			return;

		u.u_rval1 = IOPM_COMMP->iopm_response;
		return;
	    }

	    case RESETIOPM:
	    {
		register struct iopmsltbl   *stp;

#if ! defined IOPM_DRIVERS_OVERLAY
		if ( iopm_loaded(slot) )
		{
			u.u_rval1 = -1;
			return;
		}
#endif

		if ( u.u_rval1 = !kern2spm_cmd(K2S_RESETIOPM, slot, 0, 0) )
			return;

		for ( stp = iopmstbl; stp < iopmstbl + SLTBLSZ; stp++ )
			if ( stp->iopmslot == slot )
				stp->valid = 0;

#if !defined IOPM_DRIVERS_LINKED
		for ( stp = iopmbtbl; stp < iopmbtbl + SLTBLSZ; stp++ )
			if ( stp->iopmslot == slot )
				stp->valid = 0;
#endif

		return;
	    }

	    case UNRESETIOPM:
		u.u_rval1 = kern2spm_cmd(K2S_STARTIOPM, slot, arg, 0);
		return;

	    case VTOP:
		IOPM_COMMP->iopm_cmd = cmd;
		IOPM_COMMP->iopm_arg[0] = arg;
		if ( !sendcmd(slot) )
			return;

		if ( IOPM_COMMP->iopm_response == 0 && arg != MAINSTORE )
			u.u_error = EINVAL;
		else
			u.u_rval1 = IOPM_COMMP->iopm_response;
		return;
		
	    default:
		u.u_error = EINVAL;
		return;
	}

}

/******************************************************************************/
is_IOPM(slot)
uint  slot;
{
	register uint  css_slot = SSLOT(slot);
	register uint  sub_slot = SUBSLOT(slot);

	if (sub_slot == 0xf)
		return (spm_mem.sbus_slot_id[css_slot] == SBUS_IOPM);

	if (spm_mem.sbus_slot_id[css_slot] == SBUS_NIOM) {
		register int	iom;
		iom_config_t	*iomp;

		iomp = spm_mem.iom_config;
		for (iom = NUM_IOM_PER_SYS; --iom >= 0; iomp++) {
			if ( iomp->iom_slot != css_slot )
				continue;
			return
			  (iomp->ex_card_cage.css_bd_dat[sub_slot].css_slot_id
			    == SBUS_IOPM);
		}
	}

	return 0;
}

/******************************************************************************/
uchar *
iopm_map(slot, addr)
uint  slot;
uint  addr;
{
	extern uchar  *iosba_map();

	if ( SUBSLOT(slot) == 0xf )
		return iomap(SSLOT(slot), addr);
	else
		return iosba_map(SSLOT(slot), SUBSLOT(slot), addr);
}

/******************************************************************************/
uint
iopm_db_id(ioslot)
uint	ioslot;
{
	register uint		slot, subslot;
	register int		i, n;
	register iom_config_t	*iomp;
	css_bd_dat_t		*cssp;

	slot = SSLOT(ioslot);
	subslot = SUBSLOT(ioslot);
	if (subslot == 0xf)
		return (spm_mem.sbus_slot_id[slot] == SBUS_IOPM ?
			spm_mem.dev_board_id[slot] : IOPM_NO_DB);

	for (iomp = spm_mem.iom_config, n = NUM_IOM_PER_SYS; --n >= 0; iomp++) {
		if (iomp->iom_slot != slot)
			continue;

		cssp = &iomp->ex_card_cage.css_bd_dat[subslot];
		return (cssp->css_slot_id == SBUS_IOPM ?
			cssp->dev_board_id : IOPM_NO_DB);
	}

	return (IOPM_NO_DB);
}

/******************************************************************************/
/* Send command to IOPM
/* return 1 for ok, 0 for fail
*/
sendcmd(slot)
{
	spin_lock(&iopm_slp_lock);
	iopm_slp_flag = 1;
	intriop(slot);
	while ( iopm_slp_flag )
	{
		if ( mfs_sleep_with_sig_check(&IOPM_COMMP->iopm_cmd,
		                              PZERO + 1 | PCATCH,
		                              &iopm_slp_lock) )
		{
			IOPM_COMMP->iopm_cmd = 0;
			spin_unlock(&iopm_slp_lock);
			u.u_error = EINTR;
			return 0;
		}
	}
	spin_unlock(&iopm_slp_lock);
	return 1;
}

/******************************************************************************/
iopm_intr(int_data)
disp_int_t	int_data;
{
	uint	slot;

	slot =(int_data.fields.src_slot << 4) | (int_data.fields.io_slot & 0xf);
	iopm_slp_flag = 0;
	spin_lock( &iopm_slp_lock );
	mfs_wakeup_all((caddr_t)&IOPM_COMMP->iopm_cmd);
	spin_unlock( &iopm_slp_lock );
}

/*****************************************************************************/
/* interrupt to iopm
*/

intriop(slot)
{
	*iopm_intr_addr[slot] = INTR1|INTR_ON;
}

/******************************************************************************/
iopm_loaded(slot)
uint  slot;
{
	struct iopmsltbl  *sltblp;

	for ( sltblp = iopmbtbl; sltblp < iopmbtbl + SLTBLSZ; sltblp++ )
		if ( sltblp->valid == 1 && sltblp->iopmslot == slot )
			return 1;

	for ( sltblp = iopmstbl; sltblp < iopmstbl + SLTBLSZ; sltblp++ )
		if ( sltblp->valid == 1 && sltblp->iopmslot == slot )
			return 1;

	return 0;
}
