/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) ints.c: version 25.1 created on 11/27/91 at 14:57:49	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)ints.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/sbus.h"
#include "sys/sbus_pm.h"
#include "sys/debug.h"
#include "sys/ints.h"
#include "sys/sbus_spm.h"
#include "sys/own.h"
#include "sys/kmem.h"
#include "sys/synch.h"
#include "sys/cmn_err.h"
#include "sys/spm_mem.h"


void		uninitialized_vector(), unexpected_vector();
void		kern2spm_done(), spm2kern_cmd(), spm2kern_upkern_cmd();
extern void	timein(), upkern_do_strategy();
extern void	update_my_iomap(), do_tlb_flush();
extern void	con_rxint(), con_txint();
extern void	iopm_intr(), iopmb_intr(), iopms_intr();
extern void	resched_intr();
extern void	disable_interrupts();

void 	(*vector_table[])() = {
		uninitialized_vector,
		unexpected_vector,	/* MM_INTERRUPT		*/
		unexpected_vector,	/* IOM_ERROR		*/
		unexpected_vector,	/* was IOA_ERROR	*/
		unexpected_vector,	/* KERNEL_TO_SPM_CMD	*/
		unexpected_vector,	/* KERNEL_TO_SPM_OUTPUT	*/
		con_rxint,		/* CONSOLE_INPUT	*/
		con_txint,		/* CONSOLE_OUTPUT	*/
		con_rxint,		/* UPKERN_CONSOLE_INPUT	*/
		con_txint,		/* UPKERN_CONSOLE_OUTPUT */
		unexpected_vector,	/* was ICB_INTERRUPT	*/
		unexpected_vector,	/* was UPKERN_ICB_INTERRUPT	*/
		kern2spm_done,		/* KERNEL_TO_SPM_DONE	*/
		timein,			/* TIMEIN		*/
		unexpected_vector,	/* RUNQUEUES		*/
		upkern_do_strategy,	/* UPKERN_STRATEGY	*/
		update_my_iomap,	/* DO_IOMAP_UPDATE	*/
		do_tlb_flush,		/* DO_TLB_FLUSH		*/
		iopm_intr,		/* IOPM_IOCTL_INTR	*/
		iopmb_intr,		/* IOPM_BUF_INTR	*/
		iopms_intr,		/* IOPM_STR_INTR	*/
		spm2kern_cmd,		/* SPM_TO_KERNEL_CMD	*/
		unexpected_vector,	/* SPM_TO_KERNEL_DONE	*/
		spm2kern_upkern_cmd,	/* UPKERN_SPM2KERN_CMD	*/
		resched_intr,		/* RESCHED		*/
		disable_interrupts,	/* DISABLE_INTERRUPTS	*/
};

#define MAX_INTERRUPT_VECTOR	(sizeof(vector_table) / sizeof(void *))

/*
 * interrupt_queue_init:
 *
 *	Initialize queue pointers for interrupt queues.
 *	This must be called before clkstart and any I/O.
 */

own_interrupt_queue_init()
{
	/* Don't change this initialization to &own -- we must use kernel
	 * virtual address for the queue level one and four structures.
	 */
	register own_t	*o = spm_mem.pm_own[own.o_pm_id];

	o->o_queue_1.consumer = o->o_queue_1.producer = o->o_queue_1.data;
	o->o_queue_1.end = o->o_queue_1.data +
	  sizeof(o->o_queue_1.data) / sizeof(o->o_queue_1.data[0]);

	o->o_queue_4.consumer = o->o_queue_4.producer = o->o_queue_4.data;
	o->o_queue_4.end = o->o_queue_4.data +
	  sizeof(o->o_queue_4.data) / sizeof(o->o_queue_4.data[0]);
}

level_one()
{
	register disp_int_t	*consumer;
	disp_int_t		int_data;

	own.o_in_int_service++;
	consumer = own.o_queue_1.consumer;

	for (int_data = *consumer;int_data.fields.vector;int_data = *consumer) {
		*(uint *)consumer++ = NULL;
		if (consumer == own.o_queue_1.end)
			consumer = spm_mem.pm_own[own.o_pm_id]->o_queue_1.data;

		ASSERT(int_data.fields.vector < MAX_INTERRUPT_VECTOR);
		(*vector_table[int_data.fields.vector])(int_data);
	}

	own.o_queue_1.consumer = consumer;
	own.o_in_int_service--;
}

level_two()
{
	disp_int_t	interrupt_data;

	own.o_in_int_service++;

	interrupt_data = *(disp_int_t *)INT_DISP_ACK_LEVEL_TWO;

	ASSERT(! interrupt_data.fields.directed);
	ASSERT(interrupt_data.fields.level == MOT_LEVEL_TWO);
	ASSERT(interrupt_data.fields.vector < MAX_INTERRUPT_VECTOR);

	(*vector_table[interrupt_data.fields.vector])(interrupt_data);
	
	own.o_in_int_service--;
}

level_three()
{
	disp_int_t	interrupt_data;

	own.o_in_int_service++;
	spl4();			/* prevent redirected reentrancy */

	interrupt_data = *(disp_int_t *)INT_DISP_ACK_LEVEL_THREE;

	ASSERT(! interrupt_data.fields.directed);
	ASSERT(interrupt_data.fields.level == MOT_LEVEL_THREE);
	ASSERT((interrupt_data.fields.vector) < MAX_INTERRUPT_VECTOR);

	(*vector_table[interrupt_data.fields.vector])(interrupt_data);
	
	own.o_in_int_service--;
}

level_four()
{
	register disp_int_t	*consumer;
	disp_int_t		int_data;

	own.o_in_int_service++;

	consumer = own.o_queue_4.consumer;
	for (int_data = *consumer;int_data.fields.vector;int_data = *consumer) {
		*(uint *)consumer++ = NULL;
		if (consumer == own.o_queue_4.end)
			consumer = spm_mem.pm_own[own.o_pm_id]->o_queue_4.data;

		ASSERT((int_data.fields.vector) < MAX_INTERRUPT_VECTOR);
		(*vector_table[int_data.fields.vector])(int_data);
	}

	own.o_queue_4.consumer = consumer;
	own.o_in_int_service--;
}

level_five()
{
	disp_int_t	interrupt_data;

	own.o_in_int_service++;

	interrupt_data = *(disp_int_t *)INT_DISP_ACK_LEVEL_FIVE;

	ASSERT(! interrupt_data.fields.directed);
	ASSERT(interrupt_data.fields.level == MOT_LEVEL_FIVE);
	ASSERT(interrupt_data.fields.vector < MAX_INTERRUPT_VECTOR);

	(*vector_table[interrupt_data.fields.vector])(interrupt_data);
	
	own.o_in_int_service--;
}

void
uninitialized_vector(int_data)
disp_int_t	int_data;
{
	cmn_err(CE_PANIC, "uninitialized interrupt vector (0x%x)\n",
	  int_data.entire_32_bits);
}

void
unexpected_vector(int_data)
disp_int_t	int_data;
{
	cmn_err(CE_PANIC, "unexpected interrupt vector (0x%x)\n",
	  int_data.entire_32_bits);
}

#include "sys/mfs.h"

#define K2SCMD_LOCK	1
#define K2SCMD_WAIT	2

static spin_lock_t	kern2spm_lock;
static uint		k2scmd_var;

/*
 * kern2spm_cmd -- send a generic command from the kernel to the SPM
 *
 *	Update the number of arguments if NUM_K2S_ARGS is changed.
 */
/*VARARGS1*/
uint
kern2spm_cmd(cmd, arg0, arg1, arg2)
uint	cmd, arg0, arg1, arg2;
{
	spin_lock(&kern2spm_lock);
	while (k2scmd_var & K2SCMD_LOCK) {
		k2scmd_var |= K2SCMD_WAIT;
		mfs_sleep((caddr_t)&k2scmd_var, PZERO - 1, &kern2spm_lock);
	}
	k2scmd_var |= K2SCMD_LOCK;

	spm_mem.kern2spm_cmd    = cmd;
	spm_mem.kern2spm_arg[0] = arg0;
	spm_mem.kern2spm_arg[1] = arg1;
	spm_mem.kern2spm_arg[2] = arg2;
	*(disp_int_t *)ADDR_INT_DISP = spm_mem.kern2spm_int;

	mfs_sleep((caddr_t)spm_mem.kern2spm_arg, PZERO - 1, &kern2spm_lock);
	arg0 = *spm_mem.kern2spm_arg;

	if (k2scmd_var & K2SCMD_WAIT)
		mfs_wakeup((caddr_t)&k2scmd_var);
	k2scmd_var = 0;
	spin_unlock(&kern2spm_lock);

	return (arg0);
}

/*
 * kern2spm_done -- process "done" interrupt from SPM
 */
void
kern2spm_done()
{
	spin_lock(&kern2spm_lock);
	mfs_wakeup((caddr_t)spm_mem.kern2spm_arg);
	spin_unlock(&kern2spm_lock);
}

#include "sys/var.h"
#include "sys/tuneable.h"

/*
 * spm2kern_cmd -- do a generic command for the SPMM
 */
void
spm2kern_cmd(dint)
disp_int_t	dint;
{
	register uint	reply;
	extern int	bdflushcnt;

	reply = 0;

	switch (spm_mem.spm2kern_cmd) {
	case S2K_PT_FAST_FLUSH:
		v.v_autoup_hz = HZ;		/* set buffer aging to 1 sec */
		tune.t_bdflushr = 1;		/* run bdflush every second */
		bdflushcnt = 0;			/* wake up bdflush	*/
		break;

	case S2K_PT_NORMAL_FLUSH:
		v.v_autoup_hz = v.v_autoup * HZ;/* restore configured values */
		tune.t_bdflushr = tune.t_bdflushr_df;
		break;

	case S2K_PT_SHUTDOWN:
		psignal(&proc[1], SIGPWR);	/* send a SIGPWR to init */
		break;

	case S2K_CALL_FUNC:			/* call a kernel function */
		reply = upkern_inc();
		if (reply != own.o_pm_id) {
			dint.fields.vector = UPKERN_SPM2KERN_CMD;
			queue_level_one(spm_mem.pm_own[reply], dint);
			return;			/* do it on upkern pm */
		}

		spm2kern_upkern_cmd();
		return;				/* already replied */

	case S2K_KILL_PROC:			/* kill a process */
		reply = kill_proc(spm_mem.spm2kern_arg[0],
		  spm_mem.spm2kern_arg[1]);
		break;

	default:
		cmn_err(CE_WARN,
		  "spm2kern_cmd: got unknown command = %x, args: %x %x %x %x",
		  spm_mem.spm2kern_cmd,
		  spm_mem.spm2kern_arg[0], spm_mem.spm2kern_arg[1],
		  spm_mem.spm2kern_arg[2], spm_mem.spm2kern_arg[3]);
		break;
	}

	*spm_mem.spm2kern_arg = reply;		/* command done */
	*(disp_int_t *)ADDR_INT_DISP = spm_mem.spm2kern_done;
}

void
spm2kern_upkern_cmd()
{
	register uint	reply;
	extern int	etext;
	typedef uint	(*PFU)();

	reply = spm_mem.spm2kern_arg[0];
	if (reply & 1 || reply < ADDR_KERNEL || reply >= (uint)&etext)
		reply = ~0;			/* bad addr */
	else
		reply = (*(PFU)reply)(spm_mem.spm2kern_arg[1],
		  spm_mem.spm2kern_arg[2], spm_mem.spm2kern_arg[3]);

	upkern_dec();
	*spm_mem.spm2kern_arg = reply;		/* command done */
	*(disp_int_t *)ADDR_INT_DISP = spm_mem.spm2kern_done;
}

/*
 * spm2kerninit -- init stuff for SPM to Kernel communications
 */

spm2kerninit()
{
	spm_mem.spm2kern_int.fields.vector = SPM_TO_KERNEL_CMD;
	spm_mem.spm2kern_int.fields.directed = NON_DIRECTED;
	spm_mem.spm2kern_int.fields.level = MOT_LEVEL_TWO;
}

static	disp_int_t	disable_interrupts_int_data;

disable_interrupts_init()
{
	disable_interrupts_int_data.fields.vector = DISABLE_INTERRUPTS;
	disable_interrupts_int_data.fields.level = MOT_LEVEL_ONE;
	disable_interrupts_int_data.fields.directed = NON_DIRECTED;
}

void
disable_interrupts()
{
	ushort	oldpri;

	ASSERT(own.o_disable_interrupts);
	ASSERT(! own.o_reenable_interrupts);

	oldpri = spl7();
	own.o_disable_interrupts = 0;

	while (! own.o_reenable_interrupts)
		;

	splx(oldpri);
}

other_cpus_disable_interrupts()
{
	register uint	pm_id;
	register uint	num_pm = spm_mem.num_pm;
	register own_t	**opp, *o;
	static suspend_lock_t	disable_lock = SUSPEND_INIT(PZERO);

	suspend_lock(&disable_lock);

	opp = spm_mem.pm_own;
	for (pm_id = 0; pm_id < num_pm; pm_id++, opp++)  {
		if (pm_id == own.o_pm_id)
			continue;
		o = *opp;
		ASSERT(!o->o_disable_interrupts);
		o->o_reenable_interrupts = 0;
		o->o_disable_interrupts = 1;
		queue_level_one(o, disable_interrupts_int_data);
	}

	opp = spm_mem.pm_own;
	for (pm_id = 0; pm_id < num_pm; pm_id++, opp++)  {
		if (pm_id == own.o_pm_id)
			continue;
		o = *opp;
		while (o->o_disable_interrupts)
			delay(1);
	}
	suspend_unlock(&disable_lock);
}

other_cpus_reenable_interrupts()
{
	register uint	pm_id;
	register uint	num_pm = spm_mem.num_pm;
	register own_t	**opp, *o;

	opp = spm_mem.pm_own;
	for (pm_id = 0; pm_id < num_pm; pm_id++, opp++)  {
		if (pm_id == own.o_pm_id)
			continue;
		o = *opp;
		ASSERT(!o->o_disable_interrupts);
		o->o_reenable_interrupts = 1;
	}
}
