/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) cons.c: version 25.1 created on 11/27/91 at 14:57:41	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)cons.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/* cons.c */

#ident	"@(#)uts/io:cons.c	23.2"

/*
 *	S3000 Console interface
 */

#include "sys/types.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/file.h"
#include "sys/tty.h"
#include "sys/termio.h"
#include "sys/buf.h"
#include "sys/systm.h"
#include "sys/conf.h"
#include "sys/sysinfo.h"
#include "sys/spl.h"
#include "sys/spm_mem.h"
#include "sys/sbus_spm.h"
#include "sys/kmem.h"
#include "sys/debug.h"
#include "sys/ints.h"
#ifdef SAK
#include "sys/sakioctl.h"

struct sakioctl con_sak;
int con_sak_count;
#endif /* SAK */

struct tty		con_tty;
int			con_proc(), con_param();
extern char		conline;

conopen(dev, flag)
dev_t dev;
{

	if (dev != 0) {
		u.u_error = ENXIO;
		return;
	}

	if ((con_tty.t_state & ISOPEN) == 0) {
		con_tty.t_proc = con_proc;
		ttinit(&con_tty);
		con_tty.t_state |= CARR_ON;
		con_tty.t_iflag |= ICRNL|IXON|IXANY|ISTRIP;
		con_tty.t_oflag |= OPOST|ONLCR|TAB3;
		con_tty.t_lflag |= ISIG|ICANON|ECHO|ECHOK|TOSTOP;
		con_tty.t_cflag = B9600|CS8|CLOCAL;
		con_tty.t_line = conline;	/* = L_CON */
		con_tty.t_cc[VERASE] = '\b';	/* erase = CTRL-H */
		con_tty.t_cc[VKILL] = '\25';	/* kill  = CTRL-U */
#ifdef SAK
		con_sak.flags = 0;
		con_sak_count = 0;
#endif /* SAK */
		con_param();
	}
	spl_console();
	while (!(flag & FNDELAY) && !(con_tty.t_state & CARR_ON)) {
		con_tty.t_state |= WOPEN;
		sleep((caddr_t)&con_tty.t_canq, TTIPRI);
	}
	fspl0();
	(*linesw[con_tty.t_line].l_open)(&con_tty,flag);
}

conclose(dev)
dev_t dev;
{
	(*linesw[con_tty.t_line].l_close)(&con_tty);
/* FIX THIS JOE, The following code is needed because l_close
 * is not waiting for the output to drain.
 */
	ASSERT((con_tty.t_state & BUSY) || ! spm_mem.console.enable_output);
}

conread(dev)
dev_t dev;
{
	(*linesw[con_tty.t_line].l_read)(&con_tty);
}

conwrite(dev)
dev_t dev;
{	
	(*linesw[con_tty.t_line].l_write)(&con_tty);
}

conioctl(dev, cmd, arg, mode)
{
	short cflag = con_tty.t_cflag;

#ifdef SAK
	if (cmd == TCSAK_GET)
	{
		if (copyout(&con_sak, arg, sizeof con_sak))
			u.u_error = EFAULT;
		return;
	}
	else if (cmd == TCSAK_SET)
	{
		if (con_sak.flags)
			u.u_error = EINVAL;
		else if (copyin(arg, &con_sak, sizeof con_sak))
			u.u_error = EFAULT;
		return;
	}
#endif /* SAK */
	if(!(ttiocom(&con_tty, cmd, arg, mode)))
		return;

	if (cflag != con_tty.t_cflag)
		con_param();
}

void
con_rxint(int_data)
disp_int_t	int_data;
{
	static void	upkern_con_rxint();
	uint		pm_id;

	if (int_data.fields.vector == CONSOLE_INPUT) {
		pm_id = upkern_inc();
		if (pm_id != own.o_pm_id) {
			int_data.fields.vector = UPKERN_CONSOLE_INPUT;
			queue_level_four(spm_mem.pm_own[pm_id], int_data);
			return;
		}
		spl4();
	}

	upkern_con_rxint();
	upkern_dec();
}

static void
upkern_con_rxint()
{
	register caddr_t	bp;
	register int		c, xc;
	struct cblock		*cbp;

	atom_inc(&sysinfo.rcvint);

	ASSERT(! spm_mem.console.enable_input);
	c = spm_mem.console.input_buf;
	spm_mem.console.enable_input = 1;

	if (con_tty.t_iflag & IXON) {
		xc = (con_tty.t_iflag & ISTRIP) ? (c & 0x7f) : c;
		if (con_tty.t_state & TTSTOP) {
			if ((con_tty.t_iflag & IXANY) || (xc == CSTART))
				con_proc(&con_tty, T_RESUME);
		} else if (xc == CSTOP) {
			con_tty.t_state |= TTSTOP;
			return;
		}
		if ((xc == CSTOP) || (xc == CSTART))
			return;
	}
#ifdef SAK
	if (con_tty.t_iflag & ISTRIP)
		xc = c & 0x7f;
	else	xc = c;
	if (con_sak.flags & SAK_KEYS)
	{
		switch(con_sak_count)
		{
		case 0:
			if (xc == con_sak.sak_key1)
			{
				if (con_sak.flags & SAK_1KEY)
				{
					con_sak_event(&con_tty);
					return;
				}
				else	con_sak_count++;
			}
			break;
		case 1:
			if (xc == con_sak.sak_key2)
			{
				if (con_sak.flags & SAK_2KEYS)
				{
					con_sak_event(&con_tty);
					return;
				}
				else	con_sak_count++;
			}
			else	con_sak_count = 0;
			break;
		case 2:		/* SAK_3KEYS must be set to get here */
			if (xc == con_sak.sak_key3)
			{
				con_sak_event(&con_tty);
				return;
			}
			else	con_sak_count = 0;
			break;
		} /* switch(con_sak_count) */
	}
#endif /* SAK */
/* JPC: code to realloc t_rbuf stolen from ttin */
	bp = con_tty.t_rbuf.c_ptr;
	if (!bp && (cbp = getcf())) {
		con_tty.t_rbuf.c_ptr = bp = cbp->c_data;
		con_tty.t_rbuf.c_count = cfreelist.c_size;
		con_tty.t_rbuf.c_size = cfreelist.c_size;
	}
/* JPC */
	if (bp) {
		*bp++ = c;
		con_tty.t_rbuf.c_count--;
	}

	(*linesw[con_tty.t_line].l_input)(&con_tty);
}
#ifdef SAK
/*
 *	console sak event occured - send sighup, then send sigsak
 */
con_sak_event(tp)
register struct tty *tp;
{
	ttyflush(tp, (FREAD|FWRITE));
	signal (tp->t_pgrp, SIGHUP);
	signal (tp->t_pgrp, SIGSAK);
}/*---------------------------------------------------------------*/
#endif /* SAK */

void
con_txint(int_data)
disp_int_t	int_data;
{
	static void	upkern_con_txint();
	uint		pm_id;

	if (int_data.fields.vector == CONSOLE_OUTPUT) {
		pm_id = upkern_inc();
		if (pm_id != own.o_pm_id) {
			int_data.fields.vector = UPKERN_CONSOLE_OUTPUT;
			queue_level_four(spm_mem.pm_own[pm_id], int_data);
			return;
		}
		spl4();
	}

	upkern_con_txint();
	upkern_dec();
}

static void
upkern_con_txint()
{
	register struct ccblock	*tbuf;
	
	ASSERT(con_tty.t_state & BUSY);
	ASSERT(! spm_mem.console.enable_output);

	atom_inc(&sysinfo.xmtint);
	if (con_tty.t_state & (TTXON | TTXOFF | TTSTOP)) {
		if (con_tty.t_state & TTSTOP) {
			con_tty.t_state &= ~BUSY;
			return;
		}
		if (con_tty.t_state & TTXOFF) {
			con_tty.t_state &= ~TTXOFF;
			/* FIX DS, needs to push chars as well */
		} else {
			con_tty.t_state &= ~(TTXON | TBLOCK);
			/* FIX DS, needs to push chars as well */
		}
	}

	tbuf = &con_tty.t_tbuf;
	if ((tbuf->c_ptr == 0) || (tbuf->c_count <= 0)) {
		if (tbuf->c_ptr)
			tbuf->c_ptr -= tbuf->c_size - tbuf->c_count;
		if (!(CPRES &
		    (*linesw[con_tty.t_line].l_output)(&con_tty))){
			con_tty.t_state &= ~BUSY;
			if (con_tty.t_state&TTIOW && tbuf->c_count==0) {
				con_tty.t_state &= ~TTIOW;
				wakeup((caddr_t)&con_tty.t_oflag);
			}
			return;
		}
	}

	ASSERT(con_tty.t_state & BUSY);
	ASSERT(! spm_mem.console.enable_output);
	spm_mem.console.output_buf = *tbuf->c_ptr;
	spm_mem.console.enable_output = 1;

	/* interrupt the SPM */
	*(disp_int_t *)ADDR_INT_DISP = spm_mem.console.spm_output_int;

	tbuf->c_ptr++;
	tbuf->c_count--;
}

con_proc(cp, cmd)
register struct tty *cp;
{
	register s;

	ASSERT(is_upkern_lock());

	s = splhi();
	switch (cmd) {
	case T_TIME:
		cp->t_state &= ~TIMEOUT;
		goto start;

	case T_WFLUSH:
	case T_RESUME:
		cp->t_state &= ~TTSTOP;
		goto start;

	case T_OUTPUT:
	start:
		{
		register struct ccblock *tbuf;

		if (cp->t_state & (BUSY | TIMEOUT | TTSTOP)) break;
		tbuf = &cp->t_tbuf;
		if (tbuf->c_ptr == 0 || tbuf->c_count <= 0) {
			if (tbuf->c_ptr)
				tbuf->c_ptr -= tbuf->c_size - tbuf->c_count;
			if (!(CPRES & (*linesw[cp->t_line].l_output)(cp)))
				break;
		}
		cp->t_state |= BUSY;

		ASSERT(! spm_mem.console.enable_output);
		spm_mem.console.output_buf = *cp->t_tbuf.c_ptr;
		spm_mem.console.enable_output = 1;

		/* interrupt the SPM */
		*(disp_int_t *)ADDR_INT_DISP = spm_mem.console.spm_output_int;

		cp->t_tbuf.c_ptr++;
		cp->t_tbuf.c_count--;
		}
		break;

	case T_SUSPEND:
		cp->t_state |= TTSTOP;
		break;

	case T_BLOCK:
		cp->t_state |= TBLOCK;
		if (cp->t_state & BUSY)
			cp->t_state |= TTXOFF;
		else {
			cp->t_state |= BUSY;
		}
		break;

	case T_RFLUSH:
	case T_UNBLOCK:
		if (cp->t_state & TBLOCK) {
			if (cp->t_state & BUSY)
				cp->t_state |= TTXON;
			else {
				cp->t_state |= BUSY;
				cp->t_state &= ~TBLOCK;
			}
		}
		break;
	}
	splx(s);
}

con_param()
{
	ASSERT((con_tty.t_state & BUSY) || ! spm_mem.console.enable_output);
}

/*
 * initialize interrupts to be used by spm for console i/o
 * and enable the console.
 */

coninit()
{
	spm_mem.console.input_int.fields.vector = CONSOLE_INPUT;
	spm_mem.console.input_int.fields.directed = NON_DIRECTED;
	spm_mem.console.input_int.fields.level = MOT_LEVEL_THREE;

	spm_mem.console.output_int.fields.vector = CONSOLE_OUTPUT;
	spm_mem.console.output_int.fields.directed = NON_DIRECTED;
	spm_mem.console.output_int.fields.level = MOT_LEVEL_THREE;

	spm_mem.console.enable_input = 1;
	ASSERT(! spm_mem.console.enable_output);
}
