/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) clone.c: version 25.1 created on 11/27/91 at 14:57:37	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)clone.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

/*
 * Clone Driver.
 */

#include "sys/types.h"
#include "sys/param.h"
#include "sys/errno.h"
#include "sys/signal.h"
#include "sys/fs/s5dir.h"
#include "sys/fstyp.h"
#include "sys/file.h"
#include "sys/inode.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/stropts.h"
#include "sys/stream.h"
#include "sys/errno.h"
#include "sys/sysinfo.h"
#include "sys/systm.h"
#include "sys/sysmacros.h"
#include "sys/conf.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/cmn_err.h"


#define NUM_MINORS	makedev(1, 0)		/* number of minors per major */

int clnopen();
static struct module_info clnm_info = { 0, "CLONE", 0, 0, 0, 0 };
static struct qinit clnrinit = { NULL, NULL, clnopen, NULL, NULL, &clnm_info, NULL };
static struct qinit clnwinit = { NULL, NULL, NULL, NULL, NULL, &clnm_info, NULL };
struct streamtab clninfo = { &clnrinit, &clnwinit };

/*
 * Clone open.  Dev is the major device of the streams device to
 * open.  Look up the device in the cdevsw[].   Attach its qinit
 * structures to the read and write queues and call its open
 * with the q and the dev CLONEOPEN.  Swap in a new inode with
 * the real device number constructed from the major and the
 * minor returned by the device open.  
 */

clnopen(q, dev, flag, sflag)
queue_t *q;
dev_t	dev;
{
	register int		i, maj, mindev, rdev;
	register struct streamtab *st;
	register struct file	*fp;
	struct mount		*mp;

	if (sflag)
		return(OPENFAIL);

	/*
	 * Get the device to open.
	 */
	/* 	i = MAJOR[minor(dev) & 0x7f];		no MAJOR table */
	maj = minor(dev) & 0x7f;
	if ((maj >= cdevcnt) || !(st = cdevsw[maj].d_str)) {
		u.u_error = ENXIO;
		return(OPENFAIL);
	}

	/*
	 * Substitute the real qinit values for the current ones
	 */
	setq(q, st->st_rdinit, st->st_wrinit);

	/*
	 * Call the device open with the stream flag  CLONEOPEN.  The device
	 * will either fail this or return a minor device number.
	 */
	rdev = notminored(makedev(maj, 0));
	mindev = (*q->q_qinfo->qi_qopen)(q, rdev, flag, CLONEOPEN);
	if (mindev == OPENFAIL)
		return(OPENFAIL);

	/*
	 * Got an extended minor device if mindev is greater than the maximum
	 * number of minor devices per major device, or if the given major
	 * device number is an extended one.
	 */
	if (mindev >= NUM_MINORS || MINOR[maj] != rdev) {
#ifdef CLN_DEBUG
		printf("clnopen: mindev=0x%x, rdev=0x%x, MINOR[maj]=0x%x\n",
		  mindev, rdev, MINOR[maj]);
#endif
		/*
		 * For extended minor devices, you can't assume that the majors
		 * are adjacent, so use gmajor and next_major to find the
		 * correct major.
		 */
		maj = gmajor(rdev);
		i = mindev / NUM_MINORS;
		for ( ; maj >= 0; maj = next_major(maj)) {
			if (--i < 0) {
				mindev &= NUM_MINORS - 1;
				break;			/* found major */
			}
		}
		if (maj < 0) {
			cmn_err(CE_NOTE,
			  "clnopen: can't find major! dev=0x%x minor=0x%x\n",
			  denotminored(rdev), mindev);
			u.u_error = ENXIO;
			return (OPENFAIL);
		}
#ifdef CLN_DEBUG
		printf("clnopen: found major=0x%x, minor=0x%x\n", maj, mindev);
#endif
	}

	{
	register struct stdata	*sd = (struct stdata *)q->q_next->q_ptr;

	for (i = 0; i < u.u_nofiles; i++)
		if ((fp = GET_OFILE(i)) && (fp->f_inode->i_sptr == sd))
			break;
	ASSERT(i < u.u_nofiles);
	}

	/*
	 * Get the inode at top of this stream, allocate a new inode,
	 * and exchange the new inode for the old one.
	 */
	rdev = makedev(maj, mindev);

	/* set up dummy inode */

	{
	register inode_t	*ip, *nip;

	ip = fp->f_inode;
	ASSERT(ip->i_sptr);

	/*
	 * Allocate an inode from the pipe file system.
	 */
	ASSERT(pipefstyp > 0 && pipefstyp < nfstyp);
	mp = fsinfo[pipefstyp].fs_pipe;
	ASSERT(mp != NULL);

	/*
	 * Check upkern flag and lock if necessary
	 */
	if (fstypsw[pipefstyp].getinode_flag)
		nip = (*fstypsw[pipefstyp].fs_getinode)(mp, FSG_CLONE, rdev);
	else {
		upkern_lock();
		nip = (*fstypsw[pipefstyp].fs_getinode)(mp, FSG_CLONE, rdev);
		upkern_unlock();
	}
	if (nip == NULL) {
		(*q->q_qinfo->qi_qclose)(q, flag);
		return(OPENFAIL);
	}

	plock(ip);

	nip->i_sptr = ip->i_sptr;

	/* 
	 * link dummy inode to file table and to the stream 
	 */
	ip->i_sptr = NULL;	/* no other clone open will get this stream */
	fp->f_inode = nip;
	nip->i_sptr->sd_rdev = rdev;

	/*
	 * set sd_icnt to 1 in case an open comes
	 * in for the same dev on a different inode.
	 */

	nip->i_sptr->sd_icnt = 1;
	nip->i_sptr->sd_strtab = st;
	iput(ip);
	prele(nip);
	}
	return(mindev);
}
