/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54ksys3.c: version 25.1 created on 11/27/91 at 14:57:20	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54ksys3.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#define  FsTYPE 4
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/fstyp.h"
#include "sys/fs/s5macros.h"
#include "sys/systm.h"
#include "sys/mount.h"
#include "sys/immu.h"
#include "sys/file.h"
#include "sys/user.h"
#include "sys/ino.h"
#include "sys/buf.h"
#include "sys/iobuf.h"
#include "sys/fs/s5filsys.h"
#include "sys/errno.h"
#include "sys/cmn_err.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#include "sys/conf.h"
#include "sys/stat.h"
#include "sys/statfs.h"
#include "sys/ioctl.h"
#include "sys/var.h"
#include "sys/ttold.h"
#include "sys/proc.h"
#include "sys/open.h"
#include "sys/debug.h"
#include "sys/errno.h"


extern buf_t *s54kbread();
extern buf_t *s54kgeteblk();

extern struct mount s54k_4096mnt;

s54kstatf(ip, st)
register struct inode *ip;
register struct stat *st;
{
	register struct buf *bp;
	register struct dinode *dp;
	register struct s5inode *s5ip;
	char *tino;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	st->st_mode = s5ip->s5i_mode;		/* file modes */
	/*
	 * get the dates from the disk inode
	 */
	bp =
	  s54kbread(ip->i_dev, FsSECITOD(ip->i_mntdev->m_isize,ip->i_number));
	tino = (char *)bp->b_un.b_addr;
	tino += (FsSECITOO(ip->i_mntdev->m_isize, ip->i_number)*ip->i_mntdev->m_isize);
	dp = (struct dinode *)tino;
	st->st_atime = dp->di_atime;
	st->st_mtime = dp->di_mtime;
	st->st_ctime = dp->di_ctime;
	s54kbrelse(bp);
}

/* fcntl */

s54kfcntl(ip, cmd, arg, flag, offset)
register struct inode *ip;
int cmd, arg, flag;
off_t offset;
{
	struct flock	bf;
	int		i;
	struct s5inode	*s5ip;

	switch (cmd) {			/* general-case checks */
	case F_GETLK:
	case F_SETLK:
	case F_SETLKW:
		/* disallow any requests if any locking() locks are present */
		if (ip->i_locklist != NULL)  {
			u.u_error = EACCES;
			return;
		}

		/* Make NIST-PCTS happy: no locks on non-regular files */
		if ( IS_POSIX() ) {
			s5ip = (struct s5inode *)ip->i_fsptr;
			ASSERT( s5ip );
			if ((s5ip->s5i_mode&IFMT) != IFREG) {
				u.u_error = EINVAL;
				return;
			}
		}
		break;
	default:
		break;
	}

	switch (cmd) {
	case F_GETLK:
		/* get record lock */
		if (copyin((caddr_t)arg, &bf, sizeof bf))
			u.u_error = EFAULT;
		else if ((i = reclock(ip, &bf, 0, flag, offset)) != 0)
			u.u_error = i;
		else if (copyout(&bf, (caddr_t)arg, sizeof bf))
			u.u_error = EFAULT;
		break;

	case F_SETLK:
		/* set record lock */
		if (copyin((caddr_t)arg, &bf, sizeof bf))
			u.u_error = EFAULT;
		else if ((i = reclock(ip, &bf, SETFLCK, flag, offset)) != 0) {
			/* The following if statement is to maintain
			** backward compatibility. Note: the return
			** value of reclock was not changed to
			** EAGAIN because rdwr() also calls reclock(),
			** and we want rdwr() to meet the standards.
			*/
			if ( i == EAGAIN )
				u.u_error = EACCES;
			else
				u.u_error = i;
		}
		break;

	case F_SETLKW:
		/* set record lock and wait */
		if (copyin((caddr_t)arg, &bf, sizeof bf))
			u.u_error = EFAULT;
		else  {
			i = reclock(ip, &bf, SETFLCK|SLPFLCK, flag, offset);
			if (i != 0) {
				u.u_error = i;
			}
		}
		break;

	case F_CHKFL:
		break;

	default:
		u.u_error = EINVAL;
	}
}

/* ioctl */
s54kioctl(ip, cmd, arg, flag)
register struct inode *ip;
int cmd, arg, flag;
{
	register dev_t dev;

	if (ip->i_ftype != IFCHR) {
		u.u_error = ENOTTY;
		return;
	}
	dev = notminored(ip->i_rdev);
	if (cdevsw[major(dev)].d_str)
		strioctl(ip, cmd, arg, flag);
	else
		(*cdevsw[major(dev)].d_ioctl)(minor(dev), cmd, arg, flag);
}

/*
 * the mount system call.
 */
s54kmount(bip, mp, rdonly)
register struct inode *bip;
register struct mount *mp;
register int rdonly;
{
	register dev_t dev;
	register struct filsys *fp;
	extern short s54kfstyp;


	if (bip->i_ftype != IFBLK) {
		u.u_error = ENOTBLK;
		return;
	} else {
		dev = (dev_t)bip->i_rdev;
		if (bmajor(dev) >= bdevcnt) {
			u.u_error = ENXIO;
			return;
		}
	}
	dev = notminored(mp->m_dev);
	rdonly &= MS_RDONLY;
 	(*bdevsw[bmajor(dev)].d_open)(minor(dev),
		rdonly ? FREAD : FREAD|FWRITE, OTYP_MNT);
	if (u.u_error)
		return;

	mp->m_bufp = (caddr_t)s54kgeteblk();
	fp = getfs(mp);
	u.u_offset = SUPERBOFF;
	u.u_count = sizeof(struct filsys);
	u.u_base = (caddr_t)fp;
	u.u_segflg = 1;
	fio4k_read_blocked(bip);
	if (u.u_error)
		goto out;
	fp->s_fmod = 0;
	fp->s_ilock = 0;
	fp->s_flock = 0;
	fp->s_ninode = 0;
	fp->s_inode[0] = 0;
	fp->s_ronly = rdonly;
	if (fp->s_magic != FsMAGIC) {
		u.u_error = EINVAL;
		goto out;
	}
	if (rdonly)
		mp->m_flags |= MRDONLY;
	else {
		if (!fp->s_state ||
		    (fp->s_state + (long)fp->s_time) == FsOKAY) {
			fp->s_state = FsACTIVE;
			u.u_offset = SUPERBOFF;
			u.u_count = sizeof(struct filsys);
			u.u_base = (caddr_t)fp;
			u.u_segflg = 1;
			u.u_fmode = FWRITE|FSYNC;
			fio4k_write_blocked(bip);
			if (u.u_error) {
				u.u_error = EROFS;
				goto out;
			}
		}
		else {
			u.u_error = ENOSPC;
			goto out;
		}
	}

	mp->m_isize = (fp->s_type==FsSEC4) ? SEC_INODESIZE : FsINODESIZE;

	/*
	 * Invalidate buffer containing the superblock
	 * read by s54kreadi().
	 */
	s54kbinval(mp->m_dev);
	mp->m_bsize = BSIZE;
	mp->m_fstyp = s54kfstyp;
	if (pipedev == mp->m_dev)
		pipedev = mp->m_dev;

	if (mp->m_mount = iget(mp, S5ROOTINO)) {
		mp->m_mount->i_flag |= IISROOT;
		prele(mp->m_mount);
	} else
		goto out;

	/*
	 * Initialize pipe device for this fs if this is the first 
	 * fs of this type that has been mounted.
	 */

	if (!fsinfo[mp->m_fstyp].fs_pipe)
		fsinfo[mp->m_fstyp].fs_pipe = mp;
	return;

out:	/* cleanup on error */
	s54kbinval(dev);
	(*bdevsw[bmajor(dev)].d_close)(minor(dev), rdonly, OTYP_MNT);
	s54kbrelse(mp->m_bufp);
}

/*
 * the umount system call.
 */
s54kumount(mp)
register struct mount *mp;
{
	register struct inode *ip, *rip;
	register struct filsys *fp;
	dev_t dev;
	struct inode in;
	struct s5inode s5in;

	dev = notminored(mp->m_dev);

	xumount(mp);	/* remove unused sticky files from text table */

	/*
	 * If this device is the pipe device for this fs type:
	 * (1)	Return busy if the default pipefstyp is this fstyp.
	 *	If this wasn't done there would be no default pipsfstyp.
	 *	If busy is returned, the user can reassign the pipe
	 *	to another device.
	 * (2)	Clear the fs_pipe entry for this type if this device
	 *	was the pipe device for this fstyp.  By this time it has
	 *	been determined that no inode is active.
	 */
	if (fsinfo[mp->m_fstyp].fs_pipe == mp) {
		if (pipefstyp == mp->m_fstyp) {
			u.u_error = EBUSY;
			return;
		}
		fsinfo[mp->m_fstyp].fs_pipe = 0;
	}

	if (iflush(mp) < 0) {
		u.u_error = EBUSY;
		return;
	}
	/* Flush root inode to disk. */
	rip = mp->m_mount;
	ASSERT(rip != NULL);
	plock(rip);
	s54kiupdat(rip, &time, &time);
	if (u.u_error) {
		prele(rip);
		return;
	}
	/*
	 * At this point there should be no active files on the
	 * file system, and the super block should not be locked.
	 * Break the connections.
	 */
	fp = getfs(mp);
	if (!fp->s_ronly) {
		s54kbflush(dev);
		fp->s_time = time;
		fp->s_state = FsOKAY - (long)fp->s_time;
		ip = &in;
		ip->i_ftype = IFBLK;
		ip->i_rdev = mp->m_dev;
		ip->i_fstyp = mp->m_fstyp;
		ip->i_mntdev = mp;
		ip->i_fsptr = (int *)&s5in;
		s5in.s5i_mode = IFBLK;
		u.u_error = 0;
		u.u_offset = SUPERBOFF;
		u.u_count = sizeof(struct filsys);
		u.u_base = (caddr_t)fp;
		u.u_segflg = 1;
		u.u_fmode = FWRITE|FSYNC;
		fio4k_write_blocked(ip);
		u.u_error = 0;
	}
	(*bdevsw[bmajor(dev)].d_close)(minor(dev), 0, OTYP_MNT);
	if (u.u_error) {
		prele(rip);
		return;
	}
	punmount(mp);
	s54kbinval(dev);
	s54kbrelse(mp->m_bufp);
	mp->m_bufp = NULL;
	iput(rip);
	iunhash(rip);
	mp->m_mount = NULL;
	/*
	 * If any error did occur since calling the close routine
	 * we have to ignore it since we've already disposed of the
	 * inode.  Otherwise we'd be left with a mount-table entry
	 * in an inconsistent state.
	 */
	u.u_error = 0;
}

/*
 * mount root file system
 * iflg is 1 if called from iinit, 0 if from uadmin/remount
 */
s54krmount(iflg)
{
	register struct mount	*mp = &mount[0];
	register struct filsys	*fp;
	register struct inode *ip;
	struct inode iinode;
	struct s5inode s5in;
	extern short s54kfstyp;

	if (iflg) {	/* initial call from iinit */
		mp->m_bufp = (caddr_t)s54kgeteblk();
		fp = getfs(mp);
	} else {		/* for remount */
		s54kbinval(mp->m_dev);
		fp = getfs(mp);
		if (fp->s_state == FsACTIVE) {
			u.u_error = EBUSY;
			return;
		}
	}
	mp->m_flags = MINUSE;
	mp->m_dev = rootdev;
	mp->m_bsize = BSIZE; /* assume 4096 byte block fs */
	ip = &iinode;
	ip->i_ftype = IFBLK;
	ip->i_rdev = rootdev;
	ip->i_fsptr = (int *)&s5in;
	ip->i_mntdev = mp;
	s5in.s5i_mode = IFBLK;
	u.u_error = 0;
	u.u_offset = SUPERBOFF;
	u.u_count = sizeof(struct filsys);
	u.u_base = (caddr_t)fp;
	u.u_segflg = 1;
	fio4k_read_blocked(ip);
	if (u.u_error)
		cmn_err(CE_PANIC, "srmount - cannot mount root");
	fp->s_fmod = 0;
	fp->s_ilock = 0;
	fp->s_flock = 0;
	fp->s_ninode = 0;
	fp->s_inode[0] = 0;
	fp->s_ronly = 0;
	if (fp->s_magic != FsMAGIC)
		cmn_err(CE_PANIC, "srmount - not a valid root");

	if ((fp->s_state + (long)fp->s_time) == FsOKAY)
		fp->s_state = FsACTIVE;
	else
		fp->s_state = FsBAD;

	mp->m_isize = (fp->s_type == FsSEC4) ? SEC_INODESIZE : FsINODESIZE;
	u.u_offset = SUPERBOFF;
	u.u_count = sizeof(struct filsys);
	u.u_base = (caddr_t)fp;
	u.u_segflg = 1;
	u.u_fmode = FWRITE|FSYNC;
	fio4k_write_blocked(ip);
	if (u.u_error) {
		fp->s_state = FsBAD;
		u.u_error = 0;
	}
	/*
	 * Invalidate buffer containing the superblock
	 * read by s54kreadi().
	 */
	s54kbinval(mp->m_dev);
	mp->m_bsize = BSIZE;
	mp->m_fstyp = s54kfstyp;
	rootdev = mp->m_dev;
	/* Initialize pipe device for this fs. */
	fsinfo[mp->m_fstyp].fs_pipe = mp;
	/* Initialize pipefstyp to that of the default root. */
	pipefstyp = mp->m_fstyp;
	if (pipedev == rootdev)
		pipedev = rootdev;
	if (iflg) {
		fp->s_time = time;
		/* 
		 * get root inode for proc 0 and others
		 */
		rootdir = iget(&mount[0], S5ROOTINO);
		rootdir->i_flag |= IISROOT;
		prele(rootdir);
		u.u_cdir = iget(&mount[0], S5ROOTINO);
		prele(u.u_cdir);
		u.u_rdir = NULL;
	}
	mount[0].m_mount = rootdir;
}

s54krumount()
{
	register struct mount *mp = &mount[0];
	register struct filsys *fp;
	register struct inode *ip;
	struct s5inode s5in;
	struct inode iinode;

	fp = getfs(mp);
	if (fp->s_state == FsACTIVE) {
		ip = &iinode;
		ip->i_ftype = IFBLK;
		ip->i_rdev = rootdev;
		ip->i_fsptr = (int *)&s5in;
		ip->i_mntdev = mp;
		s5in.s5i_mode = IFBLK;
		fp->s_time = time;
		fp->s_state = FsOKAY - (long)fp->s_time;
		u.u_error = 0;
		u.u_offset = SUPERBOFF;
		u.u_count = sizeof(struct filsys);
		u.u_base = (caddr_t)fp;
		u.u_segflg = 1;
		u.u_fmode = FWRITE|FSYNC;
		fio4k_write_blocked(ip);
		u.u_error = 0;
	}
	s54kbdwait();
}

s54kstatfs(ip, sp, ufstyp)
register struct inode *ip;
register struct statfs *sp;
int  ufstyp;
{
	register struct filsys *fp;
	register struct buf *bp;
	struct inode in;
	struct s5inode s5in;
	extern short s54kfstyp;
	dev_t dev, ndev;

	if (ufstyp) {
		/*
		 * File system not mounted.  The inode pointer
		 * refers to a device from which the superblock
		 * must be read.
		 */
		dev = ip->i_rdev;
 		ndev = notminored(dev);
		if (ip->i_ftype != IFBLK) {
			/* Character devices not supported for now. */
			u.u_error = EINVAL;
			return;
		}
		(*bdevsw[bmajor(ndev)].d_open)(minor(ndev), 0, OTYP_LYR);
		if (u.u_error)
			return;
		bp = s54kgeteblk();
		fp = (struct filsys *)bp->b_un.b_addr;
		in.i_ftype = IFBLK;
		in.i_rdev = dev;
		in.i_fstyp = ufstyp;
		in.i_fsptr = (int *)&s5in;
		in.i_mntdev = &s54k_4096mnt;
		s5in.s5i_mode = IFBLK;
		u.u_offset = SUPERBOFF;
		u.u_count = sizeof(struct filsys);
		u.u_base = (caddr_t)fp;
		u.u_segflg = 1;
		fio4k_read_blocked(&in);
		if (u.u_error)
			goto out;
	} else
		fp = getfs(ip->i_mntdev);
	if (fp->s_magic != FsMAGIC) {
		u.u_error = EINVAL;
		goto out;
	}
	if ((fp->s_type == Fs8b) || (fp->s_type == FsSEC4)) {
		sp->f_bsize = BSIZE;
	} else {
		u.u_error = EINVAL;
		goto out;
	}
	sp->f_fstyp = s54kfstyp;
	sp->f_frsize = 0;
	sp->f_blocks = FsLTOP(sp->f_bsize, fp->s_fsize);
	sp->f_bfree = FsLTOP(sp->f_bsize, fp->s_tfree);
	sp->f_files = (fp->s_isize - 2) * FsSECINOPB(ip->i_mntdev->m_isize);
	sp->f_ffree = fp->s_tinode;
	bcopy(fp->s_fname, sp->f_fname, sizeof(sp->f_fname));
	bcopy(fp->s_fpack, sp->f_fpack, sizeof(sp->f_fpack));
out:
	if (ufstyp) {
		(*bdevsw[bmajor(ndev)].d_close)(minor(ndev), 0, OTYP_LYR);
		s54kbrelse(bp);
	}
}

