/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54ksubr.c: version 25.1 created on 11/27/91 at 14:57:11	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54ksubr.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/fs/s54k:s54ksubr.c	20.5"

#define  FsTYPE 4
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/fstyp.h"
#include "sys/ustat.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/fs/s5macros.h"
#include "sys/systm.h"
#include "sys/file.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/mount.h"
#include "sys/fs/s5filsys.h"
#include "sys/statfs.h"
#include "sys/conf.h"
#include "sys/open.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#include "sys/mfs.h"
#include "sys/acl.h"
#include "sys/mls.h"

#include "sys/priv.h"
#include "sys/audit.h"

extern buf_t *s54kbread();
extern buf_t *s54kgetblk();
extern int blks_to_free;

struct buf *s54kalloc();

daddr_t
fio4k_map_logical_physical(ip, bn, readflg)
register struct inode *ip;
register daddr_t bn;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	struct buf *nbp;
	daddr_t *bap;
	register i, j, sh;
	register daddr_t nb;
	register dev;


	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	dev = u.u_pbdev;
	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (bn < NADDR-3) {
		nb = s5ip->s5i_addr[bn];
		if (nb == 0) {
			if (readflg || (bp = s54kalloc(ip->i_mntdev))==NULL)
				return((daddr_t)-1);
			nb = FsPTOL(BSIZE, bp->b_blkno);
			if ((s5ip->s5i_mode & IFMT) == IFDIR)
				s54kbwrite(bp);
			else
				s54kbdwrite(bp);
			s5ip->s5i_addr[bn] = nb;
			ip->i_flag |= IUPD|ICHG;
		}
		if ((bn < NADDR-4) && u.u_rablock) {
			u.u_rablock = s5ip->s5i_addr[bn+1];
			if ( bn < NADDR-5 )
				u.u_next_rablock = s5ip->s5i_addr[bn+2];
		}
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for(j=3; j>0; j--) {
		sh += FsNSHIFT(BSIZE);
		nb <<= FsNSHIFT(BSIZE);
		if (bn < nb)
			break;
		bn -= nb;
	}
	if (j == 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}


	/*
	 * fetch the address from the inode
	 */
	nb = s5ip->s5i_addr[NADDR-j];
	if (nb == 0) {
		if (readflg || (bp = s54kalloc(ip->i_mntdev))==NULL)
			return((daddr_t)-1);
		nb = FsPTOL(BSIZE, bp->b_blkno);
		s54kbwrite(bp);
		s5ip->s5i_addr[NADDR-j] = nb;
		ip->i_flag |= IUPD|ICHG;
	}

	/*
	 * fetch through the indirect blocks
	 */
	for(; j<=3; j++) {
		bp = s54kbread(dev, nb);
		if (u.u_error) {
			s54kbrelse(bp);
			return((daddr_t)-1);
		}
		bap = bp->b_un.b_daddr;
		sh -= FsNSHIFT(BSIZE);
		i = (bn>>sh) & FsNMASK(BSIZE);
		nb = bap[i];
		/*
		 * calculate read-ahead.
		 */
		if ((j == 3) && (i < FsNINDIR(BSIZE)-1) && u.u_rablock) {
			u.u_rablock = bap[i+1];
			if ( i < FsNINDIR(BSIZE)-2 )
				u.u_next_rablock = bap[i+2];
		}
		if (nb == 0) {
			if (readflg || (nbp = s54kalloc(ip->i_mntdev))==NULL) {
				s54kbrelse(bp);
				return((daddr_t)-1);
			}
			nb = FsPTOL(BSIZE, nbp->b_blkno);
			if ( j < 3 || ((s5ip->s5i_mode & IFMT) == IFDIR))
				s54kbwrite(nbp);
			else
				s54kbdwrite(nbp);
			bap[i] = nb;
			if (u.u_fmode & FSYNC)
				s54kbwrite(bp);
			else
				s54kbdwrite(bp);
		} else
			s54kbrelse(bp);
	}

	return(nb);
}

/*
 * s54kbmap defines the structure of file system storage
 * by returning the physical block number on a device given the
 * inode and the logical block number in a file.
 * Indirect blocks and directory data blocks, when first allocated,
 * are cleared and written synchronously to ensure sanity.
 * Indirect blocks for synchronous writes are also updated synchronously.
 * When convenient, it also leaves the physical
 * block number of the next block of the file in u.u_rablock
 * for use in read-ahead.
 */
daddr_t
s54kbmap(ip, readflg)
register struct inode *ip;
{
	register struct s5inode *s5ip;
	register struct buf *bp;
	register sh;
	register daddr_t bn;
	register daddr_t nb;
	register sz;
	register rem;
	register i;
	int j;
	struct mount *mp;
	dev_t dev;
	int raflag;
	daddr_t *bap;
	int nshift;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	u.u_rablock = 0;
	u.u_next_rablock = 0;
	raflag = 0;

	mp = ip->i_mntdev;
	dev = ip->i_dev;
	u.u_pbdev = dev;
	bn = u.u_offset >> FsBSHIFT(BSIZE);
	if (bn < 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}
	if ((s5ip->s5i_lastr + 1) == bn)
		raflag = 1;
	u.u_pboff = u.u_offset & FsBMASK(BSIZE);
	sz = FsBSIZE(BSIZE) - u.u_pboff;
	if (u.u_count < sz) {
		sz = u.u_count;
		raflag = 0;
	} else
		s5ip->s5i_lastr = bn;
	u.u_pbsize = sz;
	if (readflg == 0) {
		if (u.u_offset >= (uint)(u.u_limit << (SCTRSHFT-1))) {
			u.u_error = EFBIG;
			return((daddr_t)-1);
		}
	} else {
		rem = ip->i_size - u.u_offset;
		if (rem < 0)
			rem = 0;
		if (rem < sz)
			sz = rem;
		if ((u.u_pbsize = sz) == 0)
			return((daddr_t)-1);
	}


	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (bn < NADDR-3) {
		i = bn;
		nb = s5ip->s5i_addr[i];
		if (nb == 0) {
			if (readflg || (bp = s54kalloc(mp))==NULL)
				return((daddr_t)-1);
			nb = FsPTOL(BSIZE, bp->b_blkno);
			if ((s5ip->s5i_mode&IFMT) == IFDIR)
				s54kbwrite(bp);
			else
				s54kbdwrite(bp);
			s5ip->s5i_addr[i] = nb;
			ip->i_flag |= IUPD|ICHG;
		}
		if ((i < NADDR-4) && raflag) {
			u.u_rablock = s5ip->s5i_addr[i+1];
			if ( i < NADDR-5 )
				u.u_next_rablock = s5ip->s5i_addr[i+2];
		}
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	nshift = FsNSHIFT(BSIZE);
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for (j = 3; j > 0; j--) {
		sh += nshift;
		nb <<= nshift;
		if (bn < nb)
			break;
		bn -= nb;
	}
	if (j == 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}

	/*
	 * fetch the address from the inode
	 */
	nb = s5ip->s5i_addr[NADDR-j];
	if (nb == 0) {
		if (readflg || (bp = s54kalloc(mp))==NULL)
			return((daddr_t)-1);
		nb = FsPTOL(BSIZE, bp->b_blkno);
		s54kbwrite(bp);
		s5ip->s5i_addr[NADDR-j] = nb;
		ip->i_flag |= IUPD|ICHG;
	}

	/*
	 * fetch through the indirect blocks
	 */
	for (; j <= 3; j++) {
		bp = s54kbread(dev, nb);
		if (u.u_error) {
			s54kbrelse(bp);
			return((daddr_t)-1);
		}
		bap = bp->b_un.b_daddr;
		sh -= nshift;
		i = (bn>>sh) & FsNMASK(BSIZE);
		nb = bap[i];
		/*
		 * calculate read-ahead.
		 */
		if ((j == 3) && (i < FsNINDIR(BSIZE)-1) && raflag) {
			u.u_rablock = bap[i+1];
			if ( i < FsNINDIR(BSIZE)-2 )
				u.u_next_rablock = bap[i+2];
		}
		if (nb == 0) {
			struct buf *nbp;

			if (readflg || (nbp = s54kalloc(mp))==NULL) {
				s54kbrelse(bp);
				return((daddr_t)-1);
			}
			nb = FsPTOL(BSIZE, nbp->b_blkno);
			if (j < 3 || (s5ip->s5i_mode&IFMT) == IFDIR)
				s54kbwrite(nbp);
			else
				s54kbdwrite(nbp);
			bap[i] = nb;
			if (u.u_fmode&FSYNC)
				s54kbwrite(bp);
			else
				s54kbdwrite(bp);
		} else
			s54kbrelse(bp);
	}

	return(nb);
}



s54kupdate(mp)
register struct mount *mp;
{
	register struct filsys *fp;
	struct inode iinode;
	struct s5inode s5in;
	register struct inode *ip;

	fp = getfs(mp);
/* FIX THIS, DS: combine these two locks? */
	spin_lock(&super_block_flock);
	spin_lock(&super_block_ilock);
	if (fp->s_fmod==0 || fp->s_ilock!=0 ||
	   fp->s_flock!=0 || fp->s_ronly!=0) {
		spin_unlock(&super_block_ilock);
		spin_unlock(&super_block_flock);
		return;
	}
	fp->s_flock = fp->s_ilock = 1;
	spin_unlock(&super_block_ilock);
	spin_unlock(&super_block_flock);
	fp->s_fmod = 0;
	fp->s_time = time;
	ip = &iinode;
	ip->i_ftype = IFBLK;
	ip->i_rdev = mp->m_dev;
	ip->i_fstyp = mp->m_fstyp;
	ip->i_fsptr = (int *)&s5in;
	ip->i_mntdev = mp;
	s5in.s5i_mode = IFBLK;
	u.u_error = 0;
	u.u_offset = SUPERBOFF;
	u.u_count = sizeof(struct filsys);
	u.u_base = (caddr_t)fp;
	u.u_segflg = 1;
	u.u_fmode = FWRITE|FSYNC;
	fio4k_write_blocked(ip);
	spin_lock(&super_block_flock);
	spin_lock(&super_block_ilock);
	fp->s_flock = fp->s_ilock = 0;
	mfs_wakeup(&fp->s_flock);
	mfs_wakeup(&fp->s_ilock);
	spin_unlock(&super_block_ilock);
	spin_unlock(&super_block_flock);
}

/*
 * Check mode permission on inode pointer.
 * Mode is READ, WRITE or EXEC, etc.
 * In the case of WRITE, the read-only status of the file
 * system is checked. Also in WRITE, prototype text
 * segments cannot be written.
 * The mode is shifted to select the owner/group/other fields.
 * The super user (or a user with appropriate privileges in a secure system)
 * is granted access permission.
 * Returns 0 for OK to access, 1 for failed access tests.
 */
s54kaccess(ip, mode)
register struct inode *ip;
register mode;
{
	register struct s5inode *s5ip;
	int 	m = mode,retmode;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

 	/* check to see if pass label policy enforcement */
  	if (!auth_label_chk( s5ip, mode )) {
  		sat_accf( ip, mode, ACCMAC );
		u.u_error = EACCES;
  		return 1;
	}

	switch (mode) {
	case ILABELR:	/* having passed the label check just return OK */
	case ILABELW:
		return 0;

	case ISUID:
 		if (auth_suid( s5ip, mode ))
 			return 0;
 		return 1;

	case ISGID:
 		if (auth_sgid( s5ip, mode ))
			return(0);
		return 1;

	case ISVTX:
		if ((s5ip->s5i_mode&mode))
			return(0);
		return(1);

	case IMNDLCK:
		if (((s5ip->s5i_mode&IFMT)==IFREG) && 
			(s5ip->s5i_mode & (ISGID|(IEXEC>>3))) == ISGID) 
			return(0);
		return(1);

	case IOBJEXEC:
		if ((s5ip->s5i_mode & IFMT) != IFREG ||
 		   (s5ip->s5i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) 
			goto fail;

	case ICDEXEC:
		mode = IEXEC;
		goto exec;

	case IWRITE:
		if (rdonlyfs(ip->i_mntdev)) {
			u.u_error = EROFS;
			return(1);
		}
		if (ip->i_flag&ITEXT)
			xrele(ip);
		/*
		 * DO NOT MERGE THESE TWO IF'S.
		 */
		if (ip->i_flag & ITEXT) {
			u.u_error = ETXTBSY;
			return(1);
		}
	case IREAD:
	case IEXEC:
exec:
		if (auth_dac_chk(mode)) {
			sat_accs( ip, ip, ACCPRIV );
			return 0;
		}
		if (u.u_uid == ip->i_uid) {
			retmode = s5ip->s5i_mode & mode;
			m = ACCOWNER;
		}
#ifdef NOTYET
		else if (s5ip->s5i_acl_inode) {
			retmode = s54kacl_search(ip,mode, UNAMED_ACL);
			m = ACCACL;
		}
		else if (s5ip->s5i_default_acl_inode) {
			retmode = s54kacl_search(ip,mode, DEFAULT_ACL);
			m = ACCACL;
		}
#endif
		else {
			if ((u.u_gid == ip->i_gid) || 
			    ( IS_POSIX_ENV( u.u_procp) && 
			    chk_supp_groups(ip->i_gid)))
				mode >>= GROUP_SH;
			else
				mode >>= OWNER_SH;
			retmode = s5ip->s5i_mode & mode;
			m = ACCMODE;
		}

		if (retmode != 0) {
 			sat_accs( ip, mode, m );
			return(0);
		}
		goto fail;
	}

fail:
 	sat_accf( ip, mode, m );
	u.u_error = EACCES;
	return(1);
}

/*
 * s54kopeni called to allow handler of special files to initialize and
 * validate before actual IO.
 */
s54kopeni(ip, flag)
register struct inode *ip;
{
	register unsigned int maj;
	register dev_t dev;

	dev = notminored(ip->i_rdev);
	switch (ip->i_ftype) {

	case IFCHR:
		maj = major(dev);
		if (maj >= cdevcnt)
			goto bad;
		if (u.u_ttyp == NULL)
			u.u_ttyd = denotminored(dev);
		if (cdevsw[maj].d_str)
			stropen(ip, flag);
		else
			(*cdevsw[maj].d_open)(minor(dev), flag, OTYP_CHR);
		break;

	case IFBLK:
		maj = bmajor(dev);
		if (maj >= bdevcnt)
			goto bad;
		(*bdevsw[maj].d_open)(minor(dev), flag, OTYP_BLK);
		break;

	case IFIFO:
		upkern_lock();
		s54kopenf(ip, flag);
		upkern_unlock();
	}
	return;

bad:
	u.u_error = ENXIO;
}

/* ARGSUSED */
s54kclosei(ip, flag, count, offset)
register struct inode *ip;
int flag, count;
off_t offset;
{
	register struct inode *tip;
	register struct mount *mp;
	register struct file *fp;
	register int (*cfunc)();
	register int fmt;
	register dev_t dev, ndev;
	int otyp;

	u.u_saved_ip = NULL;	/* bmap cache info */
	unlock(ip);
	cleanlocks(ip,USE_PID);
	if (ip->i_sptr && ip->i_ftype != IFDIR)
		strclean(ip);
	if ((unsigned)count > 1)
		return;

	fmt = ip->i_ftype;
	dev = ip->i_rdev;
 	ndev = notminored(dev);

	switch (fmt) {

	case IFCHR:
		cfunc = cdevsw[major(ndev)].d_close;
		otyp = OTYP_CHR;
		break;

	case IFBLK:
		cfunc = bdevsw[bmajor(ndev)].d_close;
		otyp = OTYP_BLK;
		break;

	case IFIFO:
		s54kclosef(ip, flag);

	default:
		return;
	}

	/*
	 * Don't call device close routine if there is any other open 
	 * device inode referring to the same device.
	 */
	if (ip->i_count > 1) 
		return;

	upkern_lock();

	for (fp = file; fp < (struct file *)v.ve_file; fp++) {
		if (fp->f_count) {
			tip = fp->f_inode;
			if ((tip->i_rdev == dev) &&
			    (tip->i_ftype == fmt) &&
			    (tip != ip)) {
				upkern_unlock();
				return;
			}
		}
	}
	if (setjmp(u.u_qsav)) {	/* catch half-closes */
		plock(ip);
		upkern_unlock();
		return;
	}
	if (fmt == IFBLK) {
		for (mp = mount; mp < (struct mount *)v.ve_mount; mp++)
			if ((mp->m_flags & MINUSE) && mp->m_dev == dev) {
				(*cfunc)(minor(ndev), flag, otyp);
				upkern_unlock();
				return;
			}
		s54kbflush(dev);
		(*cfunc)(minor(ndev), flag, otyp);
		s54kbinval(dev);
	} else {
		prele(ip);
		if (cdevsw[major(ndev)].d_str)
			strclose(ip, flag);
		else
			(*cfunc)(minor(ndev), flag, otyp);
		plock(ip);
	}
	upkern_unlock();
}

#ifdef NOTYET
s54kacl_search(ip,mode,a_type)
register struct inode *ip;
register mode;
int a_type;
{
	register struct buf *bp;
	register char *aclp, *acls;
	register struct s5inode *s5ip;
	register struct inode *aip;
	register struct s5inode *s5aip;
	register struct a_user_group *augp;
	register struct a_day_time *adtp;
	register struct a_date *adp;
	ushort	acl_mode = 0;
	uint	acl_bn = 0;
	uint	log_bn = 0;
	uint	blk_search=1;
	uint	user = 0;
	uint	group = 0;
	uint	day,hour,hms;

	s5ip = (struct s5inode *)ip->i_fsptr;

	aip = (struct inode *)get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	hms = time % (24 * 60 * 60);
	day = time / (24 * 60 * 60);
	if (hms < 0) {
		hms += (24 * 60 * 60);
		day -= 1;
	}
	hour = (hms/3600) + 1;
	day = ((day + 7340036L) % 7) + 1;
	s5aip = (struct s5inode *)aip->i_fsptr;

	while ((log_bn < MAX_ACL_BLK ) && blk_search) {
		if(!(acl_bn = s5aip->s5i_addr[log_bn++])) {
			u.u_error = EINVAL;
			blk_search = 0;
			continue;
		}

		bp = bread(ip->i_dev,acl_bn);
		if (u.u_error) {
			brelse(bp);
			blk_search = 0;
			continue;
		}
		aclp = (char *)(bp->b_un.b_addr);	
		acls = aclp;

		while (((aclp-acls) < BSIZE) && blk_search) {
			switch((char)*aclp) {
			case A_DATE:
				adp = (struct a_date *)aclp;
				if ((adp->start > time) || (adp->end < time)) {
					user=1;
					blk_search = 0;
				}
				else
					aclp += sizeof(struct a_date);
				break;
			case A_DAY:
				adtp = (struct a_day_time *)aclp;
				if ((adtp->start > day) || (adtp->end < day)) {
					user=1;
					blk_search = 0;
				}
				else
					aclp += sizeof(struct a_day_time);
				break;
			case A_TIME:
				adtp = (struct a_day_time *)aclp;
				if ((adtp->start > hour) || (adtp->end < hour)){
						user=1;
						blk_search = 0;
				}
				else
					aclp += sizeof(struct a_day_time);
				break;
			case A_USER:
				augp = (struct a_user_group *)aclp;
				if (u.u_uid == augp->id) {
				    if (augp->day_start) {
					if ((augp->day_start > day)
				  	    || (augp->day_end < day)) {
						aclp += sizeof(struct a_user_group);
						break;
					}
				    }
				    if (augp->time_start) {
					if ((augp->time_start > time)
				  	     || (augp->time_end < time)) {
						aclp += sizeof(struct a_user_group);
						break;
					}
				    }
				    acl_mode = augp->mode;
				    user=1;
				    blk_search = 0;
				}
				else
					aclp += sizeof(struct a_user_group);
				break;
			case A_GROUP:
				augp = (struct a_user_group *)aclp;
				if ( (u.u_gid == augp->id)
				  || (chk_supp_groups(augp->id))) {
				    if (augp->day_start) {
					if ((augp->day_start > day)
				  	    || (augp->day_end < day)) {
						aclp += sizeof(struct a_user_group);
						break;
					}
				    }
				    if (augp->time_start) {
					if ((augp->time_start > time)
				  	     || (augp->time_end < time)) {
						aclp += sizeof(struct a_user_group);
						break;
					}
				    }
				    acl_mode |= augp->mode;
				    group=1;
				}
				else
					aclp += sizeof(struct a_user_group);
				break;
			case NULL:
				blk_search = 0;
				continue;
			default:
				blk_search = 0;
				u.u_error = EACCES;
				continue;
			}
		}
		brelse(bp);
	}
	if ((u.u_gid == ip->i_gid) || chk_supp_groups(ip->i_gid))
		acl_mode |= ((s5ip->s5i_mode >> GROUP_SH) & MODE_MASK);
	else if(user || group)
		/* use dac group mode to mask acl mode (AND) */
		acl_mode &= ((s5ip->s5i_mode >> GROUP_SH) & MODE_MASK);
	else
		/* return 'other' mode - low 3 bits */
		acl_mode = s5ip->s5i_mode & MODE_MASK;
	if (a_type != NAMED_ACL)
		iput(aip);
	return (acl_mode & (mode >> OWNER_SH));
}
#endif

s54kfsync(ip)
register struct inode *ip;
{
	register int log_bn;
	register int phys_bn;
	register int size;
	register dev_t dev;
	register struct buf *bp;

	size = ip->i_size;
	dev = ip->i_dev;
	log_bn = 0;
	while (size > 0) {
		phys_bn = fio4k_map_logical_physical(ip, log_bn, 0);
		bp = s54kgetblk(dev, phys_bn);
		if (bp->b_flags & B_DELWRI) {
			if (bp->b_flags & B_BUSY) {
				bp->b_want_flag |= B_WANTED;
				mfs_sleep(bp, PRIBIO+1, &bio_lock);
			}
			s54kbwrite(bp);
		}
		else
			s54kbrelse(bp);
		size -= BSIZE;
		log_bn++;
	}
	ip->i_flag |= IUPD|IACC;
}

s54kftruncate(ip, length)
register struct inode *ip;
register int length;
{
	register uint blk_size;
	register int i;
	register struct s5inode *s5ip;
	register struct mount *mp;
	register int retval=0;
	uint last_blk, last_blk1;
	daddr_t bn;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

	if ((s5ip->s5i_mode & IFMT) != IFREG) {
		u.u_error = EINVAL;
		return;
	}

	/* compute total blocks to free */
	blk_size = FsBSIZE(mp->m_bsize);
	last_blk = (length + (blk_size-1))/blk_size;
	last_blk1 = ((ip->i_size) + (blk_size-1))/blk_size;
	blks_to_free = last_blk1 - last_blk;

	/* update the size of the file */
	ip->i_size = length;
	ip->i_flag |= IUPD|IACC|ICHG;

	mp = ip->i_mntdev;
	for (i=NADDR-1; (i>=0) & blks_to_free; i--) {
		bn = s5ip->s5i_addr[i];
		if (bn == (daddr_t)0)
			continue;

		switch(i) {
		case NADDR-1:
			retval = s54kbfree(mp,bn,1,1);
			break;
		case NADDR-2:
			retval = s54kbfree(mp,bn,1,0);
			break;
		case NADDR-3:
			retval = s54kbfree(mp,bn,0,0);
			break;
		default:
			s54kfree(mp, bn);
			blks_to_free--;
			retval = -1;
			break;
		}
		if (u.u_error)
			return;
		if (retval == -1)
			s5ip->s5i_addr[i] = (daddr_t)0;
	}
}

s54kbfree(mp,bn,d_indir,t_indir)
register struct mount *mp;
register daddr_t bn;
register uint d_indir,t_indir;
{
	register struct buf *bp;
	register daddr_t *bap;
	register daddr_t nb;
	register int i;
	dev_t dev;

	dev = mp->m_dev;
	bp=NULL;
	for (i=FsNINDIR(mp->m_bsize)-1; (i>=0); i--) {
		if (bp == NULL) {
			bp = s54kbread(dev,bn);
			if (bp->b_flags & B_ERROR) {
				brelse(bp);
				return;
			}
			bap = bp->b_un.b_daddr;
		}
		nb = bap[i];
		if (nb == (daddr_t)0)
			continue;
		if (d_indir)
			s54kbfree(mp,nb,t_indir,0);
		else {
			s54kfree(mp,nb);	
			bap[i] = 0;
			blks_to_free--;
		}
		if (blks_to_free == 0)
			break;
	}
	if (bp != NULL)
		s54kbdwrite(bp);
	return(i);
}
