/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54krdwri.c: version 25.1 created on 11/27/91 at 14:57:07	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54krdwri.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#define  FsTYPE 4
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/fs/s5macros.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/file.h"
#include "sys/systm.h"
#include "sys/mount.h"
#include "sys/var.h"
#include "sys/proc.h"
#include "sys/mfs.h"
#include "sys/own.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#ifdef	PERF
#include "sys/perfext.h"
#endif	/* PERF */

extern buf_t *s54kbread();
extern buf_t *s54kbreada();
extern buf_t *s54kgetblk();
extern buf_t *s54kgeteblk();

extern unsigned short condev;
extern struct tty con_tty;


/******************************************************************************

				s54kreadi(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
s54kreadi(ip)
register struct inode *ip;
{
	register ushort ftype;

	ftype = ip->i_ftype;
	if (ftype == IFREG) {
		if (ip->i_locklist != NULL) {
			struct file df;
			df.f_inode = ip;
			df.f_flag = FREAD;
			df.f_offset = u.u_offset;
			if (locked(1,&df,ip,u.u_offset,u.u_offset + u.u_count))
				return;
		}
		if (!s54kaccess(ip, IMNDLCK)) {
			s54kchklock(ip, FREAD);
			if (u.u_error)
				return;
		}
		fio4k_read_buffered(ip);
	}
	else if (ftype == IFDIR || ftype == IFLNK)
		fio4k_read_buffered(ip);
	else {
		if (ftype == IFBLK)  fio4k_read_blocked(ip);
		else {
			if (ftype == IFIFO)  fio4k_read_pipe(ip);
			else {
				if (ftype == IFCHR)  fio4k_read_raw(ip);
			}
		}
	}

}



/******************************************************************************

				s54kwritei(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
s54kwritei(ip)
register struct inode *ip;
{
	register ushort ftype;

	ftype = ip->i_ftype;
	if (ftype == IFREG) {
		if (ip->i_locklist != NULL) {
			struct file df;
			df.f_inode = ip;
			df.f_flag = FWRITE;
			df.f_offset = u.u_offset;
			if (locked(1,&df,ip,u.u_offset,u.u_offset + u.u_count))
				return;
		}
		if (!s54kaccess(ip, IMNDLCK)) {
			s54kchklock(ip, FWRITE);
			if (u.u_error)
				return;
		}
		fio4k_write_buffered(ip);
	}
	else if (ftype == IFDIR || ftype == IFLNK)
		fio4k_write_buffered(ip);
	else {
		if (ftype == IFBLK)  fio4k_write_blocked(ip);
		else {
			if (ftype == IFIFO)  fio4k_write_pipe(ip);
			else {
				if (ftype == IFCHR)  fio4k_write_raw(ip);
			}
		}
	}

}



/******************************************************************************

				fio4k_read_raw(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_read_raw(ip)
register struct inode *ip;
{
	register uint	maj;

	ip->i_flag |= IACC;
	maj = major(ip->i_rdev);

	if (cdevsw[maj].d_str)
		strread(ip);
	else
		(*cdevsw[maj].d_read)(minor(notminored(ip->i_rdev)));
}


/******************************************************************************

				fio4k_read_blocked(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_read_blocked(ip)
register struct inode *ip;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	register bytes_to_copy;
	register buffer_offset;
	register dev;
	register daddr_t block_number;


	s5ip = (struct s5inode *)ip->i_fsptr;
	dev = (int)ip->i_rdev;

	do {
		block_number = u.u_offset >> BSHIFT;
		buffer_offset = u.u_offset & (BSIZE-1);
		bytes_to_copy = BSIZE - buffer_offset;
		if (bytes_to_copy > u.u_count) bytes_to_copy = u.u_count;
		if (s5ip->s5i_lastr == (block_number-1))  {
			u.u_rablock = block_number + 1;
			u.u_next_rablock = block_number + 2;
			bp = s54kbreada(dev, block_number);
		}
		else
			bp = s54kbread(dev, block_number);
		s5ip->s5i_lastr = block_number;
		if (bp->b_resid) {
			bytes_to_copy = 0;
		}
		
		iomove_read(bp->b_un.b_addr+buffer_offset, bytes_to_copy);
		s54kbrelse(bp);
		ip->i_flag |= IACC;
	} while (u.u_error==0 && u.u_count!=0 && bytes_to_copy!=0);

}



/******************************************************************************

				fio4k_read_buffered(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_read_buffered(ip)
register struct inode *ip;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	register bytes_to_copy;
	register daddr_t block_number;
	register buffer_offset;
	register rem;


	u.u_pbdev = ip->i_dev;
	s5ip = (struct s5inode *)ip->i_fsptr;
	do {
		u.u_rablock = 0;
		u.u_next_rablock = 0;
		block_number = u.u_offset >> BSHIFT;
		if ((s5ip->s5i_lastr + 1) == block_number)
			u.u_rablock = block_number + 1;
		buffer_offset = u.u_offset & (BSIZE-1);
		bytes_to_copy = BSIZE - buffer_offset;
		if (u.u_count < bytes_to_copy) {
			bytes_to_copy = u.u_count;
			u.u_rablock = 0;
		} else
			s5ip->s5i_lastr = block_number;

		rem = ip->i_size - u.u_offset;
		if (rem < bytes_to_copy)
			bytes_to_copy = rem;
		if (bytes_to_copy <= 0)
			break;

		/* cache of the last logical to physical block translation. */
		if (! u.u_rablock && block_number == u.u_saved_blk &&
		  ip == u.u_saved_ip && ip->i_mod_cnt == u.u_saved_ip_mod_cnt)
			block_number = u.u_saved_physblk;
		else {
			u.u_saved_ip = ip;
			u.u_saved_ip_mod_cnt = ip->i_mod_cnt;
			u.u_saved_blk = block_number;
			block_number = 
			  fio4k_map_logical_physical(ip,block_number,B_READ);
			u.u_saved_physblk = block_number;
			if (u.u_error) {
				u.u_saved_ip = NULL;
				break;
			}
		}
		if ((long)block_number<0) {
			if ((s5ip->s5i_mode&IFMT) != IFREG)  {
				break;
			}
			bp = s54kgeteblk();
			s54kclrbuf(bp);
		} else if (u.u_rablock)
			bp = s54kbreada(u.u_pbdev, block_number);
		else
			bp = s54kbread(u.u_pbdev, block_number);
		ip->i_flag |= IACC;
		if (bp->b_resid) {
			bytes_to_copy = 0;
		}
		iomove_read(bp->b_un.b_addr+buffer_offset, bytes_to_copy);
		s54kbrelse(bp);
	} while (u.u_error==0 && u.u_count!=0 && bytes_to_copy);
}

/*
 * Read the file corresponding to
 * the inode pointed at by the argument.
 * The actual read arguments are found
 * in the variables:
 *	u_base		core address for destination
 *	u_offset	byte offset in file
 *	u_count		number of bytes to read
 *	u_segflg	read to kernel/user/user I
 */
/******************************************************************************

				fio4k_read_pipe(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_read_pipe(ip)
register struct inode *ip;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	register daddr_t block_number;
	register unsigned bytes_to_copy;
	register rem;


	s5ip = (struct s5inode *)ip->i_fsptr;

	while (ip->i_size == 0) {
		if (s5ip->s5i_fwcnt == 0)
			return;
		if (u.u_fmode & FNDELAY) {
			/* JTOF - NIST change */
			if ( u.u_procp->p_posix_flags & F_POSIX_BINARY ) 
				u.u_error = EAGAIN;
			return;
		}

		s5ip->s5i_fflag |= IFIR;


		spin_lock(&inode_sem);
		if (inode_wanted(ip))  {
			inode_unwant(ip);
			mfs_wakeup_all(ip);
		}
		inode_unlock(ip);

		mfs_sleep_with_sig_check(
#ifdef	PERF
			&s5ip->s5i_frcnt, pri_PPIPE, &inode_sem);
#else	/* PERF */
			&s5ip->s5i_frcnt, PPIPE, &inode_sem);
#endif	/* PERF */

		while (inode_locked(ip))  {
			inode_want(ip);
			mfs_sleep(ip, PINOD, &inode_sem);
		}
		inode_lock(ip);
		spin_unlock(&inode_sem);
	}
	u.u_offset = s5ip->s5i_frptr;
	u.u_pbdev = ip->i_dev;
	do {
		block_number = u.u_offset >> BSHIFT;
		u.u_pboff = u.u_offset & (BSIZE-1);
		bytes_to_copy = BSIZE - u.u_pboff;
		if (u.u_count < bytes_to_copy) {
			bytes_to_copy = u.u_count;
		}

		rem = ip->i_size;
		if (rem < bytes_to_copy)
			bytes_to_copy = rem;
		block_number = fio4k_map_logical_physical(ip,block_number,B_READ);
		if ((bytes_to_copy <= 0) ||
		   (u.u_error))
			break;
		bp = s54kbread(u.u_pbdev, block_number);
		if (bp->b_resid) {
			bytes_to_copy = 0;
		}
		iomove_read(bp->b_un.b_addr+u.u_pboff, bytes_to_copy);
		ip->i_size -= bytes_to_copy;
		if (u.u_offset >= PIPSIZ)
			u.u_offset = 0;
		if ((u.u_pboff+bytes_to_copy)==BSIZE &&
		    ip->i_size < (PIPSIZ-BSIZE))
			bp->b_flags &= ~B_DELWRI;
		s54kbrelse(bp);
		ip->i_flag |= IACC;
	} while (u.u_error==0 && u.u_count!=0 && bytes_to_copy!=0);

	if (ip->i_size)
		s5ip->s5i_frptr = u.u_offset;
	else
		s5ip->s5i_frptr = s5ip->s5i_fwptr = 0;
	if (s5ip->s5i_fflag&IFIW) {
		s5ip->s5i_fflag &= ~IFIW;
#ifdef	PERF
		own.o_curpri = pri_PPIPE;
#else	/* PERF */
		own.o_curpri = PPIPE;
#endif	/* PERF */
		spin_lock(&inode_sem);
		mfs_wakeup_all(&s5ip->s5i_fwcnt);
		spin_unlock(&inode_sem);
	}
}

/******************************************************************************

				fio4k_write_raw(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_write_raw(ip)
register struct inode *ip;
{
	register uint	maj;

	ip->i_flag |= IUPD|ICHG;
	maj = major(ip->i_rdev);

	if (cdevsw[maj].d_str)
		strwrite(ip);
	else
		(*cdevsw[maj].d_write)(minor(notminored(ip->i_rdev)));
}

/******************************************************************************

				fio4k_write_blocked(ip)


Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_write_blocked(ip)
register struct inode *ip;
{
	register struct buf *bp;
	register bytes_to_copy;
	register buffer_offset;
	register dev;
	register daddr_t block_number;



	dev = (int)ip->i_rdev;

	while (u.u_error==0 && u.u_count!=0) {
		block_number = u.u_offset >> BSHIFT;
		buffer_offset = u.u_offset & (BSIZE-1);
		bytes_to_copy = BSIZE - buffer_offset;
		if (bytes_to_copy > u.u_count) bytes_to_copy = u.u_count;
		if (bytes_to_copy != BSIZE) 
			bp = s54kbread(dev, block_number);
		else
			bp = s54kgetblk(dev, block_number);

		iomove_write(bp->b_un.b_addr+buffer_offset, bytes_to_copy);
		ip->i_flag |= IUPD|ICHG;
		if (u.u_error)  {
			s54kbrelse(bp);
			return;
		}
		bp->b_flags |= B_AGE;
		s54kbawrite(bp);
	}
}


/******************************************************************************

				fio4k_write_buffered(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_write_buffered(ip)
register struct inode *ip;
{
	register struct buf	*bp;
	register struct s5inode	*s5ip;
	register int		bytes_to_copy; 
	register daddr_t	block_number;
	register uint		u_offset;
	register uint		block_offset;
	register uint		bytes_written;
	extern buf_t		 *s54kpartial_getblk();

	u_offset = u.u_offset;
	if (u_offset >= (u.u_limit << (SCTRSHFT-1))) {
		if (u.u_count) u.u_error = EFBIG;
		return;
	}
	u.u_pbdev = ip->i_dev;
	s5ip = (struct s5inode *)ip->i_fsptr;

	ip->i_mod_cnt++;

	bytes_written = 0;
	while (u.u_error==0 && u.u_count!=0) {

		block_number = u_offset / BSIZE;
		block_offset = u_offset % BSIZE;
		bytes_to_copy = BSIZE - block_offset;
		if (u.u_count < bytes_to_copy) {
			bytes_to_copy = u.u_count;
		} else
			s5ip->s5i_lastr = block_number;
		if (u_offset >= u.u_limit_adj) {
			int temp;
			if (u_offset >= (u.u_limit << (SCTRSHFT-1)))
				break;
			temp = (u.u_limit << (SCTRSHFT-1)) - u_offset;
			if (bytes_to_copy > temp) bytes_to_copy = temp;
		}

		/* cache of the last logical to physical block translation. */
		if (block_number == u.u_saved_blk && ip == u.u_saved_ip
		  && ip->i_mod_cnt == u.u_saved_ip_mod_cnt) {
			block_number = u.u_saved_physblk;
			u.u_saved_ip_mod_cnt++;
		}
		else {
			u.u_saved_ip = ip;
			u.u_saved_blk = block_number;
			u.u_saved_ip_mod_cnt = ip->i_mod_cnt + 1;
			block_number = 
			  fio4k_map_logical_physical(ip,block_number,B_WRITE);
			u.u_saved_physblk = block_number;
			if (u.u_error) {
				if (bytes_written)
					u.u_error = 0;	/* retn partial count */
				u.u_saved_ip = NULL;
				break;
			}
		}
		bp = s54kpartial_getblk(u.u_pbdev, block_number, block_offset);
		iomove_write(bp->b_un.b_addr + block_offset, bytes_to_copy);
		u_offset = u.u_offset;
		if (bp->b_invalid > BSIZE - (block_offset + bytes_to_copy))
			bp->b_invalid = BSIZE - (block_offset + bytes_to_copy);
		if (u_offset > ip->i_size)  {
			if (s5ip->s5i_map)
				s54kfreemap(ip);
			ip->i_size = u_offset;
		}
		ip->i_flag |= IUPD|ICHG;
		if (u.u_error)  {
			u.u_saved_ip = NULL;
			s54kbrelse(bp);
			break;
		}
		if (u.u_fmode&FSYNC)
			s54kbwrite(bp);
		else
			s54kbdwrite(bp);
		bytes_written += bytes_to_copy;
	}
}


/*
 * Write the file corresponding to
 * the inode pointed at by the argument.
 * The actual write arguments are found
 * in the variables:
 *	u_base		core address for source
 *	u_offset	byte offset in file
 *	u_count		number of bytes to write
 *	u_segflg	write to kernel/user/user I
 */
/******************************************************************************

				fio4k_write_pipe(ip)

Purpose
Parameters
Return
Algorithm

******************************************************************************/
fio4k_write_pipe(ip)
register struct inode *ip;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	register dev;
	register daddr_t block_number;
	register unsigned bytes_to_copy;
	register unsigned int usave;


	s5ip = (struct s5inode *)ip->i_fsptr;

floop:
	usave = 0;
	while ((u.u_count+ip->i_size) > PIPSIZ) {
		if (s5ip->s5i_frcnt == 0)
			break;
		if ((u.u_count > PIPSIZ) && (ip->i_size < PIPSIZ)) {
			usave = u.u_count;
			u.u_count = PIPSIZ - ip->i_size;
			usave -= u.u_count;
			break;
		}
		if (u.u_fmode & FNDELAY) {
			/* JTOF - NIST change */
			if ( u.u_procp->p_posix_flags & F_POSIX_BINARY ) 
				u.u_error = EAGAIN;
			return;
		}

		s5ip->s5i_fflag |= IFIW;
		spin_lock(&inode_sem);
		if (inode_wanted(ip))  {
			inode_unwant(ip);
			mfs_wakeup_all(ip);
		}
		inode_unlock(ip);

		mfs_sleep_with_sig_check(
#ifdef	PERF
			&s5ip->s5i_fwcnt, pri_PPIPE, &inode_sem);
#else	/* PERF */
			&s5ip->s5i_fwcnt, PPIPE, &inode_sem);
#endif	/* PERF */

		while (inode_locked(ip))  {
			inode_want(ip);
			mfs_sleep(ip, PINOD, &inode_sem);
		}
		inode_lock(ip);
		spin_unlock(&inode_sem);
	}
	if (s5ip->s5i_frcnt == 0) {
		u.u_error = EPIPE;
		psignal(u.u_procp, SIGPIPE);
		return;
	}
	u.u_offset = s5ip->s5i_fwptr;

	u.u_pbdev = ip->i_dev;
	dev = u.u_pbdev;
	while (u.u_error==0 && u.u_count!=0) {
		block_number = u.u_offset >> BSHIFT;
		u.u_pboff = u.u_offset & (BSIZE-1);
		bytes_to_copy = BSIZE - u.u_pboff;
		if (u.u_count < bytes_to_copy) {
			bytes_to_copy = u.u_count;
		}

		block_number=fio4k_map_logical_physical(ip,block_number,B_WRITE);
		if (u.u_error)
			break;

		if ((bytes_to_copy == BSIZE)  ||
		   (u.u_pboff==0 && ip->i_size < (PIPSIZ-BSIZE)))
			bp = s54kgetblk(dev, block_number);
		else
			bp = s54kbread(dev, block_number);

		iomove_write(bp->b_un.b_addr+u.u_pboff, bytes_to_copy);
		if (u.u_error)
			s54kbrelse(bp);
		else
			s54kbdwrite(bp);
		ip->i_size += bytes_to_copy;
		if (u.u_offset == PIPSIZ)
			u.u_offset = 0;
	}
	ip->i_flag |= IUPD|ICHG;
	s5ip->s5i_fwptr = u.u_offset;
	if (s5ip->s5i_fflag&IFIR) {
		s5ip->s5i_fflag &= ~IFIR;
#ifdef	PERF
		own.o_curpri = pri_PPIPE;
#else	/* PERF */
		own.o_curpri = PPIPE;
#endif	/* PERF */
		spin_lock(&inode_sem);
		mfs_wakeup_all(&s5ip->s5i_frcnt);
		spin_unlock(&inode_sem);
	}
	/* JTOF - if it's POSIX bin and NODELAY is set return 
	          amount of IO could do without waiting
                  else go through loop until all data is out 
	*/
	if (IS_POSIX() && (u.u_fmode&FNDELAY)) {
			u.u_count = usave;
			return;
	}

	if (u.u_error==0 && usave!=0) {
		u.u_count = usave;
		goto floop;
	}
}

/*
 * Enforce record locking protocol on regular file ip.
 */
s54kchklock(ip, mode)
register struct inode *ip;
int mode;
{
	register int i;
	struct flock bf;

	bf.l_type = (mode & FWRITE) ? F_WRLCK : F_RDLCK;
	bf.l_whence = 0;
	bf.l_start = u.u_offset;
	bf.l_len = u.u_count;
	i = (u.u_fmode & FNDELAY) ? INOFLCK : SLPFLCK|INOFLCK;
	if ((i = reclock(ip, &bf, i, 0, u.u_offset)) || bf.l_type != F_UNLCK)
		u.u_error = i ? i : EAGAIN;
}
