/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54knami.c: version 23.1 created on 10/30/90 at 19:35:58	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54knami.c	23.1	10/30/90 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/fs/s54k:s54knami.c	2.1"
#define  FsTYPE 4
#include "sys/types.h"
#include "sys/fstyp.h"
#include "sys/fs/s5macros.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/nami.h"
#include "sys/file.h"
#include "sys/mount.h"
#include "sys/immu.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/own.h"
#include "sys/acl.h"
#include "sys/stat.h"
#ifdef	PERF
#include "sys/perf.h"
#include "sys/perfext.h"
#endif	/* PERF */

extern buf_t *s54kbread();
extern int	fips;

#define DOT 1
#define DOTDOT 2
s54knamei(p, flagp)
struct nx *p;
register struct argnamei *flagp;
{	
	register char *cp;
	register char *comp;
	register struct inode *dp;
	register struct inode *dip;
	register struct inode *tip;
	register struct s5inode *s5dp;	/* for sticky bit checks */
	register int i;
	register char *ccp;
	struct buf *bp;
	struct mount *mp;
	struct direct dir;
	struct s5inode *s5dip;
	struct inode *aip;
	char *dirend;
	int found = 0;
	int bn;
	off_t eo;
	struct direct x[2];
	off_t saveoff;
	int dotflag = 0;
	int emptflags;
	struct inode *s54kialloc();
	int locked = 0;
	int targlen;

	comp = p->comp;
	/*
	 * dp must be a directory 
	 */
	dp = p->dp;

	if (*comp == '\0') {
		if (flagp)
			if (flagp->cmd == NI_RMDIR || flagp->cmd == NI_DEL) {
				/*
				 * This branch is executed when a rmdir
				 * (NI_RMDIR) or unlink (NI_DEL) is executed
				 * on a remotely mounted directory.
				 */
				u.u_error = EBUSY;
				goto fail;
			}
		dir.d_ino = dp->i_number;
		goto pass;
	}

	dir.d_ino = 0;
	cp = &dir.d_name[0];
	dirend = &dir.d_name[DIRSIZ];
	while (*comp != '\0' && cp < dirend) 
		*cp++ = *comp++;

	while (cp < dirend)
		*cp++ = '\0';

	u.u_segflg = 1;

	u.u_offset = 0;
	u.u_count = dp->i_size;

	eo = -1;	/* eo is used to store the first empty entry index */
	bp = NULL;

	while (u.u_count) {
		/*
		 * Read the next directory block
		 */
		if (bp != NULL)
			s54kbrelse(bp);
		atom_inc(&sysinfo.dirblk);
		bn = s54kbmap(dp, B_READ);
		if (u.u_error)
			goto fail;
		if (bn < 0) {
			u.u_error = EIO;
			goto fail;
		}
		bp = s54kbread(dp->i_dev, bn);
		if (u.u_error) {
			s54kbrelse(bp);
			goto fail;
		}
	
		/*
		 * Search directory block. searchdir() returns
		 * offset of matching entry, or empty entry, or -1.
		 */
		cp = bp->b_un.b_addr;
		switch (i = searchdir(cp, u.u_pbsize, dir.d_name)) {
		default:
			cp += i;
			if ((dir.d_ino = ((struct direct *)cp)->d_ino) != 0) {
				/* update offset for NI_DEL */
				u.u_offset += i;
				found++;
				goto skip;
			}
			/* keep track of empty slot */
			if (eo < 0)
				eo = u.u_offset + i;
		case -1:
			u.u_offset += u.u_pbsize;
			u.u_count -= u.u_pbsize;
			continue;
		}
	}
skip:
	if (bp != NULL)
		s54kbrelse(bp);
	if (flagp == 0) {
		if (found)
			goto pass;
		u.u_error = ENOENT;
		goto fail;
	}

	u.u_count = sizeof(struct direct);
	u.u_base = (caddr_t)&dir;
	u.u_fmode = FWRITE;
	/* Leave offset alone if the operation is 
	 * NI_DEL or NI_RMDIR.
	 */
	if (eo >= 0 && flagp->cmd != NI_DEL && flagp->cmd != NI_RMDIR)
		u.u_offset = eo;


	switch (flagp->cmd) {
	case NI_RNM_NEW_CHK: 
	case NI_RNM_OLD_CHK:
		if (found)  {
			/* we shouldn't remove . */
			if (dp->i_number == dir.d_ino) { 
				u.u_error = EINVAL;
				goto fail;
			}
			if (s5access(dp, IWRITE)) 
				goto fail;
			if ((dip = iget(dp->i_mntdev, dir.d_ino)) == NULL) {
				u.u_error = ENOENT;
				goto fail;
			}
			if ((dir.d_ino == flagp->ino) && 
					(dp->i_dev == flagp->idev)) {
				iput(dip);
				/* tell rename syscall that both new and
				 * old names are the same.
				 */
				flagp->ino = 0;
				goto pass;
			}
			if((dip->i_flag & IRENAME) ||(dip->i_flag & IRENDEL))  {
				iput(dip);
				u.u_error = EBUSY;
				goto pass;
			}
			dip->i_flag |= IRENAME;
			iput(dip);
			goto pass;
		}
		u.u_error = ENOENT;
		goto fail;
		
	case NI_LINK:	/* make a link */
		upkern_lock();
		locked = 1;
		if (found) {
			u.u_error = EEXIST;
			goto fail;
		}
		if (s54kaccess(dp, IWRITE))
			goto fail;
		if (dp->i_dev != flagp->idev) {
			u.u_error = EXDEV;
			goto fail;
		}
		if (flagp->ino == dp->i_number)
			dip = dp;
		else if ((dip = iget(dp->i_mntdev, flagp->ino)) == NULL) {
			u.u_error = ENOENT;
			goto fail;
		}
		if (dip->i_nlink >= MAXLINK) {
			iput(dip);
			u.u_error = EMLINK;
			goto fail;
		}
		if(dip->i_flag & IRENDEL)  {
			iput(dip);
			u.u_error = EBUSY;
			goto fail;
		}
		if (dip->i_flag &IRENLNK && dip->i_flag&IFDIR)
			dp->i_nlink++;
		dip->i_nlink++;
		dip->i_flag |= ICHG|isyn;
		s54kiupdat(dip, &time, &time);
		dir.d_ino = flagp->ino;
		fio4k_write_buffered(dp);
		if (u.u_error) {
			dip->i_nlink--;
			dip->i_flag |= ICHG;
		}

		sat_link( dp );

		if (dip != dp)
			iput(dip);
		/* go to null so that inode will */
		/* be released properly. link does not */
		/* expect an inode pointer to be  */
		/* returned */
		iput(dp);
		goto null;
	case NI_MKNOD:	/* mknod - like exclusive create except for */
			/* mode setting - see below */
	case NI_XCREAT: /* Exclusive create on a file */
		if (found) {
			u.u_error = EEXIST;
			goto fail;
		}
	case NI_CREAT:	/* create a new file */
		if (found) {
			mp = dp->i_mntdev;
			iput(dp);
			if ((dp = iget(mp, dir.d_ino)) == NULL)
				goto noiputfail;
			if (dp->i_ftype == IFLNK)
				goto symlink;
			flagp->rcode = FSN_FOUND;
			goto done;
		}
		if (s54kaccess(dp, IWRITE))
			goto fail;
		/* Do not permit the setting of an */
		/* unspecified ftype or mode */
		if ((flagp->ftype & (ushort)(~IFMT))) {
			u.u_error = EINVAL;
			goto fail;
		}
		if (flagp->ftype == 0)
			flagp->ftype = IFREG;
		flagp->mode &= MODEMSK;
		flagp->mode &= ~u.u_cmask;
		if (flagp->cmd != NI_MKNOD)
			flagp->mode &= ~ISVTX;
		flagp->mode |= flagp->ftype;
		dip = s54kialloc(dp->i_mntdev, flagp->mode, 1, flagp->idev);
		if (dip == NULL)
			goto fail;
		dir.d_ino = dip->i_number;

/* JTOF - if posix binary and fips option on inherit gid from directory */ 
		if ( IS_POSIX_ENV(u.u_procp) && s54kaccess(dp,ISGID) )  {
			dip->i_gid = dp->i_gid;
			dip->i_flag |= ICHG;
		}


		s5dp  = (struct s5inode *)dp->i_fsptr;	/* parent dir	*/
		s5dip = (struct s5inode *)dip->i_fsptr;	/* new file	*/

		/*
		 * For security, files inherit their acl information
		 * from the parent directory.
		 * pete
		 */
#ifdef NOTYET
		if(s5dp->s5i_default_acl_inode){
			if((aip = iget(dip->i_mntdev,
				s5dp->s5i_default_acl_inode)) == NULL) {
				u.u_error = EINVAL;
				goto fail;
		    	}
			s5dip->s5i_acl_inode = s5dp->s5i_default_acl_inode;
			s5dip->s5i_acl_inode_type = DEFAULT_ACL;
		    	aip->i_nlink++;
		    	iput(aip);
		}
#endif
#ifdef	PERF
		/*
		 * For special cases, new files inherit performance data
		 * from the parent directory.  This may not be a good idea
		 * and so we may take this feature away or make it an option.
		 * misha
		 */
		if ((dp->i_mntdev->m_isize == SECURE_INODE) &&
			(dip->i_mntdev->m_isize == SECURE_INODE)) {
			if (glob_quantum_copy_flag)
				s5dip->s5i_quantum      = s5dp->s5i_quantum;
			else
				s5dip->s5i_quantum      = 0;
			if (glob_slice_copy_flag)
				s5dip->s5i_slice_clamp  = s5dp->s5i_slice_clamp;
			else
				s5dip->s5i_slice_clamp  = 0;
			if (glob_pri_copy_flag)
				s5dip->s5i_pri_clamp    = s5dp->s5i_pri_clamp;
			else
				s5dip->s5i_pri_clamp    = 0;
			if (glob_usrpri_copy_flag)
				s5dip->s5i_usrpri_clamp =s5dp->s5i_usrpri_clamp;
			else
				s5dip->s5i_usrpri_clamp = 0;
			if (glob_cpu_copy_flag)
				s5dip->s5i_cpu_clamp    = s5dp->s5i_cpu_clamp;
			else
				s5dip->s5i_cpu_clamp    = 0;
			if (glob_pri_adj_copy_flag)
				s5dip->s5i_pri_adj      = s5dp->s5i_pri_adj;
			else
				s5dip->s5i_pri_adj      = 0;
			if (glob_perf_flags_copy_flag)
				s5dip->s5i_perf_flags   = s5dp->s5i_perf_flags;
			else
				s5dip->s5i_perf_flags   = 0;
		}
#endif	/* PERF */

		fio4k_write_buffered(dp);

		if ( u.u_error == 0 )
			if (flagp->cmd == NI_MKNOD)
				sat_mknd( dp, flagp->mode );
			else
				sat_create( dp, flagp->mode );

		iput(dp);
		dp = dip;
		if (u.u_error)
			goto fail;
		flagp->rcode = FSN_NOTFOUND;
		goto done;
	case NI_MKDIR:
		upkern_lock();
		locked = 1;
		/* make a directory */
		if (found) {
			u.u_error = EEXIST;
			goto fail;
		}
		if (dp->i_nlink >= MAXLINK) {
			u.u_error = EMLINK;
			goto fail;
		}
		if (s54kaccess(dp, IWRITE))
			goto fail;
		flagp->mode &= PERMMSK;
		flagp->mode &= ~u.u_cmask;
		flagp->mode |= IFDIR;
		dip = s54kialloc(dp->i_mntdev, flagp->mode, 2, flagp->idev);
		if (dip == NULL)
			goto fail;
		x[0].d_ino = dip->i_number;  /* inumber of new directory */
		x[1].d_ino = dp->i_number;  /* inumber of .. */

/* JTOF - if posix binary and fips option on inherit gid from directory */ 
		if (IS_POSIX_ENV(u.u_procp) && s54kaccess(dp,ISGID) )  {
			dip->i_gid = dp->i_gid;
			dip->i_flag |= ICHG;
		}

		s5dp  = (struct s5inode *)dp->i_fsptr;	/* parent dir	*/
		s5dip = (struct s5inode *)dip->i_fsptr;	/* new file	*/

		/*
		 * For security, directories inherit their default
		 * acl information from the parent directory.
		 * pete
		 */
#ifdef NOTYET
		if(s5dp->s5i_default_acl_inode){
		    	if((aip = iget(dip->i_mntdev,
				s5dp->s5i_default_acl_inode)) == NULL) {
				u.u_error = EINVAL;
				goto fail;
		    	}
			s5dip->s5i_default_acl_inode =
				s5dp->s5i_default_acl_inode;
			s5dip->s5i_acl_inode_type = DEFAULT_ACL;
		    	aip->i_nlink++;
		    	iput(aip);
		}
#endif
#ifdef	PERF
		/*
		 * For special cases, new directories inherit performance data
		 * from the parent directory.  This may not be a good idea
		 * and so we may take this feature away or make it an option.
		 * misha
		 */
		if ((dp->i_mntdev->m_isize == SECURE_INODE) &&
			(dip->i_mntdev->m_isize == SECURE_INODE)) {
			if (glob_quantum_copy_flag)
				s5dip->s5i_quantum      = s5dp->s5i_quantum;
			else
				s5dip->s5i_quantum      = 0;
			if (glob_slice_copy_flag)
				s5dip->s5i_slice_clamp  = s5dp->s5i_slice_clamp;
			else
				s5dip->s5i_slice_clamp  = 0;
			if (glob_pri_copy_flag)
				s5dip->s5i_pri_clamp    = s5dp->s5i_pri_clamp;
			else
				s5dip->s5i_pri_clamp    = 0;
			if (glob_usrpri_copy_flag)
				s5dip->s5i_usrpri_clamp =s5dp->s5i_usrpri_clamp;
			else
				s5dip->s5i_usrpri_clamp = 0;
			if (glob_cpu_copy_flag)
				s5dip->s5i_cpu_clamp    = s5dp->s5i_cpu_clamp;
			else
				s5dip->s5i_cpu_clamp    = 0;
			if (glob_pri_adj_copy_flag)
				s5dip->s5i_pri_adj      = s5dp->s5i_pri_adj;
			else
				s5dip->s5i_pri_adj      = 0;
			if (glob_perf_flags_copy_flag)
				s5dip->s5i_perf_flags   = s5dp->s5i_perf_flags;
			else
				s5dip->s5i_perf_flags   = 0;
		}
#endif	/* PERF */

		cp = &x[0].d_name[0];
		ccp = &x[1].d_name[0];
		dirend = &x[0].d_name[DIRSIZ];
		while (cp < dirend) {
			*cp++ = '\0';
			*ccp++ = '\0';
		}
		x[0].d_name[0] = x[1].d_name[0] = x[1].d_name[1] = '.';
		u.u_count = 2 * sizeof(struct direct);
		u.u_base = (caddr_t)x;
		saveoff = u.u_offset;
		u.u_offset = 0;
		u.u_segflg = 1;
		u.u_fmode = FWRITE | FSYNC;
		fio4k_write_buffered(dip);
		if (u.u_error) {
			dip->i_nlink = 0;
			iput(dip);
			goto fail;
		}
		dir.d_ino = dip->i_number;
		u.u_offset = saveoff;
		u.u_base = (caddr_t)&dir;
		u.u_count = sizeof(struct direct);
		u.u_fmode = FWRITE | FSYNC;
		fio4k_write_buffered(dp);
		if (u.u_error)  {
			dip->i_nlink = 0;
			iput(dip);
			goto fail;
		}

		sat_create( dp, flagp->mode );

		dp->i_nlink++;	/* update link count for .. */
		dp->i_flag |= ICHG|isyn;
		iput(dp);
		iput(dip);
		goto null;


	case NI_RMDIR:
		upkern_lock();
		locked = 1;
		if (found == 0) {
			u.u_error = ENOENT;
			goto fail;
		}
		if (s54kaccess(dp, IWRITE)) {
			goto fail;
		}
		if (dp->i_number == dir.d_ino) { /* can't remove . */
			u.u_error = EINVAL;
			goto fail;
		}
		if ((dip = iget(dp->i_mntdev, dir.d_ino)) == NULL)
			goto fail;

		/*
		 * The following checks if we are crossing
		 * a mount point. There is an implicit assumption 
		 * that when crossing a mount point the device
		 * number changes.
		 */

		if ( auth_fsnami(dip) == 0 ) {
			iput(dip);
			u.u_error = EPERM;
			goto fail;
		}
		if (dip->i_dev != dp->i_dev) {
			iput(dip);
			u.u_error = EBUSY;
			goto fail;
		}
		if (dip->i_ftype != IFDIR) {
			u.u_error = ENOTDIR;
			iput(dip);
			goto fail;
		}
		if (dip == u.u_cdir) {
			u.u_error = EINVAL;
			iput(dip);
			goto fail;
		}
		/*
		 * if sticky bit set on parent dir, then delete only when suser,
		 * or owner of dir, or owner of parent dir, or dir is writable
		 */
		s5dp = (struct s5inode *)dp->i_fsptr;
 		if (s5dp->s5i_mode&ISVTX && (!auth_adm_ne()) &&
			dip->i_uid != u.u_uid && dp->i_uid != u.u_uid &&
			s54kaccess(dip, IWRITE)) {
			u.u_error = EACCES;
			iput(dip);
			goto fail;
		}
		/* check whether this file is being renamed */
		if (dip->i_flag & IRENAME)  {
			iput(dip);
			u.u_error = EBUSY;
			goto fail;
		}

		/* clear IRENDEL flag which might have been set by
		 * rename system call.
		 */
		dip->i_flag &= ~IRENDEL;

		/* the following checks if the directory is empty */
		u.u_count = dip->i_size;
		saveoff = u.u_offset;
		u.u_offset = 0;
		while (u.u_count) {
			bn = s54kbmap(dip, B_READ);
			if (u.u_error) {
				iput(dip);
				goto fail;
			}
			bp = s54kbread(dip->i_dev, bn);
			if (u.u_error) {
				s54kbrelse(bp);
				iput(dip);
				goto fail;
			}
			cp = bp->b_un.b_addr;
			/*
			 * Emptblk returns -1 if the directory is not empty.
			 * If it contains nothing different from . and ..
			 * then the return value indicates whether .
			 * and .. are actually present.
			 */
			if ((emptflags = emptblk4k(cp, u.u_pbsize)) == -1) {
				u.u_error = EEXIST;
				s54kbrelse(bp);
				iput(dip);
				goto fail;
			}
			else {
				dotflag |= emptflags;
				s54kbrelse(bp);
				u.u_offset += u.u_pbsize;
				u.u_count -= u.u_pbsize;
			}
		}
		dir.d_ino = 0;
		u.u_count = sizeof(struct direct);
		u.u_base = (caddr_t)&dir;
		u.u_fmode = FWRITE | FSYNC;
		u.u_offset = saveoff;
		fio4k_write_buffered(dp);
		if (u.u_error)  {
			iput(dip);
			goto fail;
		}

		sat_rmdir( dp, dip );

		if (dotflag & DOTDOT) {
			dp->i_nlink--;
			dp->i_flag |= ICHG;
		}
		iput(dp);
		if (dotflag & DOT)
			dip->i_nlink -= 2;
		else
			dip->i_nlink--;
		dip->i_flag |= ICHG;

		if(dip->i_nlink <= 0){
		    s5dip = (struct s5inode *)(dip->i_fsptr);
#ifdef NOTYET
		    if(s5dip->s5i_acl_inode) {
			s54kaclunlink(dip, UNAMED_ACL);
			if (u.u_error) {
				iput(dip);
				goto fail;
			}
		    }
		    if (s5dip->s5i_default_acl_inode) {
			s54kaclunlink(dip, DEFAULT_ACL);
			if (u.u_error) {
				iput(dip);
				goto fail;
			}
		    }
#endif
			/* release blocks now, 'cause someone */
			/* may do a readdir() before last close */ 
		    s54kitrunc(dip);
		}
		iput(dip);
		goto null;

	case NI_DEL:
		upkern_lock();
		locked = 1;
		/* delete the entry */
		if (found == 0) {
			u.u_error = ENOENT;
			goto fail;
		}
		if (s54kaccess(dp, IWRITE))
			goto fail;
		if (dp->i_number == dir.d_ino) 	/* for '.' */
			dip = dp;
		else
			dip = iget(dp->i_mntdev, dir.d_ino);
		if (dip == NULL)
			goto fail;

		if ( auth_fsnami(dip) == 0 ) {
			iput(dip);
			u.u_error = EPERM;
			goto fail;
		}
		/*
		 * if sticky bit set on parent dir, then delete only when suser,
		 * or owner of file, or owner of parent dir, or file is writable
		 */
		s5dp = (struct s5inode *)dp->i_fsptr;
 		if (s5dp->s5i_mode&ISVTX && (!auth_adm_ne()) &&
			dip->i_uid != u.u_uid && dp->i_uid != u.u_uid &&
			s54kaccess(dip, IWRITE)) {
			u.u_error = EACCES;
			iput(dip);
			goto fail;
		}
		if (dip->i_dev != dp->i_dev) {	/* mounted FS? */
			u.u_error = EBUSY;
			goto delfail;
		}

		if (!(dip->i_flag & IRENDEL) && dip->i_ftype == IFDIR && 
							!auth_unlink()) 
			goto delfail;
		if (dip->i_flag&ITEXT)
			xrele(dip);	/* try to free busy text */
		if (dip->i_flag&ITEXT && dip->i_nlink == 1) {
			u.u_error = ETXTBSY;
			goto delfail;
		}

		/* check whether this file is being renamed */
		if(dip->i_flag & IRENAME)  {
			iput(dip);
			u.u_error = EBUSY;
			return;
		}

		if (dip->i_flag&IRENDEL && dip->i_flag&IFDIR)
			dp->i_nlink--;

		/* clear IRENDEL flag which might have been set by
		 * rename system call.
		 */
		dip->i_flag &= ~IRENDEL;

		u.u_fmode = FWRITE|FSYNC;
		dir.d_ino = 0;
		fio4k_write_buffered(dp);
		if (u.u_error) 
			goto delfail;
		dip->i_nlink--;
		dip->i_flag |= ICHG;

#ifdef NOTYET
		if(dip->i_nlink <= 0){
		    s5dip = (struct s5inode *)(dip->i_fsptr);
		    if(s5dip->s5i_acl_inode)
			s54kaclunlink(dip, UNAMED_ACL);
		}
#endif
 		sat_unlink( dp, dip );
				
delfail:
		/* unlink does not expect any inode to be */
		/* returned so clean up. */
		/* if unlinking '.', avoid doing iput twice. */
		if (dp != dip)
			iput(dip);
		if (u.u_error)
			goto fail;
		iput(dp);
		goto null;

	case NI_SYMLINK:

		if (found) {
			u.u_error = EEXIST;
			goto fail;
		}
		if (s54kaccess(dp, IWRITE))
			goto fail;

		if (!(dip = s54kialloc(dp->i_mntdev, IFLNK | 0777, 1, -1)))
			goto fail;

		u.u_fmode = FWRITE | FSYNC;

		dir.d_ino = dip->i_number;

		fio4k_write_buffered(dp);
		if (u.u_error) {
			iput(dip);
			goto fail;
		}
		targlen = write_symlink(dip, (caddr_t)flagp->mode);
		if (u.u_error)
			goto fail;

		sat_slink(dip, dir.d_name, dp->i_number,
		  (caddr_t)flagp->mode, targlen);

		iput(dp);
		goto null;
	}

fail:
	iput(dp);
noiputfail:
	p->dp = dp;
	if (locked)
		upkern_unlock();
	return(NI_FAIL);

null:
	if (locked)
		upkern_unlock();
	return(NI_NULL);

done:
	p->dp = dp;
	if (locked)
		upkern_unlock();
	return(NI_DONE);

pass:
	p->dp = dp;
	p->ino = dir.d_ino;
	if (p->ino == S5ROOTINO)
		p->flags |= NX_ISROOT;
	if (locked)
		upkern_unlock();
	return(NI_PASS);

symlink:
	p->dp = dp;
	if (locked)
		upkern_unlock();
	return(NI_SYMFOUND);
}

static
write_symlink(ip, pathname)
struct inode	*ip;
caddr_t		pathname;
{
	int	path_length;	

	path_length = strlen(pathname);

	u.u_segflg = 1;
	u.u_offset = 0;
	u.u_count = path_length;
	u.u_base = pathname;

	fio4k_write_buffered(ip);
	iput(ip);

	return(path_length);
}

s54ksetattr(ip, flagp)
register struct inode *ip;
register struct argnamei *flagp;
{
	register struct s5inode *s5ip;
	register struct inode *ip1;
	register a_type;
	ushort	old_modes;
#ifdef	PERF
	short	old_perf_val;
	uint	old_perf_flags;
#endif	/* PERF */

	struct a {
		union {
		    char *fname;
		    uint fdes;
		} aa;
		int	func;		
		char	*buf;
		int	size;
	} *uap;

 	struct b {
 		int fdes;
 		off_t length;
 	} *ubp;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

 	if (! auth_fsnami(ip)) {
 		u.u_error = EPERM;
 		return (0);
 	}


	if (rdonlyfs(ip->i_mntdev)) {
		u.u_error = EROFS;
		return(0);
	}

	switch (flagp->cmd) {
#ifdef	PERF
	case NI_CHQUANTUM:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_quantum;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chquantum()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_quantum;
		s5ip->s5i_quantum = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHSLICE:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_slice_clamp;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chslice()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_slice_clamp;
		s5ip->s5i_slice_clamp = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHPRI:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_pri_clamp;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chpri()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_pri_clamp;
		s5ip->s5i_pri_clamp = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHUSRPRI:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_usrpri_clamp;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chusrpri()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_usrpri_clamp;
		s5ip->s5i_usrpri_clamp = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHCPU:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_cpu_clamp;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chcpu()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_cpu_clamp;
		s5ip->s5i_cpu_clamp = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);
#endif	/* PERF */

	case NI_CHPRIADJ:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_pri_adj;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chpriadj()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_val = s5ip->s5i_pri_adj;
		s5ip->s5i_pri_adj = (short)(flagp->mode);
		flagp->mode = old_perf_val;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHFLAGS:
		if (flagp->rcode) {
			flagp->mode  = s5ip->s5i_perf_flags;
			flagp->rcode = 0;
			return (0);
		}
		if ((u.u_uid != ip->i_uid) && !auth_chflags()) {
			u.u_error = EACCES;
			return (0);
		}
		old_perf_flags = s5ip->s5i_perf_flags;
		s5ip->s5i_perf_flags = (uint)(flagp->mode);
		flagp->mode = old_perf_flags;
		if (ip->i_flag & ITEXT)
			xrele(ip);
		return (1);

	case NI_CHMOD:
		if (u.u_uid != ip->i_uid && !auth_chmod())
			return(0);

 		old_modes = s5ip->s5i_mode;

		if (!auth_chmod_ne()) {
			/* if not root, allow chmod +t on directories only */
			if ((s5ip->s5i_mode&IFMT) != IFDIR)
				flagp->mode &= ~ISVTX;
			if (u.u_gid != ip->i_gid)
				if (IS_SVID_ENV(u.u_procp) || 
					!chk_supp_groups(ip->i_gid))
					flagp->mode &= ~ISGID;

		}
		s5ip->s5i_mode &= ~MODEMSK;
		s5ip->s5i_mode |= flagp->mode&MODEMSK;

 		sat_chmod(ip,old_modes,s5ip->s5i_mode);

		if ((ip->i_flag & ITEXT) && (s5ip->s5i_mode & ISVTX) == 0)
			xrele(ip);
		return(1);

	case NI_CHOWN:
	    /* 
	     * SVID environemnt:
	     *   A proc with auth_chown may modify the uid and gid of any file.
	     *   A proc without auth_chown may modify the uid and/or gid of
	     *   a file if it's effective uid is equal to the uid of the file.
	     *
	     * POSIX environment (_POSIX_CHOWN_RESTRICTED):
	     *   Only procs with auth_chown may change file uid.
	     *   A proc may change the gid of a file if it has auth_chown or
	     *   it's effective uid is equal to the uid of the file AND
	     *   the new uid of the file is equal to the file's current uid AND 
	     *   the new gid is the process's effective gid or a member of 
	     *   the process's set of supplemental groups.
	     */

		if ((u.u_uid != ip->i_uid) && !auth_chown())
			return(0);

		if (!auth_chown_ne()) {
			/*
			 * for POSIX, if changing uid, EPERM.
			 *	      if changing gid and the new gid is
			 *	      not proc's gid or supp. gid, EPERM.
			 */		
			if (IS_POSIX_ENV(u.u_procp))
				if (flagp->uid != ip->i_uid ||
				   (flagp->gid != ip->i_gid &&
				    flagp->gid != u.u_gid &&
				    !chk_supp_groups(flagp->gid))) {

					u.u_error = EPERM;
					return(0);
				}

 			if ((s5ip->s5i_mode&IFMT) == IFREG)
				s5ip->s5i_mode &= ~(ISUID|ISGID);
		}
		ip->i_uid = flagp->uid;
		ip->i_gid = flagp->gid;
		return(1);

	case NI_ACL:
		uap = (struct a *)u.u_ap;
		switch(uap->func) {
		    case GETACL_DEFAULT:
			if ((s5ip->s5i_mode & IFMT) != IFDIR){
				u.u_error = EINVAL;
				return(0);
			}
			s54kgetacl(ip, uap->buf, uap->size, DEFAULT_ACL);
			break;
		    case GETACL:
			a_type = (ip->i_ftype == IFACL) ? NAMED_ACL : UNAMED_ACL;
			s54kgetacl(ip, uap->buf, uap->size, a_type);
			break;
		    case SETACL_DEFAULT:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			if ((s5ip->s5i_mode & IFMT) != IFDIR){
				u.u_error = EINVAL;
				return(0);
			}
			s54ksetacl(ip, uap->buf, uap->size, DEFAULT_ACL);
			break;
		    case SETNACL:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			s54ksetacl(ip, uap->buf, uap->size, NAMED_ACL);
			break;
		    case SETACL:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			a_type = (ip->i_ftype == IFACL) ? NAMED_ACL : UNAMED_ACL;
			s54ksetacl(ip, uap->buf, uap->size, a_type);
			break;
		    case ACLSTAT_DEFAULT:
			if ((s5ip->s5i_mode & IFMT) != IFDIR){
				u.u_error = EINVAL;
				return(0);
			}
			s54kaclstat(ip, uap->buf, DEFAULT_ACL);
			break;
		    case ACLSTAT:
			a_type = (ip->i_ftype == IFACL) ? NAMED_ACL : UNAMED_ACL;
			s54kaclstat(ip, uap->buf, a_type);
			break;
		    case ACL_LINK_DEFAULT:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			u.u_dirp = (caddr_t)(uap->buf);
			if ((ip1 = namei(upath, 0)) == NULL) {
				u.u_error = EINVAL;
				return(0);
			}
 			if ((ip1->i_ftype == IFACL)  ||
 			    (ip1->i_mntdev->m_isize < SECURE_INODE )) {
				u.u_error = EINVAL;
				iput(ip1);
				return(0);
			}
			s54kacllink(ip, ip1, DEFAULT_ACL);
			iput(ip1);
			break;
		    case ACL_LINK:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			u.u_dirp = (caddr_t)(uap->buf);
			if ((ip1 = namei(upath, 0)) == NULL) {
				u.u_error = EINVAL;
				return(0);
			}
 			if ((ip1->i_ftype == IFACL)  ||
 			    (ip1->i_mntdev->m_isize < SECURE_INODE )) {
				u.u_error = EINVAL;
				iput(ip1);
				return(0);
			}
			a_type = (ip->i_ftype == IFACL) ? NAMED_ACL : UNAMED_ACL;
			s54kacllink(ip, ip1, a_type);
			iput(ip1);
			break;
		    case ACL_UNLINK_DEFAULT:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			s54kaclunlink(ip, DEFAULT_ACL);
			break;
		    case ACL_UNLINK:
			if ((u.u_uid != ip->i_uid) && !auth_acl())
				return(0);
			s54kaclunlink(ip, UNAMED_ACL);
			break;
		    default:
			u.u_error = EINVAL;
			return(0);
		}
		return(1);
 	case NI_FSYNC:
 		s54kfsync(ip);
 		break;
 	case NI_FTRUNC:
 		ubp = (struct b *)u.u_ap;
 		s54kftruncate(ip, ubp->length);
 		break;
	}
	return(0);
}


/*
 * This routine checks if a directory block has any non-trivial entries.
 * It returns -1 if it contains an entry different from either . or ..
 * and a flag indicating whether . and .. are
 * actually present otherwise.
 */

#define SDSIZ	(sizeof(struct direct))

emptblk4k(dp, size)
register struct direct *dp;
int size;
{
	register int		n;
	int			flag = 0;

	for (n = size; n >= SDSIZ; n -= SDSIZ) {
		if (dp->d_ino != 0){
			if (dp->d_name[0] == '.' && dp->d_name[1] == '\0' )
				flag |= DOT;
			else if (dp->d_name[0] == '.' && dp->d_name[1] == '.' &&
			    dp->d_name[2] == '\0') 
				flag |= DOTDOT;
			else
				return(-1);
		}
		dp++;
	}
	return(flag);
}

/* ARGSUSED */
long
s54knotify(ip, noargp)
struct inode			*ip;
register struct argnotify	*noargp;
{
	ASSERT(noargp != NULL);
	switch ((int) noargp->cmd) {
	case NO_SEEK:
		if (noargp->data1 < 0)
			u.u_error = EINVAL;
		return(noargp->data1);
		break;
	}
	return(0L);
}
