/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54kblklst.c: version 25.3 created on 2/5/92 at 17:14:56	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54kblklst.c	25.3	2/5/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/fs/s54k:s54kblklst.c	23.1"
#define  FsTYPE 4
#include	"sys/types.h"
#include	"sys/sema.h"
#include	"sys/sysmacros.h"
#include	"sys/fs/s5macros.h"
#include	"sys/immu.h"
#include	"sys/fs/s5inode.h"
#include	"sys/fstyp.h"
#include	"sys/inode.h"
#include	"sys/mount.h"
#include	"sys/user.h"
#include	"sys/buf.h"
#include	"sys/region.h"
#include 	"sys/proc.h"
#include	"sys/pfdat.h"
#include	"sys/errno.h"
#include	"sys/cmn_err.h"
#include	"sys/debug.h"
#include	"sys/conf.h"

extern buf_t *s54kbread();
extern buf_t *s54kbreada();
extern buf_t *s54kgeteblk();


/*
 *  Allocate and build the block address map
 */

s54kallocmap(ip)
register struct inode *ip;
{
	register int	*bnptr;
	register struct s5inode *s5ip;
	register int	i;
	register int	blkspp;
	register int	bsize;
	register int	nblks;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	if (s5ip->s5i_map) 
		return(1);

	/*	Get number of blocks to be mapped.
	 */

	ASSERT(s5ip->s5i_map == 0);
	bsize = FsBSIZE((ip->i_mntdev)->m_bsize);
	nblks = (ip->i_size + bsize - 1)/bsize;
	blkspp = NBPP/bsize;


	/*	Round up the file size in block to an
	 *	integral number of pages.  Allocate
	 *	space for the block number list.
	 */

	i = ((nblks + blkspp - 1) / blkspp) * blkspp;
	bnptr = s5ip->s5i_map = (int *)uptalloc(ctos(i), NULL);
	if (bnptr == NULL)
		return(0);

	/*	Build the actual list of block numbers
	 *	for the file.
	 */

	s54kbldblklst(bnptr, ip, nblks);

	/*	If the size is not an integral number of
	 *	pages long, then the last few block
	 *	number up to the next page boundary are
	 *	made zero so that no one will try to
	 *	read them in.  See code in fault.c/vfault.
	 */

	while (i%blkspp != 0) {
		*bnptr++ = -1;
		i++;
	}
	return(1);
}

/*	Read page from a file
 *
 *	return # of bytes read if no error occurs
 *	return -1 - when read error occurs
 */
s54kreadmap(ip, offset, size, vaddr, segflg)
register struct inode *ip;
off_t offset;
int size;
caddr_t vaddr;
int segflg;
{
	register struct buf	*bp;
	register int	*bnptr;
	register struct s5inode *s5ip;
	register dev_t	edev;
	register int bsize;
	register int	i;
	int ret, on, n;

	/*	Get the number of blocks to read and
	 *	a pointer to the block number list.
	 */

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	ASSERT(s5ip->s5i_map != 0);
	if (offset > ip->i_size) {
		u.u_error = EINVAL;
		printf("s54kreadpg: offset=%x ip->i_size=%x\n",
		  offset,ip->i_size);
		return(-1);
	}
	if (offset+size > ip->i_size) {
		size = ip->i_size - offset;
	}
	ret = size;
	edev = ip->i_dev;
	bsize = FsBSIZE((ip->i_mntdev)->m_bsize);
	i = offset/bsize;
	bnptr = &s5ip->s5i_map[i];
	on = offset - (i*bsize);

	while (size > 0) {
		if (*bnptr == -1) 
			break;

		if (*bnptr) {
			if ((size > bsize)  &&  *(bnptr + 1)) {
				u.u_rablock = *(bnptr+1);
				bp = s54kbreada(edev, *bnptr);
			}
			else
				bp = s54kbread(edev, *bnptr);
		} else {
			bp = (struct buf *)s54kgeteblk();
			s54kclrbuf(bp);
		}
		bnptr++;

		bp->b_flags |= B_AGE;
		if (bp->b_flags&B_ERROR) {
			prdev("page read error", edev);
			s54kbrelse(bp);
			return(-1);
		}

		n = bsize - on;
		if (n > size) n = size;
		if (segflg != 1) {
			if (copyout(bp->b_un.b_addr + on, vaddr, n)) {
				u.u_error = EFAULT;
				printf("s54kreadpg:  failure in copyout\n");
				s54kbrelse(bp);
				return(-1);
			}
		} else
			bcopy(bp->b_un.b_addr+on, vaddr, n);
		s54kbrelse(bp);
		size -= n;
		offset += n;
		vaddr += n;
		on = 0;
	}

	return(ret);
}

/*	Build the list of block numbers for a file.  This is used
 *	for mapped files.
 */

s54kbldblklst(lp, ip, nblks)
register int		*lp;
inode_t			*ip;
register int		nblks;
{
	register int	*eptr;
	register struct s5inode *s5ip;
	register int	lim;
	register int	i;
	int		*s54kbldindr();

	/*	Get the block numbers from the direct blocks first.
	 */

	eptr = &lp[nblks];
	if (nblks < 10)
		lim = nblks;
	else
		lim = 10;
	
	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	for (i = 0  ;  i < lim  ;  i++)
		*lp++ = s5ip->s5i_addr[i];
	
	if (lp >= eptr)
		return(1);
	
	while (lp < eptr) {
		lp = s54kbldindr(ip,lp,eptr,effdev(ip),s5ip->s5i_addr[i], i-10);
		if (lp == 0)
			return(0);
		i++;
	}
	return(1);
}

int  *
s54kbldindr(ip, lp, eptr, edev, blknbr, indlvl)
struct inode *ip;
register int		*lp;
register int		*eptr;
register int		edev;
int			blknbr;
int			indlvl;
{
	register struct buf *bp;
	register int    *bnptr;
	register	cnt;

	bp = s54kbread(edev, blknbr);
	if (u.u_error) {
		s54kbrelse(bp);
		return((int *) 0);
	}
	bnptr = bp->b_un.b_words;
	
	cnt = FsNINDIR((ip->i_mntdev)->m_bsize);
	ASSERT(indlvl >= 0);
/*
 * CH
 * The following are likely to happen here:
 * 	lack of free buffer
 *	stack overflow
 */

	while (cnt--  &&  lp < eptr) {
		if (indlvl == 0) {
			*lp++ = *bnptr++;
		} else {
			lp = s54kbldindr(ip,lp,eptr,edev,*bnptr++, indlvl-1);
			if (lp == 0) {
				s54kbrelse(bp);
				return(lp);
			}
		}
	}

	s54kbrelse(bp);
	return(lp);
}

/*	Free the block list attached to an inode.
 */

s54kfreemap(ip)
register inode_t	*ip;
{
	register struct s5inode *s5ip;
	register int		nblks;
	register int		blkspp;
	register		bsize;

	ASSERT((ip->i_flag & ITEXT) == 0);
	ASSERT(inode_locked(ip));
	ASSERT(ip->i_count <= 1);
	
	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

	if (ip->i_ftype != IFREG || s5ip->s5i_map == NULL)
		return;

	/* Call paging routine to flush page cache */
	flushpgch(ip);

	bsize = FsBSIZE((ip->i_mntdev)->m_bsize);
	nblks = (ip->i_size + bsize - 1)/bsize;
	blkspp = NBPP/bsize;

	/* Round up the file size (in blocks) to an integral */
	/* number of pages */
	nblks = ((nblks + blkspp - 1) / blkspp) * blkspp;
	uptfree(s5ip->s5i_map, ctos(nblks));
	s5ip->s5i_map = NULL;
}
