/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s54kacl.c: version 25.1 created on 11/27/91 at 14:56:35	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s54kacl.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)kern-port:fs/s54k/s54kacl.c	10.19.2.2"
#define  FsTYPE 4
#include "sys/types.h"
#include "sys/fstyp.h"
#include "sys/fs/s5macros.h"
#include "sys/sysmacros.h"
#include "sys/systm.h"
#include "sys/sysinfo.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/nami.h"
#include "sys/file.h"
#include "sys/mount.h"
#include "sys/immu.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/debug.h"
#include "sys/conf.h"
#include "sys/own.h"
#include "sys/acl.h"
#include "sys/stat.h"

extern buf_t *s54kbread();
extern buf_t *s54kgetblk();
extern get_acl_inode();
extern get_acl_ip();
extern remove_acl();

s54ksetacl(ip, buf, size, a_type)
register struct inode *ip;
char *buf;
int size, a_type;
{
	register struct inode *aip;
	register struct s5inode *s5ip;
	register struct s5inode *s5aip;
	register char *aclp;
	register struct buf *bp;
	uint	copysz;
	uint	new,logbn = 0;
	uint	not_done =1;
	uint	nb;
	ino_t   inum;
#ifdef NOTYET
	if ( ! auth_acl() ) {
		u.u_error = EPERM;
		return;
	}

	if ((size < 0) || (size > MAX_ACL_SIZE)) {
		u.u_error = EINVAL;
		return;
	}

	aip = (struct inode *)get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (size == 0) {
		if (!aip) {
			u.u_error = EINVAL;
			return;
		}
		remove_acl(ip, aip, a_type);
		return;
	}

	if (aip && (aip->i_nlink > 1)) {
		remove_acl(ip, aip, a_type);
		aip = NULL;
	}
	if (aip == NULL) {
		if ((aip = (struct inode *)
		s54kialloc(ip->i_mntdev,IFACL,1,-1)) == NULL) {
			u.u_error = EINVAL;
			return;
		}
	}

	s5ip = (struct s5inode *)(ip->i_fsptr);
	s5aip = (struct s5inode *)(aip->i_fsptr);
	ASSERT(s5aip != NULL);
	aip->i_size = 0;
	while (not_done && size) {
		if (new || ((s5aip->s5i_addr[logbn]) == NULL)) {
			if ((bp = (struct buf *)s54kalloc(ip->i_mntdev)) == NULL){
				not_done = 0;
				continue;
			}
		}
		else 
			bp = s54kgetblk(ip->i_dev,s5aip->s5i_addr[logbn]);

		nb = FsPTOL(BSIZE, bp->b_blkno);
		aclp = (char *)(bp->b_un.b_addr);	
		bzero(aclp, BSIZE);

		copysz = (size < BSIZE) ? size : BSIZE;
		if (copyin(buf, aclp, copysz)) {
			u.u_error = EIO;
			not_done = 0;
			continue;
		}
		buf += copysz;
		size -= copysz;

		bp->b_dev = ip->i_dev;
		s54kbwrite(bp);
		if (u.u_error) {
			not_done = 0;
			continue;
		}
		s5aip->s5i_addr[logbn++] = nb;
		aip->i_size += copysz;
	}

	if (u.u_error) {
		if (a_type != NAMED_ACL)
			iput(aip);
		return;
	}

	for( ; logbn < MAX_ACL_BLK; logbn++) { 
		if (s5aip->s5i_addr[logbn]) {
			s54kfree(ip->i_mntdev, s5aip->s5i_addr[logbn]);
			s5aip->s5i_addr[logbn] = 0;
		}
	}


	sat_acl(ip, aip);


	switch (a_type) {
	case UNAMED_ACL:
		s5ip->s5i_acl_inode = aip->i_number;
		break;
	case DEFAULT_ACL:
		s5ip->s5i_default_acl_inode = aip->i_number;
		break;
	}
	s5aip->s5i_acl_inode_type = a_type;

	ip->i_flag |= IUPD|ICHG;
	if (a_type != NAMED_ACL) {
		aip->i_flag |= IUPD|ICHG;
		iput(aip);
	}
#else
	u.u_error = EPERM;
#endif
}

s54kgetacl(ip, buf, size, a_type)
register struct inode *ip;
register char *buf;
int size, a_type;
{
	register struct inode *aip;
	register struct s5inode *s5aip;
	struct buf *bp;
	char	*aclp;
	uint	acl_bn;
	uint	log_bn=0;
	uint	copysz;
	ino_t	inum;
	
#ifdef NOTYET
	aip = (struct inode *)get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if ((size == 0) || (aip == NULL)) {
		u.u_error = EINVAL;
		return;
	}
		
	if (size > aip->i_size)
		size = aip->i_size;

	s5aip = (struct s5inode *)aip->i_fsptr;

	/* read acls into buf */

	while ((log_bn < MAX_ACL_BLK) && size) {
		if(!(acl_bn = s5aip->s5i_addr[log_bn++])) {
			u.u_error = EINVAL;
			break;
		}
		bp = s54kbread(ip->i_dev,acl_bn);
		if (u.u_error) {
			brelse(bp);
			break;	
		}

		aclp = (char *)(bp->b_un.b_addr);	
		if(size < BSIZE)
			copysz = size;
		else
			copysz = BSIZE;

		if (copyout(aclp, buf, copysz) < 0) {
			u.u_error = EFAULT;
			break;
		}
		size -= copysz;
		buf += copysz;
		s54kbrelse(bp);
	}
	ip->i_flag |= IACC;
	if (a_type != NAMED_ACL) {
		aip->i_flag |= IACC;
		iput(aip);
	}
#else
	u.u_error = EINVAL;
#endif
}

s54kaclstat(ip, buf, a_type)
register struct inode *ip;
struct stat *buf;
uint	a_type;
{
	register struct s5inode *s5aip;
	register struct inode *aip;
	register ushort acl_mode;
	struct stat ds;
	ino_t inum;

#ifdef NOTYET
	aip = (struct inode *)get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (aip == NULL) {
		u.u_error = EINVAL;
		return;
	}
		
	s5aip = (struct s5inode *)aip->i_fsptr;
		
	if (aip->i_flag & (IACC|IUPD|ICHG))
		FS_IUPDAT(aip, &time, &time);
	/*
	 * first copy from inode table
	 */

	ds.st_ino = (ushort)aip->i_number;
	ds.st_nlink = aip->i_nlink;
	ds.st_size = aip->i_size;

	if (a_type != NAMED_ACL)
		iput(aip);

	/*
	 * Call fs dependent portion to 
	 * read the disk inode to obtain
	 * file modes and dates
	 */

	FS_STATF(ip, &ds);

	/* if not the owner, then modify the modes based on the acl */
	if (u.u_uid != ip->i_uid) {
		acl_mode = s54kacl_search(ip, IREAD|IWRITE|IEXEC, a_type);
		if (u.u_gid == ip->i_gid)
			ds.st_mode = 
			   (ds.st_mode & 0707) | (acl_mode << GROUP_SH);
		else
			ds.st_mode = 
			   (ds.st_mode & 0770) | acl_mode;
	}

	if (copyout((caddr_t)&ds, (caddr_t)buf, sizeof(ds)) < 0)
		u.u_error = EFAULT;
#else
	u.u_error = EINVAL;
#endif
}

s54kaclunlink(ip, a_type)
register struct inode *ip;
int a_type;
{
	register struct inode *aip;
	register struct s5inode *s5ip;
	register struct s5inode *s5aip;
	register ino_t inum;
	register logbn;

#ifdef NOTYET
	aip = (struct inode *)get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (aip == NULL) {
		u.u_error = EINVAL;
		return;
	}

	remove_acl(ip, aip, a_type);
#else
	u.u_error = EINVAL;
#endif
}

s54kacllink(ip, ip1, a_type)
register struct inode *ip;
register struct inode *ip1;
int a_type;
{
	register struct s5inode *s5ip;
	register struct s5inode *s5ip1;
	register ino_t inum;
	register ino_t inum1;
	register struct inode *aip;


#ifdef NOTYET
	s5ip = (struct s5inode *)ip->i_fsptr;
	s5ip1 = (struct s5inode *)ip1->i_fsptr;

	if (a_type == DEFAULT_ACL) {
		if (ip1->i_ftype != IFDIR) {
			u.u_error = ENOTDIR;
			return;
		}
		inum1 = s5ip1->s5i_default_acl_inode;
		if (s5ip->s5i_acl_inode_type == NAMED_ACL) {
			inum = ip->i_number;
		}
		else {
			if (ip->i_ftype != IFDIR) {
				u.u_error = ENOTDIR;
				return;
			}
			inum = s5ip->s5i_default_acl_inode;
		}
	}
	else {
		if (s5ip->s5i_acl_inode_type == NAMED_ACL)
			inum = ip->i_number;
		else
			inum = s5ip->s5i_acl_inode;
		inum1 = s5ip1->s5i_acl_inode;
	}

	if (!inum) {
		u.u_error = EINVAL;
		return;
	}
	aip = (struct inode *)get_acl_ip(ip, a_type);

	if (aip->i_nlink >= MAXLINK) {
		if (aip != ip)
			iput(aip);
		u.u_error = EMLINK;
		return;
	}
	
	if (inum1) {
		if (inum == inum1) {
			if (aip != ip)
				iput(aip);
			u.u_error = EEXIST;
			return;
		}
		s54kaclunlink(ip1, a_type);
		if (u.u_error) {
			if (aip != ip)
				iput(aip);
			return;
		}
	}
	aip->i_nlink++;

	if (a_type == DEFAULT_ACL)
		s5ip1->s5i_default_acl_inode = inum;
	else
		s5ip1->s5i_acl_inode = inum;
	
	ip1->i_flag |= IUPD|ICHG;
	aip->i_flag |= IUPD|ICHG;
	
	/* no iput if named acl */
	if (aip != ip)
		iput(aip);
#else
	u.u_error = EINVAL;
#endif
}
