/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s5subr.c: version 25.2 created on 2/28/92 at 23:42:00	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s5subr.c	25.2	2/28/92 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)kern-port:fs/s5/s5subr.c	10.11"

#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/fstyp.h"
#include "sys/ustat.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/fs/s5macros.h"
#include "sys/systm.h"
#include "sys/file.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/mount.h"
#include "sys/fs/s5filsys.h"
#include "sys/statfs.h"
#include "sys/conf.h"
#include "sys/open.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/var.h"
#include "sys/region.h"
#include "sys/proc.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/fcntl.h"
#include "sys/flock.h"
#include "sys/mfs.h"
#include "sys/acl.h"
#include "sys/mls.h"

#include "sys/priv.h"
#include "sys/audit.h"

extern inode_t *s5get_acl_ip();
struct buf *s5alloc();

daddr_t
fio_map_logical_physical(ip, bn, readflg)
register struct inode *ip;
register daddr_t bn;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	struct buf *nbp;
	daddr_t *bap;
	register i, j, sh;
	register daddr_t nb;
	register dev;


	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	dev = u.u_pbdev;
	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (bn < NADDR-3) {
		nb = s5ip->s5i_addr[bn];
		if (nb == 0) {
			if (readflg || (bp = s5alloc(ip->i_mntdev))==NULL)
				return((daddr_t)-1);
			nb = FsPTOL(BSIZE, bp->b_blkno);
			if ((s5ip->s5i_mode & IFMT) == IFDIR)
				bwrite(bp);
			else
				bdwrite(bp);
			s5ip->s5i_addr[bn] = nb;
			ip->i_flag |= IUPD|ICHG;
		}
		if ((bn < NADDR-4) && u.u_rablock) {
			u.u_rablock = s5ip->s5i_addr[bn+1];
			if ( bn < NADDR-5 )
				u.u_next_rablock = s5ip->s5i_addr[bn+2];
		}
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for(j=3; j>0; j--) {
		sh += FsNSHIFT(BSIZE);
		nb <<= FsNSHIFT(BSIZE);
		if (bn < nb)
			break;
		bn -= nb;
	}
	if (j == 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}

	/*
	 * fetch the address from the inode
	 */
	nb = s5ip->s5i_addr[NADDR-j];
	if (nb == 0) {
		if (readflg || (bp = s5alloc(ip->i_mntdev))==NULL)
			return((daddr_t)-1);
		nb = FsPTOL(BSIZE, bp->b_blkno);
		bwrite(bp);
		s5ip->s5i_addr[NADDR-j] = nb;
		ip->i_flag |= IUPD|ICHG;
	}

	/*
	 * fetch through the indirect blocks
	 */
	for(; j<=3; j++) {
		bp = bread(dev, nb);
		if (u.u_error) {
			brelse(bp);
			return((daddr_t)-1);
		}
		bap = bp->b_un.b_daddr;
		sh -= FsNSHIFT(BSIZE);
		i = (bn>>sh) & FsNMASK(BSIZE);
		nb = bap[i];
		/*
		 * calculate read-ahead.
		 */
		if ((j == 3) && (i < FsNINDIR(dev)-1) && u.u_rablock) {
			u.u_rablock = bap[i+1];
			if ( i < FsNINDIR(dev)-2 )
				u.u_next_rablock = bap[i+2];
		}
		if (nb == 0) {
			if (readflg || (nbp = s5alloc(ip->i_mntdev))==NULL) {
				brelse(bp);
				return((daddr_t)-1);
			}
			nb = FsPTOL(BSIZE, nbp->b_blkno);
			if ( j < 3 || ((s5ip->s5i_mode & IFMT) == IFDIR))
				bwrite(nbp);
			else
				bdwrite(nbp);
			bap[i] = nb;
			if (u.u_fmode & FSYNC) 
				bwrite(bp);
			else
				bdwrite(bp);
		} else
			brelse(bp);
	}

	return(nb);
}

/*
 * s5bmap defines the structure of file system storage
 * by returning the physical block number on a device given the
 * inode and the logical block number in a file.
 * Indirect blocks and directory data blocks, when first allocated,
 * are cleared and written synchronously to ensure sanity.
 * Indirect blocks for synchronous writes are also updated synchronously.
 * When convenient, it also leaves the physical
 * block number of the next block of the file in u.u_rablock
 * for use in read-ahead.
 */
daddr_t
s5bmap(ip, readflg)
register struct inode *ip;
{
	register struct s5inode *s5ip;
	register struct buf *bp;
	register sh;
	register daddr_t bn;
	register daddr_t nb;
	register sz;
	register rem;
	register i;
	int j;
	struct mount *mp;
	dev_t dev;
	int raflag;
	daddr_t *bap;
	int nshift;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	u.u_rablock = 0;
	u.u_next_rablock = 0;
	raflag = 0;

	mp = ip->i_mntdev;
	dev = ip->i_dev;
	u.u_pbdev = dev;
	bn = u.u_offset >> FsBSHIFT(BSIZE);
	if (bn < 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}
	if ((s5ip->s5i_lastr + 1) == bn)
		raflag = 1;
	u.u_pboff = u.u_offset & FsBMASK(BSIZE);
	sz = FsBSIZE(BSIZE) - u.u_pboff;
	if (u.u_count < sz) {
		sz = u.u_count;
		raflag = 0;
	} else
		s5ip->s5i_lastr = bn;
	u.u_pbsize = sz;
	if (readflg == 0) {
		if (u.u_offset >= (uint)(u.u_limit << (SCTRSHFT-1))) {
			u.u_error = EFBIG;
			return((daddr_t)-1);
		}
	} else {
		rem = ip->i_size - u.u_offset;
		if (rem < 0)
			rem = 0;
		if (rem < sz)
			sz = rem;
		if ((u.u_pbsize = sz) == 0)
			return((daddr_t)-1);
	}


	/*
	 * blocks 0..NADDR-4 are direct blocks
	 */
	if (bn < NADDR-3) {
		i = bn;
		nb = s5ip->s5i_addr[i];
		if (nb == 0) {
			if (readflg || (bp = s5alloc(mp))==NULL)
				return((daddr_t)-1);
			nb = FsPTOL(BSIZE, bp->b_blkno);
			if ((s5ip->s5i_mode&IFMT) == IFDIR)
				bwrite(bp);
			else
				bdwrite(bp);
			s5ip->s5i_addr[i] = nb;
			ip->i_flag |= IUPD|ICHG;
		}
		if ((i < NADDR-4) && raflag) {
			u.u_rablock = s5ip->s5i_addr[i+1];
			if ( i < NADDR-5 )
				u.u_next_rablock = s5ip->s5i_addr[i+2];
		}
		return(nb);
	}

	/*
	 * addresses NADDR-3, NADDR-2, and NADDR-1
	 * have single, double, triple indirect blocks.
	 * the first step is to determine
	 * how many levels of indirection.
	 */
	nshift = FsNSHIFT(BSIZE);
	sh = 0;
	nb = 1;
	bn -= NADDR-3;
	for (j = 3; j > 0; j--) {
		sh += nshift;
		nb <<= nshift;
		if (bn < nb)
			break;
		bn -= nb;
	}
	if (j == 0) {
		u.u_error = EFBIG;
		return((daddr_t)-1);
	}

	/*
	 * fetch the address from the inode
	 */
	nb = s5ip->s5i_addr[NADDR-j];
	if (nb == 0) {
		if (readflg || (bp = s5alloc(mp))==NULL)
			return((daddr_t)-1);
		nb = FsPTOL(BSIZE, bp->b_blkno);
		bwrite(bp);
		s5ip->s5i_addr[NADDR-j] = nb;
		ip->i_flag |= IUPD|ICHG;
	}

	/*
	 * fetch through the indirect blocks
	 */
	for (; j <= 3; j++) {
		bp = bread(dev, nb);
		if (u.u_error) {
			brelse(bp);
			return((daddr_t)-1);
		}
		bap = bp->b_un.b_daddr;
		sh -= nshift;
		i = (bn>>sh) & FsNMASK(BSIZE);
		nb = bap[i];
		/*
		 * calculate read-ahead.
		 */
		if ((j == 3) && (i < FsNINDIR(BSIZE)-1) && raflag) {
			u.u_rablock = bap[i+1];
			if ( i < FsNINDIR(BSIZE)-2 )
				u.u_next_rablock = bap[i+2];
		}
		if (nb == 0) {
			struct buf *nbp;

			if (readflg || (nbp = s5alloc(mp))==NULL) {
				brelse(bp);
				return((daddr_t)-1);
			}
			nb = FsPTOL(BSIZE, nbp->b_blkno);
			if (j < 3 || (s5ip->s5i_mode&IFMT) == IFDIR)
				bwrite(nbp);
			else
				bdwrite(nbp);
			bap[i] = nb;
			if (u.u_fmode&FSYNC)
				bwrite(bp);
			else
				bdwrite(bp);
		} else
			brelse(bp);
	}

	return(nb);
}



s5update(mp)
register struct mount *mp;
{
	register struct filsys *fp;
	struct inode iinode;
	struct s5inode s5in;
	register struct inode *ip;

	fp = getfs(mp);
/* FIX THIS, DS: combine these two locks? */
	spin_lock(&super_block_flock);
	spin_lock(&super_block_ilock);
	if (fp->s_fmod==0 || fp->s_ilock!=0 ||
	   fp->s_flock!=0 || fp->s_ronly!=0) {
		spin_unlock(&super_block_ilock);
		spin_unlock(&super_block_flock);
		return;
	}
	fp->s_flock = fp->s_ilock = 1;
	spin_unlock(&super_block_ilock);
	spin_unlock(&super_block_flock);

	fp->s_fmod = 0;
	fp->s_time = time;
	ip = &iinode;
	ip->i_ftype = IFBLK;
	ip->i_rdev = mp->m_dev;
	ip->i_fstyp = mp->m_fstyp;
	ip->i_fsptr = (int *)&s5in;
	ip->i_mntdev = mp;
	s5in.s5i_mode = IFBLK;
	u.u_error = 0;
	u.u_offset = SUPERBOFF;
	u.u_count = sizeof(struct filsys);
	u.u_base = (caddr_t)fp;
	u.u_segflg = 1;
	u.u_fmode = FWRITE|FSYNC;
	fio_write_blocked(ip);
	spin_lock(&super_block_flock);
	spin_lock(&super_block_ilock);
	fp->s_flock = fp->s_ilock = 0;
	mfs_wakeup(&fp->s_flock);
	mfs_wakeup(&fp->s_ilock);
	spin_unlock(&super_block_ilock);
	spin_unlock(&super_block_flock);
}

/*
 * Check mode permission on inode pointer.
 * Mode is READ, WRITE or EXEC, etc.
 * In the case of WRITE, the read-only status of the file
 * system is checked. Also in WRITE, prototype text
 * segments cannot be written.
 * The mode is shifted to select the owner/group/other fields.
 * The super user (or a user with appropriate privileges in a secure system)
 * is granted access permission.
 * Returns 0 for OK to access, 1 for failed access tests.
 */
s5access(ip, mode)
register struct inode *ip;
register mode;
{
	register struct s5inode *s5ip;
	int m = mode, retmode;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

 	/* check to see if pass label policy enforcement */
 	if ( !auth_label_chk( s5ip, mode )) {
 		sat_accf( ip, mode, ACCMAC );
		u.u_error = EACCES;
 		return 1;
	}

	switch (mode) {
	case ILABELR:	/* having passed the label check just return OK */
	case ILABELW:
		return 0;

	case ISUID:
 		if(auth_suid( s5ip, mode ))
 			return 0;
 		return 1;

	case ISGID:
 		if (auth_sgid( s5ip, mode ))
 			return 0;
 		return 1;

	case ISVTX:
		if ((s5ip->s5i_mode&mode))
			return(0);
		return(1);

	case IMNDLCK:
		if (((s5ip->s5i_mode&IFMT)==IFREG) && 
			(s5ip->s5i_mode & (ISGID|(IEXEC>>3))) == ISGID) 
			return(0);
		return(1);

	case IOBJEXEC:
		if ((s5ip->s5i_mode & IFMT) != IFREG ||
 		   (s5ip->s5i_mode & (IEXEC|(IEXEC>>3)|(IEXEC>>6))) == 0) 
			goto fail;

	case ICDEXEC:
		mode = IEXEC;
		goto exec;

	case IWRITE:
		if (rdonlyfs(ip->i_mntdev)) {
			u.u_error = EROFS;
			return(1);
		}
		if (ip->i_flag & ITEXT)
			xrele(ip);
		/*
		 * DO NOT MERGE THESE TWO IF'S.
		 */
		if (ip->i_flag & ITEXT) {
			u.u_error = ETXTBSY;
			return(1);
		}
	case IREAD:
	case IEXEC:
exec:
		/* check for DAC override privileges */
		if ( auth_dac_chk( mode ) ) {
			sat_accs( ip, mode, ACCPRIV );
			return 0;
		}
		if (u.u_uid == ip->i_uid) {
			retmode = s5ip->s5i_mode & mode;
			m = ACCOWNER;
		}
		else if (s5ip->s5i_acl_inode) {
			retmode = s5acl_search(ip,mode, UNAMED_ACL);
			m = ACCACL;
		}
			
		else if (s5ip->s5i_default_acl_inode) {
			retmode = s5acl_search(ip,mode, DEFAULT_ACL);
			m = ACCACL;
		}
		else {
			if ((u.u_gid == ip->i_gid) || 
			    ( IS_POSIX_ENV( u.u_procp )) && 
			    chk_supp_groups(ip->i_gid))
				mode >>= GROUP_SH;
			else
				mode >>= OWNER_SH;
			retmode = s5ip->s5i_mode & mode;
			m = ACCMODE;
		}
		if (retmode != 0) {
			sat_accs( ip, mode, m );
			return(0);
		}
		goto fail;

	}

fail:
 	sat_accf( ip, mode, m );
	u.u_error = EACCES;
	return(1);
}


/*
 * s5acl_tm_inrange checks if the current time is within the time window 
 *    in the supplied acl. Days are numbered 0 = Sun to 6 = Sat.
 *    Hours within the time window *include* the end hour, eg a time window
 *    of 1 to 2 is two hours long from 1:00 to 2:59.
 *
 *       hour
 *       0     23    0     23    0     23    0     23    0     23
 * day 0 ........    ..|--|..    ........    -|....|-    -|....|-
 *     1 ..|--|..    ........    ......|-    -|......    -|....|-
 *     2 ..|--|..    ..|--|..    -|....|-    ........    -|....|-
 *     3 ..|--|..    ..|--|..    -|....|-    ......|-    -|....|-
 *     4 ..|--|..    ..|--|..    -|....|-    -|....|-    -|....|-
 *     5 ..|--|..    ..|--|..    -|....|-    -|....|-    -|....|-
 *     6 ........    ..|--|..    -|......    -|....|-    -|....|-
 *
 * sday      1           2           1           3           0
 * eday      5           0           6           1           0
 * shour     6           6          18          18          18
 * ehour    18          18           6           6           6
 *
 *       case A      case B      case C      case D      case E
 */
s5acl_tm_inrange(aclp) 
acl_t *aclp;
{
	uint 	day,hour;

			/*add 4 since 1/1/70 was thur*/
	day = (((time / (24 * 60 * 60)) + 4) % 7);
	hour = ((time % (24 * 60 * 60)) / 3600);

	/* Check if the DAY is within the window?? */
	if ( !(day >= aclp->day_start && day <= aclp->day_end         /*A,C,E*/
	      ||
	      aclp->day_start > aclp->day_end &&                      /*B,D*/
              (day >= aclp->day_start || day <= aclp->day_end)
	      ||
	      aclp->day_start == aclp->day_end &&                     /*E*/
	      aclp->hour_start > aclp->hour_end) )
		return 0;

	/* Check for a simple case with the hours*/
	if ( hour >= aclp->hour_start && hour <= aclp->hour_end )     /*A,B*/
		return 1;	

	/* check for wrap_around cases */
	else if ( aclp->hour_start > aclp->hour_end &&                /*C,D,E*/
	          (
	            hour >= aclp->hour_start &&
	            (
	              aclp->day_start < aclp->day_end &&              /*C*/
	              day >= aclp->day_start && day < aclp->day_end
	              ||
	              aclp->day_start > aclp->day_end &&              /*D*/
	              (day >= aclp->day_start || day < aclp->day_end)
	              ||
	              aclp->day_start == aclp->day_end                /*E*/
	            )
	            ||
	            hour <= aclp->hour_end && 
	            (
	              aclp->day_start < aclp->day_end &&              /*C*/
	              day > aclp->day_start && day <= aclp->day_end
	              ||
	              aclp->day_start > aclp->day_end &&              /*D*/
	              (day > aclp->day_start || day <= aclp->day_end)
	              ||
	              aclp->day_start == aclp->day_end                /*E*/
	            )
	          )
	        ) 
		return 1; 
	else 
		return 0;
}


s5acl_search(ip,mode,a_type)
register struct inode *ip;
register mode;
int a_type;
{
	register struct buf *bp;
	register struct s5inode *s5ip;
	register struct inode *aip;
	register struct s5inode *s5aip;
	register acl_t *aclp, *acls;

	ushort	acl_mode, 
		usr_mode = 0, 
		grp_mode = 0;
	uint	acl_bn, 
		log_bn;
	uint	user=0, 
		group=0, 
		end_found = 0,
		date_nok = 1, 
		time_nok = 1;

	s5ip = (struct s5inode *)ip->i_fsptr;
	aip = s5get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	s5aip = (struct s5inode *)aip->i_fsptr;

	for (log_bn = 0; log_bn < MAX_ACL_BLK; log_bn++){
		if(!(acl_bn = s5aip->s5i_addr[log_bn])) 
			break;

		bp = bread(ip->i_dev,acl_bn);
		if (u.u_error) {
			brelse(bp);
			break;
		}

		aclp = (acl_t *)(bp->b_un.b_addr);	
		acls = aclp;

		while ((aclp - acls) + sizeof(acl_t) < BSIZE && !end_found){
			switch(aclp->type) {
			case A_DATE:
				if (date_nok)
					if ((aclp->date_start < time) && 
				    	    ((aclp->date_end + (60*60*24)) > time)) 
						date_nok = 0; /*access ok*/
					else
						date_nok = 2;
				break;
			case A_TIME:
				if (time_nok)
					if (s5acl_tm_inrange(aclp))
						time_nok = 0; /*good*/
					else
						time_nok = 2;
				break;
			case A_USER:
				if (u.u_uid == aclp->id){
					user = 1;
					if (s5acl_tm_inrange(aclp))
						usr_mode |= aclp->mode;
				}
				break;
			case A_GROUP:
				if ((u.u_gid == aclp->id) || 
				   ((IS_POSIX_ENV(u.u_procp)) &&
				   chk_supp_groups(aclp->id))) {
					group = 1;
					if (s5acl_tm_inrange(aclp))
						grp_mode |= aclp->mode;
				}
				break;
			case NULL:
				end_found = 1;
				break;
			default:
				u.u_error = EACCES;
				end_found = 1;
				break; 
			}
			aclp++;
		}	

		brelse(bp);
		if (end_found)
			break;
	}

	if (a_type != NAMED_ACL)
		iput(aip);

	if (u.u_error)
		return 0;

	/* If there are changes to be made in the priority of the diffrent
	   types of ACLs, or in how they interact with the normal group and 
	   other mode bits, the changes should be made here */

	if (date_nok > 1 || time_nok > 1)
		acl_mode = (s5ip->s5i_mode & MODE_MASK);	
	else if(user)
		acl_mode= usr_mode & ((s5ip->s5i_mode >> GROUP_SH) & MODE_MASK);
	else if(group)
		acl_mode= grp_mode & ((s5ip->s5i_mode >> GROUP_SH) & MODE_MASK);
	else if ((u.u_gid == ip->i_gid) || (IS_POSIX_ENV(u.u_procp) &&
	      chk_supp_groups(ip->i_gid)))
		acl_mode = ((s5ip->s5i_mode >> GROUP_SH) & MODE_MASK);
	else
		acl_mode = s5ip->s5i_mode & MODE_MASK;

	return (acl_mode & (mode >> OWNER_SH));
}



/*
 * s5openi called to allow handler of special files to initialize and
 * validate before actual IO.
 */
s5openi(ip, flag)
register struct inode *ip;
{
	register unsigned int maj;
	register dev_t	dev;

	dev = notminored(ip->i_rdev);
	switch (ip->i_ftype) {

	case IFCHR:
		maj = major(dev);
		if (maj >= cdevcnt)
			goto bad;
		if (u.u_ttyp == NULL)
			u.u_ttyd = denotminored(dev);
		if (cdevsw[maj].d_str)
			stropen(ip, flag);
		else
			(*cdevsw[maj].d_open)(minor(dev), flag, OTYP_CHR);
		break;

	case IFBLK:
		maj = bmajor(dev);
		if (maj >= bdevcnt)
			goto bad;
		(*bdevsw[maj].d_open)(minor(dev), flag, OTYP_BLK);
		break;

	case IFIFO:
		upkern_lock();
		s5openf(ip, flag);
		upkern_unlock();
	}
	return;

bad:
	u.u_error = ENXIO;
}

/* ARGSUSED */
s5closei(ip, flag, count, offset)
register struct inode *ip;
int flag, count;
off_t offset;
{
	register struct inode *tip;
	register struct mount *mp;
	register struct file *fp;
	register int (*cfunc)();
	register int fmt;
	register dev_t	dev, ndev;
	int otyp;

	u.u_saved_ip = NULL;	/* bmap cache info */
	unlock(ip);
	cleanlocks(ip,USE_PID);
	if (ip->i_sptr && ip->i_ftype != IFDIR)
		strclean(ip, count);
	if ((unsigned)count > 1)
		return;

	fmt = ip->i_ftype;
	dev = ip->i_rdev;
	ndev = notminored(dev);

	switch (fmt) {

	case IFCHR:
		cfunc = cdevsw[major(ndev)].d_close;
		otyp = OTYP_CHR;
		break;

	case IFBLK:
		cfunc = bdevsw[bmajor(ndev)].d_close;
		otyp = OTYP_BLK;
		break;

	case IFIFO:
		s5closef(ip, flag);

	default:
		return;
	}

	/*
	 * Don't call device close routine if there is any other open 
	 * device inode referring to the same device.
	 */
	if (ip->i_count > 1) 
		return;

	upkern_lock();

	for (fp = file; fp < (struct file *)v.ve_file; fp++) {
		if (fp->f_count) {
			tip = fp->f_inode;
			if ((tip->i_rdev == dev) &&
			    (tip->i_ftype == fmt) &&
			    (tip != ip)) {
				upkern_unlock();
				return;
			}
		}
	}
	if (setjmp(u.u_qsav)) {	/* catch half-closes */
		upkern_unlock();
		plock(ip);
		return;
	}
	if (fmt == IFBLK) {
		for (mp = mount; mp < (struct mount *)v.ve_mount; mp++)
			if ((mp->m_flags & MINUSE) && mp->m_dev == dev) {
				(*cfunc)(minor(ndev), flag, otyp);
				upkern_unlock();
				return;
			}
		bflush(dev);
		(*cfunc)(minor(ndev), flag, otyp);
		binval(dev);
	} else {
		prele(ip);
		if (cdevsw[major(ndev)].d_str)
			strclose(ip, flag);
		else
			(*cfunc)(minor(ndev), flag, otyp);
		plock(ip);
	}
	upkern_unlock();
}

s5fsync(ip)
register struct inode *ip;
{
	register int log_bn;
	register int phys_bn;
	register int size;
	register dev_t dev;
	register struct buf *bp;

	size = ip->i_size;
	dev = ip->i_dev;
	log_bn = 0;
	while (size > 0) {
		phys_bn = fio_map_logical_physical(ip, log_bn, 0);
		bp = getblk(dev, phys_bn);
		if (bp->b_flags & B_DELWRI) {
			if (bp->b_flags & B_BUSY) {
				bp->b_want_flag |= B_WANTED;
				mfs_sleep(bp, PRIBIO+1, &bio_lock);
			}
			bwrite(bp);
		}
		else
			brelse(bp);
		size -= BSIZE;
		log_bn++;
	}
	ip->i_flag |= IUPD|IACC;
}

int blks_to_free;

s5ftruncate(ip, length)
register struct inode *ip;
register int length;
{
	register uint blk_size;
	register int i;
	register struct s5inode *s5ip;
	register struct mount *mp;
	register int retval=0;
	uint last_blk, last_blk1;
	daddr_t bn;

	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);

	if ((s5ip->s5i_mode & IFMT) != IFREG) {
		u.u_error = EINVAL;
		return;
	}

	/* compute total blocks to free */
	blk_size = FsBSIZE(mp->m_bsize);
	last_blk = (length + (blk_size-1))/blk_size;
	last_blk1 = ((ip->i_size) + (blk_size-1))/blk_size;
	blks_to_free = last_blk1 - last_blk;

	/* update the size of the file */
	ip->i_size = length;
	ip->i_flag |= IUPD|IACC|ICHG;

	mp = ip->i_mntdev;
	for (i=NADDR-1; (i>=0) & blks_to_free; i--) {
		bn = s5ip->s5i_addr[i];
		if (bn == (daddr_t)0)
			continue;

		switch(i) {
		case NADDR-1:
			retval = s5bfree(mp,bn,1,1);
			break;
		case NADDR-2:
			retval = s5bfree(mp,bn,1,0);
			break;
		case NADDR-3:
			retval = s5bfree(mp,bn,0,0);
			break;
		default:
			s5free(mp, bn);
			blks_to_free--;
			retval = -1;
			break;
		}
		if (u.u_error)
			return;
		if (retval == -1)
			s5ip->s5i_addr[i] = (daddr_t)0;
	}
}

s5bfree(mp,bn,d_indir,t_indir)
register struct mount *mp;
register daddr_t bn;
register uint d_indir,t_indir;
{
	register struct buf *bp;
	register daddr_t *bap;
	register daddr_t nb;
	register int i;
	dev_t dev;

	dev = mp->m_dev;
	bp=NULL;
	for (i=FsNINDIR(mp->m_bsize)-1; (i>=0); i--) {
		if (bp == NULL) {
			bp = bread(dev,bn);
			if (bp->b_flags & B_ERROR) {
				brelse(bp);
				return;
			}
			bap = bp->b_un.b_daddr;
		}
		nb = bap[i];
		if (nb == (daddr_t)0)
			continue;
		if (d_indir)
			s5bfree(mp,nb,t_indir,0);
		else {
			s5free(mp,nb);	
			bap[i] = 0;
			blks_to_free--;
		}
		if (blks_to_free == 0)
			break;
	}
	if (bp != NULL)
		bdwrite(bp);
	return(i);
}
