/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s5alloc.c: version 25.1 created on 11/27/91 at 14:55:44	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s5alloc.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#ident	"@(#)uts/fs/s5:s5alloc.c	25.1"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/fstyp.h"
#include "sys/fs/s5macros.h"
#include "sys/systm.h"
#include "sys/mount.h"
#include "sys/inode.h"
#include "sys/file.h"
#include "sys/ino.h"
#include "sys/user.h"
#include "sys/buf.h"
#include "sys/fs/s5filsys.h"
#include "sys/fs/s5fblk.h"
#include "sys/fs/s5inode.h"
#include "sys/errno.h"
#include "sys/var.h"
#include "sys/cmn_err.h"
#include "sys/debug.h"
#include "sys/synch.h"
#include "sys/mfs.h"

typedef	struct fblk *FBLKP;

/*
 * alloc will obtain the next available free disk block from the free list
 * of the specified device.
 * The super block has up to NICFREE remembered free blocks;
 * the last of these is read to obtain NICFREE more . . .
 *
 * no space on dev x/y -- when the free list is exhausted.
 */
struct buf *
s5alloc(mp)
register struct mount	*mp;
{
	register struct filsys	*fp;
	register struct buf	*bp;
	register dev_t		dev;
	register daddr_t	bno;

	dev = mp->m_dev;
	fp = getfs(mp);

	spin_lock(&super_block_flock);
	while (fp->s_flock)
		mfs_sleep((caddr_t)&fp->s_flock, PINOD, &super_block_flock);

	do {
		if (fp->s_nfree <= 0)
			goto nospace;
		if ((bno = fp->s_free[--fp->s_nfree]) == 0)
			goto nospace;
		/* this replaces s5badblock() */
		if (bno < fp->s_isize || bno >= fp->s_fsize) {
			spin_unlock(&super_block_flock);
			prdev("bad block", dev);
			spin_lock(&super_block_flock);
			bno = 0;
		}
	} while (bno == 0);

	if (fp->s_nfree <= 0) {
		fp->s_flock++;
		spin_unlock(&super_block_flock);
		bp = bread(dev, bno);
		if (u.u_error == 0) {
			fp->s_nfree = ((FBLKP)(bp->b_un.b_addr))->df_nfree;
			bcopy((caddr_t)((FBLKP)(bp->b_un.b_addr))->df_free,
			    (caddr_t)fp->s_free, sizeof(fp->s_free));
		}
		brelse(bp);
		spin_lock(&super_block_flock);
		fp->s_flock = 0;
		mfs_wakeup(&fp->s_flock);
	}
	if (fp->s_nfree <= 0 || fp->s_nfree > NICFREE) {
		spin_unlock(&super_block_flock);
		prdev("Bad free count", dev);
		spin_lock(&super_block_flock);
		goto nospace;
	}
	if (fp->s_tfree)
		fp->s_tfree--;
	fp->s_fmod = 1;
	spin_unlock(&super_block_flock);
	bp = getblk(dev, bno);
	clrbuf(bp);
	return(bp);

nospace:
	fp->s_nfree = 0;
	fp->s_tfree = 0;
	spin_unlock(&super_block_flock);
	delay(5*HZ);
	prdev("no space", dev);
	u.u_error = ENOSPC;
	return(NULL);
}

/*
 * place the specified disk block back on the free list of the
 * specified device.
 */
s5free(mp, bno)
register struct mount	*mp;
register daddr_t bno;
{
	register struct filsys *fp;
	register struct buf *bp;

	fp = getfs(mp);
	spin_lock(&super_block_flock);
	while (fp->s_flock)
		mfs_sleep(&fp->s_flock, PINOD, &super_block_flock);

	/*
	 * Check that a block number is in the range between the I list
	 * and the size of the device.
	 * This is used mainly to check that a
	 * garbage file system has not been mounted.
	 *
	 * bad block on dev x/y -- not in range
	 */
	if (bno < fp->s_isize || bno >= fp->s_fsize) {
		spin_unlock(&super_block_flock);
		prdev("bad block", mp->m_dev);
		return;
	}

	if (fp->s_nfree <= 0) {
		fp->s_nfree = 1;
		fp->s_free[0] = 0;
	}
	if (fp->s_nfree >= NICFREE) {
		fp->s_flock++;
		spin_unlock(&super_block_flock);
		bp = getblk(mp->m_dev, bno);
		((FBLKP)(bp->b_un.b_addr))->df_nfree = fp->s_nfree;
		bcopy((caddr_t)fp->s_free,
			(caddr_t)((FBLKP)(bp->b_un.b_addr))->df_free,
			sizeof(fp->s_free));
		fp->s_nfree = 0;
		bwrite(bp);
		spin_lock(&super_block_flock);
		fp->s_flock = 0;
		mfs_wakeup(&fp->s_flock);
	}
	fp->s_free[fp->s_nfree++] = bno;
	fp->s_tfree++;
	fp->s_fmod = 1;
	spin_unlock(&super_block_flock);
}

/*
 * Allocate an unused I node on the specified device.  Used with
 * file creation.  The algorithm keeps up to NICINOD spare I nodes
 * in the super block. When this runs out, a linear search through the
 * I list is instituted to pick up NICINOD more.
 */
struct inode *
s5ialloc(mp, mode, nlink, rdev)
struct mount	*mp;
ushort mode;
dev_t rdev;
{
	register struct filsys	*fp;
	register struct inode	*ip;
	register struct s5inode	*s5ip;
	register struct buf	*bp;
	register		i;
	struct dinode		*dp;
	ino_t			ino;
	daddr_t			adr;
	dev_t			dev;
	char *tino;

	dev = mp->m_dev;
	fp = getfs(mp);
loop:
	spin_lock(&super_block_ilock);
	while (fp->s_ilock)
		mfs_sleep((caddr_t)&fp->s_ilock, PINOD, &super_block_ilock);
	fp->s_ilock = 1;
	spin_unlock(&super_block_ilock);
	
loop1:
	if (fp->s_ninode > 0 && (ino = fp->s_inode[--fp->s_ninode])) {
		if ((ip = iget(mp, ino)) == NULL) {
			spin_lock(&super_block_ilock);
			fp->s_ilock = 0;
			mfs_wakeup(&fp->s_ilock);
			spin_unlock(&super_block_ilock);
			return(NULL);
		}
		s5ip = (struct s5inode *)ip->i_fsptr;
		if (s5ip->s5i_mode == 0) {
			/* found inode: update now to avoid races */
			s5ip->s5i_mode = mode;
			ip->i_ftype = mode&IFMT;
			ip->i_flag |= IACC|IUPD|ICHG|isyn;
			ip->i_nlink = nlink;
			ip->i_uid = u.u_uid;
			ip->i_gid = u.u_gid;
			ip->i_size = 0;
			for (i = 0; i < NADDR; i++)
				s5ip->s5i_addr[i] = 0;

			ip->i_priv = 0;   /* clear the priv */

			auth_s5ialloc( s5ip );

			/*
			 * Must check for rdev after address fields
			 * are zeroed because rdev is defined to be
			 * the first address field (s5inode.h).
			 */
			switch (s5ip->s5i_mode & IFMT) {
			case IFCHR:
			case IFBLK:
				if (rdev == NODEV )
					cmn_err(CE_WARN, "-1 rdev in ialloc\n");
				ip->i_rdev = rdev;
				s5ip->s5i_rdev = rdev;
			}
			/* adjust total free inode count */
			if (fp->s_tinode) 
				fp->s_tinode--;
			fp->s_fmod = 1;
			s5iupdat(ip, &time, &time);
			spin_lock(&super_block_ilock);
			fp->s_ilock = 0;
			mfs_wakeup(&fp->s_ilock);
			spin_unlock(&super_block_ilock);
			return(ip);
		}
		/*
		 * Inode was allocated after all.
		 * Look some more.
		 */
		cmn_err(CE_NOTE, "s5ialloc: inode was already allocated\n");
		s5iupdat(ip, &time, &time);
		spin_lock(&super_block_ilock);
		fp->s_ilock = 0;
		mfs_wakeup(&fp->s_ilock);
		spin_unlock(&super_block_ilock);
		iput(ip);
		goto loop;
	}

	/* only try to rebuild freelist if there are free inodes */
	if (fp->s_tinode > 0) {
		fp->s_ninode = NICINOD;
		ino = FsSECINOS(mp->m_isize, fp->s_inode[0]);
		for(adr=FsSECITOD(mp->m_isize, ino); adr < fp->s_isize; adr++) {
			bp = bread(dev, adr);
			if (u.u_error) {
				brelse(bp);
				ino += FsSECINOPB(mp->m_isize);
				continue;
			}
			tino = (char *)bp->b_un.b_addr;

			for (i = 0,dp=(struct dinode *)tino; i < FsSECINOPB(mp->m_isize); i++,ino++) {
				if (fp->s_ninode <= 0)
					break;
				if (dp->di_mode == 0)
					fp->s_inode[--fp->s_ninode] = ino;
				tino += mp->m_isize;
				dp = (struct dinode *)tino;
			}
			brelse(bp);
			if (fp->s_ninode <= 0)
				break;
		}
		if (fp->s_ninode > 0) {
			fp->s_inode[fp->s_ninode-1] = 0;
			fp->s_inode[0] = 0;
		}
		if (fp->s_ninode != NICINOD) {
			fp->s_ninode = NICINOD;
			goto loop1;
		}
	}

	fp->s_ninode = 0;
	fp->s_tinode = 0;
	spin_lock(&super_block_ilock);
	fp->s_ilock = 0;
	mfs_wakeup((caddr_t)&fp->s_ilock);
	spin_unlock(&super_block_ilock);
	prdev("Out of inodes", dev);
	u.u_error = ENOSPC;
	return(NULL);
}

/*
 * Free the specified I node on the specified device.
 * The algorithm stores up to NICINOD I nodes in the super
 * block and throws away any more.
 */
s5ifree(ip)
register struct inode	*ip;
{
	register struct filsys	*fp;
	register struct s5inode	*s5ip;
	register ushort		ino;

	/* don't put an already free inode on the free list */
	s5ip = (struct s5inode *)ip->i_fsptr;
	ASSERT(s5ip != NULL);
	if (s5ip->s5i_mode == 0)
		return;

	ino = ip->i_number;
	fp = getfs(ip->i_mntdev);
	spin_lock(&super_block_ilock);
	while (fp->s_ilock)
		mfs_sleep((caddr_t)&fp->s_ilock, PINOD, &super_block_ilock);
	fp->s_ilock = 1;
	spin_unlock(&super_block_ilock);
	s5ip->s5i_mode = 0; /* zero means inode not allocated (freeing inode) */
	/*
	 * Update disk inode from incore slot before putting it on
	 * the freelist; this eliminates a race in the simplex code
	 * which did an ifree() and then an iupdat() in iput().
	 */
	s5iupdat(ip, &time, &time);
	fp->s_tinode++;
	fp->s_fmod = 1;
	if (fp->s_ninode >= NICINOD) {
		if (ino < fp->s_inode[0])
			fp->s_inode[0] = ino;
	}
	else
		fp->s_inode[fp->s_ninode++] = ino;

	spin_lock(&super_block_ilock);
	fp->s_ilock--;
	wakeup((caddr_t)&fp->s_ilock);
	spin_unlock(&super_block_ilock);
}
