/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) s5acl.c: version 25.1 created on 11/27/91 at 14:55:39	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)s5acl.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
#include "sys/types.h"
#include "sys/fstyp.h"
#include "sys/fs/s5macros.h"
#include "sys/systm.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/nami.h"
#include "sys/proc.h"
#include "sys/user.h"
#include "sys/errno.h"
#include "sys/buf.h"
#include "sys/debug.h"
#include "sys/acl.h"
#include "sys/stat.h"

extern struct buf *s5alloc();
extern inode_t *s5ialloc();
inode_t *s5get_acl_ip();


s5setacl(ip, buf, size, a_type)
register struct inode *ip;
char *buf;
int size, a_type;
{
	register struct inode *aip;
	register struct s5inode *s5ip;
	register struct s5inode *s5aip;
	register char *aclp;
	register struct buf *bp;
	uint	copysz;
	uint	logbn = 0;
	uint	not_done =1;
	uint	nb;
	ino_t   inum;

	if ((size < 0) || (size > MAX_ACL_SIZE)) {
		u.u_error = EINVAL;
		return;
	}

	aip = s5get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (size == 0) {
		if (!aip) {
			u.u_error = EINVAL;
			return;
		}
		s5remove_acl(ip, aip, a_type);
		return;
	}

	if (aip && (aip->i_nlink > 1)) {
		s5remove_acl(ip, aip, a_type);
		aip = NULL;
	}
	if (aip == NULL) {
		if ((aip = s5ialloc(ip->i_mntdev,IFACL,1,-1)) == NULL) {
			u.u_error = EINVAL;
			return;
		}
	}

	s5ip = (struct s5inode *)(ip->i_fsptr);
	s5aip = (struct s5inode *)(aip->i_fsptr);
	ASSERT(s5aip != NULL);
	aip->i_size = 0;
	while (not_done && size) {
		if ((s5aip->s5i_addr[logbn]) == NULL) {
			if ((bp = s5alloc(ip->i_mntdev)) == NULL){
				not_done = 0;
				continue;
			}
		}
		else 
			bp = getblk(ip->i_dev,s5aip->s5i_addr[logbn]);

		nb = FsPTOL(BSIZE, bp->b_blkno);
		aclp = (char *)(bp->b_un.b_addr);	
		bzero(aclp, BSIZE);

		copysz = (size < BSIZE) ? size : 
                           (sizeof (acl_t) * (BSIZE / sizeof (acl_t)));
		if (copyin(buf, aclp, copysz)) {
			u.u_error = EIO;
			not_done = 0;
			continue;
		}
		buf += copysz;
		size -= copysz;

		bp->b_dev = ip->i_dev;
		bwrite(bp);
		if (u.u_error) {
			not_done = 0;
			continue;
		}
		s5aip->s5i_addr[logbn++] = nb;
		aip->i_size += copysz;
	}

	if (u.u_error) {
		if (a_type != NAMED_ACL)
			iput(aip);
		return;
	}

	for( ; logbn < MAX_ACL_BLK; logbn++) { 
		if (s5aip->s5i_addr[logbn]) {
			s5free(ip->i_mntdev, s5aip->s5i_addr[logbn]);
			s5aip->s5i_addr[logbn] = 0;
		}
	}


	sat_acl(ip, aip);


	switch (a_type) {
	case UNAMED_ACL:
		s5ip->s5i_acl_inode = aip->i_number;
		break;
	case DEFAULT_ACL:
		s5ip->s5i_default_acl_inode = aip->i_number;
		break;
	}
	s5aip->s5i_acl_inode_type = a_type;

	ip->i_flag |= IUPD|ICHG;
	if (a_type != NAMED_ACL) {
		aip->i_flag |= IUPD|ICHG;
		iput(aip);
	}
}

s5getacl(ip, buf, size, a_type)
register struct inode *ip;
register char *buf;
int size, a_type;
{
	register struct inode *aip;
	register struct s5inode *s5aip;
	struct buf *bp;
	char	*aclp;
	uint	acl_bn;
	uint	log_bn=0;
	uint	copysz;
	ino_t	inum;
	
	if (size == 0) {
		u.u_error = EINVAL;
		return;
	}

	aip = s5get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (aip == NULL) {
		u.u_error = EINVAL;
		return;
	}
		
	if (size > aip->i_size)
		size = aip->i_size;

	s5aip = (struct s5inode *)aip->i_fsptr;

	/* read acls into buf */

	while ((log_bn < MAX_ACL_BLK) && size) {
		if(!(acl_bn = s5aip->s5i_addr[log_bn++])) {
			u.u_error = EINVAL;
			break;
		}
		bp = bread(ip->i_dev,acl_bn);
		if (u.u_error) {
			brelse(bp);
			break;	
		}

		aclp = (char *)(bp->b_un.b_addr);	
		if(size < BSIZE)
			copysz = size;
		else
			copysz = BSIZE;

		if (copyout(aclp, buf, copysz) < 0) {
			u.u_error = EFAULT;
			break;
		}
		size -= copysz;
		buf += copysz;
		brelse(bp);
	}
	ip->i_flag |= IACC;
	if (a_type != NAMED_ACL) {
		aip->i_flag |= IACC;
		iput(aip);
	}
}

s5aclstat(ip, buf, a_type)
register struct inode *ip;
struct stat *buf;
uint	a_type;
{
	register struct s5inode *s5aip;
	register struct inode *aip;
	register ushort acl_mode;
	struct stat ds;
	ino_t inum;

	aip = s5get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (aip == NULL) {
		u.u_error = EINVAL;
		return;
	}
		
	s5aip = (struct s5inode *)aip->i_fsptr;
		
	if (aip->i_flag & (IACC|IUPD|ICHG))
		FS_IUPDAT(aip, &time, &time);
	/*
	 * first copy from inode table
	 */

	ds.st_ino = (ushort)aip->i_number;
	ds.st_nlink = aip->i_nlink;
	ds.st_size = aip->i_size;

	if (a_type != NAMED_ACL)
		iput(aip);

	/*
	 * Call fs dependent portion to 
	 * read the disk inode to obtain
	 * file modes and dates
	 */

	FS_STATF(ip, &ds);

	/* if not the owner, then modify the modes based on the acl */
	if (u.u_uid != ip->i_uid) {
		acl_mode = s5acl_search(ip, IREAD|IWRITE|IEXEC, a_type);
		if ((u.u_gid == ip->i_gid) || 
		   ((IS_POSIX_ENV(u.u_procp)) && chk_supp_groups(ip->i_gid))) 
    			ds.st_mode = 
			   (ds.st_mode & 0707) | (acl_mode << GROUP_SH);
		else
			ds.st_mode =
			   (ds.st_mode & 0770) | acl_mode;
	}

	if (copyout((caddr_t)&ds, (caddr_t)buf, sizeof(ds)) < 0)
		u.u_error = EFAULT;
}

s5aclunlink(ip, a_type)
register struct inode *ip;
int a_type;
{
	register struct inode *aip;
	register struct s5inode *s5ip;
	register struct s5inode *s5aip;
	register ino_t inum;
	register logbn;

	aip = s5get_acl_ip(ip, a_type);
	if (u.u_error)
		return;

	if (aip == NULL) {
		u.u_error = EINVAL;
		return;
	}

	s5remove_acl(ip, aip, a_type);
}

s5acllink(ip, ip1, a_type)
register struct inode *ip;
register struct inode *ip1;
int a_type;
{
	register struct s5inode *s5ip;
	register struct s5inode *s5ip1;
	register ino_t inum;
	register ino_t inum1;
	register struct inode *aip;

	/*links accross file systems are a no-no*/
	if (ip->i_dev != ip1->i_dev){
		u.u_error = EXDEV;
		return;
	}
			
	s5ip = (struct s5inode *)ip->i_fsptr;
	s5ip1 = (struct s5inode *)ip1->i_fsptr;

	if (a_type == DEFAULT_ACL) {
		if (ip1->i_ftype != IFDIR) {
			u.u_error = ENOTDIR;
			return;
		}
		inum1 = s5ip1->s5i_default_acl_inode;
		if (s5ip->s5i_acl_inode_type == NAMED_ACL) {
			inum = ip->i_number;
		}
		else {
			if (ip->i_ftype != IFDIR) {
				u.u_error = ENOTDIR;
				return;
			}
			inum = s5ip->s5i_default_acl_inode;
		}
	}
	else {
		if (s5ip->s5i_acl_inode_type == NAMED_ACL)
			inum = ip->i_number;
		else
			inum = s5ip->s5i_acl_inode;
		inum1 = s5ip1->s5i_acl_inode;
	}

	if (!inum) {
		u.u_error = EINVAL;
		return;
	}

	if (s5ip->s5i_acl_inode_type == NAMED_ACL)
		aip = s5get_acl_ip(ip, NAMED_ACL);
	else
		aip = s5get_acl_ip(ip, a_type);


	if (u.u_error)
		return;

	if (aip->i_nlink >= MAXLINK) {
		if (aip != ip)
			iput(aip);
		u.u_error = EMLINK;
		return;
	}
	
	if (inum1) {
		if (inum == inum1) {
			if (aip != ip)
				iput(aip);
			u.u_error = EEXIST;
			return;
		}
		s5aclunlink(ip1, (a_type == NAMED_ACL) ? UNAMED_ACL : a_type );
		if (u.u_error) {
			if (aip != ip)
				iput(aip);
			return;
		}
	}
	aip->i_nlink++;

	if (a_type == DEFAULT_ACL)
		s5ip1->s5i_default_acl_inode = inum;
	else
		s5ip1->s5i_acl_inode = inum;
	
	ip1->i_flag |= IUPD|ICHG;
	aip->i_flag |= IUPD|ICHG;
	
	/* no iput if named acl */
	if (aip != ip)
		iput(aip);
}

s5get_acl_inode(ip, a_type)
register struct inode *ip;
int a_type;
{
	struct s5inode *s5ip;
	ino_t inum;

	s5ip = (struct s5inode *)ip->i_fsptr;
	switch(a_type) {
	case UNAMED_ACL:
		inum = s5ip->s5i_acl_inode;
		break;
	case NAMED_ACL:
		inum = ip->i_number;
		break;
	case DEFAULT_ACL:
		inum = s5ip->s5i_default_acl_inode;
		break;
	default:
		inum = -1;
		break;
	}
	return(inum);
}

inode_t *
s5get_acl_ip(ip, a_type)
register struct inode *ip;
int a_type;
{
	register ino_t inum;
	register struct inode *aip;

	if (a_type == NAMED_ACL)
		aip = ip;
	else {
		inum = s5get_acl_inode(ip, a_type);
		if (inum == NULL)
			aip = NULL;
		else if ((aip = iget(ip->i_mntdev, inum)) == NULL) {
			u.u_error = EINVAL;
			return;
		}
	}
	return(aip);
}

s5remove_acl(ip, aip, a_type)
register struct inode *ip;
register struct inode *aip;
register int a_type;
{
	register struct s5inode* s5ip;

	ASSERT(aip);

	aip->i_nlink--;
	aip->i_flag |= IUPD|ICHG;
	if (aip != ip)
		iput(aip);

	s5ip = (struct s5inode *)ip->i_fsptr;
	if (a_type == DEFAULT_ACL)
		s5ip->s5i_default_acl_inode = 0;
	else
		s5ip->s5i_acl_inode = 0;
	
	ip->i_flag |= IUPD|ICHG;
}	
