/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) durdwri.c: version 25.1 created on 11/27/91 at 14:55:24	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)durdwri.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/
/*	Copyright (c) 1984 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF AT&T	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)uts/fs/du:durdwri.c	23.1"
#include "sys/types.h"
#include "sys/sysmacros.h"
#include "sys/param.h"
#include "sys/fstyp.h"
#include "sys/fs/s5param.h"
#include "sys/fs/s5inode.h"
#include "sys/inode.h"
#include "sys/mount.h"
#include "sys/fs/s5dir.h"
#include "sys/signal.h"
#include "sys/errno.h"
#include "sys/immu.h"
#include "sys/user.h"
#include "sys/buf.h"
#include "sys/conf.h"
#include "sys/file.h"
#include "sys/systm.h"
#include "sys/debug.h"
#include "sys/rdebug.h"
#include "sys/message.h"
#include "sys/sysinfo.h"
#include "sys/sema.h"
#include "sys/comm.h"


dureadi(ip)
register struct inode *ip;
{
	register sndd_t sd;
	int savescall;
	int unlocked = 0;

	DUPRINT3 (DB_FSS,"dureadi: ip = %x   sndd = %x \n",ip,ip->i_fsptr);
	savescall = u.u_syscall;
	if (u.u_syscall != DUREAD) 
		u.u_syscall = DUREADI;
	sd = (sndd_t)(ip->i_fsptr);
	switch (ip->i_ftype) {
		case IFIFO:
			prele(ip);
			unlocked = 1;
			break;
		case IFREG:
			if (sd->sd_stat & SDMNDLCK) {
				prele(ip);
				unlocked = 1;
			}
	}
	remfileop (ip,NULL,NULL);
	u.u_syscall = savescall;
	if (unlocked == 1)
		plock(ip);
}

duwritei(ip)
register struct inode *ip;
{
	register sndd_t sd;
	register int savescall;
	int unlocked = 0;
	savescall = u.u_syscall;


	DUPRINT3 (DB_FSS,"duwritei: ip = %x   sndd = %x \n",ip,ip->i_fsptr);
	sd = (sndd_t)(ip->i_fsptr);
	switch (ip->i_ftype) { 
		case IFIFO:
			/* ASSERT(ip->i_flag & ILOCK);	*/
			ASSERT(inode_locked(ip));
			prele(ip);
			unlocked = 1;
			break;
		case IFREG:
			/* ASSERT(ip->i_flag & ILOCK);	*/
			ASSERT(inode_locked(ip));
			if (sd->sd_stat & SDMNDLCK) {
				prele(ip);
				unlocked = 1;
			}
	}

	if (u.u_syscall != DUWRITE) 
		u.u_syscall = DUWRITEI;
	remfileop (ip,NULL,NULL);
	u.u_syscall = savescall;
	if (unlocked == 1)
		plock(ip);
}
