/*	START NEW ARIX SCCS HEADER			*/
/*							*/
/*	@(#) util.c: version 25.1 created on 11/27/91 at 14:55:06	*/
/*							*/
/*	Copyright (c) 1990 by Arix Corporation		*/
/*	All Rights Reserved				*/
/*							*/
#ident	"@(#)util.c	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation"
/*							*/
/*	END NEW ARIX SCCS HEADER			*/
/*							*/

/*
 * util.c -- common utility routines
 */

#ident	"@(#)uts/cf:util.c	20.1"

#include "in_data.h"

extern	char	*progname;		/* pathend of program name	*/
extern	int	errcount;		/* error count			*/

extern	char	*alloc(), *getword(), *pathend(), *stradd();

extern int	errno;
extern char	*sys_errlist[];

extern char	*strchr(), *strrchr(), *strcpy();


/*
 * doopen -- an error trapped fopen
 */

FILE *
doopen(name, mode)
char	*name, *mode;
{
	register FILE	*fp;

	if ((fp = fopen(name, mode)) == NULL) {
		printf("\nfopen(%s, %s) failed! (%s)\n",
		  name, mode, sys_errlist[errno]);
		die(1);
	}

	return (fp);
}


/*
 * openfile -- open the file and set up the globals for parsing
 */

openfile(inp, file)
register in_t	*inp;
char		*file;
{
	inp->in_fp = doopen(file, "r");
	strcpy(inp->in_filename, file);
	inp->in_lineno = 0;
	inp->in_ptr = inp->in_buf;
	*inp->in_buf = 0;
}


/*
 * nextcline -- get the next line, removing comments.  Returns EOF or 0.
 */

nextcline(inp)
register in_t	*inp;
{
	register char	*p;

	do {
		if (nextline(inp))
			return (EOF);
	} while (inp->in_buf[0] == '*');	/* '*' comment */

	if (p = strchr(inp->in_buf, '#'))
		*p = NULL;			/* '#' comment */

	return (0);
}


/*
 * nextword -- returns the next word on a line -- will not read a new line
 *	Typically used after findcmd.  Returns 0 on success, else EOF.
 */

nextword(inp, word)
in_t	*inp;
char	*word;
{
	return ((inp->in_ptr = getword(inp->in_ptr, word)) ? 0 : EOF);
}


/*
 * getword -- copies the next word into word from line and returns a
 *	pointer to the rest of line (if it found a word, getword always
 *	returns a non-NULL pointer)
 */

char *
getword(line, word) 	/* grab the next white space or quote bounded word */
register char	*line;
register char	*word;
{
	register int	c;

	if (line == NULL || *line == NULL) {
nulled:
		*word = NULL;
		return (NULL);		/* NULL return for empty string */
	}

	while (isspace(c = *line))
		++line;			/* eat leading white space */

	if (c == NULL)
		goto nulled;		/* nobody's home */

					/* space bounded word */
	while ((c = *line++) && !isspace(c))
		*word++ = c;

	*word = NULL;			/* NULL terminate */

	return (c ? line : line - 1);	/* return non-NULL if got word */
}


/*
 * findword -- Find the next word in the input, honoring the two kinds of
 *	comments:
 *		1) an asterisk in column 0 makes the whole line a comment
 *		2) a pound sign in any position comments the rest of the line
 *
 *	Will read more lines as needed.  Returns 0 or EOF.
 */

findword(inp, word)
register in_t	*inp;
char		*word;
{
	while ((inp->in_ptr = getword(inp->in_ptr, word)) == NULL) {
		if (nextcline(inp))
			return (EOF);
	}
	return (0);
}


/*
 * findcmd -- Find the next command at the beginning of a line, honoring the
 *	two kinds of comments:
 *		1) an asterisk in column 0 makes the whole line a comment
 *		2) a pound sign in any position comments the rest of the line
 *
 *	Will read more lines as needed.  Returns 0 on success, or EOF.
 *	Ungets word and returns EOS if word starts with '%'.
 */

findcmd(inp, word)
register in_t	*inp;
char		*word;
{
	/* do nextline first to throw away the rest of the current line */

	do {
		if (nextcline(inp))
			return (EOF);
	} while ((inp->in_ptr = getword(inp->in_ptr, word)) == NULL);

	if (*word == '%') {
		ungetline(inp);
		return (EOS);
	}

	return (0);
}


/*
 * stradd -- append str to ptr and return new ptr
 */

char *
stradd(ptr, str)
register char	*ptr, *str;
{
	if (ptr && str)
		while (*ptr = *str++)
			++ptr;

	return(ptr);
}


/*
 *	pathend -- return the last filename in a pathname
 */

char *
pathend(path)
register char	*path;
{
	register char	*p;

	if (p = strrchr(path, '/'))
		return(p + 1);

	return (path);
}

/*
 *	alloc -- error trapped calloc()
 */

char *
alloc(size)
int	size;
{
	register char	*p;
	extern char	*calloc();

	if ((p = calloc((unsigned)size, (unsigned)1) ) == NULL) {
		printf("Unable to allocate any more memory.  BYE\n");
		die(5);
	}

	return (p);
}

/*
 * selectlist -- return the index of word in list, or -1 if not found
 */

selectlist(word, list)
register char	*word;
char		**list;
{
	register char	**cp;

	for (cp = list; *cp != NULL; cp++)
		if (ucasecmp(word, *cp) == 0)
			return (cp - list);

	return (-1);
}

/*
 * ucasecmp -- do a string comparison, considering upper and lower cases
 *	to be equivalent.  Returns:  a1>a2: >0, a1==a2: 0, a1<a2: <0	002
 */

ucasecmp(a1, a2)
char	*a1, *a2;
{
	register int		c1, c2;
	register unsigned char	*s1, *s2;

	s1 = (unsigned char *)a1;
	s2 = (unsigned char *)a2;
	if (s1 == s2)
		return (0);				/* always matches */

	do {
		c1 = *s1++;
		c2 = *s2++;
		if (c1 == 0 || c2 == 0)
			break;
		if (islower(c1))
			c1 = TOUPPER(c1);
		if (islower(c2))
			c2 = TOUPPER(c2);
	} while (c1 == c2);

	return (c1 - c2);
}


/*
 * err -- prefix an error message with the current file name and line number
 */

/* VARARGS2 */
err(inp, fmt, a1, a2, a3, a4)
in_t	*inp;
char	*fmt;
{
	if (inp) {
		printf("%s: file %s, line %d: ",
		  progname, inp->in_filename, inp->in_lineno);
	}
	else {
		printf("%s: ", progname);
	}
	printf(fmt, a1, a2, a3, a4);
	printf("\n");
	if (++errcount >= ERROR_LIMIT) {
		printf("Enough already.\n");
		die(1);
	}
}


/*
 * printlist -- print out a NULL terminated string array
 */

printlist(list)
register char	**list;
{
	while (*list)
		printf("%s ", *list++);
	printf("\n");
}

/*
 * get_number -- get the next word and scan it for a number within the
 *	given range (low to high, inclusive).  Has two messages for a
 *	missing number, or an out of range number.
 */

get_number(inp, low, high, missing, out_of_range)
register in_t	*inp;
int		low, high;
char		*missing, *out_of_range;
{
	int	num;
	char	word[MAXLEN];

	if (nextword(inp, word)) {
		if (missing == NULL)
			return (EOF);

		err(inp, "%s (range: %d to %d)", missing, low, high);
		return (-1);
	}
	if (sscanf(word, "%d", &num) <= 0) {
		if (EQ(word, "-"))
			return (MAJ_UNKNOWN);
		err(inp, "Not a number '%s' Use a number from %d to %d",
		  word, low, high);
		return (-1);
	}
	if (num < low || num > high) {
		err(inp, "%s [%d] (range: %d to %d)\n",
		  out_of_range, num, low, high);
		return (-1);
	}
	return (num);
}
