# Makefile for kernel configuration

SHELL=/bin/sh
UMACH = M68040
MACH = M68020
SECOPT=SECOFF
#
#	Performance enables.
#	PERF_NOSUCHK will not do superuser check thus allowing anyone
#	to modify performance parameters.
#
PERFOPT=-DPERF

LCFLAGS	= -SYSV -O -D$(SECOPT) $(PERFOPT) $(DEBUGFLAGS) -DPOSIX -D_POSIX_SOURCE

CFLAGS	= -YI,/$(INCRT) -DINKERNEL $(DEBUGFLAGS) $(S54KDEF) -SYSV \
	$(LCFLAGS) -D$(MACH) -U$(UMACH)

INCRT	= /usr/include
ROOT	=

ETCDIR	= $(ROOT)/etc
MASTERDIR = $(ETCDIR)/master.d
MASTERS	= $(MASTERDIR)/*
CONFIG	= $(ETCDIR)/config

SYSTEM	= $(ETCDIR)/system

VER	= `/usr/sys/month_day`

all:	conf.o

conf.o:	$(CONFIG) $(SYSTEM) $(MASTERS)
	$(CONFIG) -m $(MASTERDIR) $(SYSTEM)
	$(CC) -I. $(CFLAGS) -DVERSION=\"$(VER)\" -c conf.c
