#	START NEW ARIX SCCS HEADER
#
#	@(#) nopush.sh: version 25.1 created on 11/27/91 at 14:51:36
#
#	Copyright (c) 1990 by Arix Corporation
#	All Rights Reserved
#
#	@(#)nopush.sh	25.1	11/27/91 Copyright (c) 1990 by Arix Corporation
#
#	END NEW ARIX SCCS HEADER
#
#
echo nopush: removing register save and restores in $1 for $2
#
#
tmp=/usr/tmp/nopush.$$

nawk '
func getl() {
	if ((g_ret = getline) <= 0) {
		if (g_ret < 0) {
			print ">>> I/O Error on input " FILENAME ", line # " NR;
			exit 1;
		}
		exit 0;
	}
	return 1;
}

func dump_it(prefix) {
	for (dump_i = 0; dump_i < line; dump_i++)
		print prefix lines[dump_i];
	line = 0;
	print					# print current line
}

/^'$2':/ {
	print; getl();				# print the function name
	print; getl();				# print the link opcode

	while ( 1 ) {				# eat register pushes
		if (match($0, /^[\t ]+mov\.l[\t ]+%[ad][2-7],-\(%sp\)/))
			$0 = "#" $0;
		else if (match($0, /^[\t ]+movm\.l[\t ]+&0x[0-9a-fA-F]+,-\(%sp\)/))
			$0 = "#" $0;
		else
			break;
		print; getl();
	}

# find the stack pop lines that immediately preceed an unlink opcode
# will have to store pops until either an unlink or anything else shows up
# loop until next function
	line = 0;
	while ( ! match($0, /^[a-z_A-Z][a-z_A-Z0-9]:*/)) {
		if (match($0, /^[\t ]+mov\.l[\t ]+\(%sp\)\+,%[ad][2-7]/) ||
		    match($0, /^[\t ]+movm\.l[\t ]+\(%sp\)\+,&0x[0-9a-fA-F]+/)) {
			lines[line] = $0;
			++line;
		}
		else if (match($0, /^[\t ]+unlk/))
			dump_it("#");			# comment pop lines
		else if (line > 0)
			dump_it("");			# dump pop lines
		else
			print;
		getl();
	}
	for (i = 0; i < line; i++)
		print "#" lines[i];			# pop lines

	print;						# print the function

	while (getl() > 0)				# pass rest of file
		print;
}

{ print; }

END { exit 0; }
' $1 > $tmp

/bin/cat $tmp > $1
/bin/rm -f $tmp
